/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationSystemModelMapper;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationSystemModelImpl;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class NavigationSystem
extends DaoObject<NavigationSystemModelImpl> {
    @Override
    public int insert(NavigationSystemModelImpl obj) {
        if (obj.getId() == null || obj.getId().equals("")) {
            obj.setId(UUIDGener.getObjectId());
        }
        if (obj.getOrderIndex() == 0) {
            obj.setOrderIndex(this.getMaxIndex());
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", obj.getId());
        paramsMap.put("SYSTEMNAME", obj.getSystemName());
        paramsMap.put("ORDERINDEX", obj.getOrderIndex());
        paramsMap.put("LINKURL", obj.getLinkUrl());
        paramsMap.put("LINKTARGET", obj.getLinkTarget());
        paramsMap.put("ICON16", obj.getIcon16());
        paramsMap.put("ICON64", obj.getIcon64());
        paramsMap.put("ICON96", obj.getIcon96());
        paramsMap.put("NAVDESC", obj.getNavDesc());
        paramsMap.put("APPID", obj.getAppId());
        paramsMap.put("ISHIDDEN", obj.isHidden() ? 1 : 0);
        paramsMap.put("ISACTIVITY", obj.isActivity() ? 1 : 0);
        paramsMap.put("PORTALLAYOUT", obj.getPortalLayout());
        paramsMap.put("PORTALLOCKED", obj.getPortalLocked());
        paramsMap.put("NOTIFIER", obj.getNotifier());
        paramsMap.put("CREATEDATE", new Timestamp(System.currentTimeMillis()));
        paramsMap.put("UPDATEDATE", new Timestamp(System.currentTimeMillis()));
        int r = DBSql.update(DBSql.getInsertStatement(this.entityName(), paramsMap), paramsMap);
        NavigationSystemCache.putModel(this.getModel(obj.getId()));
        return r;
    }

    @Override
    public int update(NavigationSystemModelImpl model) {
        int r;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(this.entityName()).append(" SET ");
        sql.append("SYSTEMNAME").append("=:").append("SYSTEMNAME").append(",");
        sql.append("ORDERINDEX").append("=:").append("ORDERINDEX").append(",");
        sql.append("LINKURL").append("=:").append("LINKURL").append(",");
        sql.append("LINKTARGET").append("=:").append("LINKTARGET").append(",");
        sql.append("ICON16").append("=:").append("ICON16").append(",");
        sql.append("ICON64").append("=:").append("ICON64").append(",");
        sql.append("ICON96").append("=:").append("ICON96").append(",");
        sql.append("NAVDESC").append("=:").append("NAVDESC").append(",");
        sql.append("APPID").append("=:").append("APPID").append(",");
        sql.append("ISHIDDEN").append("=:").append("ISHIDDEN").append(",");
        sql.append("ISACTIVITY").append("=:").append("ISACTIVITY").append(",");
        sql.append("PORTALLAYOUT").append("=:").append("PORTALLAYOUT").append(",");
        sql.append("PORTALLOCKED").append("=:").append("PORTALLOCKED").append(",");
        sql.append("UPDATEDATE").append("=:").append("UPDATEDATE").append(",");
        sql.append("NOTIFIER").append("=:").append("NOTIFIER");
        sql.append(" WHERE ");
        sql.append("ID").append("=:").append("ID");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("SYSTEMNAME", model.getSystemName());
        paramsMap.put("ORDERINDEX", model.getOrderIndex());
        paramsMap.put("LINKURL", model.getLinkUrl());
        paramsMap.put("LINKTARGET", model.getLinkTarget());
        paramsMap.put("ICON16", model.getIcon16());
        paramsMap.put("ICON64", model.getIcon64());
        paramsMap.put("ICON96", model.getIcon96());
        paramsMap.put("NAVDESC", model.getNavDesc());
        paramsMap.put("APPID", model.getAppId());
        paramsMap.put("ISHIDDEN", model.isHidden() ? 1 : 0);
        paramsMap.put("ISACTIVITY", model.isActivity() ? 1 : 0);
        paramsMap.put("PORTALLAYOUT", model.getPortalLayout());
        paramsMap.put("PORTALLOCKED", model.getPortalLocked());
        paramsMap.put("UPDATEDATE", new Timestamp(System.currentTimeMillis()));
        paramsMap.put("NOTIFIER", model.getNotifier());
        if ("obj_007801f265cbfd38310eb1acdd53dc02".equals(model.getId())) {
            model.setOrderIndex(9999);
        }
        try {
            r = DBSql.update(sql.toString(), paramsMap);
        }
        finally {
            NavigationSystemCache.updateModel(this.getModel(model.getId()));
        }
        return r;
    }

    @Override
    public int delete(Object oid) {
        String id = (String)oid;
        int r = super.delete(id);
        PermissionDaoFactory.createPermissionList().removeByResource(id);
        NavigationDaoFactory.createNavigationDirectory().removeBySystem(id);
        NavigationSystemCache.removeModel(id);
        return r;
    }

    public NavigationSystemModel getModel(String id) {
        return (NavigationSystemModel)this.queryById(id);
    }

    public List<NavigationSystemModelImpl> getModelList() {
        return this.query().list();
    }

    private int getMaxIndex() {
        Stream stream = NavigationSystemCache.getCache().stream();
        Optional<Integer> maxOrderIndex = stream.filter(model -> !"obj_007801f265cbfd38310eb1acdd53dc02".equals(model.getId())).map(NavigationSystemModel::getOrderIndex).max(Integer::compareTo);
        return maxOrderIndex.map(i -> i + 1).orElse(1);
    }

    @Override
    public String entityName() {
        return "SYS_NAV_SYSTEM";
    }

    @Override
    public RowMapper<NavigationSystemModelImpl> rowMapper() {
        return new NavigationSystemModelMapper();
    }
}

