/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.util;

import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.i18n.I18nRes;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class NavigationUtil {
    public static String getLangName(String lang, String text) {
        if (text.contains("lang:")) {
            String key = text.substring(text.indexOf("lang:") + 5);
            return I18nRes.findValue("_bpm.platform", lang, key);
        }
        return I18nRes.findValue("_bpm.platform", lang, text);
    }

    public static boolean isSystemNavigation(NavigationSystemModel systemModel) {
        return "obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(systemModel.getId());
    }

    public static String saveSecurityList(List<String> checklist, String key) {
        String navId = key.substring(2);
        String f = "";
        String d = "";
        String s = "";
        if (key.startsWith("f_")) {
            NavigationFunctionModel nf = NavigationFunctionCache.getModel(navId);
            NavigationDirectoryModel nd = NavigationDirectoryCache.getModel(nf.getDirectoryId());
            f = navId;
            d = nd.getId();
            s = nd.getSystemId();
        } else if (key.startsWith("d_")) {
            NavigationDirectoryModel nd = NavigationDirectoryCache.getModel(navId);
            d = navId;
            s = nd.getSystemId();
        } else if (key.startsWith("s_")) {
            s = navId;
        }
        String getDelete = "'" + f + "'";
        if (!"".equals(d)) {
            getDelete = getDelete.length() > 0 ? String.valueOf(getDelete) + ",'" + d + "'" : "'" + d + "'";
        }
        if (!"".equals(s)) {
            getDelete = getDelete.length() > 0 ? String.valueOf(getDelete) + ",'" + s + "'" : "'" + s + "'";
        }
        if (getDelete.length() == 0) {
            return "\u4e0d\u5b58\u5728\u7684\u5bfc\u822a\u8d44\u6e90\u7f16\u53f7\uff1a" + navId;
        }
        Connection conn = DBSql.open();
        try {
            try {
                conn.setAutoCommit(false);
                ArrayList<String> sqlList = new ArrayList<String>();
                String sql1 = "delete from SYS_PERMISSIONLIST where RESOURCEID in('" + getDelete + "')";
                sqlList.add(sql1);
                for (String groupId : checklist) {
                    String sql;
                    if (groupId.trim().length() == 0) continue;
                    if (!"".equals(f)) {
                        sql = "insert into SYS_PERMISSIONLIST (ID,PERMISSIONID,RESOURCETYPE,RESOURCEID,ACCESSMODE) values ('" + UUIDGener.getUUID() + "','" + groupId + "','" + "FunctionObject" + "','" + f + "'," + 0 + ")";
                        sqlList.add(sql);
                    }
                    if (!"".equals(d)) {
                        sql = "insert into SYS_PERMISSIONLIST (ID,PERMISSIONID,RESOURCETYPE,RESOURCEID,ACCESSMODE) values ('" + UUIDGener.getUUID() + "','" + groupId + "','" + "FunctionObject" + "','" + f + "'," + 0 + ")";
                        sqlList.add(sql);
                    }
                    if ("".equals(s)) continue;
                    sql = "insert into SYS_PERMISSIONLIST (ID,PERMISSIONID,RESOURCETYPE,RESOURCEID,ACCESSMODE) values ('" + UUIDGener.getUUID() + "','" + groupId + "','" + "FunctionObject" + "','" + f + "'," + 0 + ")";
                    sqlList.add(sql);
                }
                DBSql.batch(conn, sqlList.toArray(new String[0]));
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                e.printStackTrace(System.err);
                String string = e.getMessage();
                DBSql.close(conn);
                return string;
            }
        }
        finally {
            DBSql.close(conn);
        }
        PermissionListCache.getCache().reload(true);
        return "OK";
    }
}

