/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.web;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.log.auditing.constant.AuditConst;
import com.actionsoft.bpms.commons.mvc.model.PlatformMetaModelBean;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDirectory;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationFunction;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationSystem;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationDirectoryModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationFunctionModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationSystemModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.NavACCM;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.PermAPIManager;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.form.engine.helper.iae.ImpExpHelper;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class DesignNavigationWeb
extends ActionWeb {
    private static final String ROOT = "root";
    private static final String[] workTargets = new String[]{"mainFrame", "_blank", "sidebar"};
    private static final String[] workTargetsLabel = new String[]{"\u4e3b\u5de5\u4f5c\u533a", "\u65b0\u7a97\u53e3", "\u4fa7\u8fb9\u680f"};
    private int SYSTEM_WIDTH = 420;

    public DesignNavigationWeb(UserContext me) {
        super(me);
    }

    private String lang(String s) {
        return NavigationUtil.getLangName(this.getContext().getLanguage(), s);
    }

    public String openNavGraph(String nodeId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        JSONObject trees = new JSONObject();
        trees.put("name", (Object)"\u5bfc\u822a\u7ed3\u6784");
        JSONArray children2 = new JSONArray();
        trees.put("children", (Object)children2);
        if (nodeId.startsWith("s_")) {
            String navId = nodeId.substring(2);
            NavigationSystemModel ns = NavigationSystemCache.getModel(navId);
            JSONObject child2 = new JSONObject();
            child2.put("name", (Object)this.lang(ns.getSystemName()));
            if (ns.getAppId().equals("") || AMCAPIManager.isManagementApp(ns.getAppId(), this.getContext().getUID())) {
                JSONArray children = new JSONArray();
                this.getSystemHtml(ns, children);
                child2.put("children", (Object)children);
            }
            children2.add((Object)child2);
        } else if (nodeId.startsWith("d_")) {
            String navId = nodeId.substring(2);
            NavigationDirectoryModel nd = NavigationDirectoryCache.getModel(navId);
            NavigationSystemModel ns = NavigationSystemCache.getModel(nd.getSystemId());
            JSONObject child2 = new JSONObject();
            child2.put("name", (Object)this.lang(ns.getSystemName()));
            JSONArray children3 = new JSONArray();
            if (ns.getAppId().equals("") || AMCAPIManager.isManagementApp(ns.getAppId(), this.getContext().getUID())) {
                JSONObject child = new JSONObject();
                this.getDirectoryHtml(nd, true, child);
                children3.add((Object)child);
            }
            child2.put("children", (Object)children3);
            children2.add((Object)child2);
        } else if (ROOT.equals(nodeId)) {
            Iterator<NavigationSystemModel> s1 = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
            ArrayList<NavigationSystemModel> s = new ArrayList<NavigationSystemModel>();
            int i = 0;
            while (s1.hasNext()) {
                NavigationSystemModel ns = s1.next();
                String appId = ns.getAppId();
                if (!appId.equals("") && !AMCAPIManager.isManagementApp(appId, this.getContext().getUID()) || "obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(ns.getId()) || !this.hasSystemRight(ns.getId()) || ns.getId().equals("20") || !this.hasSystemRight(ns.getId())) continue;
                JSONObject child2 = new JSONObject();
                s.add(ns);
                child2.put("name", (Object)this.lang(ns.getSystemName()));
                JSONArray children = new JSONArray();
                this.getSystemHtml(ns, children);
                child2.put("children", (Object)children);
                children2.add((Object)child2);
                ++i;
            }
        }
        macroLibraries.put("treesData", trees);
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.nav.structure.htm", macroLibraries);
    }

    private void getSystemHtml(NavigationSystemModel ns, JSONArray children) {
        List<NavigationDirectoryModel> level1 = NavigationDirectoryCache.getListOfSystem(ns.getId());
        int k = 0;
        while (k < level1.size()) {
            NavigationDirectoryModel nd = level1.get(k);
            JSONObject child = new JSONObject();
            this.getDirectoryHtml(nd, k == level1.size() - 1, child);
            children.add((Object)child);
            ++k;
        }
    }

    private void getDirectoryHtml(NavigationDirectoryModel nd, boolean last, JSONObject child) {
        child.put("name", (Object)this.lang(nd.getDirectoryName()));
        List<NavigationFunctionModel> f = NavigationFunctionCache.getListOfDirectory(nd.getId());
        if (f.size() > 0) {
            JSONArray ja = new JSONArray();
            int j = 0;
            while (j < f.size()) {
                NavigationFunctionModel nf = f.get(j);
                JSONObject child3 = new JSONObject();
                child3.put("name", (Object)this.lang(nf.getFunctionName()));
                ja.add((Object)child3);
                ++j;
            }
            child.put("children", (Object)ja);
        }
    }

    public String deleteNavigationObject(String deleteId) {
        ResponseObject ro = ResponseObject.newErrResponse();
        try {
            if (deleteId.startsWith("f_")) {
                NavigationFunctionModel nf = NavigationFunctionCache.getModel(deleteId.substring(2));
                if (nf != null) {
                    DBSql.update("delete from SYS_PERMISSIONLIST where RESOURCEID='" + nf.getId() + "'");
                    NavigationDaoFactory.createNavigationFunction().delete(nf.getId());
                }
            } else if (deleteId.startsWith("d_")) {
                String id = deleteId.substring(2);
                NavigationDirectoryModel nd = NavigationDirectoryCache.getModel(id);
                List<NavigationFunctionModel> h = NavigationFunctionCache.getListOfDirectory(id);
                for (NavigationFunctionModel nf : h) {
                    DBSql.update("delete from SYS_PERMISSIONLIST where RESOURCEID='" + nf.getId() + "'");
                }
                DBSql.update("delete from SYS_PERMISSIONLIST where RESOURCEID='" + nd.getId() + "'");
                NavigationDaoFactory.createNavigationDirectory().delete(nd.getId());
            } else if (deleteId.startsWith("s_")) {
                String id = deleteId.substring(2);
                NavigationSystemModel ns = NavigationSystemCache.getModel(id);
                List<NavigationDirectoryModel> h = NavigationDirectoryCache.getListOfSystem(id);
                for (NavigationDirectoryModel nd : h) {
                    List<NavigationFunctionModel> hf = NavigationFunctionCache.getListOfDirectory(nd.getId());
                    for (NavigationFunctionModel nf : hf) {
                        DBSql.update("delete from SYS_PERMISSIONLIST where RESOURCEID='" + nf.getId() + "'");
                    }
                    DBSql.update("delete from SYS_PERMISSIONLIST where RESOURCEID='" + nd.getId() + "'");
                }
                DBSql.update("delete from SYS_PERMISSIONLIST where RESOURCEID='" + ns.getId() + "'");
                NavigationDaoFactory.createNavigationSystem().delete(ns.getId());
            }
            PermissionListCache.getCache().reload(true);
            ro.ok();
            ro.msg("\u5220\u9664\u6210\u529f");
            return ro.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            ro.err("\u5220\u9664\u5931\u8d25");
            ro.msg("ERROR");
            return ro.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String navigationCheckDD(String sNode, String tNode, String point) {
        if (sNode.startsWith("s_")) {
            if (tNode.startsWith("s_")) {
                if (!"append".equals(point)) {
                    if ("above".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                    "below".equals(point);
                    return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                }
                NavigationSystemModel ns = NavigationSystemCache.getModel(sNode.substring(2));
                if (NavigationUtil.isSystemNavigation(ns)) {
                    return ResponseObject.newWarnResponse().msg("\u7cfb\u7edf\u8282\u70b9\u4e0d\u5141\u8bb8\u8f6c\u5316").toString();
                }
                List<NavigationDirectoryModel> h = NavigationDirectoryCache.getListOfSystem(sNode.substring(2));
                if (h.size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                return ResponseObject.newWarnResponse().msg("\u7cfb\u7edf\u4e0b\u6709\u76ee\u5f55\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u76ee\u5f55").toString();
            }
            if (tNode.startsWith("d_")) {
                NavigationSystemModel ns = NavigationSystemCache.getModel(sNode.substring(2));
                if (NavigationUtil.isSystemNavigation(ns)) {
                    return ResponseObject.newWarnResponse().msg("\u7cfb\u7edf\u8282\u70b9\u4e0d\u5141\u8bb8\u8f6c\u5316").toString();
                }
                if ("append".equals(point)) {
                    if (NavigationDirectoryCache.getListOfSystem(sNode.substring(2)).size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                    return ResponseObject.newWarnResponse().msg("\u7cfb\u7edf\u4e0b\u6709\u76ee\u5f55\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u529f\u80fd").toString();
                }
                if (!"above".equals(point)) {
                    if (!"below".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                }
                if (NavigationDirectoryCache.getListOfSystem(sNode.substring(2)).size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                return ResponseObject.newWarnResponse().msg("\u7cfb\u7edf\u4e0b\u6709\u76ee\u5f55\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u76ee\u5f55").toString();
            }
            if (!tNode.startsWith("f_")) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            NavigationSystemModel ns = NavigationSystemCache.getModel(sNode.substring(2));
            if (NavigationUtil.isSystemNavigation(ns)) {
                return ResponseObject.newWarnResponse().msg("\u7cfb\u7edf\u8282\u70b9\u4e0d\u5141\u8bb8\u8f6c\u5316").toString();
            }
            if ("append".equals(point)) {
                return ResponseObject.newWarnResponse().msg("\u529f\u80fd\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5b50\u8282\u70b9").toString();
            }
            if (!"above".equals(point)) {
                if (!"below".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            }
            if (NavigationDirectoryCache.getListOfSystem(sNode.substring(2)).size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            return ResponseObject.newWarnResponse().msg("\u5b50\u7cfb\u7edf\u8282\u70b9\u4e0b\u6709\u76ee\u5f55\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u529f\u80fd").toString();
        }
        if (sNode.startsWith("d_")) {
            List<NavigationFunctionModel> list = NavigationFunctionCache.getListOfDirectory(sNode.substring(2));
            if (tNode.startsWith("s_")) {
                if ("append".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                if (list.size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                return ResponseObject.newWarnResponse().msg("\u76ee\u5f55\u4e0b\u6709\u529f\u80fd\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u7cfb\u7edf\u8282\u70b9").toString();
            }
            if (tNode.equals(ROOT)) {
                if (!"append".equals(point)) return ResponseObject.newWarnResponse().msg("\u76ee\u5f55\u4e0d\u80fd\u8f6c\u5316\u4e3a\u6839\u8282\u70b9").toString();
                if (list.size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                return ResponseObject.newWarnResponse().msg("\u76ee\u5f55\u4e0b\u6709\u529f\u80fd\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u7cfb\u7edf\u8282\u70b9").toString();
            }
            if (tNode.startsWith("d_")) {
                if ("append".equals(point)) {
                    if (list.size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                    return ResponseObject.newWarnResponse().msg("\u76ee\u5f55\u4e0b\u6709\u529f\u80fd\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u529f\u80fd\u8282\u70b9").toString();
                }
                if ("above".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
                "below".equals(point);
                return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            }
            if (!tNode.startsWith("f_")) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            if ("append".equals(point)) {
                return ResponseObject.newWarnResponse().msg("\u529f\u80fd\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5b50\u8282\u70b9").toString();
            }
            if (!"above".equals(point)) {
                if (!"below".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            }
            if (list.size() <= 0) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            return ResponseObject.newWarnResponse().msg("\u76ee\u5f55\u4e0b\u6709\u529f\u80fd\u8282\u70b9\u4e0d\u80fd\u8f6c\u5316\u4e3a\u529f\u80fd\u8282\u70b9").toString();
        }
        if (!sNode.startsWith("f_")) return ResponseObject.newErrResponse().msg("\u7cfb\u7edf\u5f02\u5e38").toString();
        if (tNode.startsWith("s_")) {
            if ("append".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            if ("above".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            "below".equals(point);
            return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
        }
        if (tNode.startsWith("d_")) {
            if ("append".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            if ("above".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
            "below".equals(point);
            return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
        }
        if (!tNode.startsWith("f_")) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
        if ("append".equals(point)) {
            return ResponseObject.newWarnResponse().msg("\u529f\u80fd\u8282\u70b9\u4e0b\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5b50\u8282\u70b9").toString();
        }
        if ("above".equals(point)) return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
        "below".equals(point);
        return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
    }

    private String NS2ND(NavigationSystemModel ns, NavigationSystemModel p) {
        NavigationDirectoryModelImpl nd = new NavigationDirectoryModelImpl();
        nd.setDirectoryName(ns.getSystemName());
        nd.setLinkTarget(ns.getLinkTarget());
        nd.setLinkUrl(ns.getLinkUrl());
        nd.setActivity(ns.isActivity());
        nd.setIcon16(ns.getIcon16());
        nd.setIcon64(ns.getIcon64());
        nd.setIcon96(ns.getIcon96());
        nd.setSystemId(p.getId());
        try {
            NavigationDaoFactory.createNavigationSystem().delete(ns.getId());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return ResponseObject.newErrResponse().msg("\u5220\u9664\u5931\u8d25").toString();
        }
        NavigationDaoFactory.createNavigationDirectory().insert(nd);
        this.dealSecurity(ns.getId(), nd.getId());
        return nd.getId();
    }

    private String NF2NS(NavigationFunctionModel nf) {
        NavigationSystemModelImpl n = new NavigationSystemModelImpl();
        n.setIcon16(nf.getIcon16());
        n.setIcon64(nf.getIcon64());
        n.setIcon96(nf.getIcon96());
        n.setSystemName(nf.getFunctionName());
        n.setLinkUrl(nf.getLinkUrl());
        n.setLinkTarget(nf.getLinkTarget());
        n.setActivity(nf.isActivity());
        try {
            NavigationDaoFactory.createNavigationFunction().delete(nf.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NavigationDaoFactory.createNavigationSystem().insert(n);
        this.dealSecurity(nf.getId(), n.getId());
        return n.getId();
    }

    private void dealSecurity(String securityKey, String newKey) {
        Stream stream = PermissionListCache.getCache().stream();
        List<String> authGroupList = stream.filter(model -> "com.actionsoft.bpms.security.AWFModelUnit".equals(model.getResourceType())).filter(model -> securityKey.equals(model.getResourceId())).map(PermissionListModel::getPermissionId).collect(Collectors.toList());
        if (authGroupList.size() > 0) {
            NavigationUtil.saveSecurityList(authGroupList, String.valueOf(newKey));
        }
    }

    private String ND2NF(NavigationDirectoryModel nd, NavigationDirectoryModel pd) {
        NavigationFunctionModelImpl nf = new NavigationFunctionModelImpl();
        nf.setDirectoryId(pd.getId());
        nf.setFunctionName(nd.getDirectoryName());
        nf.setLinkUrl(nd.getLinkUrl());
        nf.setActivity(nd.isActivity());
        nf.setNavDesc(nd.getNavDesc());
        nf.setIcon16(nd.getIcon16());
        nf.setIcon64(nd.getIcon64());
        nf.setIcon96(nd.getIcon96());
        nf.setLinkTarget(nd.getLinkTarget());
        try {
            NavigationDaoFactory.createNavigationDirectory().delete(nd.getId());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        NavigationDaoFactory.createNavigationFunction().insert(nf);
        String targetId = nf.getId();
        this.dealSecurity(nf.getId(), targetId);
        return nf.getId();
    }

    private String NS2NF(NavigationSystemModel ns, NavigationDirectoryModel nd) {
        NavigationFunctionModelImpl nf = new NavigationFunctionModelImpl();
        nf.setDirectoryId(nd.getId());
        nf.setFunctionName(ns.getSystemName());
        nf.setActivity(ns.isActivity());
        nf.setLinkUrl(ns.getLinkUrl());
        nf.setIcon16(ns.getIcon16());
        nf.setIcon64(ns.getIcon64());
        nf.setIcon96(ns.getIcon96());
        nf.setLinkTarget(ns.getLinkTarget());
        try {
            NavigationDaoFactory.createNavigationSystem().delete(ns.getId());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        NavigationDaoFactory.createNavigationFunction().insert(nf);
        this.dealSecurity(ns.getId(), nf.getId());
        return nf.getId();
    }

    private String ND2NS(NavigationDirectoryModel snd) {
        NavigationSystemModelImpl n = new NavigationSystemModelImpl();
        n.setIcon16(snd.getIcon16());
        n.setIcon64(snd.getIcon64());
        n.setIcon96(snd.getIcon96());
        n.setSystemName(snd.getDirectoryName());
        n.setLinkUrl(snd.getLinkUrl());
        n.setLinkTarget(snd.getLinkTarget());
        n.setActivity(snd.isActivity());
        try {
            NavigationDaoFactory.createNavigationDirectory().delete(snd.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NavigationDaoFactory.createNavigationSystem().insert(n);
        String targetId = n.getId();
        this.dealSecurity(snd.getId(), targetId);
        return targetId;
    }

    private String NF2ND(NavigationFunctionModel nf, NavigationSystemModel ns) {
        NavigationDirectoryModelImpl nd = new NavigationDirectoryModelImpl();
        nd.setOrderIndex(nf.getOrderIndex());
        nd.setDirectoryName(nf.getFunctionName());
        nd.setLinkTarget(nf.getLinkTarget());
        nd.setActivity(nf.isActivity());
        nd.setIcon16(nf.getIcon16());
        nd.setIcon64(nf.getIcon64());
        nd.setIcon96(nf.getIcon96());
        nd.setNavDesc(nf.getNavDesc());
        nd.setSystemId(ns.getId());
        nd.setLinkUrl(nf.getLinkUrl());
        try {
            NavigationDaoFactory.createNavigationFunction().delete(nf.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse().msg("\u5220\u9664\u5931\u8d25").toString();
        }
        NavigationDaoFactory.createNavigationDirectory().insert(nd);
        String targetId = nd.getId();
        this.dealSecurity(nf.getId(), targetId);
        return targetId;
    }

    public String navigationObjectDD(String sNode, String tNode, String point) {
        if (sNode.startsWith("s_")) {
            if (tNode.startsWith("s_")) {
                if ("append".equals(point)) {
                    NavigationSystemModel ns = NavigationSystemCache.getModel(sNode.substring(2));
                    NavigationSystemModel tns = NavigationSystemCache.getModel(tNode.substring(2));
                    NavigationDirectoryModel newNavigationDirectoryModel = NavigationDirectoryCache.getModel(this.NS2ND(ns, tns));
                    List<NavigationDirectoryModel> h = NavigationDirectoryCache.getListOfSystem(ns.getId());
                    for (NavigationDirectoryModel nd : h) {
                        this.ND2NF(nd, newNavigationDirectoryModel);
                    }
                } else {
                    NavigationSystemModel s = NavigationSystemCache.getModel(sNode.substring(2));
                    NavigationSystemModel d = NavigationSystemCache.getModel(tNode.substring(2));
                    this.sortSystem(s, d, "above".equals(point));
                }
            } else if (tNode.startsWith("d_")) {
                if ("append".equals(point)) {
                    NavigationSystemModel sds = NavigationSystemCache.getModel(sNode.substring(2));
                    NavigationDirectoryModel pnd = NavigationDirectoryCache.getModel(tNode.substring(2));
                    this.NS2NF(sds, pnd);
                } else {
                    NavigationSystemModel sds = NavigationSystemCache.getModel(sNode.substring(2));
                    NavigationDirectoryModel tnd = NavigationDirectoryCache.getModel(tNode.substring(2));
                    NavigationSystemModel pds = NavigationSystemCache.getModel(tnd.getSystemId());
                    NavigationDirectoryModel s = NavigationDirectoryCache.getModel(this.NS2ND(sds, pds));
                    this.sortDirectory(s, tnd, "above".equals(point));
                }
            } else if (tNode.startsWith("f_") && !"append".equals(point)) {
                NavigationSystemModel sNS = NavigationSystemCache.getModel(sNode.substring(2));
                NavigationFunctionModel dNF = NavigationFunctionCache.getModel(tNode.substring(2));
                NavigationDirectoryModel pND = NavigationDirectoryCache.getModel(dNF.getDirectoryId());
                NavigationFunctionModel sNF = NavigationFunctionCache.getModel(this.NS2NF(sNS, pND));
                this.sortFunction(sNF, dNF, "above".equals(point));
            }
        } else if (sNode.startsWith("d_")) {
            if (tNode.equals(ROOT)) {
                if ("append".equals(point)) {
                    NavigationDirectoryModel sourceDirectory = NavigationDirectoryCache.getModel(sNode.substring(2));
                    NavigationSystemModel dNF = NavigationSystemCache.getModel(this.ND2NS(sourceDirectory));
                }
            } else if (tNode.startsWith("s_")) {
                if ("append".equals(point)) {
                    NavigationDirectoryModelImpl snd = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(sNode.substring(2));
                    NavigationSystemModel dNS = NavigationSystemCache.getModel(tNode.substring(2));
                    NavigationDirectoryModelImpl tempSnd = new NavigationDirectoryModelImpl();
                    tempSnd.setSystemId(dNS.getId());
                    tempSnd.setOrderIndex(snd.getOrderIndex());
                    tempSnd.setDirectoryName(snd.getDirectoryName());
                    tempSnd.setLinkTarget(snd.getLinkTarget());
                    tempSnd.setActivity(snd.isActivity());
                    tempSnd.setIcon16(snd.getIcon16());
                    tempSnd.setIcon64(snd.getIcon64());
                    tempSnd.setIcon96(snd.getIcon96());
                    tempSnd.setNavDesc(snd.getNavDesc());
                    tempSnd.setLinkUrl(snd.getLinkUrl());
                    tempSnd.setId(snd.getId());
                    tempSnd.setAppId(snd.getAppId());
                    tempSnd.setExt1(snd.getExt1());
                    tempSnd.setExt2(snd.getExt2());
                    tempSnd.setNotifier(snd.getNotifier());
                    NavigationDaoFactory.createNavigationDirectory().update(tempSnd);
                } else {
                    NavigationDirectoryModel sourceDirectory = NavigationDirectoryCache.getModel(sNode.substring(2));
                    NavigationSystemModel targetSystem = NavigationSystemCache.getModel(tNode.substring(2));
                    NavigationSystemModel newSystem = NavigationSystemCache.getModel(this.ND2NS(sourceDirectory));
                    List<NavigationFunctionModel> h = NavigationFunctionCache.getListOfDirectory(sourceDirectory.getId());
                    for (NavigationFunctionModel nf : h) {
                        this.NF2ND(nf, newSystem);
                    }
                    this.sortSystem(newSystem, targetSystem, "above".equals(point));
                }
            } else if (tNode.startsWith("d_")) {
                if ("append".equals(point)) {
                    NavigationDirectoryModel sourceDirectory = NavigationDirectoryCache.getModel(sNode.substring(2));
                    NavigationDirectoryModel targetDirectory = NavigationDirectoryCache.getModel(tNode.substring(2));
                    this.ND2NF(sourceDirectory, targetDirectory);
                } else {
                    NavigationDirectoryModelImpl sourceDirectory = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(sNode.substring(2));
                    NavigationDirectoryModel targetDirectory = NavigationDirectoryCache.getModel(tNode.substring(2));
                    if (sourceDirectory.getSystemId().equals(targetDirectory.getSystemId())) {
                        this.sortDirectory(sourceDirectory, targetDirectory, "above".equals(point));
                    } else {
                        NavigationDirectoryModelImpl tempDirectory = new NavigationDirectoryModelImpl();
                        tempDirectory.setId(sourceDirectory.getId());
                        tempDirectory.setDirectoryName(sourceDirectory.getDirectoryName());
                        tempDirectory.setOrderIndex(sourceDirectory.getOrderIndex());
                        tempDirectory.setLinkUrl(sourceDirectory.getLinkUrl());
                        tempDirectory.setLinkTarget(sourceDirectory.getLinkTarget());
                        tempDirectory.setIcon16(sourceDirectory.getIcon16());
                        tempDirectory.setIcon64(sourceDirectory.getIcon64());
                        tempDirectory.setIcon96(sourceDirectory.getIcon96());
                        tempDirectory.setNavDesc(sourceDirectory.getNavDesc());
                        tempDirectory.setAppId(sourceDirectory.getAppId());
                        tempDirectory.setActivity(sourceDirectory.isActivity());
                        tempDirectory.setExt1(sourceDirectory.getExt1());
                        tempDirectory.setExt2(sourceDirectory.getExt2());
                        tempDirectory.setNotifier(sourceDirectory.getNotifier());
                        tempDirectory.setSystemId(targetDirectory.getSystemId());
                        NavigationDaoFactory.createNavigationDirectory().update(tempDirectory);
                        sourceDirectory = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(sourceDirectory.getId());
                        this.sortDirectory(sourceDirectory, targetDirectory, "above".equals(point));
                    }
                }
            } else if (tNode.startsWith("f_") && !"append".equals(point)) {
                NavigationDirectoryModel sourceDirectory = NavigationDirectoryCache.getModel(sNode.substring(2));
                NavigationFunctionModel targetFunction = NavigationFunctionCache.getModel(tNode.substring(2));
                NavigationDirectoryModel parentDirectory = NavigationDirectoryCache.getModel(targetFunction.getDirectoryId());
                NavigationFunctionModel sourceFunction = NavigationFunctionCache.getModel(this.ND2NF(sourceDirectory, parentDirectory));
                this.sortFunction(sourceFunction, targetFunction, "above".equals(point));
            }
        } else if (sNode.startsWith("f_")) {
            if (tNode.startsWith("s_")) {
                if ("append".equals(point)) {
                    NavigationFunctionModel sourceFunction = NavigationFunctionCache.getModel(sNode.substring(2));
                    NavigationSystemModel targetSystem = NavigationSystemCache.getModel(tNode.substring(2));
                    this.NF2ND(sourceFunction, targetSystem);
                } else {
                    NavigationFunctionModel sourceFunction = NavigationFunctionCache.getModel(sNode.substring(2));
                    NavigationSystemModel targetSystem = NavigationSystemCache.getModel(tNode.substring(2));
                    NavigationSystemModel sourceSystem = NavigationSystemCache.getModel(this.NF2NS(sourceFunction));
                    this.sortSystem(sourceSystem, targetSystem, "above".equals(point));
                }
            } else if (tNode.equals(ROOT)) {
                if ("append".equals(point)) {
                    NavigationFunctionModel sourceFunction = NavigationFunctionCache.getModel(sNode.substring(2));
                    NavigationSystemModel targetSystem = NavigationSystemCache.getModel(this.NF2NS(sourceFunction));
                }
            } else if (tNode.startsWith("d_")) {
                if ("append".equals(point)) {
                    NavigationFunctionModelImpl sourceFunction = (NavigationFunctionModelImpl)NavigationFunctionCache.getModel(sNode.substring(2));
                    NavigationDirectoryModel targetDirectory = NavigationDirectoryCache.getModel(tNode.substring(2));
                    if (!sourceFunction.getDirectoryId().equals(targetDirectory.getId())) {
                        NavigationFunctionModelImpl tempFunction = new NavigationFunctionModelImpl();
                        tempFunction.setId(sourceFunction.getId());
                        tempFunction.setFunctionName(sourceFunction.getFunctionName());
                        tempFunction.setOrderIndex(sourceFunction.getOrderIndex());
                        tempFunction.setLinkUrl(sourceFunction.getLinkUrl());
                        tempFunction.setLinkTarget(sourceFunction.getLinkTarget());
                        tempFunction.setIcon16(sourceFunction.getIcon16());
                        tempFunction.setIcon64(sourceFunction.getIcon64());
                        tempFunction.setIcon96(sourceFunction.getIcon96());
                        tempFunction.setNavDesc(sourceFunction.getNavDesc());
                        tempFunction.setAppId(sourceFunction.getAppId());
                        tempFunction.setActivity(sourceFunction.isActivity());
                        tempFunction.setExt1(sourceFunction.getExt1());
                        tempFunction.setExt2(sourceFunction.getExt2());
                        tempFunction.setNotifier(sourceFunction.getNotifier());
                        tempFunction.setDirectoryId(targetDirectory.getId());
                        NavigationDaoFactory.createNavigationFunction().update(tempFunction);
                    }
                } else {
                    NavigationFunctionModel sourceFunction = NavigationFunctionCache.getModel(sNode.substring(2));
                    NavigationDirectoryModel targetDirectory = NavigationDirectoryCache.getModel(tNode.substring(2));
                    NavigationSystemModel parentSystem = NavigationSystemCache.getModel(targetDirectory.getSystemId());
                    NavigationDirectoryModel sourceDirectory = NavigationDirectoryCache.getModel(this.NF2ND(sourceFunction, parentSystem));
                    this.sortDirectory(sourceDirectory, targetDirectory, "above".equals(point));
                }
            } else if (tNode.startsWith("f_") && !"append".equals(point)) {
                NavigationFunctionModelImpl sourceFunction = (NavigationFunctionModelImpl)NavigationFunctionCache.getModel(sNode.substring(2));
                NavigationFunctionModel targetFunction = NavigationFunctionCache.getModel(tNode.substring(2));
                if (sourceFunction.getDirectoryId().equals(targetFunction.getDirectoryId())) {
                    this.sortFunction(sourceFunction, targetFunction, "above".equals(point));
                } else {
                    NavigationFunctionModelImpl tempFunction = new NavigationFunctionModelImpl();
                    tempFunction.setId(sourceFunction.getId());
                    tempFunction.setFunctionName(sourceFunction.getFunctionName());
                    tempFunction.setOrderIndex(sourceFunction.getOrderIndex());
                    tempFunction.setLinkUrl(sourceFunction.getLinkUrl());
                    tempFunction.setLinkTarget(sourceFunction.getLinkTarget());
                    tempFunction.setIcon16(sourceFunction.getIcon16());
                    tempFunction.setIcon64(sourceFunction.getIcon64());
                    tempFunction.setIcon96(sourceFunction.getIcon96());
                    tempFunction.setNavDesc(sourceFunction.getNavDesc());
                    tempFunction.setAppId(sourceFunction.getAppId());
                    tempFunction.setActivity(sourceFunction.isActivity());
                    tempFunction.setExt1(sourceFunction.getExt1());
                    tempFunction.setExt2(sourceFunction.getExt2());
                    tempFunction.setNotifier(sourceFunction.getNotifier());
                    tempFunction.setDirectoryId(targetFunction.getDirectoryId());
                    NavigationDaoFactory.createNavigationFunction().update(tempFunction);
                    sourceFunction = (NavigationFunctionModelImpl)NavigationFunctionCache.getModel(sourceFunction.getId());
                    this.sortFunction(sourceFunction, targetFunction, "above".equals(point));
                }
            }
        }
        return ResponseObject.newOkResponse().msg("").toString();
    }

    private void sortFunction(NavigationFunctionModel source, NavigationFunctionModel target, boolean isAbove) {
        Stream<NavigationFunctionModel> stream = NavigationFunctionCache.getCache().stream();
        stream = stream.filter(model -> target.getDirectoryId().equals(model.getDirectoryId()));
        if (isAbove) {
            stream = this.getAboveStream(source, target, stream);
        } else if (source.getOrderIndex() > target.getOrderIndex()) {
            stream = stream.filter(model -> model.getOrderIndex() > target.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() < source.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationFunctionModel::getOrderIndex).reversed());
        } else {
            stream = stream.filter(model -> model.getOrderIndex() > source.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() <= target.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationFunctionModel::getOrderIndex));
        }
        NavigationFunction navigationFunction = NavigationDaoFactory.createNavigationFunction();
        AtomicInteger newIndex = new AtomicInteger(source.getOrderIndex());
        try {
            stream.collect(Collectors.toList()).forEach(model -> {
                NavigationFunctionModelImpl targetModel = (NavigationFunctionModelImpl)model;
                int tempIndex = model.getOrderIndex();
                targetModel.setOrderIndex(newIndex.get());
                newIndex.set(tempIndex);
                navigationFunction.update(targetModel);
            });
        }
        catch (AWSDataAccessException e) {
            e.printStackTrace(System.err);
        }
        if (source.getOrderIndex() != newIndex.get()) {
            ((NavigationFunctionModelImpl)source).setOrderIndex(newIndex.get());
            navigationFunction.update((NavigationFunctionModelImpl)source);
        }
    }

    private Stream<NavigationFunctionModel> getAboveStream(NavigationFunctionModel source, NavigationFunctionModel target, Stream<NavigationFunctionModel> stream) {
        if (source.getOrderIndex() > target.getOrderIndex()) {
            stream = stream.filter(model -> model.getOrderIndex() >= target.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() < source.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationFunctionModel::getOrderIndex).reversed());
        } else {
            stream = stream.filter(model -> model.getOrderIndex() > source.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() < target.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationFunctionModel::getOrderIndex));
        }
        return stream;
    }

    private void sortSystem(NavigationSystemModel source, NavigationSystemModel target, boolean isAbove) {
        Stream<Object> stream = NavigationSystemCache.getCache().stream();
        stream = stream.filter(model -> !"obj_007801f265cbfd38310eb1acdd53dc02".equals(model.getId()));
        if (isAbove) {
            if (source.getOrderIndex() > target.getOrderIndex()) {
                stream = stream.filter(model -> model.getOrderIndex() >= target.getOrderIndex());
                stream = stream.filter(model -> model.getOrderIndex() < source.getOrderIndex());
                stream = stream.sorted(Comparator.comparing(NavigationSystemModel::getOrderIndex).reversed());
            } else {
                stream = stream.filter(model -> model.getOrderIndex() > source.getOrderIndex());
                stream = stream.filter(model -> model.getOrderIndex() < target.getOrderIndex());
                stream = stream.sorted(Comparator.comparing(NavigationSystemModel::getOrderIndex));
            }
        } else if (source.getOrderIndex() > target.getOrderIndex()) {
            stream = stream.filter(model -> model.getOrderIndex() > target.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() < source.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationSystemModel::getOrderIndex).reversed());
        } else {
            stream = stream.filter(model -> model.getOrderIndex() > source.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() <= target.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationSystemModel::getOrderIndex));
        }
        NavigationSystem navigationSystem = NavigationDaoFactory.createNavigationSystem();
        AtomicInteger newIndex = new AtomicInteger(source.getOrderIndex());
        try {
            stream.collect(Collectors.toList()).forEach(model -> {
                if (!"obj_007801f265cbfd38310eb1acdd53dc02".equals(model.getId())) {
                    int tempIndex = model.getOrderIndex();
                    NavigationSystemModelImpl targetModel = (NavigationSystemModelImpl)model;
                    targetModel.setOrderIndex(newIndex.get());
                    newIndex.set(tempIndex);
                    navigationSystem.update(targetModel);
                }
            });
        }
        catch (AWSDataAccessException sqle) {
            sqle.printStackTrace(System.err);
        }
        if (source.getOrderIndex() != newIndex.get()) {
            ((NavigationSystemModelImpl)source).setOrderIndex(newIndex.get());
            navigationSystem.update((NavigationSystemModelImpl)source);
        }
    }

    private void sortDirectory(NavigationDirectoryModel source, NavigationDirectoryModel target, boolean isAbove) {
        Stream<Object> stream = NavigationDirectoryCache.getCache().stream();
        stream = stream.filter(model -> target.getSystemId().equals(model.getSystemId()));
        if (isAbove) {
            if (source.getOrderIndex() > target.getOrderIndex()) {
                stream = stream.filter(model -> model.getOrderIndex() >= target.getOrderIndex());
                stream = stream.filter(model -> model.getOrderIndex() < source.getOrderIndex());
                stream = stream.sorted(Comparator.comparing(NavigationDirectoryModel::getOrderIndex).reversed());
            } else {
                stream = stream.filter(model -> model.getOrderIndex() > source.getOrderIndex());
                stream = stream.filter(model -> model.getOrderIndex() < target.getOrderIndex());
                stream = stream.sorted(Comparator.comparing(NavigationDirectoryModel::getOrderIndex));
            }
        } else if (source.getOrderIndex() > target.getOrderIndex()) {
            stream = stream.filter(model -> model.getOrderIndex() > target.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() < source.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationDirectoryModel::getOrderIndex).reversed());
        } else {
            stream = stream.filter(model -> model.getOrderIndex() > source.getOrderIndex());
            stream = stream.filter(model -> model.getOrderIndex() <= target.getOrderIndex());
            stream = stream.sorted(Comparator.comparing(NavigationDirectoryModel::getOrderIndex));
        }
        NavigationDirectory navigationDirectory = NavigationDaoFactory.createNavigationDirectory();
        AtomicInteger newIndex = new AtomicInteger(source.getOrderIndex());
        try {
            stream.collect(Collectors.toList()).forEach(model -> {
                int tempIndex = model.getOrderIndex();
                NavigationDirectoryModelImpl targetModel = (NavigationDirectoryModelImpl)model;
                targetModel.setOrderIndex(newIndex.get());
                newIndex.set(tempIndex);
                navigationDirectory.update(targetModel);
            });
        }
        catch (AWSDataAccessException e) {
            e.printStackTrace(System.err);
        }
        if (source.getOrderIndex() != newIndex.get()) {
            ((NavigationDirectoryModelImpl)source).setOrderIndex(newIndex.get());
            navigationDirectory.update((NavigationDirectoryModelImpl)source);
        }
    }

    private boolean hasSecurityGroupRight() {
        String[] groupNames;
        if (this.getContext().getUID().equals("admin") || GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
            return true;
        }
        String[] stringArray = groupNames = PermissionCache.getCategorys();
        int n = groupNames.length;
        int n2 = 0;
        while (n2 < n) {
            String groupName = stringArray[n2];
            if (AccessControlAPI.getInstance().havingPermission(this.getContext(), "platform.secGroupAdmin", groupName, SecurityGroupACCM.MANAGER.getType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isApplyRight(String navId) {
        if (!navId.startsWith("s_")) {
            return false;
        }
        if (this.getContext().getUID().equals("admin") || GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
            return true;
        }
        return AccessControlAPI.getInstance().havingPermission(this.getContext(), NavACCM.resourceType, navId.substring(2), NavACCM.MANAGER.getType());
    }

    private String getOperationList(String navId) {
        boolean isSystem = false;
        if (navId.startsWith("s_")) {
            NavigationSystemModel navigationSystemModel = NavigationSystemCache.getModel(navId.substring(2));
            isSystem = NavigationUtil.isSystemNavigation(navigationSystemModel);
        }
        return "\"m" + (isSystem ? "" : "d") + (this.hasSecurityGroupRight() ? "s" : "") + (this.isApplyRight(navId) ? "a" : "") + "f\"";
    }

    private boolean hasSystemRight(String sysId) {
        return "admin".equals(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) || AccessControlAPI.getInstance().havingPermission(this.getContext(), NavACCM.resourceType, sysId, NavACCM.MANAGER.getType());
    }

    public String saveNavigationDirectory(NavigationDirectoryModel model) {
        if (UtilString.isEmpty(model.getId())) {
            NavigationDaoFactory.createNavigationDirectory().insert((NavigationDirectoryModelImpl)model);
        } else {
            ((NavigationDirectoryModelImpl)model).setOrderIndex(NavigationDirectoryCache.getModel(model.getId()).getOrderIndex());
            NavigationDaoFactory.createNavigationDirectory().update((NavigationDirectoryModelImpl)model);
        }
        return ResponseObject.newOkResponse("\u4fdd\u5b58\u6210\u529f").put("id", model.getId()).put("name", model.getDirectoryName()).toString();
    }

    public String saveNavigationFunction(NavigationFunctionModel model) {
        if (UtilString.isEmpty(model.getId())) {
            NavigationDaoFactory.createNavigationFunction().insert((NavigationFunctionModelImpl)model);
        } else {
            ((NavigationFunctionModelImpl)model).setOrderIndex(NavigationFunctionCache.getModel(model.getId()).getOrderIndex());
            NavigationDaoFactory.createNavigationFunction().update((NavigationFunctionModelImpl)model);
        }
        return ResponseObject.newOkResponse("\u4fdd\u5b58\u6210\u529f").put("id", model.getId()).toString();
    }

    public String saveNavigationSystem(NavigationSystemModel model) {
        if (UtilString.isEmpty(model.getId())) {
            NavigationDaoFactory.createNavigationSystem().insert((NavigationSystemModelImpl)model);
            HighSecurity.addNavSysAdministrator(this.getContext(), model.getId());
        } else {
            NavigationDaoFactory.createNavigationSystem().update((NavigationSystemModelImpl)model);
        }
        return ResponseObject.newOkResponse("\u4fdd\u5b58\u6210\u529f").put("id", model.getId()).put("name", model.getSystemName()).toString();
    }

    public String getForm(String systemId, String directoryId, String functionId, boolean sync, boolean isAdd) {
        NavigationFunctionModel model = new NavigationFunctionModelImpl();
        if (!isAdd) {
            model = NavigationFunctionCache.getModel(functionId);
        }
        String url = model.getLinkUrl().equals("") ? "/" : model.getLinkUrl();
        String funName = model.getNameI18N().replace("'", "&apos;");
        String functionIndex = "Auto Sequence";
        String functionName = "<span class='required'><input type='text' name='functionName'  class='txt'  value='" + funName + "'></span>";
        if (!isAdd) {
            functionName = "<span class='required'><input type='text' i18n=\"{'metadataType':'NAV_NAME_','keyID':'" + functionId + "'}\" name='functionName'  class='txt'  value='" + funName + "'></span>";
        }
        String functionUrl = "<span class='required'><input type='text' name='functionUrl' id='functionUrl' class='txt' maxlength=500 size=50 value=\"" + url + "\"></span>";
        String navDesc = "<textarea name=navDesc   class ='txt awsui-textarea'>" + new UtilString(Html.encodeForHTML(model.getNavDesc())).replace("__eol__", "\n") + "</textarea>";
        String icon16 = "<input type='text' style='width:96%;' name='icon16'  class='txt'  onchange=\"showImg(this.value,20,20,'icon16Img');\" value=\"" + model.getIcon16() + "\">";
        String icon16Img = model.getIcon16() != null && model.getIcon16().trim().length() > 0 ? "<img width='16px' height='16px' style='margin-top: 5px;position: relative;right: 0px;background-color:#ccc' src='" + model.getIcon16() + "'>" : "";
        String icon64 = "<input type='text' style='width:96%;' name='icon64'  class='txt'  onchange=\"showImg(this.value,64,64,'icon64Img');\" value=\"" + model.getIcon64() + "\">";
        String icon64Img = model.getIcon64() != null && model.getIcon64().trim().length() > 0 ? "<img width='16px' height='16px' style='margin-top: 5px;position: relative;right: 0px;' src='" + model.getIcon64() + "'>" : "";
        String icon96 = "<input type='text' style='width:96%;' name='icon96'  class='txt'  onchange=\"showImg(this.value,96,96,'icon96Img');\" value=\"" + model.getIcon96() + "\">";
        String icon96Img = model.getIcon96() != null && model.getIcon96().trim().length() > 0 ? "<img width='16px' height='16px' style='margin-top: 5px;position: relative;right: 0px;' src='" + model.getIcon96() + "'>" : "";
        String notifier = "<input type='text' name='notifier'  class='txt'  value=\"" + model.getNotifier() + "\">";
        String orderIndex = "<span class='required'><input type='text' name='orderIndex'  class='txt'  value=\"" + model.getOrderIndex() + "\"></span>";
        String appId = "<input type='text' disabled name='appid'  class='txt'  value=\"" + model.getAppId() + "\">";
        String display = "".equals(model.getAppId()) ? "display:none;" : "";
        StringBuilder workTarget = new StringBuilder();
        workTarget.append("<select id='directoryTarget' name='directoryTarget' onchange='doChange(this)' class ='awsui-select'>");
        int i = 0;
        while (i < workTargets.length) {
            String selected = "";
            if (workTargets[i].equals(model.getLinkTarget())) {
                selected = " selected='selected' ";
            }
            workTarget.append("<option value='").append(workTargets[i]).append("'").append(selected).append(">").append(workTargetsLabel[i]).append("</option>");
            ++i;
        }
        workTarget.append("</select>");
        String sidebarWidth = "";
        try {
            JSONObject ext2 = JSONObject.parseObject((String)model.getExt2());
            sidebarWidth = UtilJson.optString(ext2, "sidebarWidth");
        }
        catch (Exception ext2) {
            // empty catch block
        }
        StringBuilder selectList = new StringBuilder();
        NavigationDirectoryModel nd = NavigationDirectoryCache.getModel(directoryId);
        NavigationSystemModel systemModel = NavigationSystemCache.getModel(nd.getSystemId());
        selectList.append("<input type = \"hidden\" name = 'directoryId' value = " + directoryId + ">" + NavigationUtil.getLangName(this.getContext().getLanguage(), this.transformSpecialString(systemModel.getSystemName())) + "\\" + NavigationUtil.getLangName(this.getContext().getLanguage(), this.transformSpecialString(nd.getDirectoryName())));
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("button1", "<input type=button value='\u4fdd \u5b58'  class ='actionsoftButton' onClick=\"saveNavFunction(frmMain,'CONSOLE_P_NAV_DESIGN_FUNCTION_SAVE');return false;\" name='cr'  border='0'>");
        macroLibraries.put("refresh", sync ? "<script type = 'text/javascript'> parent.syncNavigation('f_" + functionId + "');</script>" : "");
        macroLibraries.put("functionIndex", functionIndex);
        macroLibraries.put("functionId", isAdd ? "" : functionId);
        macroLibraries.put("functionName", functionName);
        macroLibraries.put("functionUrl", functionUrl);
        macroLibraries.put("workTarget", workTarget.toString());
        macroLibraries.put("sidebarWidth", sidebarWidth);
        macroLibraries.put("directoryId", selectList.toString());
        macroLibraries.put("navDesc", navDesc);
        macroLibraries.put("icon16", icon16);
        macroLibraries.put("icon16Img", icon16Img);
        macroLibraries.put("icon64", icon64);
        macroLibraries.put("icon64Img", icon64Img);
        macroLibraries.put("icon96", icon96);
        macroLibraries.put("icon96Img", icon96Img);
        macroLibraries.put("appidStr", model.getAppId().equals("") ? "_bpm.platform" : model.getAppId());
        macroLibraries.put("appid", appId);
        macroLibraries.put("notifier", notifier);
        macroLibraries.put("systemId", systemId);
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("display", display);
        macroLibraries.put("isActivity", this.getNavActivity(model.isActivity()));
        macroLibraries.put("orderIndex", orderIndex);
        if (isAdd) {
            macroLibraries.put("isShowDate", "none");
        } else {
            macroLibraries.put("isShowDate", "");
            macroLibraries.put("createDate", UtilDate.datetimeFormat(model.getCreateDate()));
            macroLibraries.put("updateDate", UtilDate.datetimeFormat(model.getUpdateDate()));
        }
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.nav.function.form.htm", macroLibraries);
    }

    private String transformSpecialString(String str) {
        if (UtilString.isNotEmpty(str) && (str.contains("<") || str.contains(">"))) {
            str = str.replaceAll("[<]", "&lt;");
            str = str.replaceAll("[>]", "&gt;");
        }
        return str;
    }

    public String getForm(String systemId, String directoryId, boolean sync, boolean isAdd) {
        NavigationDirectoryModel model = new NavigationDirectoryModelImpl();
        if (!isAdd) {
            model = NavigationDirectoryCache.getModel(directoryId);
        }
        String url = model.getLinkUrl().equals("") ? "/" : model.getLinkUrl();
        String dirName = model.getNameI18N().replace("'", "&apos;");
        String directoryIndex = "Auto Sequence";
        String directoryName = "<span class='required'><input type='text' name='directoryName'  class='txt'  value='" + dirName + "'></span>";
        if (!isAdd) {
            directoryName = "<span class='required'><input type='text' i18n=\"{'metadataType':'NAV_NAME_','keyID':'" + directoryId + "'}\" name='directoryName'  class='txt'  value='" + dirName + "'></span>";
        }
        String directoryUrl = "<span class='required'><input type='text' name='directoryUrl'  id='directoryUrl' class='txt' value='" + url + "'></span>";
        String icon16 = "<input type='text' style='width:96%;' name='icon16'  class='txt' onchange=\"showImg(this.value,20,20,'icon16Img');\" value=\"" + model.getIcon16() + "\">";
        String icon16Img = model.getIcon16() != null && model.getIcon16().trim().length() > 0 ? "<img width='16px' height='16px'  style='margin-top: 5px;position: relative;right: 0px;background-color:#ccc' src='" + model.getIcon16() + "'>" : "";
        String icon64 = "<input type='text' style='width:96%;' name='icon64'  class='txt' onchange=\"showImg(this.value,64,64,'icon64Img');\" value=\"" + model.getIcon64() + "\">";
        String icon64Img = model.getIcon64() != null && model.getIcon64().trim().length() > 0 ? "<img width='16px' height='16px' style='margin-top: 5px;position: relative;right: 0px;' src='" + model.getIcon64() + "'>" : "";
        String icon96 = "<input type='text' style='width:96%;' name='icon96'  class='txt' onchange=\"showImg(this.value,96,96,'icon96Img');\" value=\"" + model.getIcon96() + "\">";
        String icon96Img = model.getIcon96() != null && model.getIcon96().trim().length() > 0 ? "<img width='16px' height='16px' style='margin-top: 5px;position: relative;right: 0px;' src='" + model.getIcon96() + "'>" : "";
        String notifier = "<input type='text' name='notifier'  class='txt' value=\"" + model.getNotifier() + "\">";
        String orderIndex = "<span class='required'><input type='text' name='orderIndex'  class='txt' value=\"" + model.getOrderIndex() + "\"></span>";
        String navDesc = "<textarea name=navDesc  class ='txt awsui-textarea'>" + new UtilString(model.getNavDesc()).replace("__eol__", "\n") + "</textarea>";
        StringBuilder directoryTarget = new StringBuilder();
        String[] targetArray = new String[]{"mainFrame", "_blank", "sidebar"};
        String[] labelArray = new String[]{"\u4e3b\u5de5\u4f5c\u533a", "\u65b0\u7a97\u53e3", "\u4fa7\u8fb9\u680f"};
        directoryTarget.append("<select name='directoryTarget' id='directoryTarget' onchange='doChange(this)' class ='awsui-select' >");
        int i = 0;
        while (i < targetArray.length) {
            if (!targetArray[i].equals(model.getLinkTarget())) {
                directoryTarget.append("<option value='" + targetArray[i] + "'>" + labelArray[i] + "</option>");
            } else {
                directoryTarget.append("<option value='" + targetArray[i] + "' selected=selected >" + labelArray[i] + "</option>");
            }
            ++i;
        }
        directoryTarget.append("</select>");
        String sidebarWidth = "";
        try {
            JSONObject ext2 = JSONObject.parseObject((String)model.getExt2());
            sidebarWidth = UtilJson.optString(ext2, "sidebarWidth");
        }
        catch (Exception ext2) {
            // empty catch block
        }
        String appId = "<input type='text' disabled name='appid'  class='txt'  value=\"" + model.getAppId() + "\">";
        String display = "".equals(model.getAppId()) ? "display:none;" : "";
        StringBuilder selectList = new StringBuilder();
        String systemName = NavigationSystemCache.getModel(systemId).getNameI18N();
        selectList.append("<input type = \"hidden\" name = 'systemId' value = " + systemId + ">" + this.transformSpecialString(systemName));
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("button1", "<input type=button value='\u4fdd \u5b58'  class ='actionsoftButton' onClick=\"saveNavDirectory(frmMain,'CLIENT_P_NAV_DESIGN_DIRECTORY_SAVE');return false;\" name='cr'  border='0'>");
        macroLibraries.put("refresh", sync ? "<script type = 'text/javascript'> parent.syncNavigation('d_" + directoryId + "');</script>" : "");
        macroLibraries.put("directoryIndex", directoryIndex);
        macroLibraries.put("directoryId", isAdd ? "" : directoryId);
        macroLibraries.put("directoryName", directoryName);
        macroLibraries.put("directoryTarget", directoryTarget.toString());
        macroLibraries.put("sidebarWidth", sidebarWidth);
        macroLibraries.put("directoryUrl", directoryUrl);
        macroLibraries.put("navDesc", navDesc);
        macroLibraries.put("systemId", selectList.toString());
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("isActivity", this.getNavActivity(model.isActivity()));
        macroLibraries.put("icon16", icon16);
        macroLibraries.put("icon16Img", icon16Img);
        macroLibraries.put("icon64", icon64);
        macroLibraries.put("icon64Img", icon64Img);
        macroLibraries.put("icon96", icon96);
        macroLibraries.put("icon96Img", icon96Img);
        macroLibraries.put("appid", appId.equals("") ? "_bpm.platform" : appId);
        macroLibraries.put("appIdVal", "".equals(model.getAppId()) ? "_bpm.platform" : model.getAppId());
        macroLibraries.put("display", display);
        macroLibraries.put("notifier", notifier);
        macroLibraries.put("orderIndex", orderIndex);
        if (isAdd) {
            macroLibraries.put("isShowDate", "none");
        } else {
            macroLibraries.put("isShowDate", "");
            macroLibraries.put("createDate", UtilDate.datetimeFormat(model.getCreateDate()));
            macroLibraries.put("updateDate", UtilDate.datetimeFormat(model.getUpdateDate()));
        }
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.nav.directory.form.htm", macroLibraries);
    }

    private String getNavActivity(boolean activity) {
        StringBuilder sb = new StringBuilder();
        sb.append("<select name='isActivity' class ='awsui-select'>\n");
        sb.append("\t<option value=1 " + (activity ? "selected" : "") + ">\u542f\u7528</option>\n");
        sb.append("\t<option value=0 " + (activity ? "" : "selected") + ">\u5173\u95ed</option>\n");
        sb.append("</select>\n");
        return sb.toString();
    }

    public String getForm(String id, boolean sync, boolean isAdd) {
        NavigationSystemModel model = new NavigationSystemModelImpl();
        if (!isAdd) {
            model = NavigationSystemCache.getModel(id);
        }
        String systemIndex = "Auto Sequence";
        String url = model.getLinkUrl().equals("") ? "/" : model.getLinkUrl();
        String sysName = model.getNameI18N().replace("'", "&apos;");
        String systemName = "<span class='required'><input type='text' name='systemName'  class='txt' maxlength=50 size=50 value='" + sysName + "'></span>";
        if (!isAdd) {
            systemName = "<span class='required'><input type='text' i18n=\"{'metadataType':'NAV_NAME_','keyID':'" + id + "'}\" name='systemName'  class='txt' maxlength=50 size=50 value='" + sysName + "'></span>";
        }
        String linkUrl = "<span class='required'><input type='text' name='linkUrl'  class='txt'  id='system_url' value=\"" + url + "\"></span>";
        String icon16 = "<input type='text' style='width:96%;' name='icon16'  class='txt'  onchange=\"showImg(this.value,20,20,'icon16Img');\" value=\"" + model.getIcon16() + "\">";
        String icon16Img = model.getIcon16() != null && model.getIcon16().trim().length() > 0 ? "<img width='16px' height='16px' style='margin-top: 5px;position: relative;right: 0px;background-color:#ccc' src='" + model.getIcon16() + "'>" : "";
        String icon64 = "<input type='text' style='width:96%;' name='icon64'  class='txt'  onchange=\"showImg(this.value,64,64,'icon64Img');\" value=\"" + model.getIcon64() + "\">";
        String icon64Img = model.getIcon64() != null && model.getIcon64().trim().length() > 0 ? "<img width='16px' height='16px;' style='margin-top: 5px;position: relative;right: 0px;' src='" + model.getIcon64() + "'>" : "";
        String icon96 = "<input type='text' style='width:96%;' name='icon96'  class='txt'  onchange=\"showImg(this.value,96,96,'icon96Img');\" value=\"" + model.getIcon96() + "\">";
        String icon96Img = model.getIcon96() != null && model.getIcon96().trim().length() > 0 ? "<img width='16px' height='16px;' style='margin-top: 5px;position: relative;right: 0px;' src='" + model.getIcon96() + "'>" : "";
        String navDesc = "<textarea name=navDesc   class ='txt awsui-textarea'>" + new UtilString(model.getNavDesc()).replace("__eol__", "\n") + "</textarea>";
        String notifier = "<input type='text' name='notifier'  class='txt'  value=\"" + model.getNotifier() + "\">";
        String orderIndex = "<span class='required'><input type='text' name='orderIndex'  class='txt'  value=\"" + model.getOrderIndex() + "\"></span>";
        StringBuilder workTarget = new StringBuilder();
        String[] targetArray = new String[]{"mainFrame", "_blank"};
        String[] labelArray = new String[]{"\u4e3b\u5de5\u4f5c\u533a", "\u65b0\u7a97\u53e3"};
        workTarget.append("<select name='directoryTarget'  class ='awsui-select'>");
        int i = 0;
        while (i < targetArray.length) {
            if (!targetArray[i].equals(model.getLinkTarget())) {
                workTarget.append("<option value='" + targetArray[i] + "'>" + labelArray[i] + "</option>");
            } else {
                workTarget.append("<option value='" + targetArray[i] + "' selected=selected >" + targetArray[i] + "</option>");
            }
            ++i;
        }
        workTarget.append("</select>");
        StringBuilder isHidden = new StringBuilder();
        isHidden.append("<select name='isHidden'  class ='awsui-select' awsui-qtip='\u6b64\u5f00\u5173\u4ec5\u6709\u6548\u4e8e\u7eafPortal\u95e8\u6237\u7c7b\u76ae\u80a4'>");
        isHidden.append("<option value=1 " + (model.isHidden() ? "selected" : "") + ">\u9690\u85cf</option>");
        isHidden.append("<option value=0 " + (model.isHidden() ? "" : "selected") + ">\u663e\u793a</option>");
        isHidden.append("</select>");
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("button1", "<input type=button value='\u4fdd \u5b58'  class ='actionsoftButton' onClick=\"saveNavSystem(frmMain,'CLIENT_P_NAV_DESIGN_SYSTEM_SAVE');return false;\" name='cr'  border='0'>");
        macroLibraries.put("refresh", sync ? "<script type = 'text/javascript'> parent.syncNavigation('s_" + id + "');</script>" : "");
        macroLibraries.put("systemIndex", systemIndex);
        macroLibraries.put("isHidden", isHidden.toString());
        macroLibraries.put("systemName", systemName);
        macroLibraries.put("icon16", icon16);
        macroLibraries.put("icon16Img", icon16Img);
        macroLibraries.put("icon64", icon64);
        macroLibraries.put("icon64Img", icon64Img);
        macroLibraries.put("icon96", icon96);
        macroLibraries.put("icon96Img", icon96Img);
        macroLibraries.put("navDesc", navDesc);
        macroLibraries.put("appid", model.getAppId().equals("") ? "_bpm.platform" : model.getAppId());
        macroLibraries.put("notifier", notifier);
        macroLibraries.put("linkUrl", linkUrl);
        macroLibraries.put("workTarget", workTarget.toString());
        macroLibraries.put("id", isAdd ? "" : id);
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("isActivity", this.getNavActivity(model.isActivity()));
        macroLibraries.put("orderIndex", orderIndex);
        if (isAdd) {
            macroLibraries.put("isShowDate", "none");
        } else {
            macroLibraries.put("isShowDate", "");
            macroLibraries.put("createDate", UtilDate.datetimeFormat(model.getCreateDate()));
            macroLibraries.put("updateDate", UtilDate.datetimeFormat(model.getUpdateDate()));
        }
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.nav.system.form.htm", macroLibraries);
    }

    public String getMainDesignConsole() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this.getContext().getSessionId());
        macroLibraries.put("isAdmin", String.valueOf(this.getContext().getUID().equals("admin") || HighSecurity.isON() && HighSecurity.is3PSysAdmin(this.getContext())));
        String exportBtn = "";
        if (HighSecurity.isON()) {
            if (GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
                exportBtn = "<button id=\"exportNavs\" type=\"button\" class=\"button\" onclick=\"exportNavs();\" style=\"margin-right:10px;\">\u5bfc\u51fa\u6743\u9650\u5217\u8868</button>";
            } else {
                List<String> ls;
                String users;
                boolean isAppActive;
                AppAPI appApi = SDK.getAppAPI();
                AppContext appContext = appApi.getAppContext("com.actionsoft.apps.high.security");
                if (appContext != null && (isAppActive = SDK.getAppAPI().isActive(appContext)) && !UtilString.isEmpty(users = appApi.getProperty("com.actionsoft.apps.high.security", "exportUsers")) && (ls = Arrays.asList(users.split(","))).contains(this.getContext().getUID())) {
                    exportBtn = "<button id=\"exportNavs\" type=\"button\" class=\"button\" onclick=\"exportNavs();\" style=\"margin-right:10px;\">\u5bfc\u51fa\u6743\u9650\u5217\u8868</button>";
                }
            }
        }
        macroLibraries.put("exportBtn", exportBtn);
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.nav.home.htm", macroLibraries);
    }

    public String getGridData(String tid) {
        JSONArray jsonArray;
        block6: {
            block7: {
                block5: {
                    jsonArray = new JSONArray();
                    if (!ROOT.equals(tid)) break block5;
                    Iterator<NavigationSystemModel> ns = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
                    while (ns.hasNext()) {
                        NavigationSystemModel navigationSystemModel = ns.next();
                        String appId = navigationSystemModel.getAppId();
                        boolean isManager = AMCAPIManager.isManagementApp(appId, this.getContext().getUID());
                        List<NavigationDirectoryModel> dirs = NavigationDirectoryCache.getListOfSystem(navigationSystemModel.getId());
                        boolean isHas = this.isHasOtherAppOfDirectory(dirs, appId);
                        if (isHas) {
                            isManager = true;
                        }
                        if (!appId.equals("") && !isManager || "obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(navigationSystemModel.getId()) || !this.hasSystemRight(navigationSystemModel.getId()) && (!HighSecurity.isON() || !HighSecurity.is3PSysAdmin(this.getContext().getUID()))) continue;
                        JSONObject jsonObject = new JSONObject();
                        String navDesc = "&nbsp;&nbsp;<span style='color:#999;' title='" + Html.encodeForHTMLAttribute(navigationSystemModel.getNavDesc()) + "'>" + Html.encodeForHTML(navigationSystemModel.getNavDesc()) + "</span>";
                        jsonObject.put("id", (Object)("s_" + navigationSystemModel.getId()));
                        jsonObject.put("fullId", (Object)navigationSystemModel.getId());
                        jsonObject.put("navuuid", (Object)navigationSystemModel.getId());
                        jsonObject.put("isActivity", (Object)navigationSystemModel.isActivity());
                        jsonObject.put("orderIndex", (Object)navigationSystemModel.getOrderIndex());
                        jsonObject.put("name", (Object)("<span style='font-size:13px;'>" + Html.escape(navigationSystemModel.getNameI18N()).replace(" ", "&nbsp;") + "</span>" + navDesc));
                        jsonObject.put("link", (Object)navigationSystemModel.getLinkUrl());
                        jsonObject.put("target", (Object)navigationSystemModel.getLinkTarget());
                        jsonObject.put("command", (Object)this.getOperationList("s_" + navigationSystemModel.getId()));
                        jsonObject.put("fullName", (Object)navigationSystemModel.getNameI18N());
                        jsonObject.put("appId", (Object)(appId.equals("") ? "_bpm.platform" : appId));
                        jsonArray.add((Object)jsonObject);
                    }
                    break block6;
                }
                if (!tid.startsWith("s_")) break block7;
                List<NavigationDirectoryModel> nd = NavigationDirectoryCache.getListOfSystem(tid.substring(2));
                NavigationSystemModel navigationSystemModel = NavigationSystemCache.getModel(tid.substring(2));
                for (NavigationDirectoryModel navigationDirectoryModel : nd) {
                    String appId = navigationDirectoryModel.getAppId();
                    boolean isManager = AMCAPIManager.isManagementApp(appId, this.getContext().getUID());
                    List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
                    boolean isHas = this.isHasOtherAppOfFunction(functions, appId);
                    if (isHas) {
                        isManager = true;
                    }
                    if (!appId.equals("") && !isManager) continue;
                    JSONObject jsonObject = new JSONObject();
                    String navDesc = "&nbsp;&nbsp;<span style='color:#999; title='" + Html.encodeForHTMLAttribute(navigationDirectoryModel.getNavDesc()) + "'>" + Html.encodeForHTML(navigationDirectoryModel.getNavDesc()) + "</span>";
                    jsonObject.put("id", (Object)("d_" + navigationDirectoryModel.getId()));
                    jsonObject.put("fullId", (Object)navigationDirectoryModel.getId());
                    jsonObject.put("navuuid", (Object)navigationDirectoryModel.getId());
                    jsonObject.put("isActivity", (Object)(navigationDirectoryModel.isActivity() && navigationSystemModel.isActivity() ? 1 : 0));
                    jsonObject.put("orderIndex", (Object)navigationDirectoryModel.getOrderIndex());
                    jsonObject.put("name", (Object)("<span style='font-size:13px;'>" + Html.encodeForHTML(navigationDirectoryModel.getNameI18N()).replace(" ", "&nbsp;") + "</span>" + navDesc));
                    jsonObject.put("link", (Object)navigationDirectoryModel.getLinkUrl());
                    jsonObject.put("target", (Object)navigationDirectoryModel.getLinkTarget());
                    jsonObject.put("command", (Object)this.getOperationList("d_" + navigationDirectoryModel.getId()));
                    jsonObject.put("fullName", (Object)navigationDirectoryModel.getNameI18N());
                    jsonObject.put("appId", (Object)(appId.equals("") ? "_bpm.platform" : appId));
                    jsonArray.add((Object)jsonObject);
                }
                break block6;
            }
            if (!tid.startsWith("d_")) break block6;
            List<NavigationFunctionModel> nf = NavigationFunctionCache.getListOfDirectory(tid.substring(2));
            NavigationDirectoryModel nd = NavigationDirectoryCache.getModel(tid.substring(2));
            NavigationSystemModel ns = NavigationSystemCache.getModel(nd.getSystemId());
            for (NavigationFunctionModel navigationFunctionModel : nf) {
                String appId = navigationFunctionModel.getAppId();
                if (!appId.equals("") && !AMCAPIManager.isManagementApp(appId, this.getContext().getUID())) continue;
                JSONObject jsonObject = new JSONObject();
                String navDesc = "&nbsp;&nbsp;<span style='color:#999; title='" + Html.encodeForHTML(navigationFunctionModel.getNavDesc()) + "'>" + Html.encodeForHTML(navigationFunctionModel.getNavDesc()) + "</span>";
                jsonObject.put("id", (Object)("f_" + navigationFunctionModel.getId()));
                jsonObject.put("fullId", (Object)navigationFunctionModel.getId());
                jsonObject.put("navuuid", (Object)navigationFunctionModel.getId());
                jsonObject.put("isActivity", (Object)(navigationFunctionModel.isActivity() && ns.isActivity() && nd.isActivity() ? 1 : 0));
                jsonObject.put("orderIndex", (Object)navigationFunctionModel.getOrderIndex());
                jsonObject.put("name", (Object)("<span style='font-size:13px;'>" + Html.escape(navigationFunctionModel.getNameI18N()).replace(" ", "&nbsp;") + navDesc + "</span>"));
                jsonObject.put("link", (Object)navigationFunctionModel.getLinkUrl());
                jsonObject.put("target", (Object)navigationFunctionModel.getLinkTarget());
                jsonObject.put("command", (Object)this.getOperationList("f_" + navigationFunctionModel.getId()));
                jsonObject.put("fullName", (Object)navigationFunctionModel.getNameI18N());
                jsonObject.put("appId", (Object)(appId.equals("") ? "_bpm.platform" : appId));
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray.toString();
    }

    public String exportNavs() {
        try {
            SXSSFWorkbook wb = new SXSSFWorkbook(999999);
            SXSSFSheet sheet = wb.createSheet();
            XSSFCellStyle headStyle = this.createHeadStyle(wb, "left");
            XSSFCellStyle headStyleC = this.createHeadStyle(wb, "center");
            XSSFCellStyle cellStyleC = this.createCellStyle(wb, "center", "normal");
            XSSFCellStyle cellStyle = this.createCellStyle(wb, "left", "normal");
            Row row = sheet.createRow(0);
            row.setHeight((short)500);
            this.createCell((Sheet)sheet, row, 0, headStyleC, 10000, I18nRes.findValue("_bpm.platform", "\u7528\u6237\u8d26\u53f7"));
            this.createCell((Sheet)sheet, row, 1, headStyle, 10000, I18nRes.findValue("_bpm.platform", "\u7528\u6237\u540d\u79f0"));
            this.createCell((Sheet)sheet, row, 2, headStyle, 10000, I18nRes.findValue("_bpm.platform", "\u4e00\u7ea7\u83dc\u5355\u540d\u79f0"));
            this.createCell((Sheet)sheet, row, 3, headStyle, 10000, I18nRes.findValue("_bpm.platform", "\u4e8c\u7ea7\u83dc\u5355\u540d\u79f0"));
            this.createCell((Sheet)sheet, row, 4, headStyleC, 10000, I18nRes.findValue("_bpm.platform", "\u4e09\u7ea7\u83dc\u5355\u540d\u79f0"));
            List dataList = UserCache.getActiveList();
            int k = 0;
            for (UserModel model : dataList) {
                String uid = model.getUID();
                if (GradeSecurityUtil.isSystemMaster(uid) || GradeSecurityUtil.isSecurityMaster(uid) && !GradeSecurityUtil.isAuditorMaster(uid)) continue;
                String userName = model.getUserName();
                Iterator<NavigationSystemModel> systemList = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
                while (systemList.hasNext()) {
                    NavigationSystemModel navigationSystemModel = systemList.next();
                    if (NavigationUtil.isSystemNavigation(navigationSystemModel) || !PermAPIManager.getInstance().havingModelPermission(uid, navigationSystemModel.getId())) continue;
                    String sysName = navigationSystemModel.getSystemName();
                    row = sheet.createRow(k + 1);
                    row.setHeight((short)375);
                    this.createCell(row, 0, cellStyle, uid);
                    this.createCell(row, 1, cellStyle, userName);
                    this.createCell(row, 2, cellStyle, sysName);
                    this.createCell(row, 3, cellStyle, "");
                    this.createCell(row, 4, cellStyle, "");
                    ++k;
                    List<NavigationDirectoryModel> directoryList = NavigationDirectoryCache.getListOfSystem(navigationSystemModel.getId());
                    if (directoryList == null) continue;
                    for (NavigationDirectoryModel navigationDirectoryModel : directoryList) {
                        if (!PermAPIManager.getInstance().havingModelPermission(uid, navigationDirectoryModel.getId())) continue;
                        String directName = navigationDirectoryModel.getDirectoryName();
                        row = sheet.createRow(k + 1);
                        row.setHeight((short)375);
                        this.createCell(row, 0, cellStyle, uid);
                        this.createCell(row, 1, cellStyle, userName);
                        this.createCell(row, 2, cellStyle, sysName);
                        this.createCell(row, 3, cellStyle, directName);
                        this.createCell(row, 4, cellStyle, "");
                        ++k;
                        List<NavigationFunctionModel> functionList = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
                        if (functionList == null || functionList.size() <= 0) continue;
                        for (NavigationFunctionModel navigationFunctionModel : functionList) {
                            if (!PermAPIManager.getInstance().havingModelPermission(uid, navigationFunctionModel.getId())) continue;
                            String funName = navigationFunctionModel.getFunctionName();
                            row = sheet.createRow(k + 1);
                            row.setHeight((short)375);
                            this.createCell(row, 0, cellStyle, uid);
                            this.createCell(row, 1, cellStyle, userName);
                            this.createCell(row, 2, cellStyle, sysName);
                            this.createCell(row, 3, cellStyle, directName);
                            this.createCell(row, 4, cellStyle, funName);
                            ++k;
                        }
                    }
                }
            }
            DCContext dc = ImpExpHelper.createExcel2007TmpFile((SXSSFWorkbook)wb, (String)"_bpm.platform");
            dc.setSession(this.getContext());
            DCPluginProfile dcProfile = SDK.getDCAPI().getDCProfile("_bpm.platform", "tmp");
            if (dcProfile == null) {
                throw new AWSException("Not Find DCProfile! repositoryName=tmp");
            }
            dc.setDCProfile(dcProfile);
            String auditObject = "\u7528\u6237\u6743\u9650\u5217\u8868\u6587\u4ef6\u540d\u79f0\uff1a" + dc.getFileName();
            String logInfo = "\u7528\u6237\u6743\u9650\u5217\u8868\u5bfc\u51fa\u8def\u5f84\uff1a" + dc.getFilePath();
            SDK.getLogAPI().auditClient("client", this.getContext().getUID(), AuditConst.getOpI18N("\u5bfc\u51fa"), auditObject, logInfo, this.getContext().getClientIP(), Level.INFO);
            return ResponseObject.newOkResponse(dc.getDownloadURL()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse(e.getMessage()).toString();
        }
    }

    private void createCell(Row row, int index, XSSFCellStyle style, String value) {
        this.createCell(null, row, index, style, null, value);
    }

    private void createCell(Sheet sheet, Row row, int index, XSSFCellStyle style, Integer w, String value) {
        Cell cell = row.createCell(index);
        if (w != null) {
            sheet.setColumnWidth(index, w.intValue());
        }
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue(value);
    }

    private XSSFCellStyle createHeadStyle(SXSSFWorkbook wb, String align) {
        XSSFCellStyle cellStyle = this.createCellStyle(wb, align, "normal");
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font hf = wb.createFont();
        hf.setFontHeightInPoints((short)12);
        hf.setBold(true);
        cellStyle.setFont(hf);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        return cellStyle;
    }

    private XSSFCellStyle createCellStyle(SXSSFWorkbook wb, String align, String color) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if ("center".equals(align)) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
        } else if ("left".equals(align)) {
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
        } else {
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        }
        if ("red".equals(color)) {
            Font hf = wb.createFont();
            hf.setColor((short)10);
            cellStyle.setFont(hf);
        } else if ("blue".equals(color)) {
            Font hf = wb.createFont();
            hf.setColor(HSSFColor.BLUE.index);
            cellStyle.setFont(hf);
        } else if ("yellow".equals(color)) {
            Font hf = wb.createFont();
            hf.setColor(HSSFColor.YELLOW.index);
            cellStyle.setFont(hf);
        }
        return cellStyle;
    }

    public String getNavigationTreeNodes(String tid) {
        JSONObject n;
        JSONObject attributes;
        NavigationSystemModel navigationSystemModel;
        JSONObject n2;
        JSONObject jsonObject;
        JSONObject attributes2;
        boolean isHas;
        boolean isManager;
        String appId;
        JSONArray jsonArray = new JSONArray();
        if (tid != null && tid.equals("ROOT")) {
            JSONObject root = new JSONObject();
            root.put("id", (Object)ROOT);
            root.put("name", (Object)I18nRes.findValue("_bpm.platform", "\u5bfc\u822a\u83dc\u5355"));
            root.put("open", (Object)true);
            JSONObject r = new JSONObject();
            r.put("code", (Object)"&#59366;");
            r.put("color", (Object)"#3383da");
            root.put("iconFont", (Object)r);
            jsonArray.add((Object)root);
            Iterator<NavigationSystemModel> ns = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
            while (ns.hasNext()) {
                NavigationSystemModel navigationSystemModel2 = ns.next();
                appId = navigationSystemModel2.getAppId();
                isManager = AMCAPIManager.isManagementApp(appId, this.getContext().getUID());
                List<NavigationDirectoryModel> dirs = NavigationDirectoryCache.getListOfSystem(navigationSystemModel2.getId());
                isHas = this.isHasOtherAppOfDirectory(dirs, appId);
                if (isHas) {
                    isManager = true;
                }
                if (!appId.equals("") && (!isManager || appId.equals("")) || "obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(navigationSystemModel2.getId()) || !this.hasSystemRight(navigationSystemModel2.getId())) continue;
                attributes2 = new JSONObject();
                attributes2.put("isActivity", (Object)navigationSystemModel2.isActivity());
                attributes2.put("orderIndex", (Object)navigationSystemModel2.getOrderIndex());
                jsonObject = new JSONObject();
                jsonObject.put("id", (Object)("s_" + navigationSystemModel2.getId()));
                jsonObject.put("pid", (Object)ROOT);
                jsonObject.put("name", (Object)navigationSystemModel2.getNameI18N());
                if ("obj_007801f265cbfd38310eb1acdd53dc02".equals(navigationSystemModel2.getId())) {
                    jsonObject.put("allowDrag", (Object)false);
                } else {
                    jsonObject.put("allowDrag", (Object)true);
                }
                jsonObject.put("open", (Object)false);
                n2 = new JSONObject();
                n2.put("code", (Object)"&#58983;");
                n2.put("color", (Object)"#3383da");
                jsonObject.put("iconFont", (Object)n2);
                jsonObject.put("disabled", (Object)(!navigationSystemModel2.isActivity() ? 1 : 0));
                jsonObject.put("attributes", (Object)attributes2);
                jsonArray.add((Object)jsonObject);
            }
        }
        if (tid != null && tid.equals(ROOT)) {
            Iterator<NavigationSystemModel> ns = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
            while (ns.hasNext()) {
                navigationSystemModel = ns.next();
                String appId2 = navigationSystemModel.getAppId();
                boolean isManager2 = AMCAPIManager.isManagementApp(appId2, this.getContext().getUID());
                List<NavigationDirectoryModel> dirs = NavigationDirectoryCache.getListOfSystem(navigationSystemModel.getId());
                boolean isHas2 = this.isHasOtherAppOfDirectory(dirs, appId2);
                if (isHas2) {
                    isManager2 = true;
                }
                if (!appId2.equals("") && (!isManager2 || appId2.equals("")) || ("obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(navigationSystemModel.getId()) || !this.hasSystemRight(navigationSystemModel.getId())) && (!HighSecurity.isON() || !HighSecurity.is3PSysAdmin(this.getContext().getUID()))) continue;
                attributes = new JSONObject();
                attributes.put("isActivity", (Object)navigationSystemModel.isActivity());
                attributes.put("orderIndex", (Object)navigationSystemModel.getOrderIndex());
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("id", (Object)("s_" + navigationSystemModel.getId()));
                jsonObject2.put("pid", (Object)ROOT);
                jsonObject2.put("name", (Object)navigationSystemModel.getNameI18N());
                if ("obj_007801f265cbfd38310eb1acdd53dc02".equals(navigationSystemModel.getId())) {
                    jsonObject2.put("allowDrag", (Object)false);
                } else {
                    jsonObject2.put("allowDrag", (Object)true);
                }
                jsonObject2.put("open", (Object)false);
                n = new JSONObject();
                n.put("code", (Object)"&#58983;");
                n.put("color", (Object)"#3383da");
                jsonObject2.put("iconFont", (Object)n);
                jsonObject2.put("disabled", (Object)(!navigationSystemModel.isActivity() ? 1 : 0));
                jsonObject2.put("attributes", (Object)attributes);
                jsonArray.add((Object)jsonObject2);
            }
        } else if (tid.startsWith("s_")) {
            List<NavigationDirectoryModel> nd = NavigationDirectoryCache.getListOfSystem(tid.substring(2));
            navigationSystemModel = NavigationSystemCache.getModel(tid.substring(2));
            for (NavigationDirectoryModel navigationDirectoryModel : nd) {
                appId = navigationDirectoryModel.getAppId();
                isManager = AMCAPIManager.isManagementApp(appId, this.getContext().getUID());
                List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
                isHas = this.isHasOtherAppOfFunction(functions, appId);
                if (isHas) {
                    isManager = true;
                }
                if (!appId.equals("") && (!isManager || appId.equals(""))) continue;
                attributes2 = new JSONObject();
                attributes2.put("isActivity", (Object)(navigationSystemModel.isActivity() && navigationDirectoryModel.isActivity() ? 1 : 0));
                attributes2.put("orderIndex", (Object)navigationDirectoryModel.getOrderIndex());
                jsonObject = new JSONObject();
                jsonObject.put("id", (Object)("d_" + navigationDirectoryModel.getId()));
                jsonObject.put("pid", (Object)tid);
                jsonObject.put("name", (Object)navigationDirectoryModel.getNameI18N());
                jsonObject.put("allowDrag", (Object)true);
                jsonObject.put("open", (Object)false);
                n2 = new JSONObject();
                n2.put("code", (Object)"&#59675;");
                n2.put("color", (Object)"#3383da");
                jsonObject.put("iconFont", (Object)n2);
                jsonObject.put("disabled", (Object)(!navigationSystemModel.isActivity() || !navigationDirectoryModel.isActivity() ? 1 : 0));
                jsonObject.put("attributes", (Object)attributes2);
                jsonArray.add((Object)jsonObject);
            }
        } else if (tid.startsWith("d_")) {
            List<NavigationFunctionModel> nf = NavigationFunctionCache.getListOfDirectory(tid.substring(2));
            NavigationDirectoryModel navigationDirectoryModel = NavigationDirectoryCache.getModel(tid.substring(2));
            NavigationSystemModel navigationSystemModel3 = NavigationSystemCache.getModel(navigationDirectoryModel.getSystemId());
            for (NavigationFunctionModel navigationFunctionModel : nf) {
                String appId3 = navigationFunctionModel.getAppId();
                if (!appId3.equals("") && (!AMCAPIManager.isManagementApp(appId3, this.getContext().getUID()) || appId3.equals(""))) continue;
                attributes = new JSONObject();
                attributes.put("isActivity", (Object)(navigationSystemModel3.isActivity() && navigationDirectoryModel.isActivity() && navigationFunctionModel.isActivity() ? 1 : 0));
                attributes.put("orderIndex", (Object)navigationFunctionModel.getOrderIndex());
                JSONObject jsonObject3 = new JSONObject();
                jsonObject3.put("id", (Object)("f_" + navigationFunctionModel.getId()));
                jsonObject3.put("pid", (Object)tid);
                jsonObject3.put("name", (Object)navigationFunctionModel.getNameI18N());
                jsonObject3.put("allowDrag", (Object)true);
                n = new JSONObject();
                n.put("code", (Object)"&#58902;");
                n.put("color", (Object)"#3383da");
                jsonObject3.put("iconFont", (Object)n);
                jsonObject3.put("disabled", (Object)(!navigationSystemModel3.isActivity() || !navigationDirectoryModel.isActivity() || !navigationFunctionModel.isActivity() ? 1 : 0));
                jsonObject3.put("attributes", (Object)attributes);
                jsonObject3.put("leaf", (Object)true);
                jsonArray.add((Object)jsonObject3);
            }
        }
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JSONObject jObject = jsonArray.getJSONObject(i);
                String menuName = (String)jObject.get((Object)"name");
                menuName = this.transformSpecialString(menuName);
                jObject.put("name", (Object)menuName);
                ++i;
            }
        }
        return jsonArray.toString();
    }

    private boolean isHasOtherAppOfFunction(List<NavigationFunctionModel> functions, String appId) {
        boolean isHas = false;
        for (NavigationFunctionModel navigationFunctionModel : functions) {
            if (navigationFunctionModel.getAppId().equals(appId)) continue;
            isHas = true;
            break;
        }
        if (functions.size() == 0) {
            isHas = true;
        }
        return isHas;
    }

    private boolean isHasOtherAppOfDirectory(List<NavigationDirectoryModel> dirs, String appId) {
        boolean isHas = false;
        for (NavigationDirectoryModel navigationDirectoryModel : dirs) {
            if (!navigationDirectoryModel.getAppId().trim().equals(appId)) {
                isHas = true;
                break;
            }
            List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
            isHas = this.isHasOtherAppOfFunction(functions, appId);
            if (!isHas) continue;
            isHas = true;
            break;
        }
        if (dirs.size() == 0) {
            isHas = true;
        }
        return isHas;
    }

    private boolean isAppManager(Map<String, Boolean> mgr, String appId) {
        if (UtilString.isEmpty(appId)) {
            return true;
        }
        Boolean b = mgr.get(appId);
        if (b == null) {
            b = AMCAPIManager.isManagementApp(appId, this.getContext().getUID());
            mgr.put(appId, b);
        }
        return b;
    }

    private boolean hasSysAc(Map<String, Boolean> mgr, String sysId) {
        Boolean b = mgr.get(sysId);
        if (b == null) {
            b = this.hasSystemRight(sysId);
            mgr.put(sysId, b);
        }
        return b;
    }

    public String getSearcherJson(int currentPage, int limit, String query) {
        ResponseObject responseObject = ResponseObject.newOkResponse();
        HashMap<String, Integer> newJson = new HashMap<String, Integer>();
        JSONArray result = new JSONArray();
        int max = 20;
        Iterator sysMap = NavigationSystemCache.getCache().iterator();
        HashMap<String, Boolean> mgr = new HashMap<String, Boolean>();
        HashMap<String, Boolean> sysAc = new HashMap<String, Boolean>();
        while (sysMap.hasNext()) {
            JSONObject object = new JSONObject();
            NavigationSystemModel sysModel = (NavigationSystemModel)sysMap.next();
            String appId = sysModel.getAppId();
            if (result.size() > max) break;
            if (!"".equals(query) && !NavigationUtil.getLangName(this.getContext().getLanguage(), sysModel.getSystemName()).toUpperCase().contains(query.toUpperCase()) || "obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(sysModel.getId()) || !this.isAppManager(mgr, appId) || !this.hasSysAc(sysAc, sysModel.getId())) continue;
            object.put("id", (Object)sysModel.getId());
            object.put("appId", (Object)appId);
            object.put("pid", (Object)ROOT);
            object.put("directoryId", (Object)"");
            object.put("groupName", (Object)"System");
            object.put("treeId", (Object)("s_" + sysModel.getId()));
            String name = NavigationUtil.getLangName(this.getContext().getLanguage(), sysModel.getSystemName());
            int index = name.toUpperCase().indexOf(query.toUpperCase());
            if (index > -1) {
                name = String.valueOf(name.substring(0, index)) + "<hl class='awsui-search-highlight'>" + name.substring(index, query.length() + index) + "</hl>" + name.substring(query.length() + index, name.length());
            }
            object.put("name", (Object)("<span style='margin-right:2px;'><i class='awsui-iconfont' style='font-size:13px;color:#3383da;'>&#58983;</i></span>" + name));
            object.put("linkUrl", (Object)sysModel.getLinkUrl());
            result.add((Object)object);
        }
        Iterator nvMap = NavigationDirectoryCache.getCache().iterator();
        while (nvMap.hasNext()) {
            if (result.size() > max) break;
            JSONObject object = new JSONObject();
            NavigationDirectoryModel nvModel = (NavigationDirectoryModel)nvMap.next();
            String appId = nvModel.getAppId();
            if (!"".equals(query) && !NavigationUtil.getLangName(this.getContext().getLanguage(), nvModel.getDirectoryName()).toUpperCase().contains(query.toUpperCase()) || "obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(nvModel.getSystemId()) || !this.isAppManager(mgr, appId) || !this.hasSysAc(sysAc, nvModel.getSystemId())) continue;
            NavigationSystemModel sysModel = NavigationSystemCache.getModel(nvModel.getSystemId());
            object.put("id", (Object)nvModel.getId());
            object.put("appId", (Object)appId);
            object.put("groupName", (Object)"Directory");
            object.put("treeId", (Object)("d_" + nvModel.getId()));
            object.put("pid", (Object)("s_" + sysModel.getId()));
            object.put("directoryId", (Object)nvModel.getSystemId());
            String name = NavigationUtil.getLangName(this.getContext().getLanguage(), nvModel.getDirectoryName());
            int index = name.toUpperCase().indexOf(query.toUpperCase());
            if (index > -1) {
                name = String.valueOf(name.substring(0, index)) + "<span class='awsui-search-highlight'>" + name.substring(index, query.length() + index) + "</span>" + name.substring(query.length() + index, name.length());
            }
            object.put("name", (Object)("<span style='margin-right:2px;'><i class='awsui-iconfont' style='font-size:13px;color:#3383da;'>&#59675;</i></span>" + name));
            object.put("linkUrl", (Object)nvModel.getLinkUrl());
            result.add((Object)object);
        }
        Iterator map = NavigationFunctionCache.getCache().iterator();
        while (map.hasNext()) {
            NavigationDirectoryModel nvModel;
            if (result.size() > max) break;
            JSONObject object = new JSONObject();
            NavigationFunctionModel fuModel = (NavigationFunctionModel)map.next();
            String appId = fuModel.getAppId();
            if (!"".equals(query) && !NavigationUtil.getLangName(this.getContext().getLanguage(), fuModel.getFunctionName()).toUpperCase().contains(query.toUpperCase()) || !this.isAppManager(mgr, appId) || (nvModel = NavigationDirectoryCache.getModel(fuModel.getDirectoryId())) != null && "obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(nvModel.getSystemId()) || nvModel != null && !this.hasSysAc(sysAc, nvModel.getSystemId())) continue;
            String pid = "";
            if (!UtilString.isEmpty(nvModel)) {
                pid = "d_" + nvModel.getId() + "|" + "s_" + nvModel.getSystemId();
            }
            object.put("id", (Object)fuModel.getId());
            object.put("directoryId", (Object)fuModel.getDirectoryId());
            String name = NavigationUtil.getLangName(this.getContext().getLanguage(), fuModel.getFunctionName());
            int index = name.toUpperCase().indexOf(query.toUpperCase());
            if (index > -1) {
                name = String.valueOf(name.substring(0, index)) + "<span class='awsui-search-highlight'>" + name.substring(index, query.length() + index) + "</span>" + name.substring(query.length() + index, name.length());
            }
            object.put("name", (Object)("<span style='margin-right:2px;'><i class='awsui-iconfont' style='font-size:13px;color:#3383da;'>&#58902;</i></span>" + name));
            object.put("linkUrl", (Object)fuModel.getLinkUrl());
            object.put("appId", (Object)appId);
            object.put("groupName", (Object)"Function");
            object.put("pid", (Object)pid);
            object.put("treeId", (Object)("f_" + fuModel.getId()));
            result.add((Object)object);
        }
        mgr.clear();
        mgr = null;
        sysAc.clear();
        sysAc = null;
        JSONArray returnJson = new JSONArray();
        for (Object o : result) {
            returnJson.add(o);
        }
        newJson.put("totalRecords", result.size());
        newJson.put("curPage", currentPage);
        newJson.put("data", (Integer)returnJson);
        responseObject.put("data", JSONObject.parseObject((String)JSON.toJSONString(newJson)));
        return responseObject.toString();
    }

    public String navigationSaveOrderIndex(String navIndexArr) {
        JSONArray jsonNavArr = JSONArray.parseArray((String)navIndexArr);
        NavigationFunction navigationFunction = NavigationDaoFactory.createNavigationFunction();
        NavigationSystem navigationSystem = NavigationDaoFactory.createNavigationSystem();
        NavigationDirectory navigationDirectory = NavigationDaoFactory.createNavigationDirectory();
        int i = 0;
        while (i < jsonNavArr.size()) {
            PlatformMetaModelBean modelCache;
            PlatformMetaModelBean modelSql;
            int initOrderIndex;
            JSONObject navObj = jsonNavArr.getJSONObject(i);
            String tid = navObj.getString("id");
            int orderIndex = Integer.valueOf(navObj.getString("orderIndex"));
            if (tid.startsWith("f_")) {
                NavigationFunctionModelImpl functionModel = (NavigationFunctionModelImpl)NavigationFunctionCache.getModel(tid.substring(2));
                initOrderIndex = functionModel.getOrderIndex();
                if (orderIndex != initOrderIndex) {
                    modelSql = (NavigationFunctionModelImpl)NavigationDaoFactory.createNavigationFunction().queryBy("ORDERINDEX=? AND DIRECTORYID=?", orderIndex, functionModel.getDirectoryId());
                    if (modelSql != null) {
                        modelCache = (NavigationFunctionModelImpl)NavigationFunctionCache.getModel(((NavigationFunctionModelImpl)modelSql).getId());
                        ((NavigationFunctionModelImpl)modelCache).setOrderIndex(initOrderIndex);
                        navigationFunction.update((NavigationFunctionModelImpl)modelCache);
                    }
                    functionModel.setOrderIndex(orderIndex);
                    navigationFunction.update(functionModel);
                }
            } else if (tid.startsWith("d_")) {
                NavigationDirectoryModelImpl directoryModel = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(tid.substring(2));
                initOrderIndex = directoryModel.getOrderIndex();
                modelSql = (NavigationDirectoryModelImpl)NavigationDaoFactory.createNavigationDirectory().queryBy("ORDERINDEX=? AND SYSTEMID=?", orderIndex, directoryModel.getSystemId());
                if (orderIndex != initOrderIndex) {
                    if (modelSql != null) {
                        modelCache = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(((NavigationDirectoryModelImpl)modelSql).getId());
                        ((NavigationDirectoryModelImpl)modelCache).setOrderIndex(initOrderIndex);
                        navigationDirectory.update((NavigationDirectoryModelImpl)modelCache);
                    }
                    directoryModel.setOrderIndex(orderIndex);
                    navigationDirectory.update(directoryModel);
                }
            } else if (tid.startsWith("s_")) {
                NavigationSystemModelImpl systemModel = (NavigationSystemModelImpl)NavigationSystemCache.getModel(tid.substring(2));
                initOrderIndex = systemModel.getOrderIndex();
                modelSql = (NavigationSystemModelImpl)NavigationDaoFactory.createNavigationSystem().queryBy("ORDERINDEX=?", orderIndex);
                if (orderIndex != initOrderIndex) {
                    if (modelSql != null) {
                        modelCache = (NavigationSystemModelImpl)NavigationSystemCache.getModel(((NavigationSystemModelImpl)modelSql).getId());
                        ((NavigationSystemModelImpl)modelCache).setOrderIndex(initOrderIndex);
                        navigationSystem.update((NavigationSystemModelImpl)modelCache);
                    }
                    systemModel.setOrderIndex(orderIndex);
                    navigationSystem.update(systemModel);
                }
            }
            ++i;
        }
        return ResponseObject.newOkResponse().msg("\u64cd\u4f5c\u6210\u529f").toString();
    }
}

