/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.web;

import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationFunctionModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.NavACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FunctionDeployWeb {
    private UserContext _me;

    public FunctionDeployWeb(UserContext me) {
        this._me = me;
    }

    public String getWeb(NavigationFunctionModel navigation) {
        NavigationFunctionModel model = NavigationFunctionCache.getModelByURL(navigation.getLinkUrl());
        if (model == null) {
            ((NavigationFunctionModelImpl)navigation).setId(UUIDGener.getObjectId());
            model = navigation;
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sysList", this.getSysList(model));
        macroLibraries.put("menuList", this.getMenuList(model));
        macroLibraries.put("name", model.getFunctionName());
        macroLibraries.put("icon", model.getIcon16());
        macroLibraries.put("desc", model.getNavDesc());
        macroLibraries.put("workTarget", this.getTarget(model));
        macroLibraries.put("hidden", this.getHidden(model));
        return HtmlPageTemplate.merge("_bpm.platform", "console.common.nav.deploy.htm", macroLibraries);
    }

    private boolean hasSystemRight(String sysId) {
        return "admin".equals(this._me.getUID()) || AccessControlAPI.getInstance().havingPermission(this._me, NavACCM.resourceType, sysId, NavACCM.MANAGER.getType()) || GradeSecurityUtil.isSystemMaster(this._me.getUID());
    }

    private String getTarget(NavigationFunctionModel navigation) {
        StringBuilder sb = new StringBuilder();
        if ("".equals(navigation.getLinkTarget())) {
            ((NavigationFunctionModelImpl)navigation).setLinkTarget("mainFrame");
        }
        sb.append("<option value='mainFrame' " + ("mainFrame".equals(navigation.getLinkTarget()) ? "selected=\"true\"" : "") + ">mainFrame</option>");
        sb.append("<option value='_blank' " + ("_blank".equals(navigation.getLinkTarget()) ? "selected=\"true\"" : "") + ">_blank</option>");
        return sb.toString();
    }

    private String getHidden(NavigationFunctionModel navigation) {
        StringBuilder hidden = new StringBuilder();
        hidden.append("<input type=hidden name=functionId id = 'functionId' value=" + navigation.getId() + ">\n");
        hidden.append("<input type=hidden name=url id = 'url' value='" + navigation.getLinkUrl() + "'>\n");
        hidden.append("<input type=hidden name=cmd id = 'cmd'>\n");
        hidden.append("<input type=hidden name=sid id = 'sid' value=" + this._me.getSessionId() + ">\n");
        return hidden.toString();
    }

    private String getSysList(NavigationFunctionModel navigation) {
        NavigationSystemModel systemModel;
        NavigationDirectoryModel directoryModel;
        StringBuilder html = new StringBuilder();
        html.append("<select name=\"sysname\" id=\"sysname\" style=\"width:182px;\" class =\"awsui-select\">");
        if (this.isNew(navigation)) {
            html.append("\t<option value = ''>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9") + "</option>");
        }
        String systemId = "";
        if (!this.isNew(navigation) && (directoryModel = NavigationDirectoryCache.getModel(navigation.getDirectoryId())) != null && (systemModel = NavigationSystemCache.getModel(directoryModel.getSystemId())) != null) {
            systemId = systemModel.getId();
        }
        Iterator<NavigationSystemModel> h = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
        while (h.hasNext()) {
            boolean select;
            NavigationSystemModel model = h.next();
            if ("obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(model.getId())) continue;
            String appId = model.getAppId();
            boolean isManager = AMCAPIManager.isManagementApp(appId, this._me.getUID());
            if (!appId.equals("") && (!isManager || appId.equals(""))) continue;
            boolean bl = select = !this.isNew(navigation) && model.getId().equals(systemId);
            if (select) {
                html.append("<option value=\"" + model.getId() + "\" " + "selected=\"true\"" + ">" + NavigationUtil.getLangName(this._me.getLanguage(), model.getSystemName()) + "</option>");
                continue;
            }
            if (!this.hasSystemRight(model.getId())) continue;
            html.append("<option value=\"" + model.getId() + "\" " + ">" + NavigationUtil.getLangName(this._me.getLanguage(), model.getSystemName()) + "</option>");
        }
        html.append("</select>");
        return html.toString();
    }

    public String getMenuBySystemId(String systemId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        List<NavigationDirectoryModel> h = NavigationDirectoryCache.getListOfSystem(systemId);
        if (h.size() > 0) {
            for (NavigationDirectoryModel model : h) {
                ro.addObject().put("id", model.getId()).put("name", NavigationUtil.getLangName(this._me.getLanguage(), model.getDirectoryName()));
            }
        }
        return ro.toString();
    }

    private String getMenuList(NavigationFunctionModel navigation) {
        StringBuilder html = new StringBuilder();
        html.append("<select name=\"menuname\" id=\"menuname\" class =\"awsui-select\" style=\"width:182px;\" >");
        if (this.isNew(navigation)) {
            html.append("\t<option value =''>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9") + "</option>");
        } else {
            NavigationDirectoryModel nm = NavigationDirectoryCache.getModel(navigation.getDirectoryId());
            if (nm != null) {
                List<NavigationDirectoryModel> h = NavigationDirectoryCache.getListOfSystem(nm.getSystemId());
                Iterator<NavigationDirectoryModel> iterator = h.iterator();
                while (iterator.hasNext()) {
                    NavigationDirectoryModel aH;
                    nm = aH = iterator.next();
                    html.append("\t<option value ='" + nm.getId() + "' " + (nm.getId().equals(navigation.getDirectoryId()) ? "selected=\"true\"" : "") + ">" + NavigationUtil.getLangName(this._me.getLanguage(), nm.getDirectoryName()) + "</option>");
                }
            } else {
                html.append("\t<option value =''>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9") + "</option>");
            }
        }
        html.append("</select>");
        return html.toString();
    }

    public String deploy(NavigationFunctionModel model, boolean isCreateSys, boolean isCreateDir) {
        ResponseObject responseObject = ResponseObject.newOkResponse();
        if (this.isNew(model)) {
            NavigationDaoFactory.createNavigationFunction().insert((NavigationFunctionModelImpl)model);
            this.setAutoPermissionListIfNot(model);
        } else {
            ((NavigationFunctionModelImpl)model).setOrderIndex(NavigationFunctionCache.getModel(model.getId()).getOrderIndex());
            NavigationDaoFactory.createNavigationFunction().update((NavigationFunctionModelImpl)model);
            if (isCreateSys) {
                this.setAutoPermissionListIfNot(model);
            } else if (isCreateDir) {
                this.setAutoPermissionDirListIfNot(model);
            }
        }
        responseObject.put("id", model.getId());
        responseObject.msg(I18nRes.findValue("_bpm.platform", "\u90e8\u7f72\u6210\u529f"));
        return responseObject.toString();
    }

    private void setAutoPermissionListIfNot(NavigationFunctionModel model) {
        List<PermissionListModel> funList = PermissionListCache.getNavPermissionAssnList(model.getId());
        if (!UtilString.isEmpty(funList)) {
            List<PermissionListModel> sysList;
            this.setAutoPermissionDirListIfNot(model, funList);
            NavigationDirectoryModel dirModel = NavigationDirectoryCache.getModel(model.getDirectoryId());
            if (dirModel != null && UtilString.isEmpty(sysList = PermissionListCache.getNavPermissionAssnList(dirModel.getSystemId()))) {
                this.copyPermissionList(funList, dirModel.getSystemId());
            }
        }
    }

    private void setAutoPermissionDirListIfNot(NavigationFunctionModel model, List<PermissionListModel> funList) {
        funList = funList == null ? PermissionListCache.getNavPermissionAssnList(model.getId()) : funList;
        List<PermissionListModel> dirList = PermissionListCache.getNavPermissionAssnList(model.getDirectoryId());
        if (UtilString.isEmpty(dirList)) {
            this.copyPermissionList(funList, model.getDirectoryId());
        }
    }

    private void setAutoPermissionDirListIfNot(NavigationFunctionModel model) {
        this.setAutoPermissionDirListIfNot(model, null);
    }

    private void copyPermissionList(List<PermissionListModel> funList, String navId) {
        for (PermissionListModel permissionListModel : funList) {
            PermissionListModel model = new PermissionListModel();
            model.setModel(permissionListModel);
            model.setId("");
            model.setResourceId(navId);
            PermissionDaoFactory.createPermissionList().insert(model);
        }
    }

    private boolean isNew(NavigationFunctionModel navigation) {
        return NavigationFunctionCache.getModel(navigation.getId()) == null;
    }
}

