/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.pub.web;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.modeler.io.BPMNIO;
import com.actionsoft.bpms.bpmn.modeler.io.BPMNIOControl;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.pagination.SQLPagination;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.high.model.HighSecurityModel;
import com.actionsoft.bpms.org.cache.UserPwdCycleCache;
import com.actionsoft.bpms.org.dao.OrgDaoFactory;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.model.UserPwdCycleModel;
import com.actionsoft.bpms.repository.ModelRepositoryWeb;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.coe.pal.repository.dao.CoeProcessLevelDaoFacotory;
import com.actionsoft.coe.pal.repository.dao.PALRepository;
import com.actionsoft.coe.pal.repository.model.PALRepositoryModel;
import com.actionsoft.coe.pal.ws.dao.CoeWorkSpace;
import com.actionsoft.coe.pal.ws.dao.CoeWorkSpaceDaoFactory;
import com.actionsoft.coe.pal.ws.model.CoeWorkSpaceModel;
import com.actionsoft.coe.system.property.CoePropertyUtil;
import com.actionsoft.coe.team.user.dao.CoeUserDaoFactory;
import com.actionsoft.coe.util.CoEInitUtil;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.AWSQuotaException;
import com.actionsoft.exception.BPMNDefException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;

public class PublicPortalWeb
extends ActionWeb {
    public PublicPortalWeb(UserContext uc) {
        super(uc);
    }

    public String savePwd(String oldPwd, String newPwd) {
        String msg = SDK.getPortalAPI().changePasswd(this.getContext(), oldPwd, newPwd);
        return msg;
    }

    public String getPwdIsRight(UserContext me, String oldPwd) {
        String md5_oldPwd = OrgDaoFactory.createUser().getPassword(me.getUID(), oldPwd);
        if (super.getContext().getUserModel().getPassword().equals(md5_oldPwd)) {
            return "1";
        }
        return "-1";
    }

    public String getCoEPalMarkDistributionHtml() {
        Map map = CoePropertyUtil.getPropertysValue2((String)"PROPERTYKEY like 'mark_%'", (String)"0");
        Iterator iterator = map.keySet().iterator();
        StringBuffer asb = new StringBuffer();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String id = key.substring(5, key.length());
            PALRepositoryModel coeProcessLevelModel = this.getCoeProcessLevelModelByRid(id);
            if (coeProcessLevelModel == null) continue;
            asb.append("<a child-list href='javascript:void(0)' url='./w?&sid=" + this.getContext().getSessionId() + "&cmd=CONSOLE_OPEN_COE_PAL_MARK_DISTRIBUTION_SETTING&rid=" + id + "'>" + coeProcessLevelModel.getName() + "</a>");
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("list", asb.toString());
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.portlet.coe.pal.distribution.htm", macroLibraries);
    }

    public String getIsCoEPalMarkDistribution() {
        ResponseObject ro = ResponseObject.newOkResponse();
        boolean exist = false;
        try {
            exist = CoeUserDaoFactory.createUser().isExistTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!exist) {
            ro.put("flag", "false");
            return ro.toString();
        }
        if (!CoEInitUtil.isCoeInitEnd()) {
            return "";
        }
        Map map = CoePropertyUtil.getPropertysValue2((String)"PROPERTYKEY like 'mark_%'", (String)"0");
        Iterator iterator = map.keySet().iterator();
        String flag = "false";
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String id = key.substring(5, key.length());
            if (this.getCoeProcessLevelModelByRid(id) == null) continue;
            flag = "true";
        }
        ro.put("flag", flag);
        return ro.toString();
    }

    public String getCoEPalMarkDistributionSettingHtml(String rid) {
        String p;
        UtilFile utilFile;
        PALRepositoryModel coeProcessLevelModel;
        StringBuffer appsoption = new StringBuffer();
        String imgdata = "";
        String name = "";
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        try {
            List<Object> apps = new ArrayList();
            apps = ModelRepositoryWeb.getVisibleInstalledApps(super.getContext().getUID());
            if (apps != null) {
                int i = 0;
                while (i < apps.size()) {
                    AppContext appContext = (AppContext)apps.get(i);
                    appsoption.append("<option value='" + appContext.getId() + "' >" + appContext.getName() + "</option>");
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((coeProcessLevelModel = this.getCoeProcessLevelModelByRid(rid)) != null && (utilFile = new UtilFile(String.valueOf(p = coeProcessLevelModel.getFilePath()) + "/" + coeProcessLevelModel.getId() + ".small.png")).exists()) {
            byte[] base64Bytes = Base64.encode(utilFile.readBytes());
            imgdata = "data:image/png;base64," + new String(base64Bytes);
            name = coeProcessLevelModel.getName();
        }
        macroLibraries.put("option", appsoption.toString());
        macroLibraries.put("imgdata", imgdata);
        macroLibraries.put("name", name);
        macroLibraries.put("rid", rid);
        macroLibraries.put("sid", this.getContext().getSessionId());
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.portlet.coe.pal.distribution.setting.htm", macroLibraries);
    }

    public String getCoEPMDSSCJson(String type, String appid, String value) {
        ArrayList<String> list = new ArrayList<String>();
        ResponseObject newOkResponse = ResponseObject.newOkResponse();
        newOkResponse.put("type", type);
        if (type.equals("0")) {
            String[] categorys = ProcessDefCache.getInstance().getCategorys(appid);
            int i = 0;
            while (i < categorys.length) {
                list.add(categorys[i]);
                ++i;
            }
        } else if (type.equals("1")) {
            Map map = ProcessDefCache.getInstance().getGroupsOfCategory(appid, value);
            if (map != null) {
                for (String key : map.keySet()) {
                    list.add((String)map.get(key));
                }
                newOkResponse.put("groups", map);
            }
        } else if (type.equals("2")) {
            List listOfProcessGroup = ProcessDefCache.getInstance().getListOfProcessGroup(appid, value);
            HashMap versionsOfProcess = new HashMap();
            for (ProcessDefinition proc : listOfProcessGroup) {
                if (versionsOfProcess.get(proc.getVersionId()) == null) {
                    versionsOfProcess.put(proc.getVersionId(), new ArrayList());
                }
                ((List)versionsOfProcess.get(proc.getVersionId())).add(proc);
            }
            Iterator iterator = versionsOfProcess.keySet().iterator();
            while (iterator.hasNext()) {
                List list2 = (List)versionsOfProcess.get(iterator.next());
                String proceName = "";
                ProcessDefinition runDefsOfVersion = ProcessDefCache.getInstance().getRunDefsOfVersion(appid, ((ProcessDefinition)list2.get(0)).getVersionId());
                if (runDefsOfVersion != null) {
                    proceName = this.getProcessShowTitle(runDefsOfVersion);
                } else {
                    Collections.sort(list2, new Comparator<ProcessDefinition>(){

                        @Override
                        public int compare(ProcessDefinition p1, ProcessDefinition p2) {
                            return Integer.valueOf(p1.getVersionNo()).compareTo(p2.getVersionNo());
                        }
                    });
                    proceName = this.getProcessShowTitle((ProcessDefinition)list2.get(0));
                }
                list.add(proceName);
            }
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        newOkResponse.put("list", list);
        return newOkResponse.toString();
    }

    private String getProcessShowTitle(ProcessDefinition model) {
        StringBuffer title = new StringBuffer();
        if (model == null) {
            return "";
        }
        title.append(model.getName());
        title.append(" v.").append(model.getVersionNo()).append(".0");
        switch (model.getVersionStatus()) {
            case -1: {
                title.append("(\u505c\u7528)");
                break;
            }
            case 0: {
                title.append("(\u8bbe\u8ba1)");
                break;
            }
            case 1: {
                title.append("(\u8fd0\u884c)");
            }
        }
        return title.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String saveCoEPMDSSC(String rid, String appid, String processType, String processGroup, String processName, String tmpProcessGroupId) {
        ResponseObject ro;
        try {
            this.checkActiveDefSize();
        }
        catch (Exception e) {
            ResponseObject ro2 = ResponseObject.newErrResponse(e.getMessage());
            return ro2.toString();
        }
        PALRepositoryModel plModel = this.getCoeProcessLevelModelByRid(rid);
        List plist = null;
        plist = ProcessDefCache.getInstance().getListOfGroupName(appid, processGroup);
        String processGroupId = "";
        String processDefId = "";
        boolean isBpmnLinkCoe = false;
        processName = this.getProcessOfRegex(processName);
        if (plist.size() == 0) {
            processGroupId = UUIDGener.getObjectId();
        } else {
            ProcessDefinition tmp = (ProcessDefinition)plist.get(0);
            processGroupId = tmp.getProcessGroupId();
        }
        for (ProcessDefinition proc : plist) {
            if (!proc.getName().equals(processName)) continue;
            isBpmnLinkCoe = true;
            processDefId = proc.getId();
            break;
        }
        String msg = "\u5206\u914d\u5931\u8d25";
        if (isBpmnLinkCoe) {
            this.saveCoeLink(appid, rid, processDefId);
            msg = "\u5206\u914d\u6210\u529f";
            ro = ResponseObject.newOkResponse();
            ro.put("message", msg);
            return ro.toString();
        }
        if (plModel != null) {
            String filePath = plModel.getFilePath();
            if (UtilString.isEmpty(filePath)) throw new AWSException("PAL\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728<br>\u6d41\u7a0b\u540d\u79f0:" + plModel.getName() + "<br>uuid:" + plModel.getId());
            UtilFile utilFile = new UtilFile(String.valueOf(filePath) + "/" + plModel.getId());
            String content = utilFile.readStrUTF8();
            if (UtilString.isEmpty(content)) throw new AWSException("PAL\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25<br>\u6d41\u7a0b\u540d\u79f0:" + plModel.getName() + "<br>uuid:" + plModel.getId());
            content = content.replace("process_bpmn2", "bpmn");
            com.alibaba.fastjson.JSONObject define = JSONArray.parseObject((String)content);
            com.alibaba.fastjson.JSONObject processProperties = BPMNIOControl.getJsonInitOfEngineModel((String)"process", null, (String)"", (String)processName, null);
            processProperties.put("categoryName", (Object)processType);
            processProperties.put("processGroupName", (Object)processGroup);
            processProperties.put("processGroupId", (Object)processGroupId);
            define.put("processName", (Object)processName);
            define.put("uuid", (Object)UUIDGener.getObjectId());
            define.put("processProperties", (Object)processProperties);
            try {
                String rvalue = BPMNIO.saveJsonToBPMNFile((UserContext)this.getContext(), (String)appid, (String)"", (String)"new", (String)define.toString(), (boolean)false, null);
                com.alibaba.fastjson.JSONObject rvalueObject = JSONArray.parseObject((String)rvalue);
                this.saveCoeLink(appid, rid, rvalueObject.getString("processDefId"));
                msg = "\u5206\u914d\u6210\u529f";
                ResponseObject ro3 = ResponseObject.newOkResponse();
                ro3.put("message", msg);
                return ro3.toString();
            }
            catch (BPMNDefException e) {
                e.printStackTrace();
            }
        }
        msg = "\u5206\u914d\u5931\u8d25";
        ro = ResponseObject.newErrResponse();
        ro.put("message", msg);
        return ro.toString();
    }

    private void checkActiveDefSize() {
        int maxDefSize;
        int activeDefSize = ProcessDefCache.getInstance().getActiveDefs().size();
        if (activeDefSize >= (maxDefSize = Quota.getMaxprocess())) {
            throw new AWSQuotaException("\u6d41\u7a0b\u6570\u8d85\u51fa\u6700\u5927\u914d\u989d");
        }
    }

    private String getProcessOfRegex(String processName) {
        String regex = "^(\\S*)\\sv\\.\\d{1,3}\\.0\\((\u8bbe\u8ba1|\u8fd0\u884c|\u505c\u7528)\\)$";
        Pattern compile = Pattern.compile(regex);
        Matcher matcher = compile.matcher(processName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return processName;
    }

    private void saveCoeLink(String appId, String rid, String processDefId) {
        CoePropertyUtil.createProperty((String)("mark_" + rid), (String)"1");
        CoePropertyUtil.createProperty((String)("link_" + rid), (String)processDefId);
        CoePropertyUtil.createProperty((String)("link_app_" + rid), (String)appId);
    }

    private PALRepositoryModel getCoeProcessLevelModelByRid(String rid) {
        PALRepository coeProcessLevel = CoeProcessLevelDaoFacotory.createCoeProcessLevel();
        CoeWorkSpace coeWorkSpace = CoeWorkSpaceDaoFactory.createCoeWorkSpace();
        List list = coeProcessLevel.getCoeUseProcessLevelByRid(rid);
        PALRepositoryModel plModel = null;
        int i = 0;
        while (i < list.size()) {
            plModel = (PALRepositoryModel)list.get(i);
            CoeWorkSpaceModel model = coeWorkSpace.getInstance(plModel.getWsId());
            if (model.getIsUse() == 1 && plModel.isUse()) {
                return plModel;
            }
            ++i;
        }
        return null;
    }

    public JSONObject loginCheckSecurity() {
        com.alibaba.fastjson.JSONObject loginCheckSecurityInfo = this.getLoginCheckSecurityInfo();
        return JSONObject.fromObject((Object)loginCheckSecurityInfo.toString());
    }

    public com.alibaba.fastjson.JSONObject getLoginCheckSecurityInfo() {
        List pwdList;
        String msg = "";
        boolean isSecurityPwdChange = AWSPortalConf.isSecurityPwdChange();
        UserModel userModel = this.getContext().getUserModel();
        com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
        obj.put("isSecurityPwdChange", (Object)isSecurityPwdChange);
        boolean ifOpenSecurity = false;
        try {
            ifOpenSecurity = HighSecurity.isON();
        }
        catch (Exception e) {
            ifOpenSecurity = false;
        }
        boolean isSecurityPwdComplexity = AWSPortalConf.isSecurityPwdComplexity();
        int securityMinPwdLength = AWSPortalConf.getSecurityMinPwdLength();
        int securityMaxPwdLength = AWSPortalConf.getSecurityMaxPwdLength();
        int securityPwdCycle = AWSPortalConf.getSecurityPwdCycle();
        boolean forceChangePwd = false;
        if (userModel.getPassword().equals(OrgDaoFactory.createUser().getPassword(userModel.getUID(), AWSPortalConf.getSecurityPwdDefault())) && (isSecurityPwdChange || ifOpenSecurity)) {
            forceChangePwd = true;
            msg = I18nRes.findValue("_bpm.portal", "\u60a8\u5f53\u524d\u7684\u8d26\u6237\u662f\u521d\u59cb\u5316\u9ed8\u8ba4\u53e3\u4ee4\uff0c\u8bf7\u8bbe\u7f6e\u65b0\u53e3\u4ee4");
        }
        if (ifOpenSecurity) {
            isSecurityPwdComplexity = false;
            int level = userModel.getSecurityLevel();
            HighSecurityModel tmpModel = HighSecurity.getSecModel();
            if (level == 1) {
                securityPwdCycle = Integer.valueOf(tmpModel.getLevel1Cycle());
                securityMinPwdLength = Integer.valueOf(tmpModel.getLevel1MinLength());
            } else if (level == 2) {
                securityPwdCycle = Integer.valueOf(tmpModel.getLevel2Cycle());
                securityMinPwdLength = Integer.valueOf(tmpModel.getLevel2MinLength());
            } else if (level == 3) {
                securityPwdCycle = Integer.valueOf(tmpModel.getLevel3Cycle());
                securityMinPwdLength = Integer.valueOf(tmpModel.getLevel3MinLength());
            } else {
                securityPwdCycle = Integer.valueOf(tmpModel.getLevel0Cycle());
                securityMinPwdLength = Integer.valueOf(tmpModel.getLevel0MinLength());
            }
        }
        long currentTime = System.currentTimeMillis();
        if (securityPwdCycle > 0 && (pwdList = UserPwdCycleCache.getCurrentPwds((String)userModel.getUID())).size() > 0) {
            Timestamp lastDate = ((UserPwdCycleModel)pwdList.get(0)).getLastDate();
            long msCycle = (long)securityPwdCycle * 24L * 60L * 60L * 1000L;
            long pluCycle = currentTime - lastDate.getTime();
            boolean bl = forceChangePwd = forceChangePwd || pluCycle >= msCycle;
            if (pluCycle >= msCycle) {
                msg = I18nRes.findValue("_bpm.portal", this.getContext().getLanguage(), "\u60a8\u5f53\u524d\u7684\u8d26\u6237\u53e3\u4ee4\u5df2\u8fc7\u671f\uff0c\u8bf7\u8bbe\u7f6e\u65b0\u53e3\u4ee4");
            }
        }
        obj.put("forceChangePwd", (Object)forceChangePwd);
        obj.put("isSecurityPwdComplexity", (Object)isSecurityPwdComplexity);
        obj.put("securityMinPwdLength", (Object)securityMinPwdLength);
        obj.put("securityMaxPwdLength", (Object)securityMaxPwdLength);
        obj.put("securityPwdMsg", (Object)msg);
        return obj;
    }

    public long getPrevLoginTime(String userId) {
        long prevLoginTime = 0L;
        String sql = " select * from SYS_SESSION s where s.userid = '" + userId + "' order by s.STARTTIME desc ";
        List<Long> list = DBSql.query(SQLPagination.getPaginitionSQL(sql, 0, 2), new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int paramInt) throws SQLException {
                return rs.getLong("starttime");
            }
        }, new Object[0]);
        if (list != null && list.size() > 0) {
            prevLoginTime = list.get(list.size() - 1);
        }
        return prevLoginTime;
    }
}

