/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.skins;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.SkinsPluginProfile;
import com.actionsoft.bpms.commons.portal.skins.PortalSkinsInterface;
import com.actionsoft.bpms.commons.portal.skins.PortalSkinsModel;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class PortalSkinsManager {
    private static List<PortalSkinsModel> _list = new ArrayList<PortalSkinsModel>();

    public static String getLookAndFeel(UserContext me) {
        RoleModel roleModel = me.getRoleModel();
        if (roleModel != null && !UtilString.isEmpty(roleModel.getLookAndFeel())) {
            return roleModel.getLookAndFeel();
        }
        CompanyModel companyModel = me.getCompanyModel();
        if (companyModel != null && !UtilString.isEmpty(companyModel.getLookAndFeel())) {
            return companyModel.getLookAndFeel();
        }
        return AWSPortalConf.getProperty("client.default.lookandfeel");
    }

    public static List<PortalSkinsModel> getList() {
        return _list;
    }

    public static PortalSkinsModel getSkinsModel(String id) {
        for (PortalSkinsModel skins : _list) {
            if (!skins.getId().equals(id)) continue;
            return skins;
        }
        return null;
    }

    public static PortalSkinsInterface getSkins(String id) {
        PortalSkinsModel skinsModel = PortalSkinsManager.getSkinsModel(id);
        if (skinsModel != null) {
            try {
                Object[] params = new Object[]{};
                PortalSkinsInterface obj = skinsModel.getCons().newInstance(params);
                return obj;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return null;
            }
        }
        return null;
    }

    public static boolean registerPlugin(AppContext app, SkinsPluginProfile plugin) {
        for (PortalSkinsModel obj : _list) {
            if (!obj.getId().equals(plugin.getId())) continue;
            AppsLogger.err((AppContext)app, (String)("\u6ce8\u518c\u95e8\u6237\u98ce\u683c[" + plugin.getName() + "]\u51b2\u7a81\uff0c\u539f\u56e0\u662f\u8be5Id\u5df2\u4e0e[" + obj.getAppContext().getName() + "]\u7684appId\u51b2\u7a81"));
            return false;
        }
        PortalSkinsModel skins = new PortalSkinsModel(app, plugin);
        Class[] parameterTypes = new Class[]{};
        Constructor cons = null;
        try {
            cons = ClassReflect.getConstructor(plugin.getClazzName(), parameterTypes, app);
        }
        catch (ClassNotFoundException ce) {
            AppsLogger.err((AppContext)plugin.getAppContext(), (String)("\u5b9e\u73b0\u7c7b\u52a0\u8f7d\u5f02\u5e38[" + plugin.getClazzName() + "]\u6ca1\u6709\u627e\u5230!"));
            ce.printStackTrace(System.err);
            return false;
        }
        catch (NoSuchMethodException ne) {
            AppsLogger.err((AppContext)plugin.getAppContext(), (String)("\u5b9e\u73b0\u7c7b\u52a0\u8f7d\u5f02\u5e38[" + plugin.getClazzName() + "]\u6784\u9020\u65b9\u6cd5\u4e0d\u5339\u914d!"));
            ne.printStackTrace(System.err);
            return false;
        }
        catch (Exception e) {
            AppsLogger.err((AppContext)plugin.getAppContext(), (String)("\u5b9e\u73b0\u7c7b\u52a0\u8f7d\u5f02\u5e38[" + plugin.getClazzName() + "]"));
            e.printStackTrace(System.err);
            return false;
        }
        skins.setCons(cons);
        _list.add(skins);
        return true;
    }

    public static boolean destoryPlugin(AppContext app, SkinsPluginProfile plugin) {
        PortalSkinsModel skins = PortalSkinsManager.getSkinsModel(app.getId());
        if (skins != null) {
            _list.remove(skins);
        }
        return true;
    }
}

