/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.skins.mgt;

import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.skins.mgt.NavigationSystemExtendModel;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.commons.security.ac.model.NavExtACCM;
import com.actionsoft.bpms.org.cache.CompanyCache;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.cache.TeamCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StyleManagerUtil {
    public static NavigationSystemExtendModel[] decodingNavagationSystemExtendStr(String param) {
        HashMap<Integer, NavigationSystemExtendModel> record = new HashMap<Integer, NavigationSystemExtendModel>();
        Pattern pattern = Pattern.compile("\\{[^{}]*\\}");
        Matcher matcher = pattern.matcher(param);
        String value = "";
        while (matcher.find()) {
            value = matcher.group();
            value = value.replace("{", "");
            value = value.replace("}", "");
            String[] valueArray = value.split(":");
            NavigationSystemExtendModel model = null;
            if (valueArray != null && valueArray.length == 3) {
                model = new NavigationSystemExtendModel();
                model.setId(Integer.parseInt(valueArray[0]));
                model.setOffer(valueArray[1]);
                model.setOderIndex(Integer.parseInt(valueArray[2]));
            }
            if (model == null) continue;
            record.put(record.size(), model);
        }
        return StyleManagerUtil.sortNavagationSystemExtend(record);
    }

    private static NavigationSystemExtendModel[] sortNavagationSystemExtend(Map<Integer, NavigationSystemExtendModel> record) {
        NavigationSystemExtendModel[] srcArray = new NavigationSystemExtendModel[record.size()];
        NavigationSystemExtendModel temp = null;
        int i = 0;
        while (i < record.size()) {
            srcArray[i] = record.get(i);
            ++i;
        }
        i = 0;
        while (i < srcArray.length) {
            int j = i;
            while (j > 0 && srcArray[j].getOderIndex() < srcArray[j - 1].getOderIndex()) {
                temp = srcArray[j];
                srcArray[j] = srcArray[j - 1];
                srcArray[j - 1] = temp;
                --j;
            }
            ++i;
        }
        return srcArray;
    }

    public static String encodingNavagationSystemExtendStr(NavigationSystemExtendModel[] data) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            if (data[i] != null) {
                str.append('{');
                str.append(data[i].getId());
                str.append(":");
                str.append(data[i].getOffer());
                str.append(":");
                str.append(data[i].getOderIndex());
                str.append('}');
            }
            ++i;
        }
        return str.toString();
    }

    public static String getInheritorList(String systemId, int resId) {
        StringBuilder acList = new StringBuilder();
        Iterator<AccessControlModel> acRecord = AccessControlCache.getACList(NavExtACCM.resourceType, String.valueOf(resId));
        boolean isNull = true;
        while (acRecord.hasNext()) {
            CompanyModel objModel;
            isNull = false;
            AccessControlModel acModel = acRecord.next();
            if (acModel._assignmentType.equals("company")) {
                objModel = CompanyCache.getModel((String)acModel._assignmentId);
                acList.append(" [\u516c\u53f8\uff1a").append(objModel.getName()).append(']');
                continue;
            }
            if (acModel._assignmentType.equals("department")) {
                objModel = DepartmentCache.getModel((String)acModel._assignmentId);
                acList.append(" [\u90e8\u95e8\uff1a").append(objModel.getName()).append(']');
                continue;
            }
            if (acModel._assignmentType.equals("role")) {
                objModel = RoleCache.getModel((String)acModel._assignmentId);
                acList.append(" [\u89d2\u8272\uff1a").append(objModel.getName()).append(']');
                continue;
            }
            if (acModel._assignmentType.equals("team")) {
                objModel = TeamCache.getModel((String)acModel._assignmentId);
                acList.append(" [\u56e2\u961f\uff1a").append(objModel.getName()).append(']');
                continue;
            }
            if (!acModel._assignmentType.equals("user")) continue;
            objModel = UserCache.getModelOfUniqueId((String)acModel._assignmentId);
            acList.append(" [\u7528\u6237\uff1a").append(objModel.getUserName()).append(']');
        }
        if (isNull) {
            return "*";
        }
        return acList.toString();
    }

    public static boolean isOffer(String systemId, String uid) {
        NavigationSystemModel navModel = NavigationSystemCache.getModel(systemId);
        String extendsAdmin = navModel.getPortalLocked();
        NavigationSystemExtendModel[] data = StyleManagerUtil.decodingNavagationSystemExtendStr(extendsAdmin);
        int i = 0;
        while (i < data.length) {
            NavigationSystemExtendModel model = data[i];
            if (data[i].getOffer().equals(uid)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getoffer(String systemId, UserContext user) {
        NavigationSystemExtendModel model;
        if (UtilString.isEmpty(systemId)) {
            return "admin";
        }
        NavigationSystemModel navModel = NavigationSystemCache.getModel(systemId);
        String extendsAdmin = navModel.getPortalLocked();
        if (extendsAdmin == null) {
            return null;
        }
        NavigationSystemExtendModel[] data = StyleManagerUtil.decodingNavagationSystemExtendStr(extendsAdmin);
        int i = 0;
        while (i < data.length) {
            model = data[i];
            if (data[i] != null && data[i].getOffer().equals(user.getUID())) {
                return user.getUID();
            }
            ++i;
        }
        int j = 0;
        while (j < data.length) {
            model = data[j];
            Iterator<AccessControlModel> listByResource = AccessControlAPI.getInstance().getListByResource(NavExtACCM.resourceType, String.valueOf(model.getId()));
            if (!listByResource.hasNext()) {
                UserModel offerModel = UserCache.getModel((String)SDK.getORGAPI().getUserId(model.getOffer()));
                return offerModel == null || offerModel.isClosed() ? null : model.getOffer();
            }
            if (AccessControlAPI.getInstance().havingPermission(user, NavExtACCM.resourceType, Integer.toString(model.getId()), NavExtACCM.MANAGER.getType())) {
                UserModel offerModel = UserCache.getModel((String)SDK.getORGAPI().getUserId(model.getOffer()));
                return offerModel == null || offerModel.isClosed() ? null : model.getOffer();
            }
            ++j;
        }
        return null;
    }
}

