/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.skins.mgt;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.SkinsPluginProfile;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationSystemModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.portal.skins.PortalSkinsManager;
import com.actionsoft.bpms.commons.portal.skins.PortalSkinsModel;
import com.actionsoft.bpms.commons.portal.skins.mgt.NavigationSystemExtendModel;
import com.actionsoft.bpms.commons.portal.skins.mgt.StyleManagerUtil;
import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.model.NavExtACCM;
import com.actionsoft.bpms.commons.security.ac.util.SearchUtil;
import com.actionsoft.bpms.maintain.process.util.ProcessRuntimeUtil;
import com.actionsoft.bpms.org.cache.CompanyCache;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.util.SecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.conf.portal.PortalXML;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.i18n.I18nRes;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StyleManagerWeb
extends ActionWeb {
    public StyleManagerWeb(UserContext uc) {
        super(uc);
    }

    public String getMainPage() {
        StringBuffer lookAndFeelHtml = new StringBuffer();
        String defaultLookAndFeel = AWSPortalConf.getProperty("client.default.lookandfeel");
        List<PortalSkinsModel> portalSkinsModels = PortalSkinsManager.getList();
        Collections.sort(portalSkinsModels, new Comparator<PortalSkinsModel>(){

            @Override
            public int compare(PortalSkinsModel p1, PortalSkinsModel p2) {
                AppContext o1 = p1.getAppContext();
                AppContext o2 = p2.getAppContext();
                Collator myCollator = Collator.getInstance(Locale.CHINA);
                return myCollator.compare(o1.getName(), o2.getName());
            }
        });
        if (portalSkinsModels != null && portalSkinsModels.size() != 0) {
            int i = 0;
            while (i < portalSkinsModels.size()) {
                PortalSkinsModel psm = portalSkinsModels.get(i);
                if (psm != null) {
                    SkinsPluginProfile profile = psm.getProfile();
                    AppContext appContext = psm.getAppContext();
                    String defaultFlagImg = "";
                    String paddingTop = "16px;";
                    if (appContext.getId().equals(defaultLookAndFeel)) {
                        defaultFlagImg = "<p style='width:165px;height:16px;'><span><i class='awsui-iconfont' style='font-size:13px;color:#37ab6e;float:right;'>&#59035;</i></span></p>\n";
                        paddingTop = "0px;";
                    }
                    lookAndFeelHtml.append("<li appId=\"" + appContext.getId() + "\" onclick=\"openConfigDialog('" + appContext.getId() + "','" + appContext.getName() + "','" + profile.isPortletContainer() + "');\" >\n");
                    lookAndFeelHtml.append("<span class=\"entity\">\n");
                    lookAndFeelHtml.append(defaultFlagImg);
                    lookAndFeelHtml.append("<div style=\"width:165px;padding-top:" + paddingTop + "\">\n");
                    lookAndFeelHtml.append("<img src=\"" + psm.getIcon64URL(this.getContext()) + "\">\n");
                    lookAndFeelHtml.append("</div>\n");
                    lookAndFeelHtml.append("<ul class=\"affiliate\">\n");
                    lookAndFeelHtml.append("<li class=\"title\" style=\"text-align: center;\">\n");
                    lookAndFeelHtml.append(appContext.getName()).append("\n");
                    lookAndFeelHtml.append("</li>\n");
                    lookAndFeelHtml.append("</ul>\n");
                    lookAndFeelHtml.append("</span>\n");
                    lookAndFeelHtml.append("</li>\n");
                }
                ++i;
            }
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sessionId", super.getContext().getSessionId());
        macroLibraries.put("lookAndFeelHtml", lookAndFeelHtml);
        macroLibraries.put("sid", super.getSIDFlag());
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.lf.home.htm", macroLibraries);
    }

    public String validateSkinApp(String appId) {
        PortalSkinsModel portalSkinsModel = PortalSkinsManager.getSkinsModel(appId);
        if (portalSkinsModel == null) {
            return ResponseObject.newErrResponse().msg("\u7cfb\u7edf\u5f02\u5e38").toString();
        }
        if (AMCAPIManager.isManagementApp(appId, this.getContext().getUID())) {
            return ResponseObject.newOkResponse().msg("").toString();
        }
        return ResponseObject.newWarnResponse().msg("\u60a8\u65e0\u6743\u914d\u7f6e\u8fd9\u4e2a\u4e3b\u9898\u98ce\u683c").toString();
    }

    public String getEditPage(String editType, String appId) {
        if (editType.equals("AppStrategy")) {
            return this.getAppStrategyEditPage(appId);
        }
        if (editType.equals("PortalDeskLayout")) {
            return this.getPortalDeskLayoutEditPage(appId);
        }
        return "editType \u53c2\u6570\u51fa\u9519";
    }

    public String getAppStrategyEditPage(String appId) {
        PortalSkinsModel portalSkinsModel = PortalSkinsManager.getSkinsModel(appId);
        if (portalSkinsModel == null) {
            return "";
        }
        StringBuilder orgHtml = new StringBuilder();
        List companyList = CompanyCache.getList();
        int i = 0;
        while (i < companyList.size()) {
            CompanyModel companyModel = (CompanyModel)companyList.get(i);
            String img = "<span style='margin-right: 2px;'><i class='awsui-iconfont' style='font-size:15px;color:#555;cursor:pointer;'>&#59318;</i></span>";
            String checkboxId = companyModel.getId();
            String checkbox = "";
            checkbox = companyModel.getLookAndFeel().equals(portalSkinsModel.getAppContext().getId()) ? "<input class='awsui-checkbox' type=checkbox id='" + checkboxId + "' name='companyListCheckBut' value =" + companyModel.getId() + " checked >" : "<input class='awsui-checkbox' type=checkbox id='" + checkboxId + "' name='companyListCheckBut' value =" + companyModel.getId() + "  >";
            String lable = "<label class='awsui-checkbox-label' for='" + checkboxId + "'>" + companyModel.getName() + "</label>";
            orgHtml.append("<li class='navNode'>").append(img).append(checkbox).append(lable).append("</li>");
            ++i;
        }
        String defaultLookAndFeel = AWSPortalConf.getProperty("client.default.lookandfeel");
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("sessionId", super.getContext().getSessionId());
        macroLibraries.put("appId", portalSkinsModel.getAppContext().getId());
        macroLibraries.put("isPortletContainer", portalSkinsModel.getProfile().isPortletContainer());
        macroLibraries.put("orgList", orgHtml.toString());
        macroLibraries.put("cheked", portalSkinsModel.getAppContext().getId().equals(defaultLookAndFeel) ? "checked" : "");
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        this.initRoleData(nodes, true, false, "", portalSkinsModel.getAppContext().getId());
        macroLibraries.put("roleNodes", JSON.toJSONString(nodes));
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.lf.style.designpage.edit.lookandfeel.htm", macroLibraries);
    }

    public String getRoleData(String appId, String pid, String roleGroup) {
        List<RoleModel> roleList = Cache.iteratorToList(RoleCache.getCache().iteratorSorted(RoleCache.SORT_ROLENAME));
        String groupName = roleGroup;
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        for (RoleModel roleModel : roleList) {
            if (!roleModel.getCategoryName().equals(groupName)) continue;
            nodes.add(this.getNodeObjectOfRole(pid, roleModel, appId.equals(roleModel.getLookAndFeel())));
        }
        return JSON.toJSONString(nodes);
    }

    private void initRoleData(List<Map<String, Object>> nodes, boolean notFilter, boolean searchFlag, String search, String appId) {
        String[] groupNames = RoleCache.getCategoryNames();
        if (search.trim().length() == 0) {
            List<RoleModel> roleList = Cache.iteratorToList(RoleCache.getCache().iteratorSorted(RoleCache.SORT_ROLENAME));
            int i = 0;
            while (i < groupNames.length) {
                String groupName = groupNames[i];
                if (notFilter || SecurityUtil.hasRoleAssignSec((UserContext)this.getContext(), (String)groupName)) {
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    String gid = String.valueOf(i);
                    node.put("id", gid);
                    node.put("name", I18nRes.findValue("_bpm.platform", groupName));
                    node.put("type", "RoleGroup");
                    node.put("iconCls", "roleGroup");
                    node.put("iconFont", "&#xe749;");
                    node.put("nocheck", true);
                    node.put("open", i == 0);
                    nodes.add(node);
                    if (i == 0) {
                        for (RoleModel roleModel : roleList) {
                            if (!roleModel.getCategoryName().equals(groupName)) continue;
                            nodes.add(this.getNodeObjectOfRole(gid, roleModel, roleModel.getLookAndFeel().equals(appId)));
                        }
                    }
                }
                ++i;
            }
        } else {
            int count = 0;
            String[] roleGroupNames = RoleCache.getCategoryNames();
            int i = 0;
            while (i < roleGroupNames.length) {
                if (SearchUtil.matches(roleGroupNames[i], search) && (notFilter || SecurityUtil.hasRoleAssignSec((UserContext)this.getContext(), (String)roleGroupNames[i]))) {
                    String groupName = groupNames[i];
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    String id = String.valueOf(i);
                    node.put("id", id);
                    node.put("name", I18nRes.findValue("_bpm.platform", groupName));
                    node.put("type", "RoleGroup");
                    node.put("iconCls", "roleGroup");
                    node.put("iconFont", "&#xe749;");
                    node.put("open", true);
                    nodes.add(node);
                    for (RoleModel roleModel : RoleCache.getCache()) {
                        if (!roleModel.getCategoryName().equals(groupName)) continue;
                        nodes.add(this.getNodeObjectOfRole(id, roleModel, null));
                        searchFlag = false;
                        ++count;
                    }
                }
                ++i;
            }
            if (searchFlag) {
                for (RoleModel roleModel : RoleCache.getCache()) {
                    if (!SearchUtil.matches(roleModel.getName(), search)) continue;
                    nodes.add(this.getNodeObjectOfRole("", roleModel, roleModel.getLookAndFeel().equals(appId)));
                    ++count;
                }
            }
            if (count == 0) {
                HashMap<String, Object> node = new HashMap<String, Object>();
                node.put("id", "AWS_NODE_RG_ID");
                node.put("name", I18nRes.findValue("_bpm.platform", this.getContext().getLanguage(), "\u6ca1\u6709\u76f8\u5339\u914d\u7684\u4fe1\u606f"));
                node.put("type", "RoleGroup");
                node.put("iconCls", "x-tree-node-not");
                node.put("nocheck", true);
                nodes.add(node);
            }
        }
    }

    private Map<String, Object> getNodeObjectOfRole(String pid, RoleModel model, Boolean check) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("id", model.getId());
        node.put("pid", pid);
        node.put("name", I18nRes.findValue("_bpm.platform", model.getName()));
        node.put("type", "role");
        node.put("iconCls", "role");
        node.put("iconFont", "&#59048;");
        if (check == null) {
            node.put("nocheck", "true");
        } else {
            node.put("checked", check);
        }
        return node;
    }

    public String getPortalDeskLayoutEditPage(String appId) {
        PortalSkinsModel portalSkinsModel = PortalSkinsManager.getSkinsModel(appId);
        if (portalSkinsModel == null) {
            return "";
        }
        Iterator map = NavigationSystemCache.getCache().iterator();
        StringBuffer navSubSystemHtml = new StringBuffer();
        StringBuffer portalDeskEditHtml = new StringBuffer();
        int n = 0;
        String currentNavSubSystemId = "";
        if (map != null) {
            while (map.hasNext()) {
                NavigationSystemModel systemModel = (NavigationSystemModel)map.next();
                if ("obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(systemModel.getId())) continue;
                String aClass = "navSubSystem-items";
                boolean isShow = false;
                if (n == 0) {
                    aClass = String.valueOf(aClass) + " current";
                    isShow = true;
                    currentNavSubSystemId = systemModel.getId();
                }
                ++n;
                navSubSystemHtml.append("<a id=\"" + systemModel.getId() + "\" href=\"javascript:void(0)\" onclick=\"selectNavSubSystem(this);\" class=\"" + aClass + "\">").append(NavigationUtil.getLangName(this.getContext().getLanguage(), systemModel.getSystemName())).append("</a>");
                portalDeskEditHtml.append(this.getPortalDeskEditPage(systemModel.getId(), isShow));
            }
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sessionId", super.getContext().getSessionId());
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("appId", portalSkinsModel.getAppContext().getId());
        macroLibraries.put("isPortletContainer", portalSkinsModel.getProfile().isPortletContainer());
        macroLibraries.put("navSubSystemHtml", navSubSystemHtml.toString());
        macroLibraries.put("portalDeskEditHtml", portalDeskEditHtml.toString());
        macroLibraries.put("currentNavSubSystemId", currentNavSubSystemId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.lf.style.designpage.edit.navsubsystem.htm", macroLibraries);
    }

    public String getPortalDeskEditPage(String navSubSystemId, boolean isShow) {
        String tdDisplay = isShow ? "" : "display:none;";
        NavigationSystemModel systemModel = NavigationSystemCache.getModel(navSubSystemId);
        if (systemModel == null) {
            return "";
        }
        String deskStyleHtml = "";
        String iframeId = "deskContent_" + navSubSystemId;
        String iframeSrc = "./w?sid=" + super.getContext().getSessionId() + "&cmd=CONSOLE_P_LF_STYLE_NSDC&navSubSystemId=" + navSubSystemId;
        String deskContentHtml = "<iframe id='" + iframeId + "' class='awsui-layout-iframe'  scrolling='no' src='" + iframeSrc + "' style='width:100%;height:135px;margin:0px;padding:0px;'></iframe>";
        String checked = !systemModel.isHidden() ? "checked" : "";
        String display = !systemModel.isHidden() ? "" : "display:none;";
        String tdId = "portalDeskLayout_" + navSubSystemId;
        String divId = "portalDeskDiv_" + navSubSystemId;
        String checkBoxId = "isShowPortalDesk_" + navSubSystemId;
        String checkBox = "<input class='awsui-checkbox' id='" + checkBoxId + "' type='checkbox' value='" + navSubSystemId + "' onchange='changeShowPortalDesk(this);' " + checked + "><label class='awsui-checkbox-label' for='" + checkBoxId + "'>\u63d0\u4f9b\u72ec\u7acb\u7684Portal\u684c\u9762</label>";
        StringBuilder portalDeskHtml = new StringBuilder();
        portalDeskHtml.append("<td valign=\"top\" style=\"width:77%;" + tdDisplay + "\" id=\"" + tdId + "\">\n");
        portalDeskHtml.append("   <span>").append(checkBox).append("</span>\n");
        portalDeskHtml.append("   <div id=\"" + divId + "\" style=\"" + display + "\">\n");
        portalDeskHtml.append("       <table border=\"0\" width=\"100%\" height=\"\">\n");
        portalDeskHtml.append("             <tr>\n");
        portalDeskHtml.append("                 <td style=\"\" valign=\"top\">\n");
        portalDeskHtml.append("                     <div class=\"myLable\">\n");
        portalDeskHtml.append("                          <span style=\"font-size:13px;margin-left:2px;color:#222;float:left\">\u684c\u9762\u98ce\u683c</span>\n");
        portalDeskHtml.append("                     </div>\n");
        portalDeskHtml.append(deskStyleHtml);
        portalDeskHtml.append("                 </td>\n");
        portalDeskHtml.append("             </tr>\n");
        portalDeskHtml.append("              <tr>\n");
        portalDeskHtml.append("                  <td valign=\"top\">\n");
        portalDeskHtml.append("                       <div class=\"myLable\">\n");
        portalDeskHtml.append("                            <span style=\"font-size:13px;margin-left:2px;color:#222;float:left\">\u684c\u9762\u5185\u5bb9&raquo;\u95e8\u6237\u7ee7\u627f\u7b56\u7565</span>\n");
        portalDeskHtml.append("                       </div>\n");
        portalDeskHtml.append(deskContentHtml);
        portalDeskHtml.append("                   </td>\n");
        portalDeskHtml.append("              </tr>\n");
        portalDeskHtml.append("          </table>\n");
        portalDeskHtml.append("    <div>\n");
        portalDeskHtml.append("</td>\n");
        return portalDeskHtml.toString();
    }

    public String getNavSubSystemDeskContent(String navSubSystemId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("navSubSystemId", navSubSystemId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.p.lf.style.designpage.edit.navsubsystem.deskContent.htm", macroLibraries);
    }

    public String saveSkinStyle(String appId, boolean defCheck, String roless, String companys, String navSubSystemParams) {
        PortalSkinsModel portalSkinsModel = PortalSkinsManager.getSkinsModel(appId);
        if (portalSkinsModel == null) {
            return ResponseObject.newErrResponse().msg("\u4fdd\u5b58\u914d\u7f6e\u7b56\u7565\u5931\u8d25").toString();
        }
        ArrayList<String> bs = new ArrayList<String>();
        HashSet<String> addRoleLookandfeel = new HashSet<String>();
        HashSet<String> removeRoleLookandfeel = new HashSet<String>();
        try {
            JSONObject jo = JSON.parseObject((String)roless);
            for (Map.Entry e : jo.entrySet()) {
                String roleId = (String)e.getKey();
                boolean check = jo.getBooleanValue(roleId);
                RoleModel r = RoleCache.getModel((String)roleId);
                if (r == null) continue;
                if (check) {
                    if (r.getLookAndFeel().equals(appId)) continue;
                    addRoleLookandfeel.add(roleId);
                    continue;
                }
                if (!r.getLookAndFeel().equals(appId)) continue;
                removeRoleLookandfeel.add(roleId);
            }
            for (String id : removeRoleLookandfeel) {
                String roleSql = "UPDATE ORGROLE SET LOOKANDFEEL = ''  WHERE LOOKANDFEEL= '" + portalSkinsModel.getAppContext().getId() + "' AND ID='" + id + "'";
                bs.add(roleSql);
            }
            for (String roleId : addRoleLookandfeel) {
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE ORGROLE SET LOOKANDFEEL = '").append(portalSkinsModel.getAppContext().getId()).append("' WHERE ID = '").append(roleId).append("'");
                bs.add(sql.toString());
            }
            String companySql = "UPDATE ORGCOMPANY SET LOOKANDFEEL = '' WHERE LOOKANDFEEL = '" + portalSkinsModel.getAppContext().getId() + "'";
            bs.add(companySql);
            if (companys != null && companys.trim().length() > 0) {
                String[] companyList = companys.split(" ");
                int i = 0;
                while (i < companyList.length) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("UPDATE ORGCOMPANY SET LOOKANDFEEL = '").append(portalSkinsModel.getAppContext().getId()).append("' WHERE ID = '").append(companyList[i].trim()).append("'");
                    bs.add(sql.toString());
                    ++i;
                }
            }
            if (defCheck) {
                String defaultLookAndFeel = AWSPortalConf.getProperty("client.default.lookandfeel");
                if (!portalSkinsModel.getAppContext().getId().equals(defaultLookAndFeel)) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("client.default.lookandfeel", portalSkinsModel.getAppContext().getId());
                    File appConfigFile = new File("conf/aws-portal.xml");
                    PortalXML.getInstance().saveProperty(appConfigFile, values);
                }
            }
            if (portalSkinsModel.getProfile().isPortletContainer() && navSubSystemParams != null && navSubSystemParams.trim().length() > 0) {
                String[] navSubSystemlayoutOptList = navSubSystemParams.split("]");
                int i = 0;
                while (i < navSubSystemlayoutOptList.length) {
                    String tempStr = navSubSystemlayoutOptList[i];
                    if (tempStr.startsWith("[")) {
                        String[] tempStrs = tempStr.substring(1, tempStr.length()).split(" ");
                        String navSubSystemId = tempStrs[0];
                        String isShowPortalDesk = tempStrs[1];
                        String portalLayout = "";
                        String portalLocked = "";
                        if (tempStrs.length > 2) {
                            portalLayout = tempStrs[2].substring(1, tempStrs[2].length() - 1);
                        }
                        if (tempStrs.length > 3) {
                            portalLocked = tempStrs[3];
                        }
                        StringBuffer sql = new StringBuffer();
                        int isHidden = isShowPortalDesk.equals("true") ? 0 : 1;
                        sql.append("UPDATE SYS_NAV_SYSTEM SET ").append("ISHIDDEN = ").append(isHidden).append(", ").append("PORTALLAYOUT = '").append(portalLayout).append("', ").append("PORTALLOCKED = '").append(portalLocked).append("', ").append("APPID = '").append(portalSkinsModel.getAppContext().getId()).append("' ").append("WHERE ID = '").append(navSubSystemId).append("'");
                        bs.add(sql.toString());
                    }
                    ++i;
                }
            }
            DBSql.batch(bs.toArray(new String[0]));
            RoleCache.getCache().reload(true);
            CompanyCache.getCache().reload(true);
            NavigationSystemCache.getCache().reload(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return ResponseObject.newErrResponse().msg("\u4fdd\u5b58\u914d\u7f6e\u7b56\u7565\u5931\u8d25").toString();
        }
        return ResponseObject.newOkResponse().msg("\u4fdd\u5b58\u914d\u7f6e\u7b56\u7565\u6210\u529f").toString();
    }

    public String getNavSystemExtendsJsonData(String navSubSystemId) {
        NavigationSystemModel systemModel = NavigationSystemCache.getModel(navSubSystemId);
        if (systemModel == null) {
            return "[]";
        }
        String extendsAdmin = systemModel.getPortalLocked();
        JSONArray jsonArray = new JSONArray();
        if (extendsAdmin != null && extendsAdmin.trim().length() > 0) {
            NavigationSystemExtendModel[] data = StyleManagerUtil.decodingNavagationSystemExtendStr(extendsAdmin);
            int i = 0;
            while (i < data.length) {
                NavigationSystemExtendModel model = data[i];
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("key", (Object)model.getId());
                jsonObj.put("offer", (Object)model.getOffer());
                jsonObj.put("inheritor", (Object)StyleManagerUtil.getInheritorList(navSubSystemId, model.getId()));
                jsonObj.put("orderIndex", (Object)model.getOderIndex());
                jsonArray.add((Object)jsonObj);
                ++i;
            }
        }
        return jsonArray.toString();
    }

    public String getNavSystemExtendsGetId() {
        int id = -1;
        ResponseObject responseObject = ResponseObject.newOkResponse().msg("");
        responseObject.put("id", id);
        return responseObject.toString();
    }

    public String saveNavSystemExtends(String navSubSystemId, String isExtendAdmin) {
        NavigationSystemModelImpl systemModel = (NavigationSystemModelImpl)NavigationSystemCache.getModel(navSubSystemId);
        if (systemModel == null) {
            return ResponseObject.newErrResponse().msg("\u4fdd\u5b58\u5931\u8d25").toString();
        }
        systemModel.setPortalLocked(isExtendAdmin);
        int r = NavigationDaoFactory.createNavigationSystem().update(systemModel);
        if (r == -1) {
            return ResponseObject.newErrResponse().msg("\u4fdd\u5b58\u5931\u8d25").toString();
        }
        NavigationSystemCache.updateModel(systemModel);
        return ResponseObject.newOkResponse().msg("\u4fdd\u5b58\u6210\u529f").toString();
    }

    public String removeNavSystemExtends(String navSubSystemId, String selectKey) {
        NavigationSystemModelImpl systemModel = (NavigationSystemModelImpl)NavigationSystemCache.getModel(navSubSystemId);
        if (systemModel == null) {
            return ResponseObject.newErrResponse().msg("\u5220\u9664\u5931\u8d25").toString();
        }
        String extendsAdmin = systemModel.getPortalLocked();
        NavigationSystemExtendModel[] data = StyleManagerUtil.decodingNavagationSystemExtendStr(extendsAdmin);
        String array = ProcessRuntimeUtil.getNewList((String)selectKey);
        String[] resArray = array.split(" ");
        ArrayList<String> bs = new ArrayList<String>();
        try {
            int i = 0;
            while (i < resArray.length) {
                String resId = resArray[i];
                if (resId != null && resId.trim().length() > 0) {
                    int id = Integer.parseInt(resId);
                    int j = 0;
                    while (j < data.length) {
                        if (data[j] != null && id == data[j].getId()) {
                            data[j] = null;
                            break;
                        }
                        ++j;
                    }
                    String sql = "DELETE FROM SYS_AC WHERE RESOURCEID = '" + resId + "' AND RESOURCETYPE = '" + NavExtACCM.resourceType + "'";
                    bs.add(sql.toString());
                }
                ++i;
            }
            DBSql.batch(bs.toArray(new String[0]));
            AccessControlCache.getCache().reload(true);
            systemModel.setPortalLocked(StyleManagerUtil.encodingNavagationSystemExtendStr(data));
            int r = NavigationDaoFactory.createNavigationSystem().update(systemModel);
            if (r == -1) {
                return ResponseObject.newErrResponse().msg("\u5220\u9664\u5931\u8d25").toString();
            }
            NavigationSystemCache.updateModel(systemModel);
            return ResponseObject.newOkResponse().msg("\u5220\u9664\u6210\u529f").toString();
        }
        catch (AWSDataAccessException e) {
            e.printStackTrace(System.err);
            return ResponseObject.newErrResponse().msg("\u5220\u9664\u5931\u8d25").toString();
        }
    }

    public String getUsers() {
        List userMap = UserCache.getActiveList();
        if (userMap == null || userMap.size() == 0) {
            return ResponseObject.newErrResponse().msg("\u83b7\u5f97\u7528\u6237\u5217\u8868\u5931\u8d25").toString();
        }
        ResponseObject responseObject = ResponseObject.newOkResponse().msg("");
        for (UserModel value : userMap) {
            responseObject.addObject().put("userId", value.getUID()).put("userName", value.getUserName());
        }
        return responseObject.toString();
    }
}

