/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.query;

import com.actionsoft.bpms.commons.database.DBUtils;
import com.actionsoft.bpms.commons.pagination.SQLPagination;
import com.actionsoft.bpms.commons.query.Query;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.api.HistoryTaskQueryAPI;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstQuery<Q extends Query<?, ?>, M>
implements Query<Q, M> {
    public static final String SORT_ASC = "ASC";
    public static final String SORT_DESC = "DESC";
    private Connection connection = null;
    private Map<String, Object> queryParameters = new HashMap<String, Object>();
    private Map<String, String> varMapping = new HashMap<String, String>();
    private Map<String, Object> varParameters = new HashMap<String, Object>();
    protected String sqlStatement;
    protected String countSqlStatement;
    private String orderByClause;
    private String orderByField;
    public int rowCount = -1;
    public int firstRow = 0;
    private boolean isCountOpt = false;
    public boolean isPaging = true;

    protected AbstQuery() {
    }

    public AbstQuery(String sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.countSqlStatement = sqlStatement;
    }

    public AbstQuery(String sqlStatement, String countSqlStatement) {
        this.sqlStatement = sqlStatement;
        this.countSqlStatement = countSqlStatement;
    }

    public boolean isCountOpt() {
        return this.isCountOpt;
    }

    @Override
    public Q sql(String sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.countSqlStatement = sqlStatement;
        return (Q)this;
    }

    @Override
    public Q countSql(String countSqlStatement) {
        this.countSqlStatement = countSqlStatement;
        return (Q)this;
    }

    @Override
    public Q addQuery(String fieldName, Object value) {
        this.queryParameters.put(fieldName, value);
        if (value != null) {
            String key = fieldName;
            if (fieldName.indexOf(" ") > -1) {
                key = fieldName.substring(0, fieldName.indexOf(" "));
            } else if (fieldName.trim().endsWith("=")) {
                key = fieldName.substring(0, fieldName.length() - 1).trim();
            }
            int i = 1;
            String tmp = key;
            while (this.varMapping.containsValue(key)) {
                key = String.valueOf(tmp) + "__" + i;
                ++i;
            }
            this.varMapping.put(fieldName, key);
            if (value instanceof Date) {
                value = new Timestamp(((Date)value).getTime());
            }
            this.varParameters.put(key, value);
        }
        return (Q)this;
    }

    public Q addQuerys(String[] fieldNames, Object[] values) {
        int l1 = 0;
        int l2 = 0;
        if (fieldNames != null) {
            l1 = fieldNames.length;
        }
        if (values != null) {
            l2 = values.length;
        }
        if (l1 != l2) {
            throw new IllegalArgumentException("params length and value length not equals");
        }
        if (fieldNames != null) {
            int i = 0;
            while (i < fieldNames.length) {
                this.addQuery(fieldNames[i], values[i]);
                ++i;
            }
        }
        return (Q)this;
    }

    public Q addQuerys(Map<String, Object> querys) {
        if (querys != null) {
            for (Map.Entry<String, Object> entry : querys.entrySet()) {
                this.addQuery(entry.getKey(), entry.getValue());
            }
        }
        return (Q)this;
    }

    public Map<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, Object> getSqlParameters() {
        return this.varParameters;
    }

    public String getSql() {
        StringBuilder newSql = new StringBuilder();
        newSql = this.isCountOpt ? new StringBuilder(this.countSqlStatement) : new StringBuilder(this.sqlStatement);
        StringBuilder whereClause = new StringBuilder();
        if (!this.queryParameters.isEmpty()) {
            if (newSql.toString().toUpperCase().indexOf(" WHERE ") == -1) {
                whereClause.append(" WHERE ");
            }
            for (String field : this.queryParameters.keySet()) {
                Object value = this.queryParameters.get(field);
                whereClause.append(field);
                String varName = this.varMapping.get(field);
                if (value != null && varName != null) {
                    whereClause.append(":");
                    whereClause.append(varName);
                    if (field.replace(" ", "").equals("TASKTITLELIKE") && value.toString().substring(1, value.toString().lastIndexOf(37)).contains("%")) {
                        whereClause.append(" ESCAPE '/'");
                    }
                }
                whereClause.append(" AND ");
            }
            if (whereClause.toString().endsWith(" AND ")) {
                whereClause.setLength(whereClause.length() - 5);
            }
        }
        if (this instanceof HistoryTaskQueryAPI && (((HistoryTaskQueryAPI)this).isSupportUnion() || ((HistoryTaskQueryAPI)this).isSupportPartitionUnion())) {
            newSql = newSql.insert(0, "SELECT * FROM ");
            newSql = new StringBuilder(new UtilString(newSql.toString()).replace("%WHERE%", whereClause.toString()));
        } else {
            newSql.append((CharSequence)whereClause);
        }
        String orderBy = this.getOrderBy();
        if (!UtilString.isEmpty(orderBy) && newSql.toString().toUpperCase().indexOf("ORDER BY") == -1) {
            newSql.append(" ORDER BY ").append(orderBy);
        }
        if (this.isPaging && this.rowCount > 0) {
            String sql = this.getPaginitionSQL(newSql.toString(), this.firstRow, this.rowCount);
            return sql;
        }
        return newSql.toString();
    }

    protected String getPaginitionSQL(String newSql, int firstRow, int rowCount) {
        if (this.getConnection() != null) {
            String s = DBUtils.getSupply((Connection)this.getConnection()).getName();
            return SQLPagination.getPaginitionSQL(this.getConnection(), s, newSql.toString(), firstRow, rowCount);
        }
        String sql = SQLPagination.getPaginitionSQL(newSql.toString(), firstRow, rowCount);
        return sql;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Q connection(Connection connection) {
        this.connection = connection;
        return (Q)this;
    }

    @Override
    public long count() {
        return this.count(this.connection, null, null);
    }

    protected long count(Connection conn, String s, String replace) {
        this.rowCount = -1;
        this.firstRow = 0;
        this.isCountOpt = true;
        String sql = this.getSql();
        this.isCountOpt = false;
        if (sql.indexOf("ORDER BY") > -1) {
            sql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if (this instanceof HistoryTaskQueryAPI && (((HistoryTaskQueryAPI)this).isSupportUnion() || ((HistoryTaskQueryAPI)this).isSupportPartitionUnion())) {
            sql = "SELECT COUNT(ID) AS C FROM " + sql.substring(13);
        } else {
            sql = sql.substring(sql.toUpperCase().indexOf(" FROM "));
            sql = "SELECT COUNT(ID) AS C " + sql;
        }
        String tmp = sql;
        if (!UtilString.isEmpty(s) && !UtilString.isEmpty(replace)) {
            tmp = Pattern.compile(s, 2).matcher(tmp).replaceAll(replace);
        }
        if (conn == null) {
            return DBSql.getLong(tmp, "C", this.getSqlParameters());
        }
        return DBSql.getLong(conn, tmp, "C", this.getSqlParameters());
    }

    protected Q paging(int firstRow, int rowCount) {
        this.firstRow = firstRow;
        this.rowCount = rowCount;
        return (Q)this;
    }

    @Override
    public Q orderBy(String fieldName) {
        this.orderByField = fieldName;
        return (Q)this;
    }

    @Override
    public Q asc() {
        this.addOrder(this.orderByField, SORT_ASC);
        return (Q)this;
    }

    @Override
    public Q desc() {
        this.addOrder(this.orderByField, SORT_DESC);
        return (Q)this;
    }

    private void addOrder(String fieldName, String sortOrder) {
        this.orderByClause = this.orderByClause == null ? "" : String.valueOf(this.orderByClause) + ", ";
        this.orderByClause = String.valueOf(this.orderByClause) + fieldName + " " + sortOrder;
    }

    @Override
    public M detail() {
        List list = this.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getOrderBy() {
        return this.orderByClause;
    }
}

