/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.ac;

import com.actionsoft.apps.resource.plugin.profile.ACPluginProfile;
import com.actionsoft.bpms.commons.security.ac.ACProfileManager;
import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.dao.AccessControlDaoFactory;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.cache.CompanyCache;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.TeamMemberCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.TeamMemberModel;
import com.actionsoft.bpms.org.model.UserMapModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AccessControlAPI {
    private static AccessControlAPI _accessControlAPIManager;

    private AccessControlAPI() {
    }

    public static AccessControlAPI getInstance() {
        if (_accessControlAPIManager == null) {
            _accessControlAPIManager = new AccessControlAPI();
        }
        return _accessControlAPIManager;
    }

    public ACPluginProfile getProfile(String resourceType) {
        return ACProfileManager.getProfile(resourceType);
    }

    public int appendACResource(String resourceId, String resourceType, int accessMode, String assignmentId, String assignmentType) {
        AccessControlModel model = new AccessControlModel();
        model._resourceId = resourceId;
        model._resourceType = resourceType;
        model._accessModel = accessMode;
        model._assignmentId = assignmentId;
        model._assignmentType = assignmentType;
        return AccessControlDaoFactory.creatAccessControl().insert(model);
    }

    public int removeACResource(String id) {
        return AccessControlDaoFactory.creatAccessControl().delete(id);
    }

    public List<AccessControlModel> getAccessModelListByResource(String resourceType, String resourceId, int accessMode) {
        ArrayList<AccessControlModel> list = new ArrayList<AccessControlModel>();
        Iterator<AccessControlModel> h = AccessControlCache.getACList(resourceType, resourceId);
        while (h.hasNext()) {
            AccessControlModel e = h.next();
            if (e._accessModel != accessMode) continue;
            list.add(e);
        }
        return list;
    }

    public Iterator<AccessControlModel> getListByResource(String resourceType, String resourceId) {
        Iterator<AccessControlModel> h = AccessControlCache.getACList(resourceType, resourceId);
        return h;
    }

    public List<AccessControlModel> getListByResourceType(String uid, String resourceType, int accessMode, int start, int limit) {
        ArrayList<AccessControlModel> list = new ArrayList<AccessControlModel>();
        UserModel user = UserCache.getModel((String)uid);
        if (user == null) {
            throw new IllegalArgumentException("uid[" + uid + "] not exist");
        }
        DepartmentModel departmentModel = DepartmentCache.getModel((String)user.getDepartmentId());
        if (departmentModel == null) {
            throw new IllegalArgumentException("uid[" + uid + "]'s departmentModel not exist");
        }
        CompanyModel companyModel = CompanyCache.getModel((String)departmentModel.getCompanyId());
        if (companyModel == null) {
            throw new IllegalArgumentException("uid[" + uid + "]'s companyModel not exist");
        }
        int access = 0;
        Iterator it = AccessControlCache.getCache().iterator();
        while (it.hasNext()) {
            AccessControlModel accessControlModel = (AccessControlModel)it.next();
            if (!this.havingPermission(user, accessControlModel, accessMode, departmentModel, companyModel) || ++access < start) continue;
            if (access >= start + limit) break;
            list.add(accessControlModel);
        }
        return list;
    }

    public boolean havingPermission(String uid, String resourceType, String resourceId, int accessMode, boolean restrict) {
        if (GradeSecurityUtil.isSuperMaster(uid) || GradeSecurityUtil.isSystemMaster(uid)) {
            return true;
        }
        if (restrict) {
            boolean check = this.havingPermission(uid, resourceType, resourceId, accessMode);
            return check;
        }
        Iterator<AccessControlModel> iterator = AccessControlCache.getACList(resourceType, resourceId, accessMode);
        if (!iterator.hasNext()) {
            return true;
        }
        boolean check = this.havingPermission(uid, resourceType, resourceId, accessMode);
        return check;
    }

    public boolean havingPermission(UserContext me, String resourceType, String resourceId, int accessMode, boolean restrict) {
        return this.havingPermission(me.getUID(), resourceType, resourceId, accessMode, restrict);
    }

    public boolean havingPermission(UserContext me, String resourceType, String resourceId, int accessMode) {
        return this.havingPermission(me.getUID(), resourceType, resourceId, accessMode);
    }

    public List<AccessControlModel> getACResourceList(String uid, String resourceType, int accessMode) {
        ArrayList<AccessControlModel> list = new ArrayList<AccessControlModel>();
        UserModel user = UserCache.getModel((String)uid);
        if (user == null) {
            return list;
        }
        DepartmentModel departmentModel = DepartmentCache.getModel((String)user.getDepartmentId());
        CompanyModel companyModel = CompanyCache.getModel((String)departmentModel.getCompanyId());
        Iterator<AccessControlModel> it = AccessControlCache.getACList(resourceType);
        while (it.hasNext()) {
            AccessControlModel model = it.next();
            if (!this.havingPermission(user, model, accessMode, departmentModel, companyModel)) continue;
            list.add(model);
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public boolean havingPermission(String uid, Iterator<AccessControlModel> h, int accessMode) {
        user = UserCache.getModel((String)uid);
        if (user == null) {
            return false;
        }
        isAccess = false;
        departmentModel = DepartmentCache.getModel((String)user.getDepartmentId());
        if (departmentModel == null) {
            return false;
        }
        companyModel = CompanyCache.getModel((String)departmentModel.getCompanyId());
        if (companyModel != null) ** GOTO lbl-1000
        return false;
        while (!(isAccess = this.havingPermission(user, model = h.next(), accessMode, departmentModel, companyModel))) lbl-1000:
        // 2 sources

        {
            if (h.hasNext()) continue;
        }
        return isAccess;
    }

    public boolean havingPermission(String uid, String resourceType, String resourceId, int accessMode) {
        Iterator<AccessControlModel> h = AccessControlCache.getACList(resourceType, resourceId);
        return this.havingPermission(uid, h, accessMode);
    }

    private boolean havingPermission(UserModel user, AccessControlModel model, int accessMode, DepartmentModel departmentModel, CompanyModel companyModel) {
        boolean isAccess = false;
        if (model._assignmentType.equals("company")) {
            List mapList;
            if (model._assignmentId.equals(companyModel.getId())) {
                boolean bl = isAccess = model._accessModel == accessMode;
            }
            if (!isAccess && (mapList = UserMapCache.getMapListOfUser((String)user.getUID())) != null && mapList.size() > 0) {
                int ii = 0;
                while (ii < mapList.size()) {
                    CompanyModel mapCompanyModel;
                    UserMapModel mapModel = (UserMapModel)mapList.get(ii);
                    DepartmentModel mapDeptModel = DepartmentCache.getModel((String)mapModel.getDepartmentId());
                    if (mapDeptModel != null && (mapCompanyModel = CompanyCache.getModel((String)mapDeptModel.getCompanyId())) != null && model._assignmentId.equals(mapCompanyModel.getId())) {
                        boolean bl = isAccess = model._accessModel == accessMode;
                        if (isAccess) break;
                    }
                    ++ii;
                }
            }
        } else if (model._assignmentType.equals("department")) {
            List mapList;
            DepartmentModel dModel = DepartmentCache.getModel((String)model._assignmentId);
            if (departmentModel.getId().equals(model._assignmentId) || this.putDepartmentTree(dModel, departmentModel.getId())) {
                boolean bl = isAccess = model._accessModel == accessMode;
            }
            if (!isAccess && (mapList = UserMapCache.getMapListOfUser((String)user.getUID())) != null && mapList.size() > 0) {
                int ii = 0;
                while (ii < mapList.size()) {
                    UserMapModel mapModel = (UserMapModel)mapList.get(ii);
                    DepartmentModel mapDeptModel = DepartmentCache.getModel((String)mapModel.getDepartmentId());
                    if (mapDeptModel != null && (mapDeptModel.getId().equals(model._assignmentId) || this.putDepartmentTree(dModel, mapDeptModel.getId()))) {
                        boolean bl = isAccess = model._accessModel == accessMode;
                    }
                    if (!isAccess) {
                        ++ii;
                        continue;
                    }
                    break;
                }
            }
        } else if (model._assignmentType.equals("role")) {
            List mapList;
            if (model._assignmentId.equals(user.getRoleId())) {
                boolean bl = isAccess = model._accessModel == accessMode;
            }
            if (!isAccess && (mapList = UserMapCache.getMapListOfUser((String)user.getUID())) != null && mapList.size() > 0) {
                int ii = 0;
                while (ii < mapList.size()) {
                    UserMapModel mapModel = (UserMapModel)mapList.get(ii);
                    if (mapModel != null && model._assignmentId.equals(mapModel.getRoleId())) {
                        boolean bl = isAccess = model._accessModel == accessMode;
                        if (isAccess) break;
                    }
                    ++ii;
                }
            }
        } else if (model._assignmentType.equals("team")) {
            Iterator tH = TeamMemberCache.getListOfMember((String)model._assignmentId);
            while (tH.hasNext()) {
                TeamMemberModel uModel = (TeamMemberModel)tH.next();
                if (user.getUID() == null || !user.getUID().equals(uModel.getUserId())) continue;
                boolean bl = isAccess = model._accessModel == accessMode;
                if (!isAccess) {
                    continue;
                }
                break;
            }
        } else if (model._assignmentType.equals("user") && model._assignmentId.equals(user.getUID())) {
            isAccess = model._accessModel == accessMode;
        }
        return isAccess;
    }

    private boolean putDepartmentTree(DepartmentModel rootModel, String currentDepartmentId) {
        String departmentFullId = "/" + DepartmentCache.getFullID((String)currentDepartmentId);
        if (rootModel != null) {
            String sourceDepartmentId = "/" + rootModel.getId() + "/";
            return departmentFullId.indexOf(sourceDepartmentId) != -1;
        }
        return false;
    }
}

