/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.ac;

import com.actionsoft.bpms.commons.security.ac.web.AccessControlWeb;
import com.actionsoft.bpms.org.addresstree.ACAddressTreeWeb;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.server.bind.annotation.Param;

@Controller
public class AccessControlController {
    @Mapping(value="CLIENT_COMMON_AC_ACTION_OPEN", scopeAccess=false)
    public String openACAction(UserContext me, String resourceId, String resourceType, @Param(defaultValue="Console") String invoke) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.getWeb(resourceId, resourceType, -1, false, me.getCompanyModel().getId(), "", 0, "", invoke);
    }

    @Mapping(value="CONSOLE_COMMON_ACCESSCONTROL_COMPANY_OPEN", scopeAccess=false)
    public String openAccessControlCompany(UserContext me, String resourceId, String resourceType, String select_company, int accessMode, int orgType, String invoke) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.getWeb(resourceId, resourceType, accessMode, false, select_company, "", orgType, "", invoke);
    }

    @Mapping(value="CONSOLE_COMMON_ASSIGN_ORGROLE", scopeAccess=false)
    public String openAssignOrgrole(UserContext me) {
        AccessControlWeb web = new AccessControlWeb(me);
        String companyId = me.getCompanyModel().getId();
        return web.getAssignOrgRole(companyId);
    }

    @Mapping(value="CONSOLE_COMMON_ASSIGN_ORGROLE_COMPANY_SELECT", scopeAccess=false)
    public String openAssignOrgroleCompanySelect(UserContext me, String select_company) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.getAssignOrgRole(select_company);
    }

    @Mapping(value="CONSOLE_COMMON_ASSIGN_ORGROLE_SAVE", scopeAccess=false)
    public String saveOrgrole(UserContext me, String perm, String permStr) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.saveOrgRole(perm, permStr);
    }

    @Mapping(value="CONSOLE_COMMON_ACCESSCONTROL_AC_REMOVE", scopeAccess=false)
    public String removeAccessControlAc(UserContext me, String resourceId, String resourceType, String select_company, int accessMode, int orgType, String id, String invoke) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.removeACResource(resourceId, resourceType, accessMode, true, select_company, "", orgType, id, invoke);
    }

    @Mapping(value="CONSOLE_COMMON_AC_SEARCH", scopeAccess=false)
    public String searchAccessControlAc(UserContext me, String resourceId, String resourceType, String select_company, int accessMode, int orgType, String search, String invoke) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.getWeb(resourceId, resourceType, accessMode, false, select_company, "", orgType, search, invoke);
    }

    @Mapping(value="CONSOLE_COMMON_ACCESSCONTROL_CREATE", scopeAccess=false)
    public String createAccessControl(UserContext me, String resourceId, int acTypeNameOpt, String resourceType, String acOrgId, String companyId, int orgType, String invoke) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.appendACResource(resourceId, resourceType, acOrgId, acTypeNameOpt, companyId, orgType, invoke);
    }

    @Mapping(value="CONSOLE_COMMON_ACCESSCONTROL_CHANGE_TYPE_PAGE", scopeAccess=false)
    public String openAccessControlChangeType(UserContext me, String resourceId, int accessMode, String resourceType, String invoke) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.getWeb(resourceId, resourceType, accessMode, false, me.getCompanyModel().getId(), "", 0, "", invoke);
    }

    @Mapping(value="CONSOLE_COMMON_ACCESSCONTROL_TREELOADER_DATA_JSON", scopeAccess=false)
    public String getAccessControlTreeLoaderJSONDATE(UserContext me, String requestType, String param1, String param2, String param3, String search, String resourceType, String invoke, String assignmentType) {
        ACAddressTreeWeb web = new ACAddressTreeWeb(me, Integer.parseInt(assignmentType));
        return web.getJsonTreeOfORG(requestType, param1, param2, param3, search, AccessControlWeb.isConsoleInvoke(invoke));
    }

    @Mapping(value="CLIENT_COMMON_AC_GROUP", scopeAccess=false)
    public String changeACGroup(UserContext me, RequestParams params) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.changeGroup(params);
    }

    @Mapping(value="CLIENT_COMMON_AC_SUBDATA", scopeAccess=false)
    public String getSubData(UserContext me, RequestParams params) {
        ACAddressTreeWeb web = new ACAddressTreeWeb(me);
        return web.getSubData(params);
    }

    @Mapping(value="CLIENT_COMMON_AC_ADD", scopeAccess=false)
    public String addAC(UserContext me, RequestParams params) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.addAC(params);
    }

    @Mapping(value="CLIENT_COMMON_AC_REMOVE", scopeAccess=false)
    public String removeAC(UserContext me, RequestParams params) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.removeAC(params);
    }

    @Mapping(value="CLIENT_COMMON_AC_SEARCH", scopeAccess=false)
    public String search(UserContext me, RequestParams params) {
        AccessControlWeb web = new AccessControlWeb(me);
        return web.search(params);
    }
}

