/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.ac.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.security.ac.cache.ACIndex;
import com.actionsoft.bpms.commons.security.ac.dao.AccessControlDaoFactory;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AccessControlCache
extends Cache<String, AccessControlModel> {
    public AccessControlCache(CachePluginProfile configuration) {
        super(configuration);
        this.registeIndex(ACIndex.class, new ACIndex());
    }

    public static void putModel(AccessControlModel obj) {
        AccessControlCache.getCache().put(obj._id, obj);
    }

    public static void removeModel(String id) {
        AccessControlCache.getCache().remove(id);
    }

    public static AccessControlModel getModel(String id) {
        return (AccessControlModel)AccessControlCache.getCache().get(id);
    }

    public static Object getACModel(String resourceType, String resourceId, String assignmentType, String assignmentId, int accessMode) {
        Iterator<AccessControlModel> it = AccessControlCache.getACList(resourceType);
        while (it.hasNext()) {
            AccessControlModel model = it.next();
            if (!model._resourceType.equals(resourceType) || !model._assignmentType.equals(assignmentType) || !model._assignmentId.equals(assignmentId) || model._accessModel != accessMode || !model._resourceId.equals(resourceId)) continue;
            return model;
        }
        return null;
    }

    public static Iterator<AccessControlModel> getACList(String resourceType) {
        return AccessControlCache.getCache().getByIndex(ACIndex.class, resourceType);
    }

    public static Iterator<AccessControlModel> getACList(String resourceType, String resourceId) {
        ArrayList<AccessControlModel> list = new ArrayList<AccessControlModel>();
        Iterator<AccessControlModel> it = AccessControlCache.getACList(resourceType);
        while (it.hasNext()) {
            AccessControlModel ac = it.next();
            if (!ac._resourceId.equals(resourceId) || !ac._resourceType.equals(resourceType)) continue;
            list.add(ac);
        }
        return list.iterator();
    }

    public static Iterator<AccessControlModel> getACList(String resourceType, String resourceId, int accessMode) {
        ArrayList<AccessControlModel> list = new ArrayList<AccessControlModel>();
        Iterator<AccessControlModel> it = AccessControlCache.getACList(resourceType);
        while (it.hasNext()) {
            AccessControlModel ac = it.next();
            if (!ac._resourceId.equals(resourceId) || !ac._resourceType.equals(resourceType) || ac._accessModel != accessMode) continue;
            list.add(ac);
        }
        return list.iterator();
    }

    @Override
    public void load() {
        String pmpt = "Cache\u52a0\u8f7dAC\u5bf9\u8c61\u5b9e\u4f8b";
        List<AccessControlModel> h = AccessControlDaoFactory.creatAccessControl().getInstance();
        if (h != null) {
            for (AccessControlModel model : h) {
                AccessControlCache.getCache().put(model._id, model, false);
            }
        }
        pmpt = String.valueOf(pmpt) + " [" + (h == null ? 0 : h.size()) + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(pmpt);
    }

    public static AccessControlCache getCache() {
        return CacheManager.getCache(AccessControlCache.class);
    }

    public static class ACKey {
        private String _resourceId;
        private String _resourceType;

        public ACKey(AccessControlModel acModel) {
            this._resourceId = acModel._resourceId;
            this._resourceType = acModel._resourceType;
        }

        public ACKey(String resourceId, String resourceType) {
            this._resourceId = resourceId;
            this._resourceType = resourceType;
        }

        public String getResourceId() {
            return this._resourceId;
        }

        public String getResourceType() {
            return this._resourceType;
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof ACKey) {
                ACKey o = (ACKey)anObject;
                return this._resourceType.equals(o.getResourceType()) && this._resourceId.equals(o.getResourceId());
            }
            return false;
        }

        public int hashCode() {
            return this._resourceId.hashCode() ^ this._resourceType.hashCode();
        }

        public String toString() {
            return String.valueOf(this._resourceId) + "_" + String.valueOf(this._resourceType);
        }
    }
}

