/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.ac.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class AccessControl
extends DaoObject<AccessControlModel> {
    @Override
    public int insert(AccessControlModel obj) {
        AccessControlModel model = obj;
        model._id = UUIDGener.getUUID();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", model._id);
        map.put("RESOURCEID", model._resourceId);
        map.put("RESOURCETYPE", model._resourceType);
        map.put("ACCESSMODE", model._accessModel);
        map.put("ASSIGNMENTID", model._assignmentId);
        map.put("ASSIGNMENTTYPE", model._assignmentType);
        String sql = DBSql.getInsertStatement(this.entityName(), map);
        int r = DBSql.update(sql, map);
        AccessControlCache.putModel(model);
        return r;
    }

    @Override
    public int delete(Object id) {
        int r = super.delete(id);
        AccessControlCache.removeModel((String)id);
        return r;
    }

    @Override
    public int update(AccessControlModel obj) {
        throw new UnsupportedOperationException();
    }

    public List<AccessControlModel> getInstance() {
        return this.query().list();
    }

    public AccessControlModel record2Model(ResultSet rset) {
        AccessControlModel model = new AccessControlModel();
        try {
            model._id = rset.getString("ID");
            model._resourceId = rset.getString("RESOURCEID");
            model._resourceType = rset.getString("RESOURCETYPE");
            model._accessModel = rset.getInt("ACCESSMODE");
            model._assignmentId = rset.getString("ASSIGNMENTID");
            model._assignmentType = rset.getString("ASSIGNMENTTYPE");
            if (model._resourceId == null) {
                model._resourceId = "";
            }
            if (model._resourceType == null) {
                model._resourceType = "";
            }
            if (model._assignmentId == null) {
                model._assignmentId = "";
            }
            if (model._assignmentType == null) {
                model._assignmentType = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return model;
    }

    @Override
    public String entityName() {
        return "SYS_AC";
    }

    @Override
    public RowMapper<AccessControlModel> rowMapper() {
        return new RowMapper<AccessControlModel>(){

            public AccessControlModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                return AccessControl.this.record2Model(rs);
            }
        };
    }
}

