/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.ac.web;

import com.actionsoft.apps.resource.plugin.profile.ACPluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.htmlframework.AlertWindow;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.ACProfileManager;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.model.ACAccessMode;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.commons.security.ac.model.CompanyACCM;
import com.actionsoft.bpms.commons.security.ac.util.SearchUtil;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.high.model.HighSecurityModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.addresstree.ACAddressTreeWeb;
import com.actionsoft.bpms.org.cache.CompanyCache;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.cache.TeamCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.org.model.TeamModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.util.SecurityUtil;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilSpell;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AccessControlWeb
extends ActionWeb {
    public static final int SHOW_TYPE_ORG = 0;
    public static final int SHOW_TYPE_ROLE = 1;
    public static final int SHOW_TYPE_TEAM = 2;

    public AccessControlWeb(UserContext me) {
        super(me);
    }

    public static boolean isConsoleInvoke(String invoke) {
        return "Console".equals(invoke);
    }

    private int getDefAccessMode(ACPluginProfile pf, int accessMode) {
        boolean find = false;
        ACAccessMode[] aCAccessModeArray = pf.getAccessModes();
        int n = aCAccessModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ACAccessMode model = aCAccessModeArray[n2];
            if (model.getType() == accessMode) {
                find = true;
                break;
            }
            ++n2;
        }
        if (!find) {
            accessMode = pf.getAccessModes()[0].getType();
        }
        return accessMode;
    }

    public String getWeb(String resourceId, String resourceType, int accessMode, boolean isRead, String companyId, String remindContent, int showType, String search, String invoke) {
        if ("ajaxDeleteOrgAC".equals(invoke)) {
            ResponseObject ro = ResponseObject.newOkResponse();
            ro.ok();
            return ro.toString();
        }
        ACPluginProfile pf = ACProfileManager.getProfile(resourceType);
        boolean isolationCompany = pf.isIsolationCompany();
        List<String> assignmentTypesList = null;
        if (pf != null) {
            String[] assignmentTypes = pf.getAssignmentTypes();
            if (assignmentTypes == null || assignmentTypes.length == 0) {
                String[] defaultAssignmentTypes = new String[]{ACPluginProfile.ASSN_TYPE_COMPANY, ACPluginProfile.ASSN_TYPE_DEPARTMENT, ACPluginProfile.ASSN_TYPE_ROLE, ACPluginProfile.ASSN_TYPE_TEAM, ACPluginProfile.ASSN_TYPE_USER};
                assignmentTypesList = Arrays.asList(defaultAssignmentTypes);
            } else {
                assignmentTypesList = Arrays.asList(assignmentTypes);
            }
            if (pf.getAccessModes() == null || pf.getAccessModes().length == 0) {
                return AlertWindow.getNotFoundMessagePage("\u8bbf\u95ee\u6a21\u5f0f\u672a\u5b9a\u4e49", "[resourceType=" + resourceType + "]");
            }
        } else {
            return AlertWindow.getWarningMessagePage("\u53c2\u6570\u4e0d\u6b63\u786e", "[resourceType=" + resourceType + "]");
        }
        accessMode = this.getDefAccessMode(pf, accessMode);
        boolean notFilter = AccessControlWeb.isConsoleInvoke(invoke);
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        ArrayList nodesRole = new ArrayList();
        boolean searchFlag = true;
        if (showType == 0) {
            new ACAddressTreeWeb(this.getContext()).initACAddressTreeData(assignmentTypesList, nodes, search, notFilter, companyId, resourceType, searchFlag, resourceType);
        } else if (showType == 1) {
            this.initRoleData(nodes, notFilter, searchFlag, search);
        } else if (showType == 2) {
            this.initTeamData(nodes);
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this.getContext().getSessionId());
        macroLibraries.put("treeList", JSONArray.parseArray((String)JSONObject.toJSONString(nodes)).toString());
        macroLibraries.put("accessMode", accessMode);
        macroLibraries.put("assignmentType", showType);
        macroLibraries.put("resourceId", resourceId);
        macroLibraries.put("resourceType", resourceType);
        macroLibraries.put("invoke", invoke);
        macroLibraries.put("acTypeList", this.getAcType(accessMode, resourceType));
        macroLibraries.put("isRead", isRead);
        macroLibraries.put("companyId", companyId);
        macroLibraries.put("assignmentTypesList", assignmentTypesList.toString());
        String acList = this.getAssignList(pf, resourceId, resourceType);
        macroLibraries.put("acList", acList);
        macroLibraries.put("ACAddress", false);
        macroLibraries.put("lang", this.getContext().getLanguage());
        return HtmlPageTemplate.merge("_bpm.platform", "client.common.ac.htm", macroLibraries);
    }

    public String changeGroup(RequestParams params) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        String groupType = params.get("groupType");
        String resourceType = params.get("resourceType");
        String companyId = params.get("companyId");
        String invoke = params.get("invoke");
        if (groupType.equals("org")) {
            ACPluginProfile pf = ACProfileManager.getProfile(resourceType);
            List<String> assignmentTypesList = null;
            if (pf != null) {
                String[] assignmentTypes = pf.getAssignmentTypes();
                if (assignmentTypes == null || assignmentTypes.length == 0) {
                    String[] defaultAssignmentTypes = new String[]{ACPluginProfile.ASSN_TYPE_COMPANY, ACPluginProfile.ASSN_TYPE_DEPARTMENT, ACPluginProfile.ASSN_TYPE_ROLE, ACPluginProfile.ASSN_TYPE_TEAM, ACPluginProfile.ASSN_TYPE_USER};
                    assignmentTypesList = Arrays.asList(defaultAssignmentTypes);
                } else {
                    assignmentTypesList = Arrays.asList(assignmentTypes);
                }
                if (pf.getAccessModes() == null || pf.getAccessModes().length == 0) {
                    return AlertWindow.getNotFoundMessagePage("\u8bbf\u95ee\u6a21\u5f0f\u672a\u5b9a\u4e49", "[resourceType=" + resourceType + "]");
                }
            }
            boolean notFilter = AccessControlWeb.isConsoleInvoke(invoke);
            new ACAddressTreeWeb(this.getContext()).initACAddressTreeData(assignmentTypesList, nodes, "", notFilter, companyId, resourceType, false, resourceType);
        } else if (groupType.equals("role")) {
            this.initRoleData(nodes, true, false, "");
        } else if (groupType.equals("team")) {
            this.initTeamData(nodes);
        }
        return JSON.toJSONString(nodes);
    }

    public String addAC(RequestParams params) {
        JSONArray acList = JSONArray.parseArray((String)params.get("acList"));
        String resourceType = params.get("resourceType");
        String resourceId = params.get("resourceId");
        int accessMode = 0;
        ArrayList<AccessControlModel> acModelList = new ArrayList<AccessControlModel>();
        int i = 0;
        while (i < acList.size()) {
            JSONObject item = acList.getJSONObject(i);
            String assignmentType = item.getString("assignmentType");
            String assignmentId = item.getString("assignmentId");
            String acTypeNameOpt = item.getString("acTypeNameOpt");
            try {
                accessMode = Integer.parseInt(acTypeNameOpt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (AccessControlCache.getACModel(resourceType, resourceId, assignmentType, assignmentId, accessMode) == null) {
                AccessControlAPI.getInstance().appendACResource(resourceId, resourceType, accessMode, assignmentId, assignmentType);
                AccessControlModel model = new AccessControlModel();
                model._resourceId = resourceId;
                model._resourceType = resourceType;
                model._accessModel = accessMode;
                model._assignmentId = assignmentId;
                model._assignmentType = assignmentType;
                acModelList.add(model);
            }
            ++i;
        }
        ACPluginProfile acProfile = ACProfileManager.getProfile(resourceType);
        acProfile.appendCallBack(acProfile.getAppContext().getId(), acModelList);
        ACPluginProfile pf = ACProfileManager.getProfile(resourceType);
        ResponseObject response = ResponseObject.newOkResponse();
        response.put("acList", this.getAssignList(pf, resourceId, resourceType));
        return response.toString();
    }

    private String getAssignList(ACPluginProfile pf, String resourceId, String resourceType) {
        ACAccessMode[] modes;
        JSONObject iconJSON = new JSONObject();
        iconJSON.put("company", (Object)"&#xe6ff;");
        iconJSON.put("department", (Object)"&#59318;");
        iconJSON.put("user", (Object)"&#58939;");
        iconJSON.put("role", (Object)"&#59048;");
        iconJSON.put("team", (Object)"&#xe6f9;");
        StringBuilder html = new StringBuilder();
        List<AccessControlModel> acList = Cache.iteratorToList(AccessControlCache.getACList(resourceType, resourceId));
        Collections.sort(acList, new ACComparator());
        ACAccessMode[] aCAccessModeArray = modes = pf.getAccessModes();
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            ACAccessMode acType = aCAccessModeArray[n2];
            StringBuilder ul = new StringBuilder();
            for (AccessControlModel acModel : acList) {
                if (acType.getType() != acModel._accessModel) continue;
                ul.append("<li id='").append(acModel._id).append("'><div class='awsui-iconfont'>").append(iconJSON.getString(acModel._assignmentType)).append("</div>");
                String name = "";
                switch (acModel._assignmentType) {
                    case "company": {
                        CompanyModel company = CompanyCache.getModel((String)acModel._assignmentId);
                        name = company == null ? acModel._assignmentId : company.getNameI18N();
                        break;
                    }
                    case "department": {
                        DepartmentModel dept = DepartmentCache.getModel((String)acModel._assignmentId);
                        name = dept == null ? acModel._assignmentId : dept.getNameI18N();
                        break;
                    }
                    case "user": {
                        UserModel user = UserCache.getModel((String)acModel._assignmentId);
                        name = user == null ? acModel._assignmentId : user.getUserNameI18N();
                        break;
                    }
                    case "team": {
                        TeamModel team = TeamCache.getModel((String)acModel._assignmentId);
                        name = team == null ? acModel._assignmentId : team.getNameI18N();
                        break;
                    }
                    case "role": {
                        RoleModel role = RoleCache.getModel((String)acModel._assignmentId);
                        name = role == null ? acModel._assignmentId : role.getNameI18N();
                    }
                }
                ul.append("<span class='text'>").append(name).append("</span>");
                ul.append("<div class='awsui-iconfont del' onclick='removeAC(this);'>&#58918;</div></li>");
            }
            if (ul.length() > 0) {
                String acTypeName = I18nRes.findValue("_bpm.platform", acType.getName());
                html.append("<div class='typeTitle'>").append(acTypeName).append("</div>").append("<ul>");
                html.append(ul.toString());
                html.append("</ul>");
            }
            ++n2;
        }
        return html.toString();
    }

    public String removeAC(RequestParams params) {
        String resourceId = params.get("resourceId");
        String resourceType = params.get("resourceType");
        int accessMode = Integer.parseInt(params.get("accessMode"));
        String invoke = params.get("invoke");
        String acId = params.get("acId");
        AccessControlModel model = AccessControlCache.getModel(acId);
        try {
            AccessControlAPI.getInstance().removeACResource(acId);
            model._id = "--";
            ACPluginProfile acProfile = ACProfileManager.getProfile(resourceType);
            ArrayList<AccessControlModel> list = new ArrayList<AccessControlModel>();
            list.add(model);
            acProfile.appendCallBack(acProfile.getAppContext().getId(), list);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        ResponseObject response = ResponseObject.newOkResponse();
        return response.toString();
    }

    public String search(RequestParams params) {
        boolean searchShowUserId = SDK.getAppAPI().getPropertyBooleanValue("_bpm.portal", "searchShowUserId", false);
        ResponseObject response = ResponseObject.newOkResponse();
        boolean isSaasModel = this.getContext().isSaaSModel();
        JSONArray array = new JSONArray();
        String uid = this.getContext().getUID();
        String companyId = params.get("companyId");
        String type = params.get("type");
        String keyWord = params.get("keyWord");
        int limit = 12;
        String page = params.get("page").toString();
        int start = limit * (Integer.parseInt(page) - 1);
        int listSize = 0;
        List<UserModel> orgList = new ArrayList<Object>();
        if ("org".equals(type)) {
            CompanyModel company22 = CompanyCache.getModel((String)companyId);
            if (company22.getName().contains(keyWord)) {
                orgList.add((UserModel)company22);
            }
            if (!isSaasModel) {
                for (CompanyModel company22 : CompanyCache.getCache()) {
                    if (company22.getId().equals(companyId) || !company22.getName().contains(keyWord)) continue;
                    orgList.add((UserModel)company22);
                }
            }
            for (DepartmentModel dept : DepartmentCache.getCache()) {
                if (dept == null || dept.isClosed() || isSaasModel && !dept.getCompanyId().equals(companyId) || !dept.getName().contains(keyWord)) continue;
                orgList.add((UserModel)dept);
            }
            List list = SDK.getORGAPI().liveSearchUser(uid, keyWord, Integer.MAX_VALUE);
            String show3PUser = HighSecurityModel.getProperty("show3PUser");
            for (UserModel userModel : list) {
                if (userModel.isClosed() || (!HighSecurity.isON() ? HighSecurity.is3PSecAdmin(userModel.getUID()) || HighSecurity.is3PSysAdmin(userModel.getUID()) || HighSecurity.is3PAuditor(userModel.getUID()) : !show3PUser.equals("true") && (GradeSecurityUtil.isAuditorMaster(userModel.getUID()) || GradeSecurityUtil.isSecurityMaster(userModel.getUID()) || GradeSecurityUtil.isSystemMaster(userModel.getUID())))) continue;
                DepartmentModel dept = DepartmentCache.getModel((String)userModel.getDepartmentId());
                if (dept != null && isSaasModel && !dept.getCompanyId().equals(companyId)) continue;
                orgList.add(userModel);
            }
            listSize = orgList.size();
            orgList = orgList.subList(start, start + limit > listSize ? listSize : start + limit);
            for (Serializable serializable : orgList) {
                JSONObject item = new JSONObject();
                if (serializable instanceof CompanyModel) {
                    CompanyModel c = (CompanyModel)serializable;
                    item.put("type", (Object)"company");
                    item.put("id", (Object)c.getId());
                    item.put("text", (Object)c.getName());
                } else if (serializable instanceof DepartmentModel) {
                    DepartmentModel dept = (DepartmentModel)serializable;
                    item.put("type", (Object)"department");
                    item.put("id", (Object)dept.getId());
                    item.put("text", (Object)dept.getName());
                    CompanyModel companyModel = CompanyCache.getModel((String)dept.getCompanyId());
                    if (companyModel != null) {
                        item.put("showtextsuffix", (Object)companyModel.getName());
                    }
                } else if (serializable instanceof UserModel) {
                    UserModel user = (UserModel)serializable;
                    item.put("type", (Object)"user");
                    item.put("id", (Object)user.getUID());
                    item.put("text", (Object)user.getUserName());
                    DepartmentModel deptModel = SDK.getORGAPI().getDepartmentById(user.getDepartmentId());
                    if (deptModel != null) {
                        String suffix = deptModel.getPathNameI18NOfCache();
                        if (searchShowUserId) {
                            suffix = " (" + user.getUID() + ") " + suffix;
                        }
                        item.put("showtextsuffix", (Object)suffix);
                    }
                }
                array.add((Object)item);
            }
        } else if ("role".equals(type)) {
            List roleList = new ArrayList<RoleModel>();
            for (RoleModel role : RoleCache.getCache()) {
                if (!role.getName().contains(keyWord)) continue;
                roleList.add(role);
            }
            listSize = roleList.size();
            roleList = roleList.subList(start, start + limit > listSize ? listSize : start + limit);
            for (RoleModel role : roleList) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"role");
                jSONObject.put("id", (Object)role.getId());
                jSONObject.put("text", (Object)role.getName());
                array.add((Object)jSONObject);
            }
        } else if ("team".equals(type)) {
            List allTeam = TeamCache.getListOfPublic((String)this.getContext().getUID());
            allTeam.addAll(TeamCache.getListOfPrivate((String)this.getContext().getUID()));
            List teamList = new ArrayList<TeamModel>();
            for (TeamModel team : allTeam) {
                if (!team.getName().contains(keyWord)) continue;
                teamList.add(team);
            }
            listSize = teamList.size();
            teamList = teamList.subList(start, start + limit > listSize ? listSize : start + limit);
            for (TeamModel team : teamList) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"team");
                jSONObject.put("id", (Object)team.getId());
                jSONObject.put("text", (Object)team.getName());
                array.add((Object)jSONObject);
            }
        }
        int totalPageNum = (listSize + limit - 1) / limit;
        response.put("totalPageNum", totalPageNum);
        response.put("list", array);
        return response.toString();
    }

    private void initTeamData(List<Map<String, Object>> nodes) {
        List privateTeamList;
        List publicTeamList;
        String _me = this.getContext().getUID();
        if (UtilString.isEmpty(_me)) {
            _me = "admin";
        }
        if ((publicTeamList = TeamCache.getListOfPublic((String)_me)).size() > 0) {
            HashMap<String, Object> publicRoot = new HashMap<String, Object>();
            publicRoot.put("id", "public");
            publicRoot.put("name", I18nRes.findValue("_bpm.platform", "\u516c\u5171\u7fa4\u7ec4"));
            publicRoot.put("iconFont", "&#xe621;");
            publicRoot.put("type", "team");
            publicRoot.put("open", false);
            publicRoot.put("nocheck", true);
            nodes.add(publicRoot);
        }
        if ((privateTeamList = TeamCache.getListOfPrivate((String)_me)).size() > 0) {
            HashMap<String, Object> privateRoot = new HashMap<String, Object>();
            privateRoot.put("id", "private");
            privateRoot.put("name", I18nRes.findValue("_bpm.platform", "\u79c1\u6709\u7fa4\u7ec4"));
            privateRoot.put("iconFont", "&#xe621;");
            privateRoot.put("type", "team");
            privateRoot.put("open", false);
            privateRoot.put("nocheck", true);
            nodes.add(privateRoot);
        }
        if (publicTeamList.size() == 0 && privateTeamList.size() == 0) {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("id", 1);
            node.put("name", I18nRes.findValue("_bpm.platform", "\u6ca1\u6709\u76f8\u5339\u914d\u7684\u4fe1\u606f"));
            node.put("type", "team");
            node.put("iconCls", "x-tree-node-not");
            node.put("nocheck", true);
            nodes.add(node);
        }
    }

    private void initRoleData(List<Map<String, Object>> nodes, boolean notFilter, boolean searchFlag, String search) {
        String[] groupNames = RoleCache.getCategoryNames();
        if (search.trim().length() == 0) {
            List<RoleModel> roleList = Cache.iteratorToList(RoleCache.getCache().iteratorSorted(RoleCache.SORT_ROLENAME));
            int i = 0;
            while (i < groupNames.length) {
                String groupName = groupNames[i];
                if (notFilter || SecurityUtil.hasRoleAssignSec((UserContext)this.getContext(), (String)groupName)) {
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    String gid = String.valueOf(i);
                    node.put("id", gid);
                    node.put("name", I18nRes.findValue("_bpm.platform", groupName));
                    node.put("type", "RoleGroup");
                    node.put("iconCls", "roleGroup");
                    node.put("iconFont", "&#xe749;");
                    node.put("nocheck", true);
                    node.put("open", i == 0);
                    nodes.add(node);
                    if (i == 0) {
                        for (RoleModel roleModel : roleList) {
                            if (!roleModel.getCategoryName().equals(groupName)) continue;
                            nodes.add(this.getNodeObjectOfRole(gid, roleModel));
                        }
                    }
                }
                ++i;
            }
        } else {
            int count = 0;
            String[] roleGroupNames = RoleCache.getCategoryNames();
            int i = 0;
            while (i < roleGroupNames.length) {
                if (SearchUtil.matches(roleGroupNames[i], search) && (notFilter || SecurityUtil.hasRoleAssignSec((UserContext)this.getContext(), (String)roleGroupNames[i]))) {
                    String groupName = groupNames[i];
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    String id = String.valueOf(i);
                    node.put("id", id);
                    node.put("name", I18nRes.findValue("_bpm.platform", groupName));
                    node.put("type", "RoleGroup");
                    node.put("iconCls", "roleGroup");
                    node.put("iconFont", "&#xe749;");
                    node.put("open", true);
                    nodes.add(node);
                    for (RoleModel roleModel : RoleCache.getCache()) {
                        if (!roleModel.getCategoryName().equals(groupName)) continue;
                        nodes.add(this.getNodeObjectOfRole(id, roleModel));
                        searchFlag = false;
                        ++count;
                    }
                }
                ++i;
            }
            if (searchFlag) {
                for (RoleModel roleModel : RoleCache.getCache()) {
                    if (!SearchUtil.matches(roleModel.getName(), search)) continue;
                    nodes.add(this.getNodeObjectOfRole("", roleModel));
                    ++count;
                }
            }
            if (count == 0) {
                HashMap<String, Object> node = new HashMap<String, Object>();
                node.put("id", "AWS_NODE_RG_ID");
                node.put("name", I18nRes.findValue("_bpm.platform", this.getContext().getLanguage(), "\u6ca1\u6709\u76f8\u5339\u914d\u7684\u4fe1\u606f"));
                node.put("type", "RoleGroup");
                node.put("iconCls", "x-tree-node-not");
                node.put("nocheck", true);
                nodes.add(node);
            }
        }
    }

    private String getAcType(int accessMode, String resourceType) {
        ACAccessMode[] ams;
        ACPluginProfile profile = ACProfileManager.getProfile(resourceType);
        StringBuilder typeHtml = new StringBuilder();
        if (profile != null && (ams = profile.getAccessModes()) != null) {
            int s = 0;
            int i = 0;
            while (i < ams.length) {
                if (ams[i].getType() == accessMode) {
                    s = i;
                }
                ++i;
            }
            i = 0;
            while (i < ams.length) {
                ACAccessMode am = ams[i];
                int nAcType = am.getType();
                String nAcTypeName = am.getName();
                nAcTypeName = I18nRes.findValue("_bpm.platform", nAcTypeName);
                typeHtml.append("<li><input type='checkbox' name='acTypeNameOpt' id='accessModes" + nAcType + "' class='awsui-checkbox' value='" + nAcType + "' >");
                typeHtml.append("<label class='awsui-checkbox-label' for=\"accessModes" + nAcType + "\">" + nAcTypeName + "</label></li>");
                ++i;
            }
        }
        return typeHtml.toString();
    }

    public String removeACResource(String resourceId, String resourceType, int accessMode, boolean isRead, String companyId, String remindContent, int orgType, String id, String invoke) {
        AccessControlAPI.getInstance().removeACResource(id);
        return this.getWeb(resourceId, resourceType, accessMode, false, companyId, "", orgType, "", invoke);
    }

    private Map<String, Object> getNodeObjectOfRole(String pid, RoleModel model) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("id", model.getId());
        node.put("pid", pid);
        node.put("name", I18nRes.findValue("_bpm.platform", model.getName()));
        node.put("type", "role");
        node.put("iconCls", "role");
        node.put("iconFont", "&#59048;");
        return node;
    }

    public String appendACResource(String resourceId, String resourceType, String acOrgTypeList, int accessMode, String companyId, int showType, String invoke) {
        String acOrgList = acOrgTypeList.trim();
        UtilString myStr = new UtilString(acOrgList);
        List<String> myArray = myStr.split(" ");
        String fileName = "";
        String assignmentType = "";
        String assignmentId = "";
        String remindContent = "";
        ArrayList<AccessControlModel> acModelList = new ArrayList<AccessControlModel>();
        if (myArray != null && !myArray.get(0).toString().equals("")) {
            boolean overlap = false;
            int i = 0;
            while (i < myArray.size()) {
                fileName = myArray.get(i).toString();
                if (fileName.trim().length() != 0) {
                    assignmentId = fileName.substring(0, fileName.indexOf("|"));
                    assignmentType = fileName.substring(fileName.indexOf("|") + 1, fileName.length());
                    if (AccessControlCache.getACModel(resourceType, resourceId, assignmentType, assignmentId, accessMode) == null) {
                        AccessControlAPI.getInstance().appendACResource(resourceId, resourceType, accessMode, assignmentId, assignmentType);
                        AccessControlModel model = new AccessControlModel();
                        model._resourceId = resourceId;
                        model._resourceType = resourceType;
                        model._accessModel = accessMode;
                        model._assignmentId = assignmentId;
                        model._assignmentType = assignmentType;
                        acModelList.add(model);
                        remindContent = "<img src='../apps/_bpm.platform/img/model/nondynamic.gif' border='0' > <I18N#\u6388\u6743\u6210\u529f\uff01>";
                    } else {
                        overlap = true;
                    }
                }
                ++i;
            }
        }
        ACPluginProfile acProfile = ACProfileManager.getProfile(resourceType);
        acProfile.appendCallBack(acProfile.getAppContext().getId(), acModelList);
        return this.getWeb(resourceId, resourceType, accessMode, false, companyId, remindContent, showType, "", invoke);
    }

    public String getAssignOrgRole(String companyId) {
        boolean notFilter = true;
        ArrayList nodes = new ArrayList();
        ArrayList<Map<String, Object>> nodesRole = new ArrayList<Map<String, Object>>();
        String search = "";
        boolean searchFlag = true;
        String resourceType = "x";
        new ACAddressTreeWeb(this.getContext(), 3).initACAddressTreeData(null, nodes, search, notFilter, companyId, resourceType, searchFlag, resourceType);
        this.initRoleData(nodesRole, notFilter, searchFlag, search);
        StringBuilder hiddenValue = new StringBuilder();
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("treeList", JSONArray.parseArray((String)JSONObject.toJSONString(nodes)).toString());
        macroLibraries.put("roleTreeDatas", JSONArray.parseArray((String)JSONObject.toJSONString(nodesRole)).toString());
        macroLibraries.put("companyList", this.selectCompanyUnit(companyId, false));
        macroLibraries.put("hiddenValue", hiddenValue.toString());
        macroLibraries.put("search", search);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.orgroles.htm", macroLibraries);
    }

    private String selectCompanyUnit(String companyId, boolean isolationCompany) {
        CompanyModel companyModel = this.getContext().getCompanyModel();
        if (!UtilString.isEmpty(companyId)) {
            companyModel = CompanyCache.getModel((String)companyId);
        }
        StringBuilder selectUnit = new StringBuilder("");
        selectUnit.append("<select name='select_company'  style='width:300px;' class ='awsui-select' onchange=\"selectCompany(frmMain,'CONSOLE_COMMON_ACCESSCONTROL_COMPANY_OPEN');return false;\">");
        List h = CompanyCache.getList();
        if (h != null) {
            if (companyModel == null) {
                selectUnit.append("<option value=0><I18N#\u8bf7\u9009\u62e9></option>");
            } else {
                selectUnit.append("<option value=" + companyModel.getId() + ">" + I18nRes.findValue("_bpm.platform", this.getContext().getLanguage(), companyModel.getName()) + "</option>");
            }
            if (!isolationCompany) {
                int i = 0;
                while (i < h.size()) {
                    CompanyModel model = (CompanyModel)h.get(i);
                    if (SecurityUtil.hasNotRestrictAC((UserContext)this.getContext(), (String)CompanyACCM.resourceType, (String)model.getId(), (int)CompanyACCM.MANAGER.getType()) && companyModel.getId() != model.getId()) {
                        selectUnit.append("<option value=" + model.getId() + " >" + I18nRes.findValue("_bpm.platform", this.getContext().getLanguage(), model.getName()) + "</option>");
                    }
                    ++i;
                }
            }
            selectUnit.append("</select>");
        }
        return selectUnit.toString();
    }

    public String saveOrgRole(String id, String permStr) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String[] pss = permStr.split(";");
        String[] orgs = pss[0].split(",");
        String[] roles = pss[1].split(",");
        List<PermissionAssnModel> list = PermissionAssnCache.getOrgrolePermissionAssnList(id);
        HashSet<String> s = new HashSet<String>();
        for (PermissionAssnModel m : list) {
            s.add(m.getAssignmentId());
        }
        ArrayList<String> err = new ArrayList<String>();
        String[] stringArray = orgs;
        int n = orgs.length;
        int n2 = 0;
        while (n2 < n) {
            String org = stringArray[n2];
            String[] stringArray2 = roles;
            int n3 = roles.length;
            int n4 = 0;
            while (n4 < n3) {
                String role = stringArray2[n4];
                String assignmentId = String.valueOf(org) + "|" + role;
                if (s.contains(assignmentId)) {
                    String[] sss = org.split("\\|");
                    String orgId = sss[0];
                    String orgType = sss[1];
                    String t = "";
                    if (orgType.equals("c")) {
                        CompanyModel c = CompanyCache.getModel((String)orgId);
                        t = c.getName();
                    } else if (orgType.equals("d")) {
                        DepartmentModel d = DepartmentCache.getModel((String)orgId);
                        t = d.getPathNameOfCache();
                    }
                    RoleModel r = RoleCache.getModel((String)role);
                    t = String.valueOf(t) + "," + r.getCategoryName() + '/' + r.getName();
                    err.add(t);
                } else {
                    PermissionAssnModel model = new PermissionAssnModel();
                    model.setAssignmentId(assignmentId);
                    model.setPermissionId(id);
                    model.setAssignmentType("orgrole");
                    PermissionDaoFactory.createPermissionAssn().insert(model);
                }
                ++n4;
            }
            ++n2;
        }
        if (UtilString.isEmpty(err)) {
            ro.msg("\u5206\u914d\u6210\u529f");
        } else {
            ro.warn(UtilString.isEmpty(err) ? "" : "\u91cd\u590d\u5206\u914d\uff1a" + err.size() + "\n" + UtilString.join(err, "\uff0c"));
        }
        return ro.toString();
    }

    class ACComparator
    implements Comparator<AccessControlModel> {
        ACComparator() {
        }

        @Override
        public int compare(AccessControlModel ac1, AccessControlModel ac2) {
            if (ac1 == null || ac2 == null) {
                return 0;
            }
            JSONObject json = new JSONObject();
            json.put("company", (Object)1);
            json.put("department", (Object)2);
            json.put("user", (Object)3);
            json.put("role", (Object)4);
            json.put("team", (Object)5);
            String t1 = ac1._assignmentType;
            String t2 = ac2._assignmentType;
            String name1 = "";
            String name2 = "";
            try {
                if (!t1.equals(t2)) {
                    return json.getInteger(t1) - json.getInteger(t2);
                }
                if (t1.equals("company")) {
                    name1 = CompanyCache.getModel((String)ac1._assignmentId).getName();
                    name2 = CompanyCache.getModel((String)ac2._assignmentId).getName();
                } else if (t1.equals("department")) {
                    name1 = DepartmentCache.getModel((String)ac1._assignmentId).getName();
                    name2 = DepartmentCache.getModel((String)ac2._assignmentId).getName();
                } else if (t1.equals("role")) {
                    name1 = RoleCache.getModel((String)ac1._assignmentId).getName();
                    name2 = RoleCache.getModel((String)ac2._assignmentId).getName();
                } else if (t1.equals("team")) {
                    name1 = TeamCache.getModel((String)ac1._assignmentId).getName();
                    name2 = TeamCache.getModel((String)ac2._assignmentId).getName();
                } else if (t1.equals("user")) {
                    name1 = UserCache.getModel((String)ac1._assignmentId).getUserName();
                    name2 = UserCache.getModel((String)ac2._assignmentId).getUserName();
                }
                String s1 = UtilSpell.getSpell(name1);
                String s2 = UtilSpell.getSpell(name2);
                int length = s1.length() < s2.length() ? s1.length() : s2.length();
                int i = 0;
                while (i < length) {
                    char c2;
                    char c1 = s1.charAt(i);
                    if (c1 != (c2 = s2.charAt(i))) {
                        return c1 - c2;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                return 0;
            }
            return 0;
        }
    }
}

