/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic;

import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.TaskInstance;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.commons.security.ac.model.NavFunctionACCM;
import com.actionsoft.bpms.commons.security.ac.model.ProcessStartACCM;
import com.actionsoft.bpms.commons.security.basic.Query1Model;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.basic.util.PermUtil;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.TeamMemberModel;
import com.actionsoft.bpms.org.model.UserMapModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.sdk.local.SDK;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PermAPIManager {
    private static PermAPIManager _permAPIManager;

    private PermAPIManager() {
    }

    public static PermAPIManager getInstance() {
        if (_permAPIManager == null) {
            _permAPIManager = new PermAPIManager();
        }
        return _permAPIManager;
    }

    public final String createPermission(String name, String desc, String categoryName) {
        PermissionModel model = new PermissionModel();
        model.setPermissionName(name);
        model.setPermissionDesc(desc);
        model.setCategoryName(categoryName);
        PermissionDaoFactory.createPermission().insert(model);
        return model.getId();
    }

    public final String createPermissionList(String permissionId, String resourceType, String resourceId) {
        PermissionListModel model = new PermissionListModel();
        model.setPermissionId(permissionId);
        model.setResourceId(resourceId);
        model.setResourceType(resourceType);
        model.setAccessMode("0");
        PermissionDaoFactory.createPermissionList().insert(model);
        return model.getId();
    }

    public final String createPermissionAssn(String assignmentType, String assignmentId, String permissionId) {
        PermissionAssnModel model = new PermissionAssnModel();
        model.setAssignmentType(assignmentType);
        model.setAssignmentId(assignmentId);
        model.setPermissionId(permissionId);
        PermissionDaoFactory.createPermissionAssn().insert(model);
        return model.getId();
    }

    public final void removePermission(String permissionId) {
        PermissionDaoFactory.createPermission().delete(permissionId);
    }

    public final void removePermissionList(String permissionListId) {
        PermissionDaoFactory.createPermissionList().delete(permissionListId);
    }

    public final void removePermissionListByPerm(String permissionId) {
        PermissionDaoFactory.createPermissionList().removeByPermissionId(permissionId);
    }

    public final void removePermissionAssnByPerm(String permissionId) {
        PermissionDaoFactory.createPermissionAssn().removeByPermissionId(permissionId);
    }

    public final void removePermissionAssnByRole(String roleId) {
        PermissionDaoFactory.createPermissionAssn().removeByRoleId(roleId);
    }

    public final void removePermissionAssnByUser(String userId) {
        PermissionDaoFactory.createPermissionAssn().removeByUserId(userId);
    }

    public final boolean havingModelPermission(String uid, String resourceId) {
        return this.havingModelPermission(uid, resourceId, new Query1Model());
    }

    public final boolean havingModelPermission(String uid, String resourceId, Query1Model list) {
        UserModel currentUserModel = UserCache.getModel((String)uid);
        if (currentUserModel == null) {
            return false;
        }
        if (HighSecurity.isON() && HighSecurity.is3pMenu(resourceId)) {
            return HighSecurity.checkBPMMenuAccess(uid, resourceId);
        }
        return this.havingPermission(uid, resourceId, list);
    }

    private final boolean havingPermission(String uid, String resourceId, Query1Model q1Model) {
        UserModel currentUserModel = UserCache.getModel((String)uid);
        if (currentUserModel == null) {
            return false;
        }
        List<PermissionAssnModel> userPermissionAssnList = q1Model.getUserPermissionAssnListByUID(uid);
        int i = 0;
        int size = userPermissionAssnList.size();
        while (i < size) {
            PermissionAssnModel permissionAssnModel = userPermissionAssnList.get(i);
            if (this.isPermissionHasResource(permissionAssnModel.getPermissionId(), resourceId)) {
                return true;
            }
            ++i;
        }
        List<PermissionAssnModel> deptPermissionAssnList = q1Model.getDeptPermissionAssnListByDeptId(currentUserModel.getDepartmentId());
        int i2 = 0;
        int size2 = deptPermissionAssnList.size();
        while (i2 < size2) {
            PermissionAssnModel permissionAssnModel = deptPermissionAssnList.get(i2);
            if (this.isPermissionHasResource(permissionAssnModel.getPermissionId(), resourceId)) {
                return true;
            }
            ++i2;
        }
        List<PermissionAssnModel> rolePermissionAssnList = q1Model.getRolePermissionAssnListByRoleId(currentUserModel.getRoleId());
        int i3 = 0;
        int size3 = rolePermissionAssnList.size();
        while (i3 < size3) {
            PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i3);
            if (this.isPermissionHasResource(permissionAssnModel.getPermissionId(), resourceId)) {
                return true;
            }
            ++i3;
        }
        List mapRoles = UserMapCache.getMapListOfUser((String)uid);
        int p = 0;
        int size4 = mapRoles.size();
        while (p < size4) {
            PermissionAssnModel permissionAssnModel;
            UserMapModel mapModel = (UserMapModel)mapRoles.get(p);
            rolePermissionAssnList = q1Model.getRolePermissionAssnListByRoleId(mapModel.getRoleId());
            int i4 = 0;
            while (i4 < rolePermissionAssnList.size()) {
                permissionAssnModel = rolePermissionAssnList.get(i4);
                if (this.isPermissionHasResource(permissionAssnModel.getPermissionId(), resourceId)) {
                    return true;
                }
                ++i4;
            }
            deptPermissionAssnList = q1Model.getDeptPermissionAssnListByDeptId(mapModel.getDepartmentId());
            i4 = 0;
            while (i4 < deptPermissionAssnList.size()) {
                permissionAssnModel = deptPermissionAssnList.get(i4);
                if (this.isPermissionHasResource(permissionAssnModel.getPermissionId(), resourceId)) {
                    return true;
                }
                ++i4;
            }
            ++p;
        }
        List<PermissionAssnModel> orgrolePermissionAssnList = q1Model.getOrgrolePermissionAssnList(currentUserModel);
        for (PermissionAssnModel permissionAssnModel : orgrolePermissionAssnList) {
            if (!this.isPermissionHasResource(permissionAssnModel.getPermissionId(), resourceId)) continue;
            return true;
        }
        boolean isAc = AccessControlAPI.getInstance().havingPermission(uid, q1Model.getACList(NavFunctionACCM.resourceType, resourceId).iterator(), NavFunctionACCM.VISIT.getType());
        return isAc;
    }

    public final boolean isAccessMobileAppPermission(String permissionId, String resourceId) {
        List<PermissionListModel> permissionList = PermissionListCache.getMobileAppUnit(permissionId);
        int ii = 0;
        int size = permissionList.size();
        while (ii < size) {
            PermissionListModel permissionListModel = permissionList.get(ii);
            if (permissionListModel.getResourceId().equals(resourceId)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public final boolean isAccessMobilePolicyPermission(String permissionId, String resourceId) {
        List<PermissionListModel> permissionList = PermissionListCache.getMobilePolicyUnit(permissionId);
        int ii = 0;
        int size = permissionList.size();
        while (ii < size) {
            PermissionListModel permissionListModel = permissionList.get(ii);
            if (permissionListModel.getResourceId().equals(resourceId)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    private final boolean isPermissionHasResource(String permissionId, String resourceId) {
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceId().equals(resourceId)) continue;
            return true;
        }
        return false;
    }

    public final boolean isAccessMenuPermission(String permissionId, String resourceId) {
        List<PermissionListModel> permissionList = PermissionListCache.getAWFModelUnit(permissionId);
        int ii = 0;
        while (ii < permissionList.size()) {
            PermissionListModel permissionListModel = permissionList.get(ii);
            if (permissionListModel.getResourceId().equals(resourceId)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public final boolean havingDocumentLayerPermission(String uid, String resourceId) {
        List<PermissionAssnModel> userPermissionAssnList = PermissionAssnCache.getUserPermissionAssnListByUID(uid);
        int i = 0;
        int size = userPermissionAssnList.size();
        while (i < size) {
            PermissionAssnModel userPermissionAssnModel = userPermissionAssnList.get(i);
            if (this.isAccessDocumentLayerPermission(userPermissionAssnModel.getPermissionId(), resourceId)) {
                return true;
            }
            ++i;
        }
        UserModel currentUserModel = UserCache.getModel((String)uid);
        List<PermissionAssnModel> rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(currentUserModel.getRoleId());
        int i2 = 0;
        int size2 = rolePermissionAssnList.size();
        while (i2 < size2) {
            PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i2);
            if (this.isAccessDocumentLayerPermission(permissionAssnModel.getPermissionId(), resourceId)) {
                return true;
            }
            ++i2;
        }
        List mapRoles = UserMapCache.getMapListOfUser((String)uid);
        int p = 0;
        while (p < mapRoles.size()) {
            UserMapModel mapModel = (UserMapModel)mapRoles.get(p);
            rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(mapModel.getRoleId());
            int i3 = 0;
            while (i3 < rolePermissionAssnList.size()) {
                PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i3);
                if (this.isAccessDocumentLayerPermission(permissionAssnModel.getPermissionId(), resourceId)) {
                    return true;
                }
                ++i3;
            }
            ++p;
        }
        return false;
    }

    public final boolean isAccessDocumentLayerPermission(String permissionId, String resourceId) {
        List<PermissionListModel> permissionList = PermissionListCache.getAWFDocumentLayerUnit(permissionId);
        int ii = 0;
        int size = permissionList.size();
        while (ii < size) {
            PermissionListModel permissionListModel = permissionList.get(ii);
            if (permissionListModel.getResourceId().equals(resourceId)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public final boolean havingFunctionRolePermission(String uid, String resourceId) {
        List<PermissionAssnModel> userPermissionAssnList = PermissionAssnCache.getUserPermissionAssnListByUID(uid);
        int i = 0;
        int size = userPermissionAssnList.size();
        while (i < size) {
            PermissionAssnModel userSecurityModel = userPermissionAssnList.get(i);
            if (this.isAccessFunctionRolePermission(userSecurityModel.getPermissionId(), resourceId)) {
                return true;
            }
            ++i;
        }
        UserModel currentUserModel = UserCache.getModel((String)uid);
        List<PermissionAssnModel> rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(currentUserModel.getRoleId());
        int i2 = 0;
        int size2 = rolePermissionAssnList.size();
        while (i2 < size2) {
            PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i2);
            if (this.isAccessFunctionRolePermission(permissionAssnModel.getPermissionId(), resourceId)) {
                return true;
            }
            ++i2;
        }
        List mapRoles = UserMapCache.getMapListOfUser((String)uid);
        int p = 0;
        int size3 = mapRoles.size();
        while (p < size3) {
            UserMapModel mapModel = (UserMapModel)mapRoles.get(p);
            rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(mapModel.getRoleId());
            int i3 = 0;
            while (i3 < rolePermissionAssnList.size()) {
                PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i3);
                if (this.isAccessFunctionRolePermission(permissionAssnModel.getPermissionId(), resourceId)) {
                    return true;
                }
                ++i3;
            }
            ++p;
        }
        return false;
    }

    private final boolean isAccessFunctionRolePermission(String permissionId, String resourceId) {
        List<PermissionListModel> permissionList = PermissionListCache.getAWFRoleUnit(permissionId);
        int ii = 0;
        while (ii < permissionList.size()) {
            PermissionListModel permissionListModel = permissionList.get(ii);
            if (permissionListModel != null && permissionListModel.getResourceId() != null && permissionListModel.getResourceId().equals(resourceId)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public final boolean havingUserInPermission(String uid, String permissionId) {
        UserModel um = UserCache.getModel((String)uid);
        if (um == null) {
            um = UserCache.getModelOfUniqueId((String)uid);
            if (um == null) {
                throw new AWSIllegalArgumentException("uid:" + uid + "\u4e0d\u662f\u5408\u6cd5\u7684\u7cfb\u7edf\u8d26\u6237");
            }
            uid = um.getUID();
        }
        DepartmentModel d = null;
        List<PermissionAssnModel> assns = PermissionAssnCache.getListByPermission(Collections.singletonList(permissionId));
        HashSet<String> roleMaps = null;
        for (PermissionAssnModel assn : assns) {
            if ("role".equals(assn.getAssignmentType())) {
                if (um.getRoleId().equals(assn.getAssignmentId())) {
                    return true;
                }
                if (roleMaps == null) {
                    roleMaps = new HashSet<String>();
                    roleMaps.add(um.getRoleId());
                    List mapRoles = UserMapCache.getMapListOfUser((String)um.getUID());
                    for (UserMapModel map : mapRoles) {
                        roleMaps.add(map.getRoleId());
                    }
                }
                if (!roleMaps.contains(assn.getAssignmentId())) continue;
                return true;
            }
            if ("user".equals(assn.getAssignmentType())) {
                if (!uid.equals(assn.getAssignmentId())) continue;
                return true;
            }
            if ("dept".equals(assn.getAssignmentType())) {
                UserModel model = UserCache.getModel((String)uid);
                d = DepartmentCache.getModel((String)model.getDepartmentId());
                if (d == null) continue;
                if (assn.getAssignmentId().equals(d.getId())) {
                    return true;
                }
                List mapRoles = UserMapCache.getMapListOfUser((String)um.getUID());
                for (UserMapModel map : mapRoles) {
                    if (!assn.getAssignmentId().equals(map.getDepartmentId())) continue;
                    return true;
                }
                continue;
            }
            if (!"orgrole".equals(assn.getAssignmentType())) continue;
            if (d == null) {
                d = DepartmentCache.getModel((String)um.getDepartmentId());
            }
            if (!PermUtil.userIsOrgrole(um, assn.getAssignmentId(), d)) continue;
            return true;
        }
        return false;
    }

    public final boolean havingRoleInPermissionAssnList(String roleId, String permissionId) {
        List<PermissionAssnModel> rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(roleId);
        int i = 0;
        int size = rolePermissionAssnList.size();
        while (i < size) {
            PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i);
            if (permissionAssnModel.getPermissionId().equals(permissionId) && permissionAssnModel.getAssignmentId().equals(roleId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean havingPorcessInPermissionList(String processDefId, String permissionId) {
        List<PermissionListModel> processPermissionList = PermissionListCache.getProcessPermissionList(permissionId);
        int i = 0;
        while (i < processPermissionList.size()) {
            PermissionListModel permissionListModel = processPermissionList.get(i);
            if (permissionListModel.getPermissionId().equals(permissionId) && permissionListModel.getResourceId().equals(processDefId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean checkProcessStartOfUser(String userId, String processDefVersionId) {
        List<PermissionListModel> processPermissionAssnList = PermissionListCache.getProcessPermissionAssnListByProcessDefId(processDefVersionId);
        if (processPermissionAssnList != null) {
            for (PermissionListModel permissionListModel : processPermissionAssnList) {
                if (!this.havingUserInPermission(userId, permissionListModel.getPermissionId())) continue;
                return true;
            }
        }
        boolean isAc = AccessControlAPI.getInstance().havingPermission(userId, ProcessStartACCM.resourceType, processDefVersionId, ProcessStartACCM.VISIT.getType());
        return isAc;
    }

    public final boolean checkProcessStartOfRole(String roleId, String processDefId) {
        List<PermissionListModel> processPermissionAssnList = PermissionListCache.getProcessPermissionAssnListByProcessDefId(processDefId);
        if (processPermissionAssnList != null) {
            int i = 0;
            while (i < processPermissionAssnList.size()) {
                PermissionListModel permissionListModel = processPermissionAssnList.get(i);
                if (this.havingRoleInPermissionAssnList(roleId, permissionListModel.getPermissionId())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public List<UserModel> getUserListByNavMenu(String navId) {
        ArrayList<UserModel> vctUserList = new ArrayList<UserModel>();
        Iterator htUserList = UserCache.getCache().iteratorSorted((Comparator)new Comparator<UserModel>(){

            @Override
            public int compare(UserModel o1, UserModel o2) {
                return o1.getOrderIndex() - o2.getOrderIndex();
            }
        });
        while (htUserList.hasNext()) {
            UserModel userModel = (UserModel)htUserList.next();
            if (userModel.isClosed() || !this.havingModelPermission(userModel.getUID(), navId)) continue;
            vctUserList.add(userModel);
        }
        return vctUserList;
    }

    public List<UserModel> getUserListByAC(String resourceId, String resourceType) {
        return this.getUserListByAC(resourceId, resourceType, -1);
    }

    public List<UserModel> getUserListByAC(String resourceId, String resourceType, int acAccessMode) {
        HashSet<UserModel> hpSet = new HashSet<UserModel>();
        List accessControlModels = SDK.getPermAPI().getACListByResource(resourceType, resourceId);
        for (AccessControlModel accessControlModel : accessControlModels) {
            List userModels;
            if (acAccessMode != -1 && acAccessMode != accessControlModel._accessModel) continue;
            if ("department".equals(accessControlModel._assignmentType)) {
                String departmentId = accessControlModel._assignmentId;
                userModels = SDK.getORGAPI().getAllUsersByDepartment(departmentId);
                hpSet.addAll(userModels);
                continue;
            }
            if ("company".equals(accessControlModel._assignmentType)) {
                String companyId = accessControlModel._assignmentId;
                List departmentModels = DepartmentCache.getDepartmentListOfLayer((int)1, (String)companyId);
                for (DepartmentModel departmentModel : departmentModels) {
                    List userModels2 = SDK.getORGAPI().getAllUsersByDepartment(departmentModel.getId());
                    hpSet.addAll(userModels2);
                }
                continue;
            }
            if ("role".equals(accessControlModel._assignmentType)) {
                String roleId = accessControlModel._assignmentId;
                userModels = SDK.getORGAPI().getUsersByRoleWithMap(roleId);
                hpSet.addAll(userModels);
                continue;
            }
            if ("team".equals(accessControlModel._assignmentType)) {
                String teamId = accessControlModel._assignmentId;
                Iterator teamMemberModels = SDK.getORGAPI().getTeamMembers(teamId);
                while (teamMemberModels.hasNext()) {
                    TeamMemberModel teamMemberModel = (TeamMemberModel)teamMemberModels.next();
                    hpSet.add(UserCache.getModel((String)teamMemberModel.getUserId()));
                }
                continue;
            }
            if ("user".equals(accessControlModel._assignmentType)) {
                hpSet.add(UserCache.getModel((String)accessControlModel._assignmentId));
                continue;
            }
            throw new AWSException("\u9519\u8bef\u7684ac\u6743\u9650\u7c7b\u578b\uff1a" + accessControlModel._assignmentType);
        }
        hpSet.remove(null);
        return new ArrayList<UserModel>(hpSet);
    }

    /*
     * Exception decompiling
     */
    public final boolean havingBoModelPermission(UserContext userContext, String boModelId, String permType, ProcessInstance processInst, TaskInstance taskInst, Map<String, List<PermissionListModel>> bufferData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4, 12] lbl62 : CaseStatement: default:\u000a, @NONE, blocks:[4, 12] lbl62 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean havingBoItemModelPermission(UserContext userContext, String boItemId, String permType, ProcessInstance processInst, TaskInstance taskInst, Map<String, List<PermissionListModel>> bufferData) {
        return this.havingBoItemModelPermission(userContext, null, boItemId, permType, processInst, taskInst, bufferData);
    }

    /*
     * Exception decompiling
     */
    public final boolean havingBoItemModelPermission(UserContext userContext, String boModelId, String boItemId, String permType, ProcessInstance processInst, TaskInstance taskInst, Map<String, List<PermissionListModel>> bufferData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4, 12] lbl68 : CaseStatement: default:\u000a, @NONE, blocks:[4, 12] lbl68 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean havingBPAProcessModelPermission(String uid, String resourceId, String resourceType) {
        UserModel currentUserModel = UserCache.getModel((String)uid);
        if (currentUserModel == null) {
            return false;
        }
        List<PermissionAssnModel> userPermissionAssnList = PermissionAssnCache.getUserPermissionAssnListByUID(uid);
        int i = 0;
        int size = userPermissionAssnList.size();
        while (i < size) {
            PermissionAssnModel permissionAssnModel = userPermissionAssnList.get(i);
            if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                return true;
            }
            ++i;
        }
        List<PermissionAssnModel> deptPermissionAssnList = PermissionAssnCache.getDeptPermissionAssnListByDeptId(currentUserModel.getDepartmentId());
        int i2 = 0;
        int size2 = deptPermissionAssnList.size();
        while (i2 < size2) {
            PermissionAssnModel permissionAssnModel = deptPermissionAssnList.get(i2);
            if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                return true;
            }
            ++i2;
        }
        List<PermissionAssnModel> rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(currentUserModel.getRoleId());
        int i3 = 0;
        int size3 = rolePermissionAssnList.size();
        while (i3 < size3) {
            PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i3);
            if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                return true;
            }
            ++i3;
        }
        List mapRoles = UserMapCache.getMapListOfUser((String)uid);
        int p = 0;
        int size4 = mapRoles.size();
        while (p < size4) {
            UserMapModel mapModel = (UserMapModel)mapRoles.get(p);
            rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(mapModel.getRoleId());
            int i4 = 0;
            while (i4 < rolePermissionAssnList.size()) {
                PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i4);
                if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                    return true;
                }
                ++i4;
            }
            ++p;
        }
        return false;
    }

    public final boolean havingBPAOrgModelPermission(String uid, String resourceId, String resourceType) {
        UserModel currentUserModel = UserCache.getModel((String)uid);
        if (currentUserModel == null) {
            return false;
        }
        List<PermissionAssnModel> userPermissionAssnList = PermissionAssnCache.getUserPermissionAssnListByUID(uid);
        int i = 0;
        int size = userPermissionAssnList.size();
        while (i < size) {
            PermissionAssnModel permissionAssnModel = userPermissionAssnList.get(i);
            if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                return true;
            }
            ++i;
        }
        List<PermissionAssnModel> deptPermissionAssnList = PermissionAssnCache.getDeptPermissionAssnListByDeptId(currentUserModel.getDepartmentId());
        int i2 = 0;
        int size2 = deptPermissionAssnList.size();
        while (i2 < size2) {
            PermissionAssnModel permissionAssnModel = deptPermissionAssnList.get(i2);
            if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                return true;
            }
            ++i2;
        }
        List<PermissionAssnModel> rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(currentUserModel.getRoleId());
        int i3 = 0;
        int size3 = rolePermissionAssnList.size();
        while (i3 < size3) {
            PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i3);
            if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                return true;
            }
            ++i3;
        }
        List mapRoles = UserMapCache.getMapListOfUser((String)uid);
        int p = 0;
        int size4 = mapRoles.size();
        while (p < size4) {
            UserMapModel mapModel = (UserMapModel)mapRoles.get(p);
            rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(mapModel.getRoleId());
            int i4 = 0;
            while (i4 < rolePermissionAssnList.size()) {
                PermissionAssnModel permissionAssnModel = rolePermissionAssnList.get(i4);
                if (this.isPermissionHasResourceByType(permissionAssnModel.getPermissionId(), resourceId, resourceType)) {
                    return true;
                }
                ++i4;
            }
            ++p;
        }
        return false;
    }

    private final boolean isPermissionHasResourceByType(String permissionId, String resourceId, String resourceType) {
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceId().equals(resourceId) || !model.getResourceType().equals(resourceType)) continue;
            return true;
        }
        return false;
    }
}

