/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic;

import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.security.basic.util.PermUtil;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Query1Model {
    private List<AccessControlModel> acList = null;
    private Map<String, List<PermissionAssnModel>> assnOfDepts = new HashMap<String, List<PermissionAssnModel>>();
    private Map<String, List<PermissionAssnModel>> assnOfRoles = new HashMap<String, List<PermissionAssnModel>>();
    private List<PermissionAssnModel> orgroleList = null;
    private Map<String, List<PermissionAssnModel>> userList = null;

    public List<AccessControlModel> getACList(String resourceType, String resourceId) {
        if (this.acList == null) {
            Iterator<AccessControlModel> h = AccessControlCache.getACList(resourceType, resourceId);
            List<AccessControlModel> tp = AccessControlCache.iteratorToList(h);
            this.acList = tp == null ? Collections.EMPTY_LIST : tp;
        }
        return this.acList;
    }

    public List<PermissionAssnModel> getDeptPermissionAssnListByDeptId(String deptId) {
        List<PermissionAssnModel> list = this.assnOfDepts.get(deptId);
        if (list == null) {
            list = PermissionAssnCache.getDeptPermissionAssnListByDeptId(deptId);
            this.assnOfDepts.put(deptId, list);
        }
        return list;
    }

    public List<PermissionAssnModel> getRolePermissionAssnListByRoleId(String deptId) {
        List<PermissionAssnModel> list = this.assnOfRoles.get(deptId);
        if (list == null) {
            list = PermissionAssnCache.getRolePermissionAssnListByRoleId(deptId);
            this.assnOfRoles.put(deptId, list);
        }
        return list;
    }

    public List<PermissionAssnModel> getOrgrolePermissionAssnList(UserModel user) {
        if (this.orgroleList == null) {
            this.orgroleList = new ArrayList<PermissionAssnModel>();
            Iterator it = PermissionAssnCache.getCache().iterator();
            while (it.hasNext()) {
                PermissionAssnModel model = (PermissionAssnModel)it.next();
                if (!"orgrole".equals(model.getAssignmentType())) continue;
                this.orgroleList.add(model);
            }
        }
        DepartmentModel ud = DepartmentCache.getModel((String)user.getDepartmentId());
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        for (PermissionAssnModel model : this.orgroleList) {
            if (!PermUtil.userIsOrgrole(user, model.getAssignmentId(), ud)) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public List<PermissionAssnModel> getUserPermissionAssnListByUID(String userId) {
        List<PermissionAssnModel> ll;
        if (this.userList == null) {
            this.userList = new HashMap<String, List<PermissionAssnModel>>();
            Iterator it = PermissionAssnCache.getCache().iterator();
            while (it.hasNext()) {
                PermissionAssnModel model = (PermissionAssnModel)it.next();
                if (!"user".equals(model.getAssignmentType())) continue;
                List<PermissionAssnModel> tp = this.userList.get(model.getAssignmentId());
                if (tp == null) {
                    tp = new ArrayList<PermissionAssnModel>();
                    this.userList.put(model.getAssignmentId(), tp);
                }
                tp.add(model);
            }
        }
        return (ll = this.userList.get(userId)) == null ? Collections.EMPTY_LIST : ll;
    }
}

