/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.security.basic.util.PermUtil;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PermissionAssnCache
extends Cache<String, PermissionAssnModel> {
    public PermissionAssnCache(CachePluginProfile configuration) {
        super(configuration);
    }

    public static void putModel(PermissionAssnModel model) {
        PermissionAssnCache.getCache().put(model.getId(), model);
    }

    public static void removeModel(String id) {
        PermissionAssnCache.getCache().remove(id);
    }

    public static List<PermissionAssnModel> getRolePermissionAssnListByRoleId(String roleId) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getAssignmentId().equals(roleId) || !"role".equals(model.getAssignmentType())) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionAssnModel> getOrgrolePermissionAssnListByRole(String roleId) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!"orgrole".equals(model.getAssignmentType()) || !PermUtil.roleInOrgrole(roleId, model.getAssignmentId())) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionAssnModel> getOrgrolePermissionAssnList(UserModel user) {
        DepartmentModel ud = DepartmentCache.getModel((String)user.getDepartmentId());
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!"orgrole".equals(model.getAssignmentType()) || !PermUtil.userIsOrgrole(user, model.getAssignmentId(), ud)) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static void removeByPermissionId(String permissionId) {
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId)) continue;
            PermissionAssnCache.removeModel(model.getId());
        }
    }

    public static void removeByRoleId(String roleId) {
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getAssignmentId().equals(roleId) || !model.getAssignmentType().equals("role")) continue;
            PermissionAssnCache.removeModel(model.getId());
        }
    }

    public static void removeByUserId(String userId) {
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getAssignmentId().equals(userId) || !model.getAssignmentType().equals("user")) continue;
            PermissionAssnCache.removeModel(model.getId());
        }
    }

    public static List<PermissionAssnModel> getRolePermissionAssnList(String permissionId) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getAssignmentType().equals("role")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static PermissionAssnModel getRolePermissionAssnModel(String roleId, String permissionId) {
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getAssignmentId().equals(roleId) || !model.getAssignmentType().equals("role")) continue;
            return model;
        }
        return null;
    }

    public static PermissionAssnModel getUserPermissionAssnModel(String userId, String permissionId) {
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getAssignmentId().equals(userId) || !model.getAssignmentType().equals("user")) continue;
            return model;
        }
        return null;
    }

    public static PermissionAssnModel getDeptPermissionAssnModel(String deptId, String permissionId) {
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getAssignmentId().equals(deptId) || !model.getAssignmentType().equals("dept")) continue;
            return model;
        }
        return null;
    }

    public static List<PermissionAssnModel> getUserPermissionAssnList(String permissionId) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getAssignmentType().equals("user")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionAssnModel> getDeptPermissionAssnList(String permissionId) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getAssignmentType().equals("dept")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionAssnModel> getOrgrolePermissionAssnList(String permissionId) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getAssignmentType().equals("orgrole")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static boolean existAssn(String permissionId) {
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getPermissionId().equals(permissionId)) continue;
            return true;
        }
        return false;
    }

    public static List<PermissionAssnModel> getListByPermission(Collection<String> permissionIds) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        block0: while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            for (String permissionId : permissionIds) {
                if (!model.getPermissionId().equals(permissionId)) continue;
                list.add(model);
                continue block0;
            }
        }
        return list;
    }

    public static List<PermissionAssnModel> getUserPermissionAssnListByUID(String userId) {
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getAssignmentId().equals(userId) || !model.getAssignmentType().equals("user")) continue;
            list.add(list.size(), model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionAssnModel> getDeptPermissionAssnListByDeptId(String deptId) {
        DepartmentModel dp = DepartmentCache.getModel((String)deptId);
        if (dp == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PermissionAssnModel> list = new ArrayList<PermissionAssnModel>();
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            if (!model.getAssignmentType().equals("dept") || !model.getAssignmentId().equals(deptId) && !(String.valueOf('/') + dp.getPathIdOfCache() + '/').contains(String.valueOf('/') + model.getAssignmentId() + '/')) continue;
            list.add(list.size(), model);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public void load() {
        String pmpt = "Cache\u52a0\u8f7d\u6743\u9650\u7ec4\u5206\u914d\u5b9e\u4f8b";
        List<PermissionAssnModel> h = PermissionDaoFactory.createPermissionAssn().getList();
        if (h != null) {
            for (PermissionAssnModel model : h) {
                PermissionAssnCache.getCache().put(model.getId(), model, false);
            }
        }
        pmpt = String.valueOf(pmpt) + " [" + (h == null ? 0 : h.size()) + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(pmpt);
    }

    public static PermissionAssnCache getCache() {
        return CacheManager.getCache(PermissionAssnCache.class);
    }
}

