/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class PermissionCache
extends Cache<String, PermissionModel> {
    public PermissionCache(CachePluginProfile configuration) {
        super(configuration);
    }

    public static void putModel(PermissionModel model) {
        PermissionCache.getCache().put(model.getId(), model);
    }

    public static void updateModel(PermissionModel model) {
        PermissionCache.putModel(model);
    }

    public static void removeModel(String id) {
        PermissionCache.getCache().remove(id);
    }

    public static String[] getCategorys() {
        HashMap<String, String> tmpList = new HashMap<String, String>();
        Iterator it = PermissionCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionModel model = (PermissionModel)it.next();
            tmpList.put(model.getCategoryName(), model.getCategoryName());
        }
        String[] groupNames = new String[tmpList.keySet().size()];
        int p = 0;
        Iterator e = tmpList.keySet().iterator();
        while (e.hasNext()) {
            String groupName;
            groupNames[p] = groupName = (String)tmpList.get(e.next());
            ++p;
        }
        Arrays.sort(groupNames, Collator.getInstance(Locale.CHINA));
        return groupNames;
    }

    public static List<PermissionModel> getListOfCategorys(String categorys) {
        categorys = " " + categorys.trim() + " ";
        ArrayList<PermissionModel> h = new ArrayList<PermissionModel>();
        Iterator it = PermissionCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionModel model = (PermissionModel)it.next();
            if (categorys.indexOf(" " + model.getCategoryName() + " ") <= -1) continue;
            h.add(model);
        }
        return h;
    }

    public static List<PermissionModel> getListOfCategory(String category) {
        ArrayList<PermissionModel> h = new ArrayList<PermissionModel>();
        Iterator it = PermissionCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionModel model = (PermissionModel)it.next();
            if (!model.getCategoryName().equals(category)) continue;
            h.add(model);
        }
        Collections.sort(h, new Comparator<PermissionModel>(){
            Collator collator = Collator.getInstance(Locale.CHINA);

            @Override
            public int compare(PermissionModel o1, PermissionModel o2) {
                return this.collator.getCollationKey(o1.getPermissionName()).compareTo(this.collator.getCollationKey(o2.getPermissionName()));
            }
        });
        return h;
    }

    public static PermissionModel getModel(String id) {
        return (PermissionModel)PermissionCache.getCache().get(id);
    }

    @Override
    public void load() {
        String pmpt = "Cache\u52a0\u8f7d\u6743\u9650\u7ec4\u5bf9\u8c61\u5b9e\u4f8b";
        List<PermissionModel> _list = PermissionDaoFactory.createPermission().getList();
        if (_list != null) {
            for (PermissionModel model : _list) {
                PermissionCache.getCache().put(model.getId(), model, false);
            }
        }
        pmpt = String.valueOf(pmpt) + " [" + _list.size() + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(pmpt);
    }

    public static PermissionCache getCache() {
        return CacheManager.getCache(PermissionCache.class);
    }
}

