/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.cache.ListValueIndex;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;

public class PermissionListCache
extends Cache<String, PermissionListModel> {
    public PermissionListCache(CachePluginProfile configuration) {
        super(configuration);
        this.registeIndex(PermissionIndex.class, new PermissionIndex());
        this.registeIndex(ResourceIdIndex.class, new ResourceIdIndex());
    }

    public static void putModel(PermissionListModel model) {
        PermissionListCache.getCache().put(model.getId(), model);
    }

    public static void removeModel(String id) {
        PermissionListCache.getCache().remove(id);
    }

    public static List<PermissionListModel> getNavPermissionAssnList(String navId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator it = PermissionListCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionListModel model = (PermissionListModel)it.next();
            if (!model.getResourceId().equals(navId) || !model.getResourceType().equals("FunctionObject")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionListModel> getMobileAppList(String permissionId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("MobileApp")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionListModel> getMobilePolicyList(String permissionId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("MobilePolicy")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionListModel> getMobileAppPermissionAssnList(String appId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator it = PermissionListCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionListModel model = (PermissionListModel)it.next();
            if (!model.getResourceId().equals(appId) || !model.getResourceType().equals("MobileApp")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionListModel> getMobilePolicyPermissionAssnList(String policyId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator it = PermissionListCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionListModel model = (PermissionListModel)it.next();
            if (!model.getResourceId().equals(policyId) || !model.getResourceType().equals("MobilePolicy")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionListModel> getProcessPermissionList(String permissionId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("process")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionListModel> getProcessPermissionFormList(String permissionId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("FormTable") && !model.getResourceType().equals("FormField")) continue;
            list.add(model);
        }
        return list;
    }

    public static List<PermissionListModel> getProcessPermissionAssnListByProcessDefId(String processDefId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator it = PermissionListCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionListModel model = (PermissionListModel)it.next();
            if (!model.getResourceId().equals(processDefId) || !model.getResourceType().equals("process")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<PermissionListModel> getProcessPermissionAssnListByBPAProcessDefId(String processDefId) {
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        Iterator it = PermissionListCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionListModel model = (PermissionListModel)it.next();
            if (!model.getResourceId().equals(processDefId) || !model.getResourceType().equals("bpaprocess")) continue;
            list.add(model);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> getProcessPermissionAssnListByBPAResourceType(String permissionId, String resourceType) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = PermissionListCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionListModel model = (PermissionListModel)it.next();
            if (!model.getResourceType().equals(resourceType) || !model.getPermissionId().equals(permissionId)) continue;
            list.add(model.getResourceId());
        }
        return Collections.unmodifiableList(list);
    }

    public static void removeByPermissionId(String permissionId) {
        List list = IteratorUtils.toList(PermissionListCache.getListOfPermission(permissionId));
        int i = 0;
        while (i < list.size()) {
            PermissionListModel model = (PermissionListModel)list.get(i);
            if (model.getPermissionId().equals(permissionId)) {
                PermissionListCache.removeModel(model.getId());
            }
            ++i;
        }
    }

    public static void removeByResourceId(String resourceId) {
        List list = IteratorUtils.toList(PermissionListCache.getCache().iterator());
        int i = 0;
        while (i < list.size()) {
            PermissionListModel model = (PermissionListModel)list.get(i);
            if (model.getResourceId().equals(resourceId)) {
                PermissionListCache.removeModel(model.getId());
            }
            ++i;
        }
    }

    public static void removeByPermissionIdResourceType(String permissionId, String type) {
        List list = IteratorUtils.toList(PermissionListCache.getCache().iterator());
        int i = 0;
        while (i < list.size()) {
            PermissionListModel model = (PermissionListModel)list.get(i);
            if (model.getPermissionId().equals(permissionId) && type.equals(model.getResourceType())) {
                PermissionListCache.removeModel(model.getId());
            }
            ++i;
        }
    }

    public static List<PermissionListModel> getMobileAppUnit(String permissionId) {
        ArrayList<PermissionListModel> tmp = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("MobileApp")) continue;
            tmp.add(model);
        }
        return tmp;
    }

    public static List<PermissionListModel> getMobilePolicyUnit(String permissionId) {
        ArrayList<PermissionListModel> tmp = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("MobilePolicy")) continue;
            tmp.add(model);
        }
        return tmp;
    }

    public static List<PermissionListModel> getAWFModelUnit(String permissionId) {
        ArrayList<PermissionListModel> tmp = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("FunctionObject")) continue;
            tmp.add(model);
        }
        return tmp;
    }

    public static PermissionListModel getPermissionByPermissionIdAndResourceId(String permissionId, String resourceId) {
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getPermissionId().equals(permissionId) || !model.getResourceId().equals(resourceId)) continue;
            return model;
        }
        return null;
    }

    public static Map<String, String> getPermissionsByResourceId(String resourceId) {
        HashMap<String, String> tmp = new HashMap<String, String>();
        String r = resourceId.split("\\|")[0];
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermissionByBoDefId(r);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("FunctionObject") || !model.getResourceId().equals(resourceId)) continue;
            tmp.put(model.getPermissionId(), "");
        }
        return tmp;
    }

    public static List<PermissionListModel> getPermissionsListByResourceId(String resourceId, Map<String, List<PermissionListModel>> bufferData) {
        ArrayList<PermissionListModel> tmp = new ArrayList<PermissionListModel>();
        String r = resourceId.split("\\|")[0];
        if (bufferData != null && bufferData.get(r) != null) {
            for (PermissionListModel p : bufferData.get(r)) {
                if (!p.getResourceId().equals(resourceId)) continue;
                tmp.add(p);
            }
            return tmp;
        }
        ArrayList<PermissionListModel> bufferDataList = bufferData != null ? new ArrayList<PermissionListModel>() : null;
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermissionByBoDefId(r);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (model.getResourceId().equals(resourceId)) {
                tmp.add(model);
            }
            if (bufferDataList == null) continue;
            bufferDataList.add(model);
        }
        if (bufferData != null) {
            bufferData.put(r, bufferDataList);
        }
        return tmp;
    }

    public static List<PermissionListModel> getPermissionsListLikeByResourceId(String resourceId, Map<String, List<PermissionListModel>> bufferData) {
        ArrayList<PermissionListModel> tmp = new ArrayList<PermissionListModel>();
        String r = resourceId.split("\\|")[0];
        if (bufferData != null && bufferData.get(r) != null) {
            for (PermissionListModel p : bufferData.get(r)) {
                if (!p.getResourceId().equals(resourceId)) continue;
                tmp.add(p);
            }
            return tmp;
        }
        ArrayList<PermissionListModel> bufferDataList = bufferData != null ? new ArrayList<PermissionListModel>() : null;
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermissionByBoDefId(r);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (model.getResourceId().indexOf(resourceId) > -1) {
                tmp.add(model);
            }
            if (bufferDataList == null) continue;
            bufferDataList.add(model);
        }
        if (bufferData != null) {
            bufferData.put(r, bufferDataList);
        }
        return tmp;
    }

    public static List<PermissionListModel> getAWFDocumentLayerUnit(String permissionId) {
        ArrayList<PermissionListModel> tmp = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("DocumentLayerUnit")) continue;
            tmp.add(model);
        }
        return tmp;
    }

    public static List<PermissionListModel> getAWFRoleUnit(String permissionId) {
        ArrayList<PermissionListModel> tmp = new ArrayList<PermissionListModel>();
        Iterator<PermissionListModel> it = PermissionListCache.getListOfPermission(permissionId);
        while (it.hasNext()) {
            PermissionListModel model = it.next();
            if (!model.getResourceType().equals("RoleObject")) continue;
            tmp.add(model);
        }
        return tmp;
    }

    public static Iterator<PermissionListModel> getListOfPermission(String permissionId) {
        return PermissionListCache.getCache().getByIndex(PermissionIndex.class, permissionId);
    }

    @Override
    public void load() {
        String pmpt = "Cache\u52a0\u8f7d\u6743\u9650\u7ec4\u8d44\u6e90\u5217\u8868\u5b9e\u4f8b";
        Map<Integer, PermissionListModel> h = PermissionDaoFactory.createPermissionList().getPermissionList();
        if (h != null) {
            for (PermissionListModel model : h.values()) {
                PermissionListCache.getCache().put(model.getId(), model, false);
            }
        }
        pmpt = String.valueOf(pmpt) + " [" + (h == null ? 0 : h.size()) + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(pmpt);
    }

    public static Iterator<PermissionListModel> getListOfPermissionByBoDefId(String boDefId) {
        return PermissionListCache.getCache().getByIndex(ResourceIdIndex.class, boDefId);
    }

    public static PermissionListCache getCache() {
        return CacheManager.getCache(PermissionListCache.class);
    }

    private final class PermissionIndex
    extends ListValueIndex<String, PermissionListModel> {
        private PermissionIndex() {
        }

        @Override
        public String key(PermissionListModel model) {
            return model.getPermissionId();
        }
    }

    private final class ResourceIdIndex
    extends ListValueIndex<String, PermissionListModel> {
        private ResourceIdIndex() {
        }

        @Override
        public String key(PermissionListModel model) {
            return model.getResourceId().split("\\|")[0];
        }
    }
}

