/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class Permission
extends DaoObject<PermissionModel> {
    @Override
    public int insert(PermissionModel obj) {
        Connection con = DBSql.open();
        int r = 0;
        try {
            r = this.insert(con, obj);
        }
        finally {
            DBSql.close(con);
        }
        return r;
    }

    public int insert(Connection connection, PermissionModel obj) {
        PermissionModel model = obj;
        if (UtilString.isEmpty(model.getId())) {
            model.setId(UUIDGener.getUUID());
        }
        if (UtilString.isEmpty(model.getPermissionName())) {
            throw new AWSIllegalArgumentException("PermissionName", "EMPT");
        }
        if (UtilString.isEmpty(model.getCategoryName())) {
            throw new AWSIllegalArgumentException("CategoryName", "EMPT");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", model.getId());
        map.put("PERMISSIONNAME", model.getPermissionName());
        map.put("PERMISSIONDESC", model.getPermissionDesc());
        map.put("ISSYSTEM", model.isSystem() ? 1 : 0);
        map.put("CATEGORYNAME", model.getCategoryName());
        String sql = DBSql.getInsertStatement(this.entityName(), map);
        int r = DBSql.update(connection, sql, map);
        if (r > 0) {
            PermissionCache.putModel(model);
        }
        return r;
    }

    @Override
    public int update(PermissionModel obj) {
        PermissionModel model = obj;
        String sql = null;
        sql = "UPDATE " + this.entityName() + " SET " + "PERMISSIONNAME" + "=:FIELD_PERMISSION_NAME," + "PERMISSIONDESC" + "=:FIELD_PERMISSION_DESC," + "ISSYSTEM" + "=:FIELD_IS_SYSTEM," + "CATEGORYNAME" + "=:FIELD_CATEGORYNAME WHERE " + "ID" + "=:id";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FIELD_PERMISSION_NAME", model.getPermissionName());
        map.put("FIELD_PERMISSION_DESC", model.getPermissionDesc());
        map.put("FIELD_IS_SYSTEM", model.isSystem() ? 1 : 0);
        map.put("FIELD_CATEGORYNAME", model.getCategoryName());
        map.put("id", model.getId());
        int r = DBSql.update(sql.toString(), map);
        PermissionCache.updateModel(this.getModel(model.getId()));
        return r;
    }

    public int modifyCategory(String category, String newCategory) {
        String sql = "update " + this.entityName() + " set " + "CATEGORYNAME" + "=:newCategory where " + "CATEGORYNAME" + "=:category";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("newCategory", newCategory);
        map.put("category", category);
        int r = DBSql.update(sql, map);
        PermissionCache.getCache().reload(true);
        return r;
    }

    @Override
    public int delete(Object oid) {
        String id = (String)oid;
        if ("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31".equals(oid)) {
            throw new AWSDataAccessException("CONSOLE\u6743\u9650\u7ec4-\u7ba1\u7406\u5458\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        int r = super.delete(id);
        PermissionCache.removeModel(id);
        PermissionDaoFactory.createPermissionList().removeByPermissionId(id);
        PermissionDaoFactory.createPermissionAssn().removeByPermissionId(id);
        return r;
    }

    private PermissionModel getModel(String id) {
        return (PermissionModel)this.queryById(id);
    }

    public List<PermissionModel> getList() {
        return this.query().list();
    }

    @Override
    public String entityName() {
        return "SYS_PERMISSION";
    }

    @Override
    public RowMapper<PermissionModel> rowMapper() {
        return new PermissionModelMapper();
    }

    public static class PermissionModelMapper
    implements RowMapper<PermissionModel> {
        public PermissionModel mapRow(ResultSet rset, int rowNum) throws SQLException {
            PermissionModel model = new PermissionModel();
            model.setId(rset.getString("ID"));
            model.setPermissionDesc(rset.getString("PERMISSIONDESC"));
            model.setPermissionName(rset.getString("PERMISSIONNAME"));
            model.setSystem(rset.getBoolean("ISSYSTEM"));
            model.setCategoryName(rset.getString("CATEGORYNAME"));
            if (model.getPermissionDesc() == null) {
                model.setPermissionDesc("");
            }
            if (model.getCategoryName() == null) {
                model.setCategoryName("");
            }
            return model;
        }
    }
}

