/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSIllegalArgumentException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PermissionAssn
extends DaoObject<PermissionAssnModel> {
    @Override
    public int insert(PermissionAssnModel model) {
        if (UtilString.isEmpty(model.getId())) {
            model.setId(UUIDGener.getUUID());
        }
        if (UtilString.isEmpty(model.getAssignmentId())) {
            throw new AWSIllegalArgumentException("AssignmentId", "EMPT");
        }
        if (UtilString.isEmpty(model.getPermissionId())) {
            throw new AWSIllegalArgumentException("PermissionId", "EMPT");
        }
        if (UtilString.isEmpty(model.getAssignmentType())) {
            throw new AWSIllegalArgumentException("AssignmentType", "EMPT");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", model.getId());
        map.put("PERMISSIONID", model.getPermissionId());
        map.put("ASSIGNMENTID", model.getAssignmentId());
        map.put("ASSIGNMENTTYPE", model.getAssignmentType());
        String sql = DBSql.getInsertStatement(this.entityName(), map);
        int r = DBSql.update(sql, map);
        PermissionAssnCache.getCache().reload(true);
        return r;
    }

    @Override
    public int update(PermissionAssnModel obj) {
        throw new UnsupportedOperationException();
    }

    public void removeByPermissionId(String permissionId) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from SYS_PERMISSIONASSN  where PERMISSIONID=:PERMISSIONID");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("PERMISSIONID", permissionId);
        DBSql.update(sql.toString(), param);
        PermissionAssnCache.removeByPermissionId(permissionId);
    }

    public void removePermAssn(String id, String assignmentType, String securityList) {
        boolean delRole = "role".equals(assignmentType);
        UtilString myStr = new UtilString(securityList);
        List<String> myArray = myStr.split(" ");
        HashMap<String, String> perms = new HashMap<String, String>();
        int i = 0;
        while (i < myArray.size()) {
            if (!myArray.get(i).toString().equals("")) {
                perms.put(myArray.get(i).toString(), "");
            }
            ++i;
        }
        Iterator it = PermissionAssnCache.getCache().iterator();
        while (it.hasNext()) {
            boolean isDel;
            PermissionAssnModel model = (PermissionAssnModel)it.next();
            boolean bl = isDel = model.getAssignmentId().equals(id) && perms.containsKey(model.getPermissionId()) && model.getAssignmentType().equals(assignmentType);
            if (!isDel && (!delRole || !model.getAssignmentId().endsWith("|" + id) || !perms.containsKey(model.getPermissionId()) || !model.getAssignmentType().equals("orgrole"))) continue;
            this.delete(model.getId());
            PermissionAssnCache.getCache().remove(model.getId());
        }
    }

    public void removeByRoleId(String roleId) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from SYS_PERMISSIONASSN where ASSIGNMENTTYPE = :role and ASSIGNMENTID=:roleId");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("role", "role");
        param.put("roleId", roleId);
        DBSql.update(sql.toString(), param);
        PermissionAssnCache.removeByRoleId(roleId);
    }

    public void removeByUserId(String userId) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from SYS_PERMISSIONASSN  where ASSIGNMENTTYPE = :user and ASSIGNMENTID=:userId");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user", "user");
        param.put("userId", userId);
        DBSql.update(sql.toString(), param);
        PermissionAssnCache.removeByUserId(userId);
    }

    public List<PermissionAssnModel> getList() {
        return this.query().list();
    }

    @Override
    public String entityName() {
        return "SYS_PERMISSIONASSN";
    }

    @Override
    public RowMapper<PermissionAssnModel> rowMapper() {
        return new PermissionAssnModelMapper();
    }

    public static class PermissionAssnModelMapper
    implements RowMapper<PermissionAssnModel> {
        public PermissionAssnModel mapRow(ResultSet rset, int rowNum) throws SQLException {
            PermissionAssnModel model = new PermissionAssnModel();
            model.setId(rset.getString("ID"));
            model.setPermissionId(rset.getString("PERMISSIONID"));
            model.setAssignmentId(rset.getString("ASSIGNMENTID"));
            model.setAssignmentType(rset.getString("ASSIGNMENTTYPE"));
            return model;
        }
    }
}

