/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.dao;

import com.actionsoft.bpms.commons.database.BatchPreparedStatementSetter;
import com.actionsoft.bpms.commons.database.LocalTxManager;
import com.actionsoft.bpms.commons.database.MapResultSetExtractor;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PermissionList
extends DaoObject<PermissionListModel> {
    public void assentSecurity(String permissionId, String resourceType, List<PermissionListModel> list) {
        try {
            LocalTxManager.getInstance().begin();
            Connection conn = DBSql.open();
            this.removeByResourceType(conn, permissionId, resourceType);
            this.createModels(conn, permissionId, resourceType, list);
            LocalTxManager.getInstance().commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            LocalTxManager.getInstance().rollback();
        }
        PermissionListCache.getCache().reload(true);
    }

    public void batchCreateOrUpdate(List<PermissionListModel> list) {
        if (list != null && list.size() > 0) {
            block12: {
                Connection conn = null;
                try {
                    try {
                        conn = DBSql.open();
                        conn.setAutoCommit(false);
                        ArrayList<PermissionListModel> listAdd = new ArrayList<PermissionListModel>();
                        ArrayList<PermissionListModel> listUpdate = new ArrayList<PermissionListModel>();
                        for (PermissionListModel pm : list) {
                            if (UtilString.isEmpty(pm.getId())) {
                                listAdd.add(pm);
                                continue;
                            }
                            listUpdate.add(pm);
                        }
                        if (listUpdate.size() > 0) {
                            this.updateModels(conn, listUpdate);
                        }
                        if (listAdd.size() > 0) {
                            this.createModels(conn, listAdd);
                        }
                        conn.commit();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        try {
                            conn.rollback();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        DBSql.close(conn);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    DBSql.close(conn);
                    throw throwable;
                }
                DBSql.close(conn);
            }
            PermissionListCache.getCache().reload(true);
        }
    }

    public void removeFromPermissions(String resource, String type, String securityList) {
        UtilString myStr = new UtilString(securityList);
        List<String> myArray = myStr.split(" ");
        HashMap<String, String> perms = new HashMap<String, String>();
        int i = 0;
        while (i < myArray.size()) {
            if (!myArray.get(i).toString().equals("")) {
                perms.put(myArray.get(i).toString(), "");
            }
            ++i;
        }
        Iterator it = PermissionListCache.getCache().iterator();
        while (it.hasNext()) {
            PermissionListModel model = (PermissionListModel)it.next();
            if (!model.getResourceId().equals(resource) || !perms.containsKey(model.getPermissionId()) || !model.getResourceType().equals(type)) continue;
            this.delete(model.getId());
        }
    }

    @Override
    public int delete(Object oid) {
        String id = (String)oid;
        int r = super.delete(id);
        PermissionListCache.removeModel(id);
        return r;
    }

    public void assentMenuSecurity(String navId, String securityList) {
        block9: {
            String naviid = navId.substring(2);
            Map<String, String> perms = PermissionListCache.getPermissionsByResourceId(naviid);
            String[] permissions = securityList.split(",");
            ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
            int i = 0;
            while (i < permissions.length) {
                if (permissions[i].trim().length() != 0 && !perms.containsKey(permissions[i])) {
                    PermissionListModel model = new PermissionListModel();
                    model.setPermissionId(permissions[i]);
                    model.setResourceId(naviid);
                    model.setResourceType("FunctionObject");
                    list.add(model);
                }
                ++i;
            }
            Connection conn = null;
            try {
                try {
                    conn = DBSql.open();
                    conn.setAutoCommit(false);
                    this.removeByResource(conn, naviid);
                    this.createModels(conn, list);
                    conn.commit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    try {
                        conn.rollback();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    DBSql.close(conn);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DBSql.close(conn);
                throw throwable;
            }
            DBSql.close(conn);
        }
        PermissionListCache.getCache().reload(true);
    }

    public void createModels(String permissionId, String resourceType, List<PermissionListModel> list) {
        Connection conn = DBSql.open();
        try {
            this.createModels(conn, permissionId, resourceType, list);
        }
        finally {
            DBSql.close(conn);
        }
        PermissionListCache.getCache().reload(true);
    }

    private void createModels(Connection conn, String permissionId, String resourceType, List<PermissionListModel> list) {
        if (list != null) {
            for (PermissionListModel model : list) {
                model.setPermissionId(permissionId);
                model.setResourceType(resourceType);
            }
            this.createModels(conn, list);
        }
    }

    private void createModels(Connection conn, final List<PermissionListModel> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append("SYS_PERMISSIONLIST");
        sb.append("(");
        sb.append("ID");
        sb.append(',');
        sb.append("PERMISSIONID");
        sb.append(',');
        sb.append("RESOURCETYPE");
        sb.append(',');
        sb.append("RESOURCEID");
        sb.append(',');
        sb.append("ACCESSMODE");
        sb.append(',');
        sb.append("EXT1");
        sb.append(")VALUES(?,?,?,?,?,?)");
        DBSql.batch(conn, sb.toString(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return list.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                PermissionListModel model = (PermissionListModel)list.get(i);
                ps.setString(1, UUIDGener.getUUID());
                ps.setString(2, model.getPermissionId());
                ps.setString(3, model.getResourceType());
                ps.setString(4, model.getResourceId());
                ps.setInt(5, 0);
                ps.setString(6, model.getExt1());
            }
        });
    }

    private void updateModels(Connection conn, final List<PermissionListModel> listUpdate) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append("SYS_PERMISSIONLIST").append(" SET ");
        sb.append("PERMISSIONID").append("=?,");
        sb.append("RESOURCETYPE").append("=?,");
        sb.append("RESOURCEID").append("=?,");
        sb.append("ACCESSMODE").append("=?,");
        sb.append("EXT1").append("=?");
        sb.append(" WHERE ").append("ID").append("=?");
        DBSql.batch(conn, sb.toString(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return listUpdate.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                PermissionListModel model = (PermissionListModel)listUpdate.get(i);
                ps.setString(1, model.getPermissionId());
                ps.setString(2, model.getResourceType());
                ps.setString(3, model.getResourceId());
                ps.setInt(4, !UtilString.isEmpty(model.getAccessMode()) ? Integer.parseInt(model.getAccessMode()) : 0);
                ps.setString(5, model.getExt1());
                ps.setString(6, model.getId());
            }
        });
    }

    public void deleteModelsByPermissionIdAndLikeType(String permissionId, List<String> resourceIdList) {
        if (resourceIdList != null && resourceIdList.size() > 0) {
            block8: {
                Connection conn = null;
                try {
                    try {
                        conn = DBSql.open();
                        conn.setAutoCommit(false);
                        this.deleteModelsByPermissionIdAndLikeType(conn, permissionId, resourceIdList);
                        conn.commit();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        try {
                            conn.rollback();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        DBSql.close(conn);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DBSql.close(conn);
                    throw throwable;
                }
                DBSql.close(conn);
            }
            PermissionListCache.getCache().reload(true);
        }
    }

    private void deleteModelsByPermissionIdAndLikeType(Connection conn, final String permissionId, final List<String> resourceIdList) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append("SYS_PERMISSIONLIST").append(" WHERE ");
        sb.append("PERMISSIONID").append("=? AND ");
        sb.append("RESOURCEID").append(" LIKE ?");
        DBSql.batch(conn, sb.toString(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return resourceIdList.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                String resourceId = (String)resourceIdList.get(i);
                ps.setString(1, permissionId);
                ps.setString(2, String.valueOf(resourceId) + "%");
            }
        });
    }

    public void removeByResourceType(Connection conn, String permissionId, String resourceType) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from SYS_PERMISSIONLIST where PERMISSIONID=:FIELD_PERMISSION_ID and RESOURCETYPE=:APPLICATION_MODEL");
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("FIELD_PERMISSION_ID", permissionId);
        paraMap.put("APPLICATION_MODEL", resourceType);
        DBSql.update(conn, sql.toString(), paraMap);
        PermissionListCache.removeByPermissionIdResourceType(permissionId, resourceType);
    }

    public void removeByResource(Connection conn, String resourceId) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from SYS_PERMISSIONLIST where RESOURCEID=? and RESOURCETYPE=?");
        DBSql.update(conn, sql.toString(), new Object[]{resourceId, "FunctionObject"});
        PermissionListCache.removeByResourceId(resourceId);
    }

    public void removeByResource(String resourceId) {
        Connection conn = DBSql.open();
        try {
            this.removeByResource(conn, resourceId);
        }
        finally {
            DBSql.close(conn);
        }
    }

    public void removeByResourceTypeAndResourceId(Connection conn, String permissionId, String resourceType, String resourceId) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from SYS_PERMISSIONLIST where RESOURCEID=? and RESOURCETYPE=? and PERMISSIONID=?");
        DBSql.update(conn, sql.toString(), new Object[]{resourceId, resourceType, permissionId});
        PermissionListCache.removeByResourceId(resourceId);
    }

    public void removeByResourceTypeAndResourceId(String permissionId, String resourceType, String resourceId) {
        Connection conn = DBSql.open();
        try {
            this.removeByResourceTypeAndResourceId(conn, permissionId, resourceType, resourceId);
        }
        finally {
            DBSql.close(conn);
        }
    }

    public List<PermissionListModel> getListByResourceType(String permissionId, String resourceType, int accessMode) {
        StringBuilder sb1 = new StringBuilder();
        sb1.append("SELECT * FROM ");
        sb1.append("SYS_PERMISSIONLIST");
        sb1.append(" WHERE ");
        sb1.append("PERMISSIONID");
        sb1.append("=? ");
        sb1.append(" AND ");
        sb1.append("RESOURCETYPE");
        sb1.append("=? ");
        sb1.append(" AND ");
        sb1.append("ACCESSMODE");
        sb1.append("=?");
        List<PermissionListModel> list = DBSql.query(sb1.toString(), this.rowMapper(), permissionId, resourceType, 0);
        return list;
    }

    public Map<Integer, PermissionListModel> getPermissionList() {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ");
        sql.append("SYS_PERMISSIONLIST");
        return (Map)DBSql.query(sql.toString(), new MapResultSetExtractor(this.rowMapper()), new Object[0]);
    }

    public void removeByPermissionId(String permissionId) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("PERMISSIONID", permissionId);
        String s = "delete from SYS_PERMISSIONLIST where PERMISSIONID=:PERMISSIONID";
        DBSql.update(s, paramsMap);
        PermissionListCache.removeByPermissionId(permissionId);
    }

    @Override
    public int insert(PermissionListModel model) throws AWSDataAccessException {
        if (UtilString.isEmpty(model.getId())) {
            model.setId(UUIDGener.getUUID());
        }
        if (UtilString.isEmpty(model.getResourceId())) {
            throw new AWSIllegalArgumentException("ResourceId", "EMPT");
        }
        if (UtilString.isEmpty(model.getPermissionId())) {
            throw new AWSIllegalArgumentException("PermissionId", "EMPT");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", model.getId());
        map.put("RESOURCEID", model.getResourceId());
        map.put("RESOURCETYPE", model.getResourceType());
        map.put("PERMISSIONID", model.getPermissionId());
        map.put("ACCESSMODE", !UtilString.isEmpty(model.getAccessMode()) ? Integer.parseInt(model.getAccessMode()) : 0);
        map.put("EXT1", model.getExt1());
        String sql = DBSql.getInsertStatement(this.entityName(), map);
        int r = DBSql.update(sql, map);
        PermissionListCache.putModel(model);
        return r;
    }

    @Override
    public int update(PermissionListModel model) throws AWSDataAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String entityName() {
        return "SYS_PERMISSIONLIST";
    }

    @Override
    public RowMapper<PermissionListModel> rowMapper() {
        return new PermissionListModelMapper();
    }

    public static class PermissionListModelMapper
    implements RowMapper<PermissionListModel> {
        public PermissionListModel mapRow(ResultSet rs, int i) throws SQLException {
            PermissionListModel model = new PermissionListModel();
            model.setId(rs.getString("ID"));
            model.setPermissionId(rs.getString("PERMISSIONID"));
            model.setResourceType(rs.getString("RESOURCETYPE"));
            model.setResourceId(rs.getString("RESOURCEID"));
            model.setAccessMode(rs.getString("ACCESSMODE"));
            model.setExt1(rs.getString("EXT1"));
            return model;
        }
    }
}

