/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.commons.security.ac.model.ProcessStartACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.cache.CompanyCache;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.cache.TeamCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.util.SecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilSerialize;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class CommonSecurityWeb {
    private UserContext _me;

    public CommonSecurityWeb(UserContext me) {
        this._me = me;
    }

    public String getCommonSecurityGroup(String id, String permissionType) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        if (id.startsWith("s_") || id.startsWith("d_") || id.startsWith("f_")) {
            id = id.substring(2);
        }
        macroLibraries.put("id", id);
        macroLibraries.put("resourceType", ProcessStartACCM.resourceType);
        macroLibraries.put("permissionType", permissionType);
        macroLibraries.put("sid", sid);
        macroLibraries.put("sessionId", this._me.getSessionId());
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.common.group.security.htm", macroLibraries);
    }

    public String getCommonSecurityGroupJsonData(String id, String permissionType, String type, String permissionName, String categoryName) {
        String permissionId;
        ResponseObject ro = ResponseObject.newOkResponse();
        class PermissionWrapper {
            private String permissionId;
            private String assignmentType;
            private PermissionModel permissionModel;

            public PermissionWrapper(String permissionId, String assignmentType) {
                this.permissionId = permissionId;
                this.assignmentType = assignmentType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PermissionWrapper that = (PermissionWrapper)o;
                return Objects.equals(this.permissionId, that.permissionId) && Objects.equals(this.assignmentType, that.assignmentType);
            }

            public int hashCode() {
                return Objects.hash(this.permissionId, this.assignmentType);
            }
        }
        HashSet<PermissionWrapper> permissionWrapperSet = new HashSet<PermissionWrapper>();
        HashSet<String> rolePermissionIdSet = new HashSet<String>();
        HashSet<String> orgrolePermissionIdSet = new HashSet<String>();
        if ("user".equals(permissionType)) {
            ArrayList<PermissionAssnModel> userPermissionAssnList = new ArrayList<PermissionAssnModel>();
            userPermissionAssnList.addAll(PermissionAssnCache.getUserPermissionAssnListByUID(id));
            UserModel user = UserCache.getModel((String)id);
            if (user != null) {
                userPermissionAssnList.addAll(PermissionAssnCache.getDeptPermissionAssnListByDeptId(user.getDepartmentId()));
                userPermissionAssnList.addAll(PermissionAssnCache.getRolePermissionAssnListByRoleId(user.getRoleId()));
                userPermissionAssnList.addAll(PermissionAssnCache.getOrgrolePermissionAssnList(user));
                List list = UserMapCache.getMapListOfUser((String)id);
                if (list != null) {
                    for (Iterator<Object> map : list) {
                        userPermissionAssnList.addAll(PermissionAssnCache.getDeptPermissionAssnListByDeptId(map.getDepartmentId()));
                        userPermissionAssnList.addAll(PermissionAssnCache.getRolePermissionAssnListByRoleId(map.getRoleId()));
                    }
                }
            }
            for (PermissionAssnModel permissionAssnModel : userPermissionAssnList) {
                permissionWrapperSet.add(new PermissionWrapper(permissionAssnModel.getPermissionId(), permissionAssnModel.getAssignmentType()));
            }
        } else if ("role".equals(permissionType)) {
            List<PermissionAssnModel> rolePermissionAssnList = PermissionAssnCache.getRolePermissionAssnListByRoleId(id);
            for (PermissionAssnModel r : rolePermissionAssnList) {
                rolePermissionIdSet.add(r.getPermissionId());
                permissionWrapperSet.add(new PermissionWrapper(r.getPermissionId(), null));
            }
            List<PermissionAssnModel> orgrolePermissionAssnList = PermissionAssnCache.getOrgrolePermissionAssnListByRole(id);
            for (PermissionAssnModel permissionAssnModel : orgrolePermissionAssnList) {
                orgrolePermissionIdSet.add(permissionAssnModel.getPermissionId());
                permissionWrapperSet.add(new PermissionWrapper(permissionAssnModel.getPermissionId(), null));
            }
        } else if ("nav".equals(permissionType)) {
            List<PermissionListModel> navPermissionAssnList = PermissionListCache.getNavPermissionAssnList(id);
            for (PermissionListModel navPermissionAssnModel : navPermissionAssnList) {
                permissionId = navPermissionAssnModel.getPermissionId();
                permissionWrapperSet.add(new PermissionWrapper(permissionId, null));
            }
        } else if ("process".equals(permissionType)) {
            List<PermissionListModel> processPermissionAssnList = PermissionListCache.getProcessPermissionAssnListByProcessDefId(id);
            for (PermissionListModel processPermissionAssnModel : processPermissionAssnList) {
                permissionId = processPermissionAssnModel.getPermissionId();
                permissionWrapperSet.add(new PermissionWrapper(permissionId, null));
            }
        } else if ("mobile".equals(permissionType)) {
            List<PermissionListModel> mobileAppPermissionAssnList = PermissionListCache.getMobileAppPermissionAssnList(id);
            for (PermissionListModel navPermissionAssnModel : mobileAppPermissionAssnList) {
                permissionId = navPermissionAssnModel.getPermissionId();
                permissionWrapperSet.add(new PermissionWrapper(permissionId, null));
            }
        } else if ("mobilePolicy".equals(permissionType)) {
            List<PermissionListModel> mobilePolicyPermissionAssnList = PermissionListCache.getMobilePolicyPermissionAssnList(id);
            for (PermissionListModel navPermissionAssnModel : mobilePolicyPermissionAssnList) {
                permissionId = navPermissionAssnModel.getPermissionId();
                permissionWrapperSet.add(new PermissionWrapper(permissionId, null));
            }
        }
        JSONArray ja = new JSONArray();
        int count = 0;
        Collator collator = Collator.getInstance(Locale.CHINA);
        Comparator comparator = (o1, o2) -> collator.compare(o1.getPermissionName(), o2.getPermissionName());
        if ("SECURITY_ADD".equals(type)) {
            Iterator permissionModelIterator = PermissionCache.getCache().iteratorSorted(comparator);
            HashMap<String, Boolean> secMap = new HashMap<String, Boolean>();
            HashSet<String> permissionIdSet = new HashSet<String>();
            for (PermissionWrapper permissionWrapper : permissionWrapperSet) {
                permissionIdSet.add(permissionWrapper.permissionId);
            }
            while (permissionModelIterator.hasNext()) {
                PermissionModel permissionModel = (PermissionModel)permissionModelIterator.next();
                JSONObject jo = new JSONObject();
                if (secMap.get(permissionModel.getCategoryName()) == null) {
                    secMap.put(permissionModel.getCategoryName(), GradeSecurityUtil.isSecurityMaster(this._me.getUID()) || SecurityUtil.hasSecGroupAssignSec((UserContext)this._me, (String)permissionModel.getCategoryName()));
                }
                if (permissionIdSet.contains(permissionModel.getId()) || !((Boolean)secMap.get(permissionModel.getCategoryName())).booleanValue() || !"".equals(categoryName) && !permissionModel.getCategoryName().equals(categoryName) || !"".equals(permissionName) && !permissionModel.getPermissionName().toLowerCase().contains(permissionName.toLowerCase())) continue;
                jo.put("secGroup", (Object)permissionModel.getPermissionName());
                jo.put("secCategory", (Object)permissionModel.getCategoryName());
                jo.put("explanation", (Object)permissionModel.getPermissionDesc());
                jo.put("id", (Object)permissionModel.getId());
                jo.put("dataType", (Object)I18nRes.findValue("_bpm.platform", "\u6743\u9650\u7ec4"));
                ja.add((Object)jo);
                ++count;
            }
        } else {
            PermissionModel model;
            ArrayList<PermissionWrapper> sortList = new ArrayList<PermissionWrapper>();
            for (PermissionWrapper permissionWrapper : permissionWrapperSet) {
                model = PermissionCache.getModel(permissionWrapper.permissionId);
                if (model == null) continue;
                permissionWrapper.permissionModel = model;
                sortList.add(permissionWrapper);
            }
            sortList.sort((o1, o2) -> collator.compare(((PermissionWrapper)o1).permissionModel.getPermissionName(), ((PermissionWrapper)o2).permissionModel.getPermissionName()));
            for (PermissionWrapper permissionWrapper : sortList) {
                model = permissionWrapper.permissionModel;
                boolean role = rolePermissionIdSet.contains(model.getId());
                boolean orgrole = orgrolePermissionIdSet.contains(model.getId());
                String rolesuf = role ? " <span><i class='awsui-iconfont' style='color:#3383da'>&#59048;</i></span>" : "";
                String suf = orgrole ? " <span><i class='awsui-iconfont' style='color:#3383da'>&#58958;</i></span>" + rolesuf : "";
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("secGroup", (Object)I18nRes.findValue("_bpm.platform", "\u6743\u9650\u7ec4"));
                jsonObj.put("secCategory", (Object)(String.valueOf(model.getCategoryName()) + "/" + model.getPermissionName() + suf));
                jsonObj.put("explanation", (Object)model.getPermissionDesc());
                jsonObj.put("id", (Object)model.getId());
                jsonObj.put("dataType", (Object)I18nRes.findValue("_bpm.platform", "\u6743\u9650\u7ec4"));
                if ("user".equals(permissionType)) {
                    jsonObj.put("assignmentType", (Object)permissionWrapper.assignmentType);
                    if (!"user".equals(permissionWrapper.assignmentType)) {
                        jsonObj.put("AWS_Grid_noCheckbox", (Object)true);
                    }
                }
                ja.add((Object)jsonObj);
            }
        }
        if (UtilString.isEmpty(type) && ("process".equals(permissionType) || "nav".equals(permissionType))) {
            String data = this.getOrgACData(id, permissionType);
            JSONArray acOrg = JSONArray.parseArray((String)data);
            ja.addAll((Collection)acOrg);
        }
        if (count > 500 && "".equals(categoryName)) {
            ro.put("data", "");
            ro.msg(I18nRes.findValue("_bpm.platform", "\u6743\u9650\u7ec4\u6570\u636e\u592a\u591a"));
        }
        ro.put("data", ja);
        return ro.toString();
    }

    public String getOrgACData(String id, String permissionType) {
        JSONArray arr = new JSONArray();
        List<Object> acList = new ArrayList();
        if ("process".equals(permissionType)) {
            ProcessDefinition processDefinition = (ProcessDefinition)ProcessDefCache.getInstance().getModel(id);
            String resourceId = processDefinition == null ? id : processDefinition.getVersionId();
            acList = Cache.iteratorToList(AccessControlCache.getACList("platform.processStart", resourceId));
        } else {
            acList = Cache.iteratorToList(AccessControlCache.getACList("platform.navFunction", id));
        }
        for (AccessControlModel accessControlModel : acList) {
            CompanyModel objModel;
            String assignmentType = accessControlModel._assignmentType;
            JSONObject jsonObj = new JSONObject();
            if ("company".equals(assignmentType) && (objModel = CompanyCache.getModel((String)accessControlModel._assignmentId)) != null) {
                jsonObj.put("secGroup", (Object)I18nRes.findValue("_bpm.platform", "\u5355\u4f4d"));
                jsonObj.put("secCategory", (Object)objModel.getName());
                jsonObj.put("explanation", (Object)"");
                jsonObj.put("id", (Object)accessControlModel._id);
            }
            if ("department".equals(assignmentType) && (objModel = DepartmentCache.getModel((String)accessControlModel._assignmentId)) != null) {
                jsonObj.put("secGroup", (Object)I18nRes.findValue("_bpm.platform", "\u90e8\u95e8"));
                jsonObj.put("secCategory", (Object)objModel.getPathNameOfCache());
                jsonObj.put("explanation", (Object)"");
                jsonObj.put("id", (Object)accessControlModel._id);
            }
            if ("role".equals(assignmentType) && (objModel = RoleCache.getModel((String)accessControlModel._assignmentId)) != null) {
                jsonObj.put("secGroup", (Object)I18nRes.findValue("_bpm.platform", "\u89d2\u8272"));
                jsonObj.put("secCategory", (Object)(String.valueOf(objModel.getCategoryName()) + "/" + objModel.getName()));
                jsonObj.put("explanation", (Object)"");
                jsonObj.put("id", (Object)accessControlModel._id);
            }
            if ("team".equals(assignmentType) && (objModel = TeamCache.getModel((String)accessControlModel._assignmentId)) != null) {
                jsonObj.put("secGroup", (Object)I18nRes.findValue("_bpm.platform", "\u7fa4\u7ec4"));
                jsonObj.put("secCategory", (Object)objModel.getName());
                jsonObj.put("explanation", (Object)"");
                jsonObj.put("id", (Object)accessControlModel._id);
            }
            if ("user".equals(assignmentType) && (objModel = UserCache.getModel((String)accessControlModel._assignmentId)) != null) {
                jsonObj.put("secGroup", (Object)I18nRes.findValue("_bpm.platform", "\u4eba\u5458"));
                jsonObj.put("secCategory", (Object)objModel.getUserName());
                jsonObj.put("explanation", (Object)"");
                jsonObj.put("id", (Object)accessControlModel._id);
            }
            if ("orgrole".equals(assignmentType)) {
                String[] s = accessControlModel._assignmentId.split("\\|");
                String t = "";
                if (s[1].equals("company")) {
                    CompanyModel c = CompanyCache.getModel((String)s[0]);
                    t = "<I18N#" + I18nRes.findValue("_bpm.platform", "\u516c\u53f8") + ">\uff1a" + (t == null ? s[0] : c.getName());
                } else if (s[1].equals("department")) {
                    DepartmentModel d = DepartmentCache.getModel((String)s[0]);
                    CompanyModel c = null;
                    if (d != null) {
                        c = CompanyCache.getModel((String)d.getCompanyId());
                    }
                    if (c != null) {
                        t = "<I18N#\u90e8\u95e8>\uff1a" + c.getName() + "//" + d.getPathNameOfCache();
                    }
                }
                RoleModel r = RoleCache.getModel((String)s[2]);
                if (r != null) {
                    t = String.valueOf(t) + "\uff0c<I18N#\u89d2\u8272>\uff1a" + Html.escape(String.valueOf(r.getCategoryName()) + "<" + r.getName() + ">");
                }
                jsonObj.put("secGroup", (Object)I18nRes.findValue("_bpm.platform", "\u7ec4\u7ec7\u89d2\u8272"));
                jsonObj.put("secCategory", (Object)t);
                jsonObj.put("explanation", (Object)"");
                jsonObj.put("id", (Object)accessControlModel._id);
            }
            jsonObj.put("dataType", (Object)I18nRes.findValue("_bpm.platform", "AC\u6388\u6743\u7ec4\u7ec7"));
            arr.add((Object)jsonObj);
        }
        return arr.toString();
    }

    public String getCommonSecurityGroupAdd(String id, String permissionType) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        StringBuilder options = new StringBuilder();
        options.append("<option value=''>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9\u5206\u7c7b") + "</option>");
        String[] list = PermissionCache.getCategorys();
        int i = 0;
        while (i < list.length) {
            String categoryName = list[i];
            if (SecurityUtil.hasSecGroupAssignSec((UserContext)this._me, (String)categoryName)) {
                options.append("<option value='" + categoryName + "'>" + categoryName + "</option>");
            }
            ++i;
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("id", id);
        macroLibraries.put("permissionType", permissionType);
        macroLibraries.put("sid", sid);
        macroLibraries.put("options", options.toString());
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.common.group.security.add.htm", macroLibraries);
    }

    public String saveCommonSecurityGroup(String id, String pid, String securityList, String permissionType) {
        ResponseObject ro;
        block10: {
            List<String> myArray;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block9: {
                                ro = ResponseObject.newOkResponse();
                                securityList = securityList.trim();
                                UtilString myStr = new UtilString(securityList);
                                myArray = myStr.split(" ");
                                if (!"user".equals(permissionType)) break block9;
                                int i = 0;
                                while (i < myArray.size()) {
                                    PermissionAssnModel model = new PermissionAssnModel();
                                    if (!myArray.get(i).toString().equals("")) {
                                        model.setPermissionId(myArray.get(i).toString());
                                        model.setAssignmentId(id);
                                        model.setAssignmentType("user");
                                        PermissionDaoFactory.createPermissionAssn().insert(model);
                                    }
                                    ++i;
                                }
                                break block10;
                            }
                            if (!"role".equals(permissionType)) break block11;
                            int i = 0;
                            while (i < myArray.size()) {
                                PermissionAssnModel model = new PermissionAssnModel();
                                if (!myArray.get(i).toString().equals("")) {
                                    model.setPermissionId(myArray.get(i).toString());
                                    model.setAssignmentId(id);
                                    model.setAssignmentType("role");
                                    PermissionDaoFactory.createPermissionAssn().insert(model);
                                }
                                ++i;
                            }
                            break block10;
                        }
                        if (!"nav".equals(permissionType)) break block12;
                        int i = 0;
                        while (i < myArray.size()) {
                            PermissionListModel model = new PermissionListModel();
                            model.setPermissionId(myArray.get(i).toString());
                            model.setResourceId(id);
                            model.setResourceType("FunctionObject");
                            PermissionDaoFactory.createPermissionList().insert(model);
                            this.setAutoPermissionListIfNot(pid, id, myArray.get(i).toString());
                            ++i;
                        }
                        break block10;
                    }
                    if (!"process".equals(permissionType)) break block13;
                    int i = 0;
                    while (i < myArray.size()) {
                        if (!myArray.get(i).toString().equals("")) {
                            PermissionListModel model = new PermissionListModel();
                            model.setPermissionId(myArray.get(i).toString());
                            model.setResourceId(id);
                            model.setResourceType("process");
                            PermissionDaoFactory.createPermissionList().insert(model);
                        }
                        ++i;
                    }
                    break block10;
                }
                if (!"mobile".equals(permissionType)) break block14;
                int i = 0;
                while (i < myArray.size()) {
                    PermissionListModel model = new PermissionListModel();
                    model.setPermissionId(myArray.get(i).toString());
                    model.setResourceId(id);
                    model.setResourceType("MobileApp");
                    PermissionDaoFactory.createPermissionList().insert(model);
                    ++i;
                }
                break block10;
            }
            if (!"mobilePolicy".equals(permissionType)) break block10;
            int i = 0;
            while (i < myArray.size()) {
                PermissionListModel model = new PermissionListModel();
                model.setPermissionId(myArray.get(i).toString());
                model.setResourceId(id);
                model.setResourceType("MobilePolicy");
                PermissionDaoFactory.createPermissionList().insert(model);
                ++i;
            }
        }
        return ro.toString();
    }

    private void setAutoPermissionListIfNot(String pid, String id, String permissionId) {
        if (!"".equals(pid)) {
            JSONObject jo = UtilSerialize.parseObject(pid);
            String sysId = UtilJson.optString(jo, "sysId");
            String dirId = UtilJson.optString(jo, "dirId");
            List<PermissionListModel> funList = PermissionListCache.getNavPermissionAssnList(id);
            if (!UtilString.isEmpty(funList)) {
                if (!UtilString.isEmpty(dirId)) {
                    List<PermissionListModel> dirList = PermissionListCache.getNavPermissionAssnList(dirId);
                    if (!UtilString.isEmpty(dirList)) {
                        for (PermissionListModel d : dirList) {
                            if (!d.getPermissionId().equals(permissionId)) continue;
                            PermissionDaoFactory.createPermissionList().delete(d.getId());
                        }
                    }
                    this.copyPermissionList(funList, dirId);
                }
                if (!UtilString.isEmpty(sysId)) {
                    List<PermissionListModel> sysList = PermissionListCache.getNavPermissionAssnList(sysId);
                    if (!UtilString.isEmpty(sysList)) {
                        for (PermissionListModel d : sysList) {
                            if (!d.getPermissionId().equals(permissionId)) continue;
                            PermissionDaoFactory.createPermissionList().delete(d.getId());
                        }
                    }
                    this.copyPermissionList(funList, sysId);
                }
            }
        }
    }

    private void copyPermissionList(List<PermissionListModel> funList, String navId) {
        for (PermissionListModel permissionListModel : funList) {
            PermissionListModel cacheModel = PermissionListCache.getPermissionByPermissionIdAndResourceId(permissionListModel.getPermissionId(), navId);
            if (cacheModel != null) continue;
            PermissionListModel model = new PermissionListModel();
            model.setModel(permissionListModel);
            model.setId("");
            model.setResourceId(navId);
            PermissionDaoFactory.createPermissionList().insert(model);
        }
    }

    public String removeCommonSecurityGroup(String id, String securityList, String permissionType) {
        ResponseObject ro = ResponseObject.newOkResponse();
        securityList = securityList.trim();
        try {
            if ("user".equals(permissionType)) {
                PermissionDaoFactory.createPermissionAssn().removePermAssn(id, "user", securityList);
            } else if ("role".equals(permissionType)) {
                PermissionDaoFactory.createPermissionAssn().removePermAssn(id, "role", securityList);
            } else if ("nav".equals(permissionType)) {
                PermissionDaoFactory.createPermissionList().removeFromPermissions(id, "FunctionObject", securityList);
            } else if ("process".equals(permissionType)) {
                PermissionDaoFactory.createPermissionList().removeFromPermissions(id, "process", securityList);
            } else if ("mobile".equals(permissionType)) {
                PermissionDaoFactory.createPermissionList().removeFromPermissions(id, "MobileApp", securityList);
            } else if ("mobilePolicy".equals(permissionType)) {
                PermissionDaoFactory.createPermissionList().removeFromPermissions(id, "MobilePolicy", securityList);
            }
        }
        catch (Exception e) {
            ro.err(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u5931\u8d25\u8be6\u60c5\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7"));
            e.printStackTrace(System.err);
            return ro.toString();
        }
        return ro.toString();
    }

    public String removeNavSecurityGroup(String id, String permissionType) {
        ResponseObject ro = ResponseObject.newOkResponse();
        return ro.toString();
    }

    public String updateNavSecurityGroup(String navId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        return ro.toString();
    }
}

