/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.NavACCM;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.PermAPIManager;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.basic.util.PermUtil;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSForbiddenException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SecurityGroupAppModelTabWeb {
    private UserContext _me;

    public SecurityGroupAppModelTabWeb(UserContext me) {
        this._me = me;
    }

    public String saveSecurity(String groupId, String securityList) {
        ResponseObject response = ResponseObject.newOkResponse("\u4fdd\u5b58\u6210\u529f");
        securityList = securityList.trim();
        try {
            JSONObject jsonStr = JSONObject.parseObject((String)securityList);
            String navSecList = jsonStr.getString("navselected");
            String dwSecList = jsonStr.getString("dwselected");
            response = this.saveNewSecurity(groupId, navSecList, "FunctionObject");
            response = this.saveNewSecurity(groupId, dwSecList, "process");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.err("\u64cd\u4f5c\u5931\u8d25!" + e.toString());
            return response.toString();
        }
        HighSecurity.auditLog(this._me, "access", "\u6388\u6743", groupId, "\u6388\u6743\u83dc\u5355\u6743\u9650", Level.INFO);
        return response.toString();
    }

    public ResponseObject saveNewSecurity(String groupId, String idsList, String resourceType) {
        ResponseObject response = ResponseObject.newOkResponse("\u4fdd\u5b58\u6210\u529f");
        ArrayList<PermissionListModel> PList = new ArrayList<PermissionListModel>();
        ArrayList<String> selectList = new ArrayList<String>();
        ArrayList removeList = new ArrayList();
        try {
            if (!UtilString.isEmpty(idsList)) {
                int i;
                JSONArray arr = JSONArray.parseArray((String)idsList);
                if (arr != null && arr.size() > 0) {
                    i = 0;
                    while (i < arr.size()) {
                        JSONObject json = arr.getJSONObject(i);
                        String id = json.getString("id");
                        boolean isPerm = json.getBooleanValue("isChecked");
                        PermissionDaoFactory.createPermissionList().removeByResourceTypeAndResourceId(groupId, resourceType, id);
                        if (isPerm) {
                            selectList.add(id);
                        }
                        ++i;
                    }
                }
                if (selectList != null && selectList.size() > 0) {
                    selectList = new ArrayList(new HashSet(selectList));
                    i = 0;
                    while (i < selectList.size()) {
                        PermissionListModel model = new PermissionListModel();
                        if (!((String)selectList.get(i)).toString().equals("")) {
                            model.setPermissionId(groupId);
                            model.setResourceId(((String)selectList.get(i)).toString());
                            model.setResourceType(resourceType);
                            PList.add(model);
                        }
                        ++i;
                    }
                }
                PermissionDaoFactory.createPermissionList().createModels(groupId, resourceType, PList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.err("\u64cd\u4f5c\u5931\u8d25!" + e.toString());
            return response;
        }
        return response;
    }

    public String getSecurityTree(String groupId) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        JSONArray navArr = new JSONArray();
        PermissionModel sercurityGroupmodel = PermissionCache.getModel(groupId);
        boolean isAccess = AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", sercurityGroupmodel.getCategoryName(), SecurityGroupACCM.MANAGER.getType());
        boolean isSuperMaster = false;
        boolean isMaster = GradeSecurityUtil.isSuperMaster(this._me.getUID()) || GradeSecurityUtil.isSecurityMaster(this._me.getUID());
        boolean isControl = false;
        if (isMaster || isAccess) {
            isSuperMaster = true;
        }
        Iterator<NavigationSystemModel> systemList = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
        List<NavigationSystemModel> list = PermUtil.getNavigationSystemListByResort(systemList);
        systemList = list.iterator();
        HashMap<String, String> isAllNotControl = new HashMap<String, String>();
        if (systemList != null) {
            List<PermissionListModel> permissionList = PermissionListCache.getAWFModelUnit(groupId);
            HashSet<String> fs = new HashSet<String>();
            for (PermissionListModel p : permissionList) {
                fs.add(p.getResourceId());
            }
            JSONArray sysArray = new JSONArray();
            while (systemList.hasNext()) {
                NavigationSystemModel navigationSystemModel = systemList.next();
                boolean isHidden = false;
                isControl = AccessControlAPI.getInstance().havingPermission(this._me, NavACCM.resourceType, navigationSystemModel.getId(), NavACCM.MANAGER.getType());
                isAllNotControl.put(String.valueOf(isControl), String.valueOf(isControl));
                if (!(isMaster || !NavigationUtil.isSystemNavigation(navigationSystemModel) && isControl)) {
                    isHidden = true;
                }
                if (NavigationUtil.isSystemNavigation(navigationSystemModel) && HighSecurity.isON()) {
                    isHidden = true;
                }
                if (isHidden) continue;
                JSONObject sysObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationSystemModel));
                String systemId = navigationSystemModel.getId();
                boolean isManagerS = fs.contains(systemId);
                boolean isManagerD = false;
                boolean isManagerF = false;
                sysObject.put("isManager", (Object)isManagerS);
                JSONArray directoryArray = new JSONArray();
                List<NavigationDirectoryModel> directoryList = NavigationDirectoryCache.getListOfSystem(systemId);
                if (directoryList != null) {
                    for (NavigationDirectoryModel navigationDirectoryModel : directoryList) {
                        JSONObject directoryObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationDirectoryModel));
                        String directoryId = navigationDirectoryModel.getId();
                        isManagerD = fs.contains(directoryId);
                        directoryObject.put("isManager", (Object)isManagerD);
                        List<NavigationFunctionModel> functionList = NavigationFunctionCache.getListOfDirectory(directoryId);
                        JSONArray functionArr = new JSONArray();
                        if (functionList != null) {
                            List<NavigationFunctionModel> listOfDirectory = NavigationFunctionCache.getListOfDirectory(directoryId);
                            for (NavigationFunctionModel navigationFunctionModel : listOfDirectory) {
                                String cmd;
                                String functionId = navigationFunctionModel.getId();
                                isManagerF = fs.contains(functionId);
                                JSONObject functionObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationFunctionModel));
                                functionObject.put("isManager", (Object)isManagerF);
                                functionObject.put("showDWSec", (Object)false);
                                String linkUrl = navigationFunctionModel.getLinkUrl();
                                JSONObject urlParams = PermUtil.getUrlParams(linkUrl);
                                if (urlParams != null && !UtilString.isEmpty(cmd = urlParams.getString("cmd")) && cmd.equals("CLIENT_DW_PORTAL")) {
                                    ProcessDefinition processDefinition;
                                    List definitionList;
                                    String processGroupId = urlParams.getString("processGroupId");
                                    String appId = urlParams.getString("appId");
                                    if (!UtilString.isEmpty(processGroupId) && (definitionList = ProcessDefCache.getInstance().getListOfProcessGroup(appId, processGroupId)).size() > 0 && (processDefinition = (ProcessDefinition)definitionList.get(0)).getEngineType() == 1) {
                                        functionObject.put("showDWSec", (Object)true);
                                        functionObject.put("processGroupId", (Object)processGroupId);
                                        functionObject.put("processDefId", (Object)processDefinition.getId());
                                        boolean isHaveDWsec = PermAPIManager.getInstance().havingPorcessInPermissionList(processDefinition.getId(), groupId);
                                        functionObject.put("isHaveDWsec", (Object)isHaveDWsec);
                                    }
                                }
                                functionArr.add((Object)functionObject);
                            }
                            directoryObject.put("function", (Object)functionArr);
                        }
                        directoryArray.add((Object)directoryObject);
                    }
                    sysObject.put("directory", (Object)directoryArray);
                }
                if (!isManagerS && !isManagerD && !isManagerF) continue;
                sysArray.add((Object)sysObject);
            }
            navArr.add((Object)sysArray);
        }
        if (!isMaster && isAllNotControl.size() == 1) {
            throw new AWSForbiddenException("\u6ca1\u6709\u53ef\u8bbf\u95ee\u7684\u5b50\u7cfb\u7edf\u8d44\u6e90");
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("isSuperMaster", String.valueOf(isSuperMaster));
        macroLibraries.put("navArr", navArr);
        macroLibraries.put("sid", sid);
        macroLibraries.put("isAccess", String.valueOf(isAccess));
        macroLibraries.put("groupId", groupId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.appmodel.htm", macroLibraries);
    }

    public String openSystemNavPage(String groupId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        JSONArray navArr = new JSONArray();
        PermissionModel sercurityGroupmodel = PermissionCache.getModel(groupId);
        boolean isAccess = AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", sercurityGroupmodel.getCategoryName(), SecurityGroupACCM.MANAGER.getType());
        boolean isSuperMaster = false;
        boolean isMaster = GradeSecurityUtil.isSuperMaster(this._me.getUID()) || GradeSecurityUtil.isSecurityMaster(this._me.getUID());
        boolean isControl = false;
        if (isMaster || isAccess) {
            isSuperMaster = true;
        }
        Iterator<NavigationSystemModel> systemList = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
        List<NavigationSystemModel> list = PermUtil.getNavigationSystemListByResort(systemList);
        systemList = list.iterator();
        HashMap<String, String> isAllNotControl = new HashMap<String, String>();
        if (systemList != null) {
            List<PermissionListModel> permissionList = PermissionListCache.getAWFModelUnit(groupId);
            HashSet<String> fs = new HashSet<String>();
            for (PermissionListModel p : permissionList) {
                fs.add(p.getResourceId());
            }
            JSONArray sysArray = new JSONArray();
            while (systemList.hasNext()) {
                NavigationSystemModel navigationSystemModel = systemList.next();
                boolean isHidden = false;
                isControl = AccessControlAPI.getInstance().havingPermission(this._me, NavACCM.resourceType, navigationSystemModel.getId(), NavACCM.MANAGER.getType());
                isAllNotControl.put(String.valueOf(isControl), String.valueOf(isControl));
                if (!(isMaster || !NavigationUtil.isSystemNavigation(navigationSystemModel) && isControl)) {
                    isHidden = true;
                }
                if (NavigationUtil.isSystemNavigation(navigationSystemModel) && HighSecurity.isON()) {
                    isHidden = true;
                }
                if (isHidden) continue;
                JSONObject sysObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationSystemModel));
                String systemId = navigationSystemModel.getId();
                boolean isManager = fs.contains(systemId);
                if (isManager) continue;
                JSONArray directoryArray = new JSONArray();
                List<NavigationDirectoryModel> directoryList = NavigationDirectoryCache.getListOfSystem(systemId);
                if (directoryList != null) {
                    for (NavigationDirectoryModel navigationDirectoryModel : directoryList) {
                        JSONObject directoryObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationDirectoryModel));
                        String directoryId = navigationDirectoryModel.getId();
                        isManager = fs.contains(directoryId);
                        if (isManager) continue;
                        directoryObject.put("isManager", (Object)(!isManager ? 1 : 0));
                        List<NavigationFunctionModel> functionList = NavigationFunctionCache.getListOfDirectory(directoryId);
                        JSONArray functionArr = new JSONArray();
                        if (functionList != null) {
                            List<NavigationFunctionModel> listOfDirectory = NavigationFunctionCache.getListOfDirectory(directoryId);
                            for (NavigationFunctionModel navigationFunctionModel : listOfDirectory) {
                                String cmd;
                                String functionId = navigationFunctionModel.getId();
                                isManager = fs.contains(functionId);
                                if (isManager) continue;
                                JSONObject functionObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationFunctionModel));
                                functionObject.put("isManager", (Object)(!isManager ? 1 : 0));
                                functionObject.put("showDWSec", (Object)false);
                                String linkUrl = navigationFunctionModel.getLinkUrl();
                                JSONObject urlParams = PermUtil.getUrlParams(linkUrl);
                                if (urlParams != null && !UtilString.isEmpty(cmd = urlParams.getString("cmd")) && cmd.equals("CLIENT_DW_PORTAL")) {
                                    ProcessDefinition processDefinition;
                                    List definitionList;
                                    String processGroupId = urlParams.getString("processGroupId");
                                    String appId = urlParams.getString("appId");
                                    if (!UtilString.isEmpty(processGroupId) && (definitionList = ProcessDefCache.getInstance().getListOfProcessGroup(appId, processGroupId)).size() > 0 && (processDefinition = (ProcessDefinition)definitionList.get(0)).getEngineType() == 1) {
                                        functionObject.put("showDWSec", (Object)true);
                                        functionObject.put("processGroupId", (Object)processGroupId);
                                        functionObject.put("processDefId", (Object)processDefinition.getId());
                                        functionObject.put("isHaveDWsec", (Object)false);
                                    }
                                }
                                functionArr.add((Object)functionObject);
                            }
                            directoryObject.put("function", (Object)functionArr);
                        }
                        directoryArray.add((Object)directoryObject);
                    }
                    sysObject.put("directory", (Object)directoryArray);
                }
                sysObject.put("isManager", (Object)(!isManager ? 1 : 0));
                sysArray.add((Object)sysObject);
            }
            navArr.add((Object)sysArray);
        }
        macroLibraries.put("sid", this._me.getSessionId());
        macroLibraries.put("isSuperMaster", String.valueOf(isSuperMaster));
        macroLibraries.put("navArr", navArr);
        macroLibraries.put("isAccess", String.valueOf(isAccess));
        macroLibraries.put("groupId", groupId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.appmodel.addsystem.dlg.htm", macroLibraries);
    }
}

