/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.web.CompanyWeb;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SecurityGroupBPAOrgTabWeb {
    private UserContext _me;

    public SecurityGroupBPAOrgTabWeb(UserContext me) {
        this._me = me;
    }

    public String getBPAOrgList(String groupId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this._me.getSessionId());
        PermissionModel sercurityGroupmodel = PermissionCache.getModel(groupId);
        boolean isSuperMaster = GradeSecurityUtil.isSuperMaster(this._me.getUID()) || AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", sercurityGroupmodel.getCategoryName(), SecurityGroupACCM.MANAGER.getType());
        CompanyWeb web = new CompanyWeb(this._me);
        String orgJsonStr = web.getOrganizationTreeJsonData("OrgRoot", "0", "", "");
        JSONArray array = JSONArray.parseArray((String)orgJsonStr);
        String orgJsonStr_role = web.getOrganizationTreeJsonData("RoleRoot", "", "", "");
        JSONArray role = JSONArray.parseArray((String)orgJsonStr_role);
        int i = 0;
        while (i < role.size()) {
            JSONObject jsonObject = role.getJSONObject(i);
            array.add((Object)jsonObject);
            ++i;
        }
        macroLibraries.put("isSuperMaster", String.valueOf(isSuperMaster));
        macroLibraries.put("groupId", groupId);
        List<String> resourceIdList = PermissionListCache.getProcessPermissionAssnListByBPAResourceType(groupId, "bpaorg");
        if (resourceIdList.size() > 0) {
            JSONArray resultTree = new JSONArray();
            int i2 = 0;
            while (i2 < array.size()) {
                JSONObject jsonObject = array.getJSONObject(i2);
                String id = UtilJson.optString(jsonObject, "id");
                if (resourceIdList.contains(id)) {
                    jsonObject.put("checked", (Object)true);
                } else {
                    jsonObject.put("checked", (Object)false);
                }
                resultTree.add((Object)jsonObject);
                ++i2;
            }
            array = resultTree;
        }
        macroLibraries.put("selectedDatas", resourceIdList);
        macroLibraries.put("array", array);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.bpaorg.htm", macroLibraries);
    }

    public String saveBPAORGList(String groupId, String securityList) {
        ResponseObject response = ResponseObject.newOkResponse("\u6388\u6743\u6210\u529f");
        securityList = securityList.trim();
        UtilString myStr = new UtilString(securityList);
        List<Object> myArray = new ArrayList();
        if (!UtilString.isEmpty(securityList)) {
            myArray = myStr.split(" ");
        }
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        int i = 0;
        while (i < myArray.size()) {
            PermissionListModel model = new PermissionListModel();
            String idString = ((String)myArray.get(i)).toString();
            model.setResourceId(idString);
            list.add(model);
            ++i;
        }
        try {
            PermissionDaoFactory.createPermissionList().assentSecurity(groupId, "bpaorg", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.err("\u64cd\u4f5c\u5931\u8d25!" + e.toString());
            return response.toString();
        }
        return response.toString();
    }
}

