/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SecurityGroupBaseDataTabWeb {
    private UserContext _me;

    public SecurityGroupBaseDataTabWeb(UserContext me) {
        this._me = me;
    }

    public String getBaseDataForm(String groupId) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        boolean isSuperMaster = false;
        PermissionModel model = PermissionCache.getModel(groupId);
        if (this._me.getUID().equals("admin") || AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", model.getCategoryName(), SecurityGroupACCM.MANAGER.getType())) {
            isSuperMaster = true;
        }
        String groupName = "";
        String groupDesc = "";
        StringBuilder categoryHtml = new StringBuilder();
        if (model.isSystem()) {
            groupName = model.getPermissionName();
            groupDesc = model.getPermissionDesc();
            categoryHtml.append("<input type='text' style='width:102.1%;' name='categoryName' id='categoryName' class ='awsui-combobox' value='" + model.getCategoryName() + "'/>");
        } else {
            groupName = "<input class=\"txt\" type=\"text\" name=\"groupName\" value=\"" + model.getPermissionName() + "\"/>";
            groupDesc = "<input class='txt' type='text' name='groupDesc' value='" + model.getPermissionDesc() + "'/>";
            categoryHtml.append("<input type='text' name='categoryName' id='categoryName' class ='awsui-combobox' value='" + model.getCategoryName() + "'/>");
        }
        String[] categorys = PermissionCache.getCategorys();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < categorys.length) {
            if (this._me.getUID().equals("admin") || AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", categorys[i], SecurityGroupACCM.MANAGER.getType())) {
                list.add("{label:'" + categorys[i] + "',value:'" + categorys[i] + "'}");
            }
            ++i;
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("categoryName", categoryHtml.toString());
        macroLibraries.put("categorySoures", list);
        macroLibraries.put("groupName", groupName);
        macroLibraries.put("groupDesc", groupDesc);
        macroLibraries.put("isSystem", String.valueOf(model.isSystem() ? true : !isSuperMaster));
        macroLibraries.put("sid", sid);
        macroLibraries.put("groupId", groupId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.basedata.htm", macroLibraries);
    }

    public String saveBaseData(PermissionModel model) {
        ResponseObject ro = ResponseObject.newErrResponse();
        if (UtilString.isEmpty(model.getId())) {
            model.setId(UUIDGener.getUUID());
            List<PermissionModel> models = PermissionCache.getListOfCategory(model.getCategoryName());
            int i = 0;
            while (i < models.size()) {
                PermissionModel m = models.get(i);
                if (model.getPermissionName().equals(m.getPermissionName())) {
                    ro.msg("\u4fdd\u5b58\u5931\u8d25\uff0c[\u6743\u9650\u7ec4\u540d\u79f0]\u5df2\u5b58\u5728\uff0c\u8fdd\u53cd\u6570\u636e\u5e93\u552f\u4e00\u7ea6\u675f");
                    return ro.toString();
                }
                ++i;
            }
            PermissionDaoFactory.createPermission().insert(model);
            ro.ok();
            ro.put("t", String.valueOf(model.getId()));
            return ro.toString();
        }
        PermissionDaoFactory.createPermission().update(model);
        ro.ok();
        ro.put("t", String.valueOf(model.getId()));
        return ro.toString();
    }
}

