/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.cache.AccessControlCache;
import com.actionsoft.bpms.commons.security.ac.dao.AccessControlDaoFactory;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.util.SecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SecurityGroupCardWeb
extends ActionWeb {
    public static final int PAGE_TYPE_BASE = 0;
    public static final int PAGE_TYPE_APP_MODEL = 1;
    public static final int PAGE_TYPE_DOCUMENT_LAYER = 2;
    public static final int PAGE_TYPE_WORKFLOW = 3;
    public static final int PAGE_TYPE_FUNCTION_ROLE = 4;
    public static final int PAGE_TYPE_USER = 9;
    public static final int PAGE_TYPE_ROLE = 8;

    public SecurityGroupCardWeb(UserContext me) {
        super(me);
    }

    public String getSecurityCategoryList() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("page_title", "\u6743\u9650\u7ec4\u5206\u7c7b");
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("isSuperMaster", GradeSecurityUtil.isSuperMaster(this.getContext().getUID()));
        String btn = "<div class=\"awsui-btn-group\"><button id='add' type='button' class='awsui-btn awsui-btn-blue' style='margin-right:10px;'>\u65b0\u5efa</button><button id='delete' type='button' class='awsui-btn awsui-btn-danger' style='margin-right:10px;'>\u5220\u9664</button></div><div class=\"awsui-btn-group\"><button id='merge' type='button' class='awsui-btn' style='margin-right:10px;'>\u5408\u5e76\u5206\u7c7b</button></div>";
        macroLibraries.put("btn", GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSecurityMaster(this.getContext().getUID()) ? btn : "");
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.root.htm", macroLibraries);
    }

    public String mergeCategory(String categorys, String newCategory) {
        UtilString usData = new UtilString(categorys);
        int modifyRecordCount = 0;
        try {
            modifyRecordCount = Integer.parseInt(usData.matchValue("_AWSSHEETMODIFYCOUNT{", "}AWSSHEETMODIFYCOUNT_"));
        }
        catch (Exception e) {
            modifyRecordCount = 0;
        }
        ResponseObject r = ResponseObject.newErrResponse();
        try {
            int i = 0;
            while (i < modifyRecordCount) {
                String categoryName = usData.matchValue("_AWSSHEETMODIFYRECORD" + i + "{", "}AWSSHEETMODIFYRECORD" + i + "_");
                if (categoryName.trim().length() != 0) {
                    String sql = "update SYS_PERMISSION set categoryname=:newCategory where categoryname=:categoryName";
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("newCategory", newCategory);
                    map.put("categoryName", categoryName);
                    DBSql.update(sql, map);
                    String sql1 = "UPDATE SYS_AC set RESOURCEID=:newCategory where RESOURCETYPE='platform.secGroupAdmin' and RESOURCEID=:categoryName";
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("newCategory", newCategory);
                    map1.put("categoryName", categoryName);
                    DBSql.update(sql1, map1);
                }
                ++i;
            }
        }
        catch (Exception e) {
            r.msg(e.getMessage() == null ? "\u5408\u5e76\u53d1\u751f\u9519\u8bef" : e.getMessage());
            return r.toString();
        }
        PermissionCache.getCache().reload(true);
        AccessControlCache.getCache().reload(true);
        r.ok();
        return r.toString();
    }

    public String modifyCategory(String category, String newCategory) {
        ResponseObject ro = ResponseObject.newErrResponse();
        try {
            PermissionDaoFactory.createPermission().modifyCategory(category, newCategory);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ro.msg("\u4fee\u6539\u6743\u9650\u7ec4\u540d\u79f0\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u68c0\u67e5\u65e5\u5fd7");
            return ro.toString();
        }
        ro.ok();
        return ro.toString();
    }

    public String getSecurityGroupList(String categoryName) {
        if (categoryName == null || categoryName.length() == 0) {
            return this.getSecurityCategoryList();
        }
        boolean isManager = SecurityUtil.hasSecGroupManagerSec((UserContext)this.getContext(), (String)categoryName) || GradeSecurityUtil.isSecurityMaster(this.getContext().getUID());
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("page_title", "<a href='' onclick=\"listRoot('CONSOLE_M_SEC_GROUP_CATEGORY_LIST');return false;\">\u6743\u9650\u7ec4\u5206\u7c7b</a><b>&raquo;</b>" + categoryName);
        macroLibraries.put("isManager", isManager);
        macroLibraries.put("categoryName", categoryName);
        macroLibraries.put("sid", this.getSIDFlag());
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.list.htm", macroLibraries);
    }

    public String getSecurityGroupJsonData(String categoryName, String currentPage, String limit) {
        int i;
        int start = Integer.valueOf(currentPage) == 0 ? 1 : Integer.valueOf(currentPage);
        int end = Integer.valueOf(limit);
        start = (start - 1) * end;
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        JSONObject json = new JSONObject();
        if (categoryName == null || categoryName.length() == 0) {
            String[] groups = PermissionCache.getCategorys();
            i = 0;
            while (i < groups.length) {
                if (SecurityUtil.hasSecGroupManagerSec((UserContext)this.getContext(), (String)groups[i]) || GradeSecurityUtil.isSecurityMaster(this.getContext().getUID())) {
                    JSONObject jsonObj = new JSONObject();
                    String groupName = Html.escape(groups[i]).replace("\"", "&quot;");
                    int size = PermissionCache.getListOfCategory(groupName).size();
                    String buttons = "<a href='' onclick=\"modifySecurityCategory('" + groupName + "');return false;\"><span awsui-qtip='\u4fee\u6539'><i class='awsui-iconfont' style='font-size:13px;color:#e69b43;cursor:pointer;'>&#58934;</i></span></a>&nbsp;&nbsp;<a href='' onclick=\"openAc('" + groupName + "','" + "platform.secGroupAdmin" + "');return false;\"><span awsui-qtip='\u4e8c\u7ea7\u7ba1\u7406\u5458'><i class='awsui-iconfont' style='font-size:13px;color:#E8574E;cursor:pointer;'>&#59212;</i></span></a>";
                    if (!SecurityUtil.hasSecGroupManagerSec((UserContext)this.getContext(), (String)groups[i]) && !GradeSecurityUtil.isSecurityMaster(this.getContext().getUID())) {
                        buttons = "";
                    }
                    String category = "<span><i class='awsui-iconfont' style='font-size:15px;color:#e69b43;cursor:pointer;'>&#58995;</i></span>&nbsp;<a href='' onclick=\"listDetial(frmMain,'" + groupName + "','CONSOLE_M_SEC_GROUP_LIST');return false;\">" + groupName.replace(" ", "&nbsp;") + "</a>";
                    jsonObj.put("secCategory", (Object)category);
                    jsonObj.put("operation", (Object)buttons);
                    jsonObj.put("secNum", (Object)size);
                    jsonObj.put("val", (Object)groupName);
                    list.add(jsonObj);
                }
                ++i;
            }
        } else {
            List<PermissionModel> h = PermissionCache.getListOfCategory(categoryName);
            boolean isManager = SecurityUtil.hasSecGroupManagerSec((UserContext)this.getContext(), (String)categoryName);
            String css1 = "";
            String css2 = "";
            if (h != null) {
                int i2 = 0;
                while (i2 < h.size()) {
                    PermissionModel model = h.get(i2);
                    String permissionName = model.getPermissionName().replace("\"", "&quot;");
                    if (!PermissionAssnCache.existAssn(model.getId())) {
                        css1 = "<font color='gray' awsui-qtip='\u8be5\u6743\u9650\u7ec4\u672a\u88ab\u4f7f\u7528'>";
                        css2 = "</font>";
                    } else {
                        css2 = "";
                        css1 = "";
                    }
                    String buttons = "<a href='' onclick=\"openSecurity(frmMain,'" + model.getId() + "','CONSOLE_M_SEC_GROUP_OPEN','" + permissionName + "'); return false;\"><span awsui-qtip='\u4fee\u6539'><i class='awsui-iconfont' style='font-size:13px;color:#e69b43;cursor:pointer;'>&#58934;</i></span></a>";
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("group", (Object)(String.valueOf(css1) + "<a href='' onclick=\"openSecurity(frmMain,'" + model.getId() + "','CONSOLE_M_SEC_GROUP_OPEN','" + permissionName + "'); return false;\">" + permissionName.replace(" ", "&nbsp;") + "</a>" + css2));
                    jsonObj.put("operation", (Object)buttons);
                    jsonObj.put("desc", (Object)(String.valueOf(css1) + model.getPermissionDesc() + css2));
                    jsonObj.put("id", (Object)model.getId());
                    jsonObj.put("isManager", (Object)isManager);
                    list.add(jsonObj);
                    ++i2;
                }
            }
        }
        JSONArray returnJson = new JSONArray();
        i = start;
        while (i < start + end) {
            if (i > list.size() - 1) break;
            returnJson.add(list.get(i));
            ++i;
        }
        json.put("totalRecords", (Object)list.size());
        json.put("curPage", (Object)currentPage);
        json.put("data", (Object)returnJson);
        return json.toString();
    }

    public String getSecurityGroupForm(String groupId, int pageType) {
        String sid = this.getContext().getSessionId();
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        boolean isBPA = SDK.getAppAPI().isActive("com.actionsoft.apps.coe.bpa");
        PermissionModel sercurityGroupmodel = PermissionCache.getModel(groupId);
        String isAccess = "false";
        isAccess = GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) ? "none" : String.valueOf(AccessControlAPI.getInstance().havingPermission(this.getContext(), "platform.secGroupAdmin", sercurityGroupmodel.getCategoryName(), SecurityGroupACCM.MANAGER.getType()));
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("sessionId", sid);
        macroLibraries.put("groupId", groupId);
        macroLibraries.put("pageType", Integer.toString(pageType));
        macroLibraries.put("groupName", PermissionCache.getModel(groupId).getPermissionName().replace("\"", "&quot;"));
        macroLibraries.put("ASPModel", "false");
        macroLibraries.put("isAccess", isAccess);
        macroLibraries.put("isBPA", isBPA);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.htm", macroLibraries);
    }

    public String removeSecurityGroup(String idList, String category) {
        UtilString myStr = new UtilString(idList);
        ResponseObject r = ResponseObject.newErrResponse();
        List<String> myArray = myStr.split(" ");
        int i = 0;
        while (i < myArray.size()) {
            try {
                PermissionDaoFactory.createPermission().delete(myArray.get(i).toString());
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("CONSOLE\u6743\u9650\u7ec4") > -1) {
                    r.msg(e.getMessage());
                } else {
                    r.msg("\u5220\u9664\u8868\u5355\u6a21\u578b\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u68c0\u67e5\u65e5\u5fd7");
                }
                e.printStackTrace(System.err);
                return r.toString();
            }
            ++i;
        }
        PermissionCache.getCache().reload(true);
        r.ok();
        return r.toString();
    }

    public String createSecGroupCategory(String categoryName, String perminssionName, String perminssionDesc) {
        ResponseObject ro = ResponseObject.newErrResponse();
        PermissionModel model = new PermissionModel();
        model.setPermissionName(perminssionName);
        model.setCategoryName(categoryName);
        model.setPermissionDesc(perminssionDesc);
        model.setId(UUIDGener.getUUID());
        List<PermissionModel> models = PermissionCache.getListOfCategory(model.getCategoryName());
        int i = 0;
        while (i < models.size()) {
            PermissionModel m = models.get(i);
            if (model.getPermissionName().equals(m.getPermissionName())) {
                ro.msg("\u4fdd\u5b58\u5931\u8d25\uff0c[\u6743\u9650\u7ec4\u540d\u79f0]\u5df2\u5b58\u5728\uff0c\u8fdd\u53cd\u6570\u636e\u5e93\u552f\u4e00\u7ea6\u675f");
                return ro.toString();
            }
            ++i;
        }
        int r = PermissionDaoFactory.createPermission().insert(model);
        if (r == -2) {
            ro.msg("\u8d85\u51faLicence\u8bb8\u53ef,\u8bf7\u4e0e\u8f6f\u4ef6\u4f9b\u5e94\u5546\u8054\u7cfb");
            return ro.toString();
        }
        ro.ok("\u65b0\u5efa\u6210\u529f");
        if (!this.getContext().getUID().equals("admin")) {
            AccessControlModel accessModel = new AccessControlModel();
            accessModel._resourceId = categoryName;
            accessModel._resourceType = "platform.secGroupAdmin";
            accessModel._accessModel = SecurityGroupACCM.MANAGER.getType();
            accessModel._assignmentId = this.getContext().getUID();
            accessModel._assignmentType = "user";
            AccessControlDaoFactory.creatAccessControl().insert(accessModel);
        }
        return ro.toString();
    }

    public String removeSecGroupCategory(String categorys) {
        ResponseObject ro = ResponseObject.newErrResponse();
        List<PermissionModel> permisses = PermissionCache.getListOfCategorys(categorys);
        try {
            int i = 0;
            while (i < permisses.size()) {
                PermissionModel model = permisses.get(i);
                PermissionDaoFactory.createPermission().delete(model.getId());
                ++i;
            }
            ro.ok();
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("CONSOLE\u6743\u9650\u7ec4") > -1) {
                ro.msg(e.getMessage());
            } else {
                ro.msg("\u5220\u9664\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7");
            }
            e.printStackTrace(System.err);
        }
        return ro.toString();
    }
}

