/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bo.design.util.BOUtil;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.dictionary.model.DictModel;
import com.actionsoft.bpms.commons.dictionary.util.Xml2DictUtil;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.commons.xmetadata.XCacheModel;
import com.actionsoft.bpms.dw.design.cache.DWCache;
import com.actionsoft.bpms.dw.design.model.DWModel;
import com.actionsoft.bpms.form.design.cache.FormCache;
import com.actionsoft.bpms.form.design.model.FormItemModel;
import com.actionsoft.bpms.form.design.model.FormModel;
import com.actionsoft.bpms.repository.ModelRepositoryWeb;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.JavascriptEscape;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SecurityGroupDataTabWeb {
    private UserContext _me;

    public SecurityGroupDataTabWeb(UserContext me) {
        this._me = me;
    }

    public String getSecurityData(String groupId) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        List<PermissionListModel> list = PermissionListCache.getProcessPermissionFormList(groupId);
        JSONArray ja = this.buildJsonByList(list);
        macroLibraries.put("data", ja.toString());
        macroLibraries.put("sid", sid);
        macroLibraries.put("groupId", groupId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.datasecurity.htm", macroLibraries);
    }

    private JSONArray buildJsonByList(List<PermissionListModel> list) {
        String boId;
        JSONArray ja = new JSONArray();
        JSONObject tablefParam = new JSONObject();
        JSONObject tableParam = new JSONObject();
        JSONObject fieldParam = new JSONObject();
        for (PermissionListModel pm : list) {
            String type;
            JSONObject jo;
            String[] splits = pm.getResourceId().split("\\|");
            boId = splits[0];
            String value = pm.getExt1();
            if (pm.getResourceType().equals("FormTable")) {
                if (splits.length != 2) continue;
                String type2 = splits[1];
                jo = tableParam.getJSONObject(boId);
                if (jo == null) {
                    jo = new JSONObject();
                    BOModel boModel = (BOModel)BOCache.getInstance().getModel(boId);
                    if (boModel == null) continue;
                    AppContext appContext = AppsAPIManager.getInstance().getAppContext(boModel.getAppId());
                    jo.put("appId", (Object)appContext.getId());
                    jo.put("appName", (Object)appContext.getName());
                    jo.put("appImgUrl", (Object)appContext.getIcon16Url(this._me));
                    jo.put("category", (Object)boModel.getCategoryName());
                    jo.put("boId", (Object)boId);
                    jo.put("boName", (Object)(String.valueOf(boModel.getTitle()) + "(" + boModel.getName() + ")"));
                    jo.put("isSub", (Object)this.isSub(boModel));
                    tableParam.put(boId, (Object)jo);
                    ja.add((Object)jo);
                }
                if (type2.equals("TS")) {
                    this.setValue(jo, "hide", value);
                }
                if (type2.equals("TA")) {
                    this.setValue(jo, "add", value);
                }
                if (type2.equals("TD")) {
                    this.setValue(jo, "del", value);
                }
            }
            if (!pm.getResourceType().equals("FormField") || splits.length != 3) continue;
            String fid = splits[1];
            jo = fieldParam.getJSONObject(String.valueOf(boId) + fid);
            if (jo == null) {
                jo = new JSONObject();
                jo.put("id", (Object)fid);
                BOItemModel boItemModel = BOCache.getInstance().getBOItemModel(boId, fid);
                if (boItemModel == null) continue;
                jo.put("name", (Object)boItemModel.getName());
                jo.put("label", (Object)boItemModel.getTitle());
                fieldParam.put(String.valueOf(boId) + fid, (Object)jo);
                JSONArray fields = tablefParam.getJSONArray(boId);
                if (fields == null) {
                    fields = new JSONArray();
                    tablefParam.put(boId, (Object)fields);
                }
                fields.add((Object)(String.valueOf(boId) + fid));
            }
            if ((type = splits[2]).equals("FH")) {
                this.setValue(jo, "hide", value);
            }
            if (!type.equals("FR")) continue;
            this.setValue(jo, "read", value);
        }
        ja = this.sortTables(ja);
        int i = 0;
        int size = ja.size();
        while (i < size) {
            JSONObject jo = ja.getJSONObject(i);
            boId = jo.getString("boId");
            JSONArray fieldstr = tablefParam.getJSONArray(boId);
            JSONArray fields = new JSONArray();
            if (fieldstr != null) {
                int j = 0;
                int sizej = fieldstr.size();
                while (j < sizej) {
                    fields.add((Object)fieldParam.getJSONObject(fieldstr.getString(j)));
                    ++j;
                }
                jo.put("fields", (Object)this.sortFields(fields, boId));
            } else {
                jo.put("fields", (Object)new JSONArray());
            }
            ++i;
        }
        return ja;
    }

    private JSONArray sortTables(JSONArray tables) {
        JSONArray listArray = new JSONArray();
        if (AppPlatformConfig.hasValidTeam((String)this._me.getUID())) {
            List<Object> apps = new ArrayList();
            apps = ModelRepositoryWeb.getVisibleInstalledApps(this._me.getUID());
            AppsAPIManager.getInstance().sortAppByName(apps);
            for (AppContext appContext : apps) {
                Collection<String> cs = this.getCategorysByApp(appContext.getId());
                for (String c : cs) {
                    if (!this.isAppCategoryVisible(appContext.getId(), c, this._me.getUID())) continue;
                    String categoryName = c;
                    List boList = BOCache.getInstance().getListByCategoryName(appContext.getId(), categoryName);
                    Collections.sort(boList, new Comparator<BOModel>(){

                        @Override
                        public int compare(BOModel o1, BOModel o2) {
                            Collator myCollator = Collator.getInstance(Locale.CHINA);
                            return myCollator.compare(o1.getName(), o2.getName());
                        }
                    });
                    block2: for (BOModel boModel : boList) {
                        int i = 0;
                        int size = tables.size();
                        while (i < size) {
                            String boId = tables.getJSONObject(i).getString("boId");
                            if (boModel.getId().equals(boId)) {
                                listArray.add((Object)tables.getJSONObject(i));
                                tables.remove(i);
                                continue block2;
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        int i = 0;
        int n = tables.size();
        while (i < n) {
            listArray.add((Object)tables.getJSONObject(i));
            ++i;
        }
        return listArray;
    }

    private JSONArray sortFields(JSONArray fields, String boId) {
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(boId);
        JSONArray listArray = new JSONArray();
        block0: for (BOItemModel bo : boModel.getBoItems()) {
            int i = 0;
            int size = fields.size();
            while (i < size) {
                String fid = fields.getJSONObject(i).getString("id");
                if (bo.getId().equals(fid)) {
                    listArray.add((Object)fields.getJSONObject(i));
                    fields.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
        int i = 0;
        int size = fields.size();
        while (i < size) {
            listArray.add((Object)fields.getJSONObject(i));
            ++i;
        }
        return listArray;
    }

    private void setValue(JSONObject jo, String key, String value) {
        if ("true".equals(value)) {
            jo.put(key, (Object)true);
        } else if ("false".equals(value)) {
            jo.put(key, (Object)false);
        } else if (!"".equals(value)) {
            jo.put(key, (Object)value);
        }
    }

    public String delSecurityData(String groupId, String delData) {
        if ("".equals(delData)) {
            throw new AWSIllegalArgumentException("delData", "NULL");
        }
        JSONObject jo = JSONObject.parseObject((String)JavascriptEscape.unescape(delData));
        JSONArray table = jo.getJSONArray("table");
        JSONArray field = jo.getJSONArray("field");
        ArrayList<String> ls = new ArrayList<String>();
        int i = 0;
        int size = table.size();
        while (i < size) {
            ls.add(table.getString(i));
            ++i;
        }
        i = 0;
        size = field.size();
        while (i < size) {
            ls.add(field.getString(i));
            ++i;
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        PermissionDaoFactory.createPermissionList().deleteModelsByPermissionIdAndLikeType(groupId, ls);
        return ro.toString();
    }

    public String saveSecurityData(String groupId, String securityData) {
        if ("".equals(securityData)) {
            throw new AWSIllegalArgumentException("securityData", "NULL");
        }
        ArrayList<PermissionListModel> lpl = new ArrayList<PermissionListModel>();
        JSONArray ja = JSONArray.parseArray((String)JavascriptEscape.unescape(securityData));
        int i = 0;
        int size = ja.size();
        while (i < size) {
            PermissionListModel pm;
            String reId;
            JSONObject jo = ja.getJSONObject(i);
            String boId = jo.getString("boId");
            String hide = jo.getString("hide");
            String add = jo.getString("add");
            String del = jo.getString("del");
            if (hide != null) {
                reId = String.valueOf(boId) + "|" + "TS";
                pm = PermissionListCache.getPermissionByPermissionIdAndResourceId(groupId, reId);
                if (pm == null) {
                    pm = new PermissionListModel();
                }
                pm.setPermissionId(groupId);
                pm.setResourceType("FormTable");
                pm.setResourceId(reId);
                pm.setExt1(hide);
                lpl.add(pm);
            }
            if (add != null) {
                reId = String.valueOf(boId) + "|" + "TA";
                pm = PermissionListCache.getPermissionByPermissionIdAndResourceId(groupId, reId);
                if (pm == null) {
                    pm = new PermissionListModel();
                }
                pm.setPermissionId(groupId);
                pm.setResourceType("FormTable");
                pm.setResourceId(reId);
                pm.setExt1(add);
                lpl.add(pm);
            }
            if (del != null) {
                reId = String.valueOf(boId) + "|" + "TD";
                pm = PermissionListCache.getPermissionByPermissionIdAndResourceId(groupId, reId);
                if (pm == null) {
                    pm = new PermissionListModel();
                }
                pm.setPermissionId(groupId);
                pm.setResourceType("FormTable");
                pm.setResourceId(reId);
                pm.setExt1(del);
                lpl.add(pm);
            }
            JSONArray fields = jo.getJSONArray("fields");
            int j = 0;
            int sizej = fields.size();
            while (j < sizej) {
                PermissionListModel pm2;
                String reId2;
                JSONObject f = fields.getJSONObject(j);
                String id = f.getString("id");
                String hidef = f.getString("hide");
                String readf = f.getString("read");
                if (hidef != null) {
                    reId2 = String.valueOf(boId) + "|" + id + "|" + "FH";
                    pm2 = PermissionListCache.getPermissionByPermissionIdAndResourceId(groupId, reId2);
                    if (pm2 == null) {
                        pm2 = new PermissionListModel();
                    }
                    pm2.setPermissionId(groupId);
                    pm2.setResourceType("FormField");
                    pm2.setResourceId(reId2);
                    pm2.setExt1(hidef);
                    lpl.add(pm2);
                }
                if (readf != null) {
                    reId2 = String.valueOf(boId) + "|" + id + "|" + "FR";
                    pm2 = PermissionListCache.getPermissionByPermissionIdAndResourceId(groupId, reId2);
                    if (pm2 == null) {
                        pm2 = new PermissionListModel();
                    }
                    pm2.setPermissionId(groupId);
                    pm2.setResourceType("FormField");
                    pm2.setResourceId(reId2);
                    pm2.setExt1(readf);
                    lpl.add(pm2);
                }
                ++j;
            }
            ++i;
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        PermissionDaoFactory.createPermissionList().batchCreateOrUpdate(lpl);
        HighSecurity.auditLog(this._me, "access", "\u6388\u6743", groupId, "\u6388\u6743\u6570\u636e\u6743\u9650", Level.INFO);
        return ro.toString();
    }

    public String getBoDataTree() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        macroLibraries.put("sid", sid);
        macroLibraries.put("sessionId", this._me.getSessionId());
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.groupdata.template.page.htm", macroLibraries);
    }

    public String getBoDataTreeAjaxData(String appId, String requestType, String param1, String param2, String param3, String param4) {
        boolean isTemplateNode = param3.equals("1");
        StringBuilder jsonStr = new StringBuilder("[");
        if (requestType.equals("BMRoot")) {
            jsonStr.append("{id: 'root',nocheck:true,name: '\u5fae\u5e94\u7528',open: true,iconFont:{code:'&#xe7b2;',color:'#616161'},iconCls:'tree_root',menu:false,type:'root'},");
            if (AppPlatformConfig.hasValidTeam((String)this._me.getUID())) {
                List<Object> apps = new ArrayList();
                apps = ModelRepositoryWeb.getVisibleInstalledApps(this._me.getUID());
                AppsAPIManager.getInstance().sortAppByName(apps);
                int i = 0;
                for (AppContext appContext : apps) {
                    if (!this.isAppVisible(appContext, this._me.getUID()) && !GradeSecurityUtil.isSecurityMaster(this._me.getUID())) continue;
                    jsonStr.append(this.getBizModelAppsJson(++i, appContext, isTemplateNode)).append(',');
                }
            }
        } else if (requestType.equals("BMApps")) {
            Collection<String> cs = this.getCategorysByApp(appId);
            int i = 0;
            for (String string : cs) {
                if (!this.isAppCategoryVisible(appId, string, this._me.getUID()) && !GradeSecurityUtil.isSecurityMaster(this._me.getUID())) continue;
                jsonStr.append(this.getBizModelCategorysJson(param1, ++i, appId, string, isTemplateNode)).append(',');
            }
        } else if (requestType.equals("BMBOCategory")) {
            String categoryName = param4;
            String domData = param2;
            List list = BOCache.getInstance().getListByCategoryName(appId, categoryName);
            Collections.sort(list, new Comparator<BOModel>(){

                @Override
                public int compare(BOModel o1, BOModel o2) {
                    Collator myCollator = Collator.getInstance(Locale.CHINA);
                    return myCollator.compare(o1.getName(), o2.getName());
                }
            });
            for (BOModel boModel : list) {
                if (!BOUtil.modelManager((String)this._me.getUID(), (BOModel)boModel)) continue;
                jsonStr.append(this.getBOJson(appId, boModel, isTemplateNode, "", param4, domData)).append(',');
            }
        }
        if (jsonStr.toString().lastIndexOf(",") > -1) {
            jsonStr.setLength(jsonStr.length() - 1);
        }
        jsonStr.append(']');
        return jsonStr.toString();
    }

    private boolean isAppVisible(AppContext appContext, String uid) {
        if ("OFFLINE".equals(appContext.getRuntimeState())) {
            return false;
        }
        Map list = BOCache.getInstance().getListByApp(appContext.getId());
        for (BOModel model : list.values()) {
            if (!AMCAPIManager.isXModelAccess((XCacheModel)model, uid)) continue;
            return true;
        }
        return false;
    }

    private String getBizModelAppsJson(int index, AppContext appContext, boolean isTemplateNode) {
        File icon;
        String id = appContext.getId().replace('.', '_');
        StringBuilder jsonStr = new StringBuilder();
        String text = appContext.getName();
        appContext.getRuntimeState();
        jsonStr.append('{');
        if ("STOPPED".equals(appContext.getRuntimeState())) {
            text = "<span style=\"color:#999\" title=\"\u5df2\u6682\u505c\">" + text + "</span>";
            jsonStr.append("title:\"\u5df2\u6682\u505c").append("\",");
        }
        if ("READY".equals(appContext.getRuntimeState())) {
            text = "<span style=\"color:#999\" title=\"\u5df2\u5c31\u7eea\">" + text + "</span>";
            jsonStr.append("title:\"\u5df2\u5c31\u7eea").append("\",");
        }
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(text);
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appContext.getId()).append("',");
        jsonStr.append("appname:'").append(appContext.getName()).append("',");
        jsonStr.append("type:'BMApps',");
        if (!isTemplateNode) {
            jsonStr.append("nocheck:true,");
        }
        if ((icon = new File(appContext.getIcon16FilePath())).exists()) {
            jsonStr.append("icon:'" + AppsAPIManager.getInstance().getIcon16URL(appContext.getId(), this._me) + "',");
        } else {
            jsonStr.append("iconCls:'treeBMApps',");
        }
        jsonStr.append("leaf:false,");
        jsonStr.append("title:").append("'").append(appContext.getId()).append("',");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'root'");
        jsonStr.append(",menu:false");
        jsonStr.append('}');
        return jsonStr.toString();
    }

    private Collection<String> getCategorysByApp(String appId) {
        HashSet<String> l = new HashSet<String>();
        Map ps = ProcessDefCache.getInstance().getListByApp(appId);
        for (ProcessDefinition model : ps.values()) {
            if (!AMCAPIManager.isXModelAccess((XCacheModel)model, this._me.getUID()) && !GradeSecurityUtil.isSecurityMaster(this._me.getUID())) continue;
            l.add(model.getCategoryName());
        }
        Map bos = BOCache.getInstance().getListByApp(appId);
        for (BOModel model : bos.values()) {
            if (!AMCAPIManager.isXModelAccess((XCacheModel)model, this._me.getUID()) && !GradeSecurityUtil.isSecurityMaster(this._me.getUID())) continue;
            l.add(model.getCategoryName());
        }
        Map forms = FormCache.getInstance().getListByApp(appId);
        for (FormModel model : forms.values()) {
            if (!AMCAPIManager.isXModelAccess((XCacheModel)model, this._me.getUID()) && !GradeSecurityUtil.isSecurityMaster(this._me.getUID())) continue;
            l.add(model.getCategoryName());
        }
        Map dws = DWCache.getInstance().getListByApp(appId);
        for (DWModel model : dws.values()) {
            if (!AMCAPIManager.isXModelAccess((XCacheModel)model, this._me.getUID()) && !GradeSecurityUtil.isSecurityMaster(this._me.getUID())) continue;
            l.add(model.getCategoryName());
        }
        if (AppsAPIManager.getInstance().isActive(appId)) {
            List dicts = Xml2DictUtil.getList((String)appId, (boolean)true);
            for (DictModel dict : dicts) {
                l.add(dict.getCategoryName());
            }
            List dictDrs = Xml2DictUtil.getList((String)appId, (boolean)false);
            for (DictModel dr : dictDrs) {
                l.add(dr.getCategoryName());
            }
        }
        ArrayList<String> categoryList = new ArrayList<String>(l);
        Collections.sort(categoryList, Collator.getInstance(Locale.CHINA));
        return categoryList;
    }

    private boolean isAppCategoryVisible(String appId, String category, String uid) {
        Map list = BOCache.getInstance().getListByApp(appId);
        for (BOModel model : list.values()) {
            if (!category.equals(model.getCategoryName()) || !AMCAPIManager.isXModelAccess((XCacheModel)model, uid)) continue;
            return true;
        }
        return true;
    }

    private String getBizModelCategorysJson(String index, int indexMe, String appId, String bcName, boolean isTemplateNode) {
        StringBuilder jsonStr = new StringBuilder();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        String id = "AWS_NODE_BC_ID_" + index + indexMe;
        String pid = appId.replace('.', '_');
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(bcName);
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("appname:'").append(app.getName()).append("',");
        jsonStr.append("type:'BMCategory',");
        if (!isTemplateNode) {
            jsonStr.append("nocheck:true,");
        }
        jsonStr.append("iconCls:'treeBMCategory',");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'" + pid + "'");
        jsonStr.append(",menu:false");
        jsonStr.append('}');
        return jsonStr.toString();
    }

    private String getBOJson(String appId, BOModel boModel, boolean isTemplateNode, String templateType, String categoryId, String domData) {
        JSONObject jo = new JSONObject();
        StringBuilder json = new StringBuilder();
        jo.put("id", (Object)("AWS_NODE_BO_ID_" + boModel.getId()));
        jo.put("name", (Object)(String.valueOf(boModel.getTitle()) + "(" + boModel.getName() + ")"));
        if (boModel.getEntityType() == null) {
            return "";
        }
        if (boModel.getEntityType().equals("VIEW") && boModel.getViewType().equals("BOVIEW")) {
            jo.put("iconCls", (Object)"treeBMBOVBOView");
        } else if (boModel.getEntityType().equals("VIEW") && boModel.getViewType().equals("COMMON")) {
            jo.put("iconCls", (Object)"treeBMBOVCommon");
        } else if (boModel.getEntityType().equals("STRUCTURE")) {
            jo.put("iconCls", (Object)"treeBMBOStructure");
        } else {
            jo.put("iconCls", (Object)"treeBMBO");
        }
        jo.put("qtip", (Object)boModel.getName());
        if (!isTemplateNode) {
            jo.put("nocheck", (Object)true);
        } else if (isTemplateNode && templateType.equals("bo")) {
            jo.put("nocheck", (Object)true);
            jo.put("templateNode", (Object)true);
        } else if (isTemplateNode && templateType.equals("bofield")) {
            jo.put("open", (Object)false);
        } else if (isTemplateNode && templateType.equals("exp")) {
            jo.put("nocheck", (Object)true);
        }
        jo.put("category", (Object)boModel.getCategoryName());
        jo.put("type", (Object)"BMBO");
        jo.put("draggable", (Object)false);
        if (!boModel.getEntityType().equals("STRUCTURE") && !BOUtil.hasTables((BOModel)boModel)) {
            jo.put("exist", (Object)false);
        }
        String pid = "AWS_NODE_BC_BO_" + categoryId.replaceAll(" ", "");
        jo.put("appid", (Object)appId);
        jo.put("title", (Object)boModel.getName());
        jo.put("pid", (Object)pid);
        this.buildParamData(jo, boModel, domData);
        if (jo.getBoolean("undo") != null) {
            return "";
        }
        return jo.toString();
    }

    private boolean isSub(BOModel boModel) {
        Map list = FormCache.getInstance().getListByBoModelId(boModel.getId());
        for (FormModel f : list.values()) {
            for (FormItemModel ft : f.getFormItems()) {
                if (!ft.getBoModelId().equals(boModel.getId()) || !ft.isGrid()) continue;
                return true;
            }
        }
        return false;
    }

    private void buildParamData(JSONObject jo, BOModel boModel, String domData) {
        AppContext appContext = AppsAPIManager.getInstance().getAppContext(boModel.getAppId());
        jo.put("appId", (Object)appContext.getId());
        jo.put("appName", (Object)appContext.getName());
        jo.put("appImgUrl", (Object)appContext.getIcon16Url(this._me));
        jo.put("category", (Object)boModel.getCategoryName());
        jo.put("boName", (Object)(String.valueOf(boModel.getTitle()) + "(" + boModel.getName() + ")"));
        jo.put("boId", (Object)boModel.getId());
        jo.put("isSub", (Object)this.isSub(boModel));
        JSONArray baseJa = null;
        boolean undo = false;
        if (!"".equals(domData)) {
            baseJa = JSONArray.parseArray((String)JavascriptEscape.unescape(domData));
        }
        JSONArray ja = new JSONArray();
        List fields = BOCache.getInstance().getBOItemList(boModel);
        for (BOItemModel bom : fields) {
            JSONObject jof = new JSONObject();
            jof.put("id", (Object)bom.getId());
            jof.put("name", (Object)bom.getName());
            jof.put("label", (Object)bom.getTitle());
            ja.add((Object)jof);
        }
        jo.put("fields", (Object)ja);
    }
}

