/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.emm.mam.apps.MobileAppProfile;
import com.actionsoft.emm.mam.apps.MobileAppsResource;
import java.util.HashMap;
import java.util.List;

public class SecurityGroupMobileAppsWeb {
    private UserContext _me;

    public SecurityGroupMobileAppsWeb(UserContext me) {
        this._me = me;
    }

    public String getMobileAppList(String groupId) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        PermissionModel sercurityGroupmodel = PermissionCache.getModel(groupId);
        boolean isSuperMaster = GradeSecurityUtil.isSuperMaster(this._me.getUID()) || GradeSecurityUtil.isSecurityMaster(this._me.getUID()) || AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", sercurityGroupmodel.getCategoryName(), SecurityGroupACCM.MANAGER.getType());
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='table' >");
        boolean isnull = true;
        List<PermissionListModel> mobilAppSecurityList = PermissionListCache.getMobileAppList(groupId);
        if (mobilAppSecurityList != null) {
            int count = 0;
            int size = mobilAppSecurityList.size();
            int i = 0;
            while (i < size) {
                PermissionListModel model = mobilAppSecurityList.get(i);
                List apps = MobileAppsResource.getListByApp((String)model.getResourceId());
                if (apps.size() > 0) {
                    isnull = false;
                    sb.append("<tr><td class='check'><input class='awsui-checkbox' type=checkbox name='chk");
                    sb.append(i).append(" id='chk").append(count).append("' value ='").append(model.getId());
                    sb.append("'></td><td class='list'>");
                    sb.append(AMCUtil.getListAppIcon(((MobileAppProfile)apps.get(0)).getAppContext().getId()));
                    sb.append("<label class='awsui-checkbox-label' for='chk").append(count).append("'>");
                    sb.append(((MobileAppProfile)apps.get(0)).getAppContext().getName());
                    sb.append("</label></td></tr>");
                }
                ++i;
            }
        } else {
            sb.append("<tr><td align='center' style='font-size:14px;'><br/><br/><br/>\u6682\u65e0\u6743\u9650\u4fe1\u606f\uff01");
            sb.append("</td></tr>\n");
        }
        sb.append("</table>");
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("isSuperMaster", String.valueOf(isSuperMaster));
        macroLibraries.put("security", sb.toString());
        macroLibraries.put("isnull", isnull);
        macroLibraries.put("sid", sid);
        macroLibraries.put("groupId", groupId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.mobileapp.htm", macroLibraries);
    }

    public String addSecurityMobileApp(String groupId, String mobileAppIds) {
        List<String> myArray = new UtilString(mobileAppIds = mobileAppIds.trim()).split(" ");
        if (myArray != null) {
            int i = 0;
            while (i < myArray.size()) {
                PermissionListModel model = new PermissionListModel();
                model.setPermissionId(groupId);
                model.setResourceId(myArray.get(i).toString());
                model.setResourceType("MobileApp");
                PermissionDaoFactory.createPermissionList().insert(model);
                ++i;
            }
        }
        return this.getMobileAppList(groupId);
    }

    public String removeMobilApp(String groupId, String list) {
        ResponseObject responseObject = ResponseObject.newOkResponse();
        list = list.trim();
        UtilString myStr = new UtilString(list);
        List<String> myArray = myStr.split(" ");
        int i = 0;
        while (i < myArray.size()) {
            try {
                PermissionDaoFactory.createPermissionList().delete(myArray.get(i).toString());
                PermissionListCache.getCache().reload(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                responseObject.err("[" + myArray.get(i).toString() + "]\u5bfc\u81f4\u6570\u636e\u4e0d\u80fd\u5168\u90e8\u5220\u9664");
                return responseObject.toString();
            }
            ++i;
        }
        responseObject.msg("\u5220\u9664\u6210\u529f");
        HighSecurity.auditLog(this._me, "access", "\u5220\u9664", groupId, "\u5220\u9664\u79fb\u52a8\u5e94\u7528\u6743\u9650", Level.INFO);
        return responseObject.toString();
    }

    public static boolean isSecurityGroupUsed(String groupId) {
        List<PermissionAssnModel> userSecurityList = PermissionAssnCache.getUserPermissionAssnList(groupId);
        if (userSecurityList != null) {
            for (UserModel currentUser : UserCache.getCache()) {
                int iiii = 0;
                while (iiii < userSecurityList.size()) {
                    PermissionAssnModel model = userSecurityList.get(iiii);
                    if (model.getAssignmentId().equals(currentUser.getUID())) {
                        return true;
                    }
                    ++iiii;
                }
            }
        }
        return false;
    }
}

