/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SecurityGroupProcessTabWeb {
    private UserContext _me;

    public SecurityGroupProcessTabWeb(UserContext me) {
        this._me = me;
    }

    public String getBPAProcessList(String groupId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this._me.getSessionId());
        PermissionModel sercurityGroupmodel = PermissionCache.getModel(groupId);
        boolean isSuperMaster = GradeSecurityUtil.isSuperMaster(this._me.getUID()) || AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", sercurityGroupmodel.getCategoryName(), SecurityGroupACCM.MANAGER.getType());
        macroLibraries.put("isSuperMaster", String.valueOf(isSuperMaster));
        macroLibraries.put("groupId", groupId);
        JSONArray array = this.getBPATreeData(groupId);
        macroLibraries.put("bpaTreeData", array);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.process.htm", macroLibraries);
    }

    public JSONArray getBPATreeData(String groupId) {
        JSONArray bpaTreeData = new JSONArray();
        AppAPI appAPI = SDK.getAppAPI();
        if (appAPI.isActive("com.actionsoft.apps.coe.bpa")) {
            String sourceAppId = "_bpm.platform";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sid", this._me.getSessionId());
            params.put("groupId", groupId);
            ResponseObject responseObject = appAPI.callASLP(appAPI.getAppContext(sourceAppId), "aslp://com.actionsoft.apps.coe.bpa/getBPAProcessList", params);
            if (responseObject != null && responseObject.isOk() && responseObject.toJSONObject().get((Object)"data") != null) {
                bpaTreeData = responseObject.toJSONObject().getJSONObject("data").getJSONArray("data");
            }
        }
        return bpaTreeData;
    }

    public String saveBPAProcessList(String groupId, String securityList) {
        ResponseObject response = ResponseObject.newOkResponse("\u6388\u6743\u6210\u529f");
        securityList = securityList.trim();
        UtilString myStr = new UtilString(securityList);
        List<Object> myArray = new ArrayList();
        if (!UtilString.isEmpty(securityList)) {
            myArray = myStr.split(" ");
        }
        ArrayList<PermissionListModel> list = new ArrayList<PermissionListModel>();
        int i = 0;
        while (i < myArray.size()) {
            if (!((String)myArray.get(i)).toString().equals("10f882f7-ae01-4430-b54d-e504246bf0e3")) {
                PermissionListModel model = new PermissionListModel();
                model.setResourceId(((String)myArray.get(i)).toString());
                list.add(model);
            }
            ++i;
        }
        try {
            PermissionDaoFactory.createPermissionList().assentSecurity(groupId, "bpaprocess", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.err("\u64cd\u4f5c\u5931\u8d25!" + e.toString());
            return response.toString();
        }
        return response.toString();
    }
}

