/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.SecurityGroupACCM;
import com.actionsoft.bpms.commons.security.basic.PermAPIManager;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.cache.CompanyCache;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.org.util.SecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SecurityGroupRoleSecurityTabWeb {
    private UserContext _me;

    public SecurityGroupRoleSecurityTabWeb(UserContext me) {
        this._me = me;
    }

    public String getList(String permissionId) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        PermissionModel sercurityGroupmodel = PermissionCache.getModel(permissionId);
        boolean isSuperMaster = GradeSecurityUtil.isSuperMaster(this._me.getUID()) || GradeSecurityUtil.isSecurityMaster(this._me.getUID()) || AccessControlAPI.getInstance().havingPermission(this._me, "platform.secGroupAdmin", sercurityGroupmodel.getCategoryName(), SecurityGroupACCM.MANAGER.getType());
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='table'>");
        boolean isnull = true;
        int size = RoleCache.getCache().size();
        if (size > 0) {
            Iterator h = RoleCache.getCache().iterator();
            int i = 0;
            int j = 0;
            while (h.hasNext()) {
                RoleModel roleModel = (RoleModel)h.next();
                if (!SecurityUtil.hasRoleAssignSec((UserContext)this._me, (String)roleModel.getCategoryName()) || !PermAPIManager.getInstance().havingRoleInPermissionAssnList(roleModel.getId(), permissionId)) continue;
                isnull = false;
                PermissionAssnModel rolePermissionAssnModel = PermissionAssnCache.getRolePermissionAssnModel(roleModel.getId(), permissionId);
                sb.append("<td><input class='awsui-checkbox' type=checkbox name='chk").append(++i).append("' id='chk").append(i);
                sb.append("' value =").append(rolePermissionAssnModel.getId());
                sb.append(">&nbsp;<span><i class='awsui-iconfont' style='color:#555'>&#59048;</i></span>");
                sb.append(" <label class='awsui-checkbox-label' for='chk" + i).append("'>");
                sb.append(String.valueOf(roleModel.getCategoryName()) + "/" + roleModel.getName()).append("</label></td>\n");
                if ((j + 1) % 2 == 0) {
                    sb.append("</tr><tr>\n");
                }
                ++j;
            }
            List<PermissionAssnModel> orgroles = PermissionAssnCache.getOrgrolePermissionAssnList(permissionId);
            for (PermissionAssnModel orgrole : orgroles) {
                isnull = false;
                sb.append("<td><input class='awsui-checkbox' type=checkbox name='chk").append(++i).append("' id='chk").append(i);
                sb.append("' value =").append(orgrole.getId());
                sb.append(">&nbsp;<span><i class='awsui-iconfont' style='color:#555'>&#58958;</i></span>");
                sb.append(" <label class='awsui-checkbox-label' for='chk" + i).append("'>");
                sb.append(this.getOrgroleLable(orgrole.getAssignmentId())).append("</label></td>\n");
                if ((j + 1) % 2 == 0) {
                    sb.append("</tr><tr>\n");
                }
                ++j;
            }
            if (i % 2 != 0) {
                sb.append("<td></td>");
            }
            sb.append("</tr>\n");
        }
        sb.append("</table>");
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("isSuperMaster", String.valueOf(isSuperMaster));
        macroLibraries.put("security", sb.toString());
        macroLibraries.put("sid", sid);
        macroLibraries.put("isnull", isnull);
        macroLibraries.put("groupId", permissionId);
        macroLibraries.put("permissionName", sercurityGroupmodel.getPermissionName());
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.rolesecurity.htm", macroLibraries);
    }

    private String getOrgroleLable(String assignmentId) {
        String[] sss = assignmentId.split("\\|");
        String orgId = sss[0];
        String orgType = sss[1];
        String roleId = sss[2];
        StringBuilder sb = new StringBuilder();
        if (orgType.equals("c")) {
            CompanyModel c = CompanyCache.getModel((String)orgId);
            if (c != null) {
                sb.append(c.getName());
            } else {
                sb.append("\u516c\u53f8\uff1a" + orgId);
            }
        } else if (orgType.equals("d")) {
            DepartmentModel d = DepartmentCache.getModel((String)orgId);
            CompanyModel c = null;
            if (d != null) {
                c = CompanyCache.getModel((String)d.getCompanyId());
            }
            if (c != null) {
                sb.append(String.valueOf(c.getName()) + "//" + d.getPathNameOfCache());
            } else {
                sb.append("\u5355\u4f4d\uff1a" + orgId);
            }
        }
        RoleModel r = RoleCache.getModel((String)roleId);
        if (r != null) {
            sb.append("\uff0c" + r.getCategoryName() + Html.escape("<" + r.getName() + ">"));
        }
        return sb.toString();
    }

    public String removeRole(String groupId, String list) {
        ResponseObject responseObject = ResponseObject.newOkResponse();
        list = list.trim();
        UtilString myStr = new UtilString(list);
        List<String> myArray = myStr.split(" ");
        int i = 0;
        while (i < myArray.size()) {
            try {
                PermissionDaoFactory.createPermissionAssn().delete(myArray.get(i).toString());
                PermissionAssnCache.getCache().reload(true);
            }
            catch (Exception e) {
                responseObject.err("[" + myArray.get(i).toString() + "]\u5bfc\u81f4\u6570\u636e\u4e0d\u80fd\u5168\u90e8\u5220\u9664");
                e.printStackTrace();
                return responseObject.toString();
            }
            ++i;
        }
        responseObject.msg("\u5220\u9664\u6210\u529f");
        return responseObject.toString();
    }

    public static boolean isSecurityGroupUsed(String groupId) {
        for (RoleModel roleModel : RoleCache.getCache()) {
            if (!PermAPIManager.getInstance().havingRoleInPermissionAssnList(roleModel.getId(), groupId)) continue;
            return true;
        }
        return false;
    }
}

