/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.basic.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.basic.PermAPIManager;
import com.actionsoft.bpms.commons.security.basic.util.PermUtil;
import com.actionsoft.bpms.server.UserContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class UserSecurityTabWeb {
    private UserContext _me;
    public static final int PAGE_TYPE_SECURITYGROUP = 0;
    public static final int PAGE_TYPE_SECURITYLIST = 1;

    public UserSecurityTabWeb(UserContext me) {
        this._me = me;
    }

    public String getSecurityTree(String uid) {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        Iterator<NavigationSystemModel> systemList = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
        List<NavigationSystemModel> list = PermUtil.getNavigationSystemListByResort(systemList);
        systemList = list.iterator();
        JSONArray sysArray = new JSONArray();
        while (systemList.hasNext()) {
            NavigationSystemModel navigationSystemModel = systemList.next();
            if (!this._me.getUID().equals("admin") && NavigationUtil.isSystemNavigation(navigationSystemModel)) continue;
            String systemId = navigationSystemModel.getId();
            boolean systemChecked = PermAPIManager.getInstance().havingModelPermission(uid, systemId);
            if (!systemChecked) continue;
            JSONObject sysObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationSystemModel));
            JSONArray directoryArray = new JSONArray();
            List<NavigationDirectoryModel> directoryList = NavigationDirectoryCache.getListOfSystem(systemId);
            if (directoryList != null) {
                for (NavigationDirectoryModel navigationDirectoryModel : directoryList) {
                    String directoryId = navigationDirectoryModel.getId();
                    boolean directoryChecked = PermAPIManager.getInstance().havingModelPermission(uid, directoryId);
                    if (!directoryChecked) continue;
                    JSONObject directoryObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationDirectoryModel));
                    JSONArray functionArr = new JSONArray();
                    List<NavigationFunctionModel> functionList = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
                    if (functionList != null && functionList.size() > 0) {
                        for (NavigationFunctionModel navigationFunctionModel : functionList) {
                            boolean functionChecked = PermAPIManager.getInstance().havingModelPermission(uid, navigationFunctionModel.getId());
                            if (!functionChecked) continue;
                            JSONObject functionObject = JSONObject.parseObject((String)JSON.toJSONString((Object)navigationFunctionModel));
                            functionArr.add((Object)functionObject);
                        }
                        directoryObject.put("function", (Object)functionArr);
                    }
                    directoryArray.add((Object)directoryObject);
                }
                sysObject.put("directory", (Object)directoryArray);
            }
            sysArray.add((Object)sysObject);
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("navArr", sysArray);
        macroLibraries.put("sid", sid);
        macroLibraries.put("uid", uid);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.group.page.appmodel2.htm", macroLibraries);
    }
}

