/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.delegation;

import com.actionsoft.bpms.commons.security.delegation.DelegationCache;
import com.actionsoft.bpms.commons.security.delegation.model.DelegationModel;
import com.actionsoft.bpms.commons.security.delegation.util.DelegationDaoUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DelegationAPIManager {
    private static DelegationAPIManager _api = new DelegationAPIManager();

    private DelegationAPIManager() {
    }

    public static DelegationAPIManager getInstance() {
        return _api;
    }

    public void create(DelegationModel delegationModel) {
        DelegationDaoUtil.getInstance().create(delegationModel);
    }

    public void remove(String id) {
        DelegationDaoUtil.getInstance().remove(id);
    }

    public void changeDelegateUser(String id, String userIds) {
        DelegationDaoUtil.getInstance().changeDelegateUser(id, userIds);
    }

    public void changeEndtime(String id, Date endTime) {
        Timestamp tims = new Timestamp(endTime.getTime());
        DelegationDaoUtil.getInstance().changeEndtime(id, tims);
    }

    public DelegationModel getModel(String id) {
        return DelegationCache.getModel(id);
    }

    public List<DelegationModel> getListByApplicantUser(String userId) {
        return DelegationCache.getListByApplicantUser(userId);
    }

    public List<DelegationModel> getListOfValidByDelegateUser(String userId) {
        ArrayList<DelegationModel> list = new ArrayList<DelegationModel>();
        List<DelegationModel> listAll = DelegationCache.getListByDelegateUser(userId);
        long currentTime = System.currentTimeMillis();
        for (DelegationModel model : listAll) {
            if (model.getEndTime().getTime() <= currentTime) continue;
            list.add(model);
        }
        return list;
    }
}

