/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.delegation;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.security.delegation.model.DelegationModel;
import com.actionsoft.bpms.commons.security.delegation.util.DelegationDaoUtil;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DelegationCache
extends Cache<String, DelegationModel> {
    public DelegationCache(CachePluginProfile configuration) {
        super(configuration);
    }

    public static void putModel(DelegationModel model) {
        DelegationCache.getCache().put(model.getId(), model);
    }

    public static void removeModel(String id) {
        DelegationCache.getCache().remove(id);
    }

    public static DelegationModel getModel(String id) {
        return (DelegationModel)DelegationCache.getCache().get(id);
    }

    public static List<DelegationModel> getListByApplicantUser(String userId) {
        ArrayList<DelegationModel> list = new ArrayList<DelegationModel>();
        Iterator it = DelegationCache.getCache().iterator();
        while (it.hasNext()) {
            DelegationModel model = (DelegationModel)it.next();
            if (!model.getApplicantUser().equals(userId)) continue;
            list.add(model);
        }
        return list;
    }

    public static List<DelegationModel> getListByDelegateUser(String userId) {
        ArrayList<DelegationModel> list = new ArrayList<DelegationModel>();
        Iterator it = DelegationCache.getCache().iterator();
        while (it.hasNext()) {
            DelegationModel model = (DelegationModel)it.next();
            String matchStr = " " + model.getDelegateUser() + " ";
            if (matchStr.indexOf(" " + userId + " ") <= -1 && matchStr.indexOf(" " + userId + "<") <= -1) continue;
            list.add(model);
        }
        return list;
    }

    @Override
    public void load() {
        String pmpt = "Cache\u52a0\u8f7d\u7528\u6237\u4efb\u52a1\u59d4\u6258\u7533\u8bf7\u5b9e\u4f8b";
        List<DelegationModel> _list = DelegationDaoUtil.getInstance().getList();
        if (_list != null) {
            for (DelegationModel model : _list) {
                DelegationCache.getCache().put(model.getId(), model, false);
            }
        }
        pmpt = String.valueOf(pmpt) + " [" + (_list == null ? 0 : _list.size()) + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(pmpt);
    }

    public static DelegationCache getCache() {
        return CacheManager.getCache(DelegationCache.class);
    }
}

