/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.delegation.util;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.security.delegation.DelegationCache;
import com.actionsoft.bpms.commons.security.delegation.model.DelegationModel;
import com.actionsoft.bpms.commons.security.delegation.model.DelegationScopeModel;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.sdk.local.SDK;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;

public class DelegationDaoUtil {
    private static DelegationDaoUtil dao = new DelegationDaoUtil();

    private DelegationDaoUtil() {
    }

    public static DelegationDaoUtil getInstance() {
        return dao;
    }

    public void create(DelegationModel delegationModel) {
        if ((delegationModel.getScopeType().equals("1") || delegationModel.getScopeType().equals("2")) && delegationModel.getScope().isEmpty()) {
            throw new AWSIllegalArgumentException("scope", "EMPT");
        }
        for (DelegationScopeModel scoepModel : delegationModel.getScope()) {
            if (UtilString.isEmpty(scoepModel.getResourceId())) {
                throw new AWSIllegalArgumentException("resourceId", "EMPT");
            }
            if (!UtilString.isEmpty(scoepModel.getResourceType())) continue;
            throw new AWSIllegalArgumentException("resourceType", "EMPT");
        }
        if (UtilString.isEmpty(delegationModel.getApplicantUser())) {
            throw new AWSIllegalArgumentException("applicantUser", "EMPT");
        }
        UserModel user = UserCache.getModel((String)delegationModel.getApplicantUser());
        if (user == null) {
            throw new AWSIllegalArgumentException("applicantUser", "FORMAT");
        }
        if (UtilString.isEmpty(delegationModel.getDelegateUser())) {
            throw new AWSIllegalArgumentException("delegateUser", "EMPT");
        }
        user = UserCache.getModel((String)SDK.getORGAPI().getUserIds(delegationModel.getDelegateUser()));
        if (user == null) {
            throw new AWSIllegalArgumentException("delegateUser", "FORMAT");
        }
        if (delegationModel.getBeginTime() == null) {
            throw new AWSIllegalArgumentException("beginTime", "EMPT");
        }
        if (delegationModel.getEndTime() == null) {
            throw new AWSIllegalArgumentException("endTime", "EMPT");
        }
        if (delegationModel.getBeginTime().getTime() >= delegationModel.getEndTime().getTime()) {
            throw new AWSIllegalArgumentException("beginTime", "FORMAT");
        }
        delegationModel.setId(UUIDGener.getUUID());
        delegationModel.setCreateTime(new Timestamp(System.currentTimeMillis()));
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("ID", delegationModel.getId());
        vars.put("APPLICANTUSER", delegationModel.getApplicantUser());
        vars.put("DELEGATEUSER", delegationModel.getDelegateUser());
        vars.put("SCOPETYPE", delegationModel.getScopeType());
        vars.put("DELEGATEREASON", delegationModel.getDelegateReason());
        vars.put("BEGINTIME", delegationModel.getBeginTime());
        vars.put("ENDTIME", delegationModel.getEndTime());
        vars.put("CREATETIME", delegationModel.getCreateTime());
        vars.put("PROCESSINSTID", delegationModel.getProcessInstId());
        Connection conn = null;
        try {
            try {
                conn = DBSql.open();
                conn.setAutoCommit(false);
                DBSql.update(conn, "INSERT INTO SYS_DELEGATION(ID,APPLICANTUSER,DELEGATEUSER,SCOPETYPE,DELEGATEREASON,BEGINTIME,ENDTIME,CREATETIME,PROCESSINSTID) VALUES(:ID,:APPLICANTUSER,:DELEGATEUSER,:SCOPETYPE,:DELEGATEREASON,:BEGINTIME,:ENDTIME,:CREATETIME,:PROCESSINSTID)", vars);
                if (!delegationModel.getScope().isEmpty()) {
                    for (DelegationScopeModel scoepModel : delegationModel.getScope()) {
                        scoepModel.setId(UUIDGener.getUUID());
                        vars = new HashMap();
                        vars.put("ID", scoepModel.getId());
                        vars.put("PID", delegationModel.getId());
                        vars.put("RESOURCETYPE", scoepModel.getResourceType());
                        vars.put("RESOURCEID", scoepModel.getResourceId());
                        DBSql.update(conn, "INSERT INTO SYS_DELEGATIONSCOPE(ID,PID,RESOURCETYPE,RESOURCEID) VALUES(:ID,:PID,:RESOURCETYPE,:RESOURCEID)", vars);
                    }
                }
                conn.commit();
                DelegationCache.putModel(delegationModel);
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                }
                catch (Exception ee) {
                    throw new AWSDataAccessException(ee);
                }
                throw new AWSDataAccessException(e);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (Exception e) {
                    throw new AWSDataAccessException(e);
                }
            }
            DBSql.close(conn);
        }
    }

    public void changeDelegateUser(String id, String userIds) {
        if (UtilString.isEmpty(id)) {
            throw new AWSIllegalArgumentException("id", "NULL");
        }
        if (userIds == null || userIds.isEmpty()) {
            throw new AWSIllegalArgumentException("userIds", "EMPT");
        }
        String not = SDK.getORGAPI().validateUsers(userIds);
        if (!UtilString.isEmpty(not)) {
            throw new AWSIllegalArgumentException("\u8d26\u6237\u4e0d\u5408\u6cd5:" + not);
        }
        userIds = SDK.getORGAPI().getUserIds(userIds);
        DelegationModel delegationModel = DelegationCache.getModel(id);
        if (delegationModel == null) {
            throw new AWSIllegalArgumentException("[" + id + "]\u5bf9\u5e94\u7684\u59d4\u6258\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("ID", id);
        vars.put("DELEGATEUSER", userIds.trim());
        DBSql.update("UPDATE SYS_DELEGATION SET DELEGATEUSER=:DELEGATEUSER WHERE ID=:ID", vars);
        if (delegationModel != null) {
            delegationModel.setDelegateUser(userIds);
        }
        DelegationCache.putModel(delegationModel);
    }

    public void changeEndtime(String id, Timestamp endTime) {
        if (endTime == null) {
            throw new AWSIllegalArgumentException("endTime", "NULL");
        }
        if (UtilString.isEmpty(id)) {
            throw new AWSIllegalArgumentException("id", "NULL");
        }
        DelegationModel delegationModel = DelegationCache.getModel(id);
        if (delegationModel == null) {
            throw new AWSIllegalArgumentException("[" + id + "]\u5bf9\u5e94\u7684\u59d4\u6258\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("ID", id);
        vars.put("ENDTIME", endTime);
        DBSql.update("UPDATE SYS_DELEGATION SET ENDTIME=:ENDTIME WHERE ID=:ID", vars);
        delegationModel.setEndTime(endTime);
        DelegationCache.putModel(delegationModel);
    }

    public void remove(String id) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("ID", id);
        DBSql.update("DELETE FROM SYS_DELEGATION WHERE ID=:ID", vars);
        DBSql.update("DELETE FROM SYS_DELEGATIONSCOPE WHERE PID=:ID", vars);
        DelegationCache.removeModel(id);
    }

    public List<DelegationModel> getList() {
        List<DelegationModel> list = null;
        list = DBSql.query("SELECT * FROM SYS_DELEGATION ORDER BY CREATETIME DESC", new RowMapper<DelegationModel>(){

            public DelegationModel mapRow(ResultSet rset, int arg1) throws SQLException {
                DelegationModel model = new DelegationModel();
                model.setId(rset.getString("ID"));
                model.setApplicantUser(rset.getString("APPLICANTUSER"));
                model.setDelegateUser(rset.getString("DELEGATEUSER"));
                model.setScopeType(rset.getString("SCOPETYPE"));
                model.setDelegateReason(rset.getString("DELEGATEREASON"));
                model.setBeginTime(rset.getTimestamp("BEGINTIME"));
                model.setEndTime(rset.getTimestamp("ENDTIME"));
                model.setCreateTime(rset.getTimestamp("CREATETIME"));
                model.setProcessInstId(rset.getString("PROCESSINSTID"));
                return model;
            }
        }, new Object[0]);
        for (DelegationModel delegationModel : list) {
            if (delegationModel.getScopeType().equals("0")) continue;
            List<DelegationScopeModel> scopeList = DBSql.query("SELECT * FROM SYS_DELEGATIONSCOPE WHERE PID=?", new RowMapper<DelegationScopeModel>(){

                public DelegationScopeModel mapRow(ResultSet rset, int arg1) throws SQLException {
                    DelegationScopeModel model = new DelegationScopeModel();
                    model.setId(rset.getString("ID"));
                    model.setResourceType(rset.getString("RESOURCETYPE"));
                    model.setResourceId(rset.getString("RESOURCEID"));
                    return model;
                }
            }, delegationModel.getId());
            delegationModel.setScope(scopeList);
        }
        return list;
    }
}

