/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.high;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppTeam;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.log.auditing.Auditor;
import com.actionsoft.bpms.commons.log.auditing.model.AuditConfModel;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.model.CompanyACCM;
import com.actionsoft.bpms.commons.security.ac.model.NavACCM;
import com.actionsoft.bpms.commons.security.ac.web.AccessControlWeb;
import com.actionsoft.bpms.commons.security.high.model.HighSecurityModel;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AppContainerException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class HighSecurity {
    private static HighSecurityModel tpModel = null;
    private static final String xml = "conf/aws-high-security.xml";

    static {
        HighSecurity.load3PConfig();
    }

    public static HighSecurityModel getSecModel() {
        return tpModel;
    }

    public static void setSecModel(HighSecurityModel model) {
        tpModel = model;
    }

    private static boolean checkNull(String s, String group) {
        if (s == null || "".equals(s)) {
            HighSecurity.printMsg("\u4e09\u5458\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a" + group + "\u6307\u5b9aAWS\u8d26\u6237!!!");
            return false;
        }
        return true;
    }

    public static boolean checkHighSecurityConfig() {
        if (!HighSecurity.isON()) {
            HighSecurity.activeAdmin();
            return true;
        }
        if (!HighSecurity.checkNull(tpModel.getSysAdmin(), "\u7cfb\u7edf\u7ba1\u7406\u5458")) {
            return false;
        }
        if (!HighSecurity.checkNull(tpModel.getSecAdmin(), "\u5b89\u5168\u4fdd\u5bc6\u5458")) {
            return false;
        }
        if (!HighSecurity.checkNull(tpModel.getAuditor(), "\u7cfb\u7edf\u5ba1\u8ba1\u5458")) {
            return false;
        }
        String[] ss = tpModel.getSysAdmin().split(" ");
        String[] cs = tpModel.getSecAdmin().split(" ");
        String[] as = tpModel.getAuditor().split(" ");
        HashSet<String> s = new HashSet<String>();
        s.addAll(Arrays.asList(ss));
        s.addAll(Arrays.asList(cs));
        s.addAll(Arrays.asList(as));
        if (s.size() == ss.length + cs.length + as.length) {
            System.out.println("***************************************************************");
            System.out.println("AWS\u4ee5\u4e09\u5458\u5b89\u5168\u4fdd\u5bc6\u63a7\u5236\u6a21\u5f0f\u8fd0\u884c");
            System.out.println("***************************************************************");
            HighSecurity.deActiveAdmin();
            return true;
        }
        HighSecurity.printMsg("\u4e09\u5458\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u76f8\u5e94\u89d2\u8272AWS\u8d26\u6237\u4e0d\u80fd\u91cd\u590d!!!");
        return false;
    }

    public static void initUser() {
        String teamId = String.valueOf(AppPlatformConfig.awsteam) + "Security";
        AuditConfModel conf = Auditor.getLgConf();
        if (tpModel.isON()) {
            HighSecurity.initDefaultUser(tpModel.getAuditor());
            HighSecurity.initDefaultUser(tpModel.getSecAdmin());
            HighSecurity.initDefaultUser(tpModel.getSysAdmin());
            HighSecurity.initDerivativeUser();
            AppTeam team = AppPlatformConfig.getAppTeamById((String)teamId);
            if (team == null) {
                team = new AppTeam();
                team.setAppsPermissions(HighSecurity.getAppsPermissions());
                team.setDesc("AWS\u4e09\u5458\u9ed8\u8ba4\u7ec4");
                team.setName("AWS Security Team1");
                team.setValid(true);
                team.setId(teamId);
                AppPlatformConfig.addTeam((AppTeam)team);
            }
            HighSecurity.addMemberByTeam(team, tpModel.getAuditor());
            HighSecurity.addMemberByTeam(team, tpModel.getSecAdmin());
            HighSecurity.addMemberByTeam(team, tpModel.getSysAdmin());
            AppPlatformConfig.modifyTeam((AppTeam)team);
            if (conf != null) {
                conf.setDao(true);
            }
        } else {
            AppPlatformConfig.removeTeam((String)teamId);
        }
    }

    private static void addMemberByTeam(AppTeam team, String users) {
        String[] usersArray;
        String[] stringArray = usersArray = users.split(" ");
        int n = usersArray.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            if (!team.getMembers().contains(user)) {
                team.getMembers().add(user);
            }
            ++n2;
        }
    }

    private static List<AppContext> getApps() {
        List<Object> installApps = new ArrayList();
        try {
            installApps = AMCUtil.queryAllAppsList();
        }
        catch (AppContainerException e) {
            e.printStackTrace();
        }
        ArrayList<AppContext> list = new ArrayList<AppContext>();
        for (AppContext appContext : installApps) {
            list.add(appContext);
        }
        return list;
    }

    private static Map<String, String> getAppsPermissions() {
        HashMap<String, String> appsPermissions = new HashMap<String, String>();
        List<AppContext> list = HighSecurity.getApps();
        int i = 0;
        while (i < list.size()) {
            AppContext app = list.get(i);
            appsPermissions.put(app.getId(), "AB");
            ++i;
        }
        return appsPermissions;
    }

    private static void printMsg(String s) {
        System.out.println(" ");
        System.out.println(s);
        System.err.println(s);
    }

    public static boolean checkBPMCmdAccess(UserContext me, String cmd) {
        if (!HighSecurity.isON() || !HighSecurity.is3pCmd(cmd)) {
            return true;
        }
        boolean chk = HighSecurity.is3PSysAdmin(me) && HighSecurity.hasAc(tpModel.getSysCmd(), cmd);
        chk = chk || HighSecurity.is3PSecAdmin(me) && HighSecurity.hasAc(tpModel.getSecCmd(), cmd);
        boolean bl = chk = chk || HighSecurity.is3PAuditor(me) && HighSecurity.hasAc(tpModel.getAuditorCmd(), cmd);
        if (!chk) {
            SDK.getLogAPI().unauthorizedAccess(me, "\u8d8a\u6743\u8bbf\u95ee\u4e09\u5458\u4fdd\u62a4\u529f\u80fd");
        }
        return chk;
    }

    public static void addNavSysAdministrator(UserContext uc, String rid) {
        if (!"admin".equals(uc.getUID())) {
            AccessControlWeb web = new AccessControlWeb(uc);
            String resourceId = rid;
            String tableName = NavACCM.resourceType;
            int accessMode = NavACCM.MANAGER.getType();
            String acOrg = String.valueOf(uc.getUserModel().getUID()) + "|user";
            try {
                web.appendACResource(resourceId, tableName, acOrg, accessMode, uc.getCompanyModel().getId(), 0, "Console");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addCompanyAdministrator(UserContext uc, String rid) {
        if (!"admin".equals(uc.getUID())) {
            AccessControlWeb web = new AccessControlWeb(uc);
            String resourceId = rid;
            String resourceType = CompanyACCM.resourceType;
            int type = CompanyACCM.VISIT.getType();
            String acOrg = String.valueOf(uc.getUserModel().getUID()) + "|user";
            web.appendACResource(resourceId, resourceType, acOrg, type, uc.getCompanyModel().getId(), 0, "Console");
        }
    }

    public static boolean checkBPMMenuAccess(String uid, String menuId) {
        boolean access = HighSecurity.checkBPMMenuAccessInner(uid, menuId);
        return access;
    }

    private static boolean checkBPMMenuAccessInner(String uid, String menuId) {
        if ("obj_2376d8ca158247eabbf717c61a9fa797".equals(menuId) && (HighSecurity.isDerivativeSysAdmin(uid) || HighSecurity.isDerivativeAuditor(uid) || HighSecurity.isDerivativeSecAdmin(uid))) {
            return false;
        }
        if (HighSecurity.is3PSysAdmin(uid)) {
            return HighSecurity.hasAc(tpModel.getSysAdminMenu(), menuId);
        }
        if (HighSecurity.is3PSecAdmin(uid)) {
            return HighSecurity.hasAc(tpModel.getSecAdminMenu(), menuId);
        }
        if (HighSecurity.is3PAuditor(uid)) {
            return HighSecurity.hasAc(tpModel.getAuditorMenu(), menuId);
        }
        return false;
    }

    public static boolean hasAc(String s, String s1) {
        return (String.valueOf(' ') + s + ' ').indexOf(String.valueOf(' ') + s1 + ' ') != -1;
    }

    private static boolean activeAdmin() {
        String sql = "UPDATE ORGUSER SET CLOSED=0 WHERE USERID='admin' AND CLOSED=1";
        DBSql.update(sql);
        return true;
    }

    private static boolean deActiveAdmin() {
        String sql = "UPDATE ORGUSER set CLOSED=1 WHERE USERID='admin' AND CLOSED=0";
        DBSql.update(sql);
        return true;
    }

    private static boolean is3PSysAdmin(UserModel model) {
        return model != null && HighSecurity.is3PSysAdmin(model.getUID());
    }

    private static boolean is3PSecAdmin(UserModel model) {
        return model != null && HighSecurity.is3PSecAdmin(model.getUID());
    }

    private static boolean is3PAuditor(UserModel model) {
        return model != null && HighSecurity.is3PAuditor(model.getUID());
    }

    public static boolean is3PSysAdmin(UserContext uc) {
        return uc != null && HighSecurity.is3PSysAdmin(uc.getUserModel());
    }

    public static boolean is3PSecAdmin(UserContext uc) {
        return uc != null && HighSecurity.is3PSecAdmin(uc.getUserModel());
    }

    public static boolean is3PAuditor(UserContext uc) {
        return uc != null && HighSecurity.is3PAuditor(uc.getUserModel());
    }

    public static boolean is3pMenu(String menuId) {
        return HighSecurity.hasAc(tpModel.getSysAdminMenu(), menuId) || HighSecurity.hasAc(tpModel.getSecAdminMenu(), menuId) || HighSecurity.hasAc(tpModel.getAuditorMenu(), menuId);
    }

    private static boolean is3pCmd(String cmd) {
        return HighSecurity.hasAc(tpModel.getSysCmd(), cmd) || HighSecurity.hasAc(tpModel.getSecCmd(), cmd) || HighSecurity.hasAc(tpModel.getAuditorCmd(), cmd);
    }

    public static boolean is3pRole(String uid) {
        return HighSecurity.is3PSysAdmin(uid) || HighSecurity.is3PSecAdmin(uid) || HighSecurity.is3PAuditor(uid);
    }

    public static boolean isDerivativeSysAdmin(String uid) {
        return HighSecurity.hasAc(tpModel.getDerivativeSysAdmin(), uid);
    }

    public static boolean isOriginalSysAdmin(String uid) {
        return HighSecurity.hasAc(tpModel.getSysAdmin(), uid);
    }

    public static boolean is3PSysAdmin(String uid) {
        return HighSecurity.isOriginalSysAdmin(uid) || HighSecurity.isDerivativeSysAdmin(uid);
    }

    public static boolean isDerivativeSecAdmin(String uid) {
        return HighSecurity.hasAc(tpModel.getDerivativeSecAdmin(), uid);
    }

    public static boolean isOriginalSecAdmin(String uid) {
        return HighSecurity.hasAc(tpModel.getSecAdmin(), uid);
    }

    public static boolean is3PSecAdmin(String uid) {
        return HighSecurity.isOriginalSecAdmin(uid) || HighSecurity.isDerivativeSecAdmin(uid);
    }

    public static boolean isDerivativeAuditor(String uid) {
        return HighSecurity.hasAc(tpModel.getDerivativeAuditor(), uid);
    }

    public static boolean isOriginalAuditor(String uid) {
        return HighSecurity.hasAc(tpModel.getAuditor(), uid);
    }

    public static boolean is3PAuditor(String uid) {
        return HighSecurity.isOriginalAuditor(uid) || HighSecurity.isDerivativeAuditor(uid);
    }

    private static void load3PConfig() {
        if (tpModel == null) {
            tpModel = new HighSecurityModel();
        }
        SAXReader saxreader = new SAXReader();
        try {
            String accessWarningTime;
            Document doc = saxreader.read(xml);
            Element el = (Element)doc.getRootElement().selectSingleNode("/AWSHighSecurity/SecurityPlugs");
            tpModel.setON("on".equalsIgnoreCase(el.attributeValue("service")));
            tpModel.setSecurityLevel("on".equalsIgnoreCase(el.attributeValue("securityLevel")));
            tpModel.setSysAdmin(HighSecurity.getElementText(el.selectSingleNode("sysadmin/uids")));
            tpModel.setSysAdminMenu(HighSecurity.getElementText(el.selectSingleNode("sysadmin/accessmenu")));
            tpModel.setSysCmd(HighSecurity.getElementText(el.selectSingleNode("sysadmin/accesscmd")));
            tpModel.setSecAdmin(HighSecurity.getElementText(el.selectSingleNode("secadmin/uids")));
            tpModel.setSecAdminMenu(HighSecurity.getElementText(el.selectSingleNode("secadmin/accessmenu")));
            tpModel.setSecCmd(HighSecurity.getElementText(el.selectSingleNode("secadmin/accesscmd")));
            tpModel.setAuditor(HighSecurity.getElementText(el.selectSingleNode("auditor/uids")));
            tpModel.setAuditorMenu(HighSecurity.getElementText(el.selectSingleNode("auditor/accessmenu")));
            tpModel.setAuditorCmd(HighSecurity.getElementText(el.selectSingleNode("auditor/accesscmd")));
            tpModel.setLevel0MinLength(HighSecurity.getElementText(el.selectSingleNode("pwd/level0MinLength")));
            tpModel.setLevel1MinLength(HighSecurity.getElementText(el.selectSingleNode("pwd/level1MinLength")));
            tpModel.setLevel2MinLength(HighSecurity.getElementText(el.selectSingleNode("pwd/level2MinLength")));
            tpModel.setLevel3MinLength(HighSecurity.getElementText(el.selectSingleNode("pwd/level3MinLength")));
            tpModel.setLevel0Cycle(HighSecurity.getElementText(el.selectSingleNode("pwd/level0Cycle")));
            tpModel.setLevel1Cycle(HighSecurity.getElementText(el.selectSingleNode("pwd/level1Cycle")));
            tpModel.setLevel2Cycle(HighSecurity.getElementText(el.selectSingleNode("pwd/level2Cycle")));
            tpModel.setLevel3Cycle(HighSecurity.getElementText(el.selectSingleNode("pwd/level3Cycle")));
            tpModel.setComplexityRegular(HighSecurity.getElementText(el.selectSingleNode("pwd/complexityRegular")));
            String s0 = HighSecurity.getElementText(el.selectSingleNode("retentionTime/s0"));
            String s1 = HighSecurity.getElementText(el.selectSingleNode("retentionTime/s1"));
            String s2 = HighSecurity.getElementText(el.selectSingleNode("retentionTime/s2"));
            if (UtilString.isNotEmpty(s0) && s0.matches("[0-9]+") && Integer.parseInt(s0) > 0) {
                tpModel.setS0(Integer.parseInt(s0));
            }
            if (UtilString.isNotEmpty(s1) && s1.matches("[0-9]+") && Integer.parseInt(s1) > 0) {
                tpModel.setS1(Integer.parseInt(s1));
            }
            if (UtilString.isNotEmpty(s2) && s2.matches("[0-9]+") && Integer.parseInt(s2) > 0) {
                tpModel.setS2(Integer.parseInt(s2));
            }
            if (UtilString.isNotEmpty(accessWarningTime = HighSecurity.getElementText(el.selectSingleNode("accessWarningTime"))) && accessWarningTime.matches("[0-9]+") && Integer.parseInt(accessWarningTime) > 0) {
                tpModel.setAccessWarningTime(Integer.parseInt(accessWarningTime));
            }
            tpModel.setUserDefaultRole(HighSecurity.getElementText(el.selectSingleNode("userDefaultRole")));
            Element properties = (Element)el.selectSingleNode("properties");
            Iterator iter2 = properties.elementIterator();
            while (iter2.hasNext()) {
                Element property = (Element)iter2.next();
                String name = property.attributeValue("name");
                String value = property.getTextTrim();
                HighSecurityModel.getProperties().put(name.trim().toUpperCase(), value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void store() throws Exception {
        SAXReader saxreader = new SAXReader();
        Document doc = saxreader.read(new File(xml));
        Element el = (Element)doc.getRootElement().selectSingleNode("/AWSHighSecurity/SecurityPlugs");
        HighSecurity.setElementText(el, "//sysadmin/uids", tpModel.getSysAdmin());
        HighSecurity.setElementText(el, "//sysadmin/accessmenu", tpModel.getSysAdminMenu());
        HighSecurity.setElementText(el, "//sysadmin/accesscmd", tpModel.getSysCmd());
        HighSecurity.setElementText(el, "//secadmin/uids", tpModel.getSecAdmin());
        HighSecurity.setElementText(el, "//secadmin/accessmenu", tpModel.getSecAdminMenu());
        HighSecurity.setElementText(el, "//secadmin/accesscmd", tpModel.getSecCmd());
        HighSecurity.setElementText(el, "//auditor/uids", tpModel.getAuditor());
        HighSecurity.setElementText(el, "//auditor/accessmenu", tpModel.getAuditorMenu());
        HighSecurity.setElementText(el, "//auditor/accesscmd", tpModel.getAuditorCmd());
        HighSecurity.setElementText(el, "//pwd/level0MinLength", tpModel.getLevel0MinLength());
        HighSecurity.setElementText(el, "//pwd/level1MinLength", tpModel.getLevel1MinLength());
        HighSecurity.setElementText(el, "//pwd/level2MinLength", tpModel.getLevel2MinLength());
        HighSecurity.setElementText(el, "//pwd/level3MinLength", tpModel.getLevel3MinLength());
        HighSecurity.setElementText(el, "//pwd/level0Cycle", tpModel.getLevel0Cycle());
        HighSecurity.setElementText(el, "//pwd/level1Cycle", tpModel.getLevel1Cycle());
        HighSecurity.setElementText(el, "//pwd/level2Cycle", tpModel.getLevel2Cycle());
        HighSecurity.setElementText(el, "//pwd/level3Cycle", tpModel.getLevel3Cycle());
        HighSecurity.setElementText(el, "//pwd/complexityRegular", tpModel.getComplexityRegular());
        HighSecurity.setElementText(el, "//retentionTime/s0", String.valueOf(tpModel.getComplexityRegular()));
        HighSecurity.setElementText(el, "//retentionTime/s1", String.valueOf(tpModel.getComplexityRegular()));
        HighSecurity.setElementText(el, "//retentionTime/s2", String.valueOf(tpModel.getComplexityRegular()));
        HighSecurity.setElementText(el, "//accessWarningTime", "" + tpModel.getAccessWarningTime());
        HighSecurity.setElementText(el, "//userDefaultRole", tpModel.getUserDefaultRole());
        el.attribute("service").setText(tpModel.isON() ? "on" : "off");
        el.attribute("securityLevel").setText(tpModel.isSecurityLevel() ? "on" : "off");
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((OutputStream)new FileOutputStream(new File(xml)), format);
            writer.write(doc);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isON() {
        return tpModel.isON();
    }

    public static boolean isSecurityLevel() {
        return tpModel.isSecurityLevel();
    }

    public static boolean hasSecurityLevel(String uid, String processInstId) {
        if (HighSecurity.isSecurityLevel()) {
            return HighSecurity.hasSecurityLevel(UserCache.getModel((String)uid), SDK.getProcessAPI().getInstanceById(processInstId));
        }
        return true;
    }

    public static boolean hasSecurityLevel(String uid, ProcessInstance processInstance) {
        if (HighSecurity.isSecurityLevel()) {
            return HighSecurity.hasSecurityLevel(UserCache.getModel((String)uid), processInstance);
        }
        return true;
    }

    public static boolean hasSecurityLevel(UserModel model, ProcessInstance processInstance) {
        if (HighSecurity.isSecurityLevel()) {
            HighSecurity.hasSecurityLevel(model, HighSecurity.getSecurityLevelByProcessInstance(processInstance));
        }
        return true;
    }

    public static int getSecurityLevelByProcessInstance(ProcessInstance processInstance) {
        if (HighSecurity.isSecurityLevel()) {
            if (processInstance == null) {
                return -1;
            }
            ProcessDefinition pdf = (ProcessDefinition)ProcessDefCache.getInstance().get((Serializable)((Object)processInstance.getProcessDefId()));
            if (pdf != null && pdf.isSecurityLayer()) {
                return processInstance.getSecurityLayer();
            }
        }
        return -1;
    }

    public static boolean hasSecurityLevel(UserModel model, int securityLayer) {
        return model.getSecurityLevel() >= securityLayer;
    }

    private static void setElementText(Element root, String xp, String text) {
        Element el = (Element)root.selectSingleNode(xp);
        if (el != null) {
            el.setText(text);
        }
    }

    private static String getElementText(Node n) {
        if (n != null) {
            return ((Element)n).getTextTrim();
        }
        return "";
    }

    private static void initDefaultUser(String users) {
        if (users != null && !users.trim().equals("")) {
            UserModel admin = UserCache.getModel((String)"admin");
            if (admin == null) {
                return;
            }
            String deptId = admin.getDepartmentId();
            String roleId = admin.getRoleId();
            String password = AWSPortalConf.getSecurityPwdDefault();
            boolean isManager = false;
            JSONObject jo = JSONObject.parseObject((String)"{\"system1\":\"\u7cfb\u7edf\u7ba1\u7406\u54581\",\"system2\":\"\u7cfb\u7edf\u7ba1\u7406\u54582\",\"security1\":\"\u5b89\u5168\u4fdd\u5bc6\u7ba1\u7406\u54581\",\"security2\":\"\u5b89\u5168\u4fdd\u5bc6\u7ba1\u7406\u54582\",\"auditor1\":\"\u5b89\u5168\u5ba1\u8ba1\u54581\",\"auditor2\":\"\u5b89\u5168\u5ba1\u8ba1\u54582\"}");
            String[] stringArray = users.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String user = stringArray[n2];
                if (UserCache.getModel((String)user) == null) {
                    String userId = user;
                    String userName = jo.getString(user) == null ? user : jo.getString(user);
                    SDK.getORGAPI().createUser(deptId, userId, userName, roleId, password, isManager);
                }
                ++n2;
            }
        }
    }

    public static void initDerivativeUser() {
        JSONArray ldum = null;
        AppContext app = SDK.getAppAPI().getAppContext("com.actionsoft.apps.high.security");
        if (app != null && SDK.getAppAPI().isActive("com.actionsoft.apps.high.security")) {
            String aslp = "aslp://com.actionsoft.apps.high.security/queryDerivativeUser";
            ResponseObject ro = SDK.getAppAPI().callASLP(app, aslp, null);
            if (ro.isErr()) {
                return;
            }
            ldum = (JSONArray)ro.get("users");
        }
        if (ldum != null) {
            boolean aFirstFlag = true;
            boolean bFirstFlag = true;
            boolean cFirstFlag = true;
            StringBuilder auditor = new StringBuilder();
            StringBuilder secadmin = new StringBuilder();
            StringBuilder sysadmin = new StringBuilder();
            int i = 0;
            int size_i = ldum.size();
            while (i < size_i) {
                JSONObject dum = ldum.getJSONObject(i);
                String securityType = dum.getString("securityType");
                String userId = dum.getString("userId");
                if (securityType.equals("auditor")) {
                    if (aFirstFlag) {
                        auditor.append(userId);
                        aFirstFlag = false;
                    } else {
                        auditor.append(" ").append(userId);
                    }
                } else if (securityType.equals("secadmin")) {
                    if (bFirstFlag) {
                        secadmin.append(userId);
                        bFirstFlag = false;
                    } else {
                        secadmin.append(" ").append(userId);
                    }
                } else if (securityType.equals("sysadmin")) {
                    if (cFirstFlag) {
                        sysadmin.append(userId);
                        cFirstFlag = false;
                    } else {
                        sysadmin.append(" ").append(userId);
                    }
                }
                ++i;
            }
            tpModel.setDerivativeAuditor(auditor.toString());
            tpModel.setDerivativeSecAdmin(secadmin.toString());
            tpModel.setDerivativeSysAdmin(sysadmin.toString());
        }
    }

    public static void auditLog(UserContext context, String catalog, String op, String obj, String info, Level level) {
        HighSecurity.auditLog(context, catalog, context.getUID(), op, obj, info, level);
    }

    public static void auditLog(UserContext context, String catalog, String user, String op, String obj, String info, Level level) {
        if (HighSecurity.isON()) {
            SDK.getLogAPI().audit("SECURITY", catalog, user, op, obj, info, context != null ? context.getClientIP() : "", level);
        }
    }

    public static Integer getSaveDay(int level) {
        if (level == 0) {
            return tpModel.getS0();
        }
        if (level == 1) {
            return tpModel.getS1();
        }
        if (level == 2) {
            return tpModel.getS2();
        }
        return tpModel.getS0();
    }

    public static Integer getAccessWarningTime() {
        return tpModel.getAccessWarningTime();
    }

    public static String getUserDefaultRole() {
        return tpModel.getUserDefaultRole();
    }

    public static void warningAccessLog(String uid) {
        UserModel um;
        if (HighSecurity.isON() && HighSecurity.is3PSecAdmin(uid) && tpModel.getAccessWarningTime() > 0 && (um = UserCache.getModel((String)uid)) != null && !um.isClosed()) {
            long frequencyTime = tpModel.getAccessWarningTime() * 60 * 60 * 1000;
            HashMap<String, Object> mp = new HashMap<String, Object>();
            mp.put("OP", "access");
            mp.put("LOG_OBJECT", "\u5ba1\u8ba1\u65e5\u5fd7");
            mp.put("OP_USER", uid);
            Timestamp time = DBSql.getTimestamp("SELECT MAX(OP_TIME) AS MAXDATE FROM SYS_AUDIT_LOG  WHERE OP =:OP AND LOG_OBJECT = :LOG_OBJECT AND OP_USER = :OP_USER", "MAXDATE", mp);
            if (time != null && System.currentTimeMillis() - time.getTime() > frequencyTime) {
                SDK.getSLAAPI().throwAlarm(String.valueOf(um.getUserName()) + "<" + uid + ">" + I18nRes.findValue("_bpm.platform", "\u6307\u5b9a\u65f6\u95f4\u5185\u672a\u8bbf\u95ee\u65e5\u5fd7"), uid, 1, tpModel.getAccessWarningTime() + I18nRes.findValue("_bpm.platform", "\u5c0f\u65f6\u5185"), "", (double)(System.currentTimeMillis() - time.getTime()), "");
            }
        }
    }
}

