/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.high.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.high.model.HighSecurityModel;
import com.actionsoft.bpms.server.UserContext;
import java.util.HashMap;
import java.util.List;

public class HighSecurityWeb {
    private UserContext _me;
    private static final String ROLE1 = "1_";
    private static final String ROLE2 = "2_";
    private static final String ROLE3 = "3_";
    private static final String NAV1 = "1_";
    private static final String NAV2 = "2_";

    public HighSecurityWeb(UserContext me) {
        this._me = me;
    }

    public String SaveSetting(String state, String sys, String sec, String auditor, String chklist) {
        HighSecurityModel model = new HighSecurityModel();
        model.setAuditorMenu("20");
        model.setSecAdminMenu("20");
        model.setSysAdminMenu("20");
        model.setON("on".equals(state));
        model.setSysAdmin(sys);
        model.setSecAdmin(sec);
        model.setAuditor(auditor);
        String[] navs = chklist.trim().split(" ");
        int i = 0;
        while (i < navs.length) {
            String sysCmd;
            String menu;
            NavigationFunctionModel nf;
            NavigationDirectoryModel nd;
            String sub1;
            String menuId = "";
            String cmdId = "";
            if (navs[i].startsWith("1_")) {
                sub1 = navs[i].substring("1_".length());
                if (sub1.startsWith("1_")) {
                    menuId = sub1.substring("1_".length());
                    nd = NavigationDirectoryCache.getModel(menuId);
                    if (nd != null) {
                        cmdId = HighSecurityWeb.parseCmd(nd.getLinkUrl());
                    }
                } else {
                    menuId = sub1.substring("2_".length());
                    nf = NavigationFunctionCache.getModel(menuId);
                    if (nf != null) {
                        cmdId = HighSecurityWeb.parseCmd(nf.getLinkUrl());
                    }
                }
                menu = model.getSysAdminMenu();
                if (menuId.length() > 0) {
                    model.setSysAdminMenu(menu.length() > 0 ? String.valueOf(menu) + " " + menuId : menuId);
                }
                sysCmd = model.getSysCmd();
                if (cmdId.length() > 0) {
                    model.setSysCmd(sysCmd.length() > 0 ? String.valueOf(sysCmd) + " " + cmdId : cmdId);
                }
            } else if (navs[i].startsWith("2_")) {
                sub1 = navs[i].substring("2_".length());
                if (sub1.startsWith("1_")) {
                    menuId = sub1.substring("1_".length());
                    nd = NavigationDirectoryCache.getModel(menuId);
                    if (nd != null) {
                        cmdId = HighSecurityWeb.parseCmd(nd.getLinkUrl());
                    }
                } else {
                    menuId = sub1.substring("2_".length());
                    nf = NavigationFunctionCache.getModel(menuId);
                    if (nf != null) {
                        cmdId = HighSecurityWeb.parseCmd(nf.getLinkUrl());
                    }
                }
                menu = model.getSecAdminMenu();
                if (menuId.length() > 0) {
                    model.setSecAdminMenu(menu.length() > 0 ? String.valueOf(menu) + " " + menuId : menuId);
                }
                sysCmd = model.getSecCmd();
                if (cmdId.length() > 0) {
                    model.setSecCmd(sysCmd.length() > 0 ? String.valueOf(sysCmd) + " " + cmdId : cmdId);
                }
            } else if (navs[i].startsWith(ROLE3)) {
                sub1 = navs[i].substring(ROLE3.length());
                if (sub1.startsWith("1_")) {
                    menuId = sub1.substring("1_".length());
                    nd = NavigationDirectoryCache.getModel(menuId);
                    if (nd != null) {
                        cmdId = HighSecurityWeb.parseCmd(nd.getLinkUrl());
                    }
                } else {
                    menuId = sub1.substring("2_".length());
                    nf = NavigationFunctionCache.getModel(menuId);
                    if (nf != null) {
                        cmdId = HighSecurityWeb.parseCmd(nf.getLinkUrl());
                    }
                }
                menu = model.getAuditorMenu();
                if (menuId.length() > 0) {
                    model.setAuditorMenu(menu.length() > 0 ? String.valueOf(menu) + " " + menuId : menuId);
                }
                sysCmd = model.getAuditorCmd();
                if (cmdId.length() > 0) {
                    model.setAuditorCmd(sysCmd.length() > 0 ? String.valueOf(sysCmd) + " " + cmdId : cmdId);
                }
            }
            ++i;
        }
        HighSecurityModel old = HighSecurity.getSecModel();
        ResponseObject r = ResponseObject.newOkResponse();
        try {
            HighSecurity.setSecModel(model);
            HighSecurity.store();
        }
        catch (Exception e) {
            HighSecurity.setSecModel(old);
            e.printStackTrace(System.err);
            r.err();
            r.msg("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u68c0\u67e5\u65e5\u5fd7");
            return r.toString();
        }
        return r.toString();
    }

    private static String parseCmd(String url) {
        if (url != null && url.indexOf(63) != -1) {
            String[] ss = url.substring(url.indexOf(63) + 1).split("&");
            int i = 0;
            while (i < ss.length) {
                if (ss[i].split("=")[0].equals("cmd")) {
                    return ss[i].split("=")[1];
                }
                ++i;
            }
        }
        return "";
    }

    public String getSetting() {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr>");
        sb.append("<td>\u7cfb\u7edf\u7ba1\u7406\u5458</td>");
        sb.append("<td><textarea  rows=6 COLS=32 name='sysadmin' readOnly>" + HighSecurity.getSecModel().getSysAdmin() + "</textarea>" + this.getUserSelect("sysadmin") + "</td>");
        sb.append("<td>" + this.getBPMMenu(HighSecurity.getSecModel().getSysAdminMenu(), "1_") + "</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>\u5b89\u5168\u4fdd\u5bc6\u5458</td>");
        sb.append("<td><textarea id='secadmin' rows=6 COLS=32 name='secadmin' readOnly>" + HighSecurity.getSecModel().getSecAdmin() + "</textarea>" + this.getUserSelect("secadmin") + "</td>");
        sb.append("<td>" + this.getBPMMenu(HighSecurity.getSecModel().getSecAdminMenu(), "2_") + "</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>\u7cfb\u7edf\u5ba1\u8ba1\u5458</td>");
        sb.append("<td><textarea id='auditor' rows=6 COLS=32 name='auditor' readOnly>" + HighSecurity.getSecModel().getAuditor() + "</textarea>" + this.getUserSelect("auditor") + "</td>");
        sb.append("<td>" + this.getBPMMenu(HighSecurity.getSecModel().getAuditorMenu(), ROLE3) + "</td>");
        sb.append("</tr>");
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("userlist", sb.toString());
        macroLibraries.put("sid", this._me.getSessionId());
        macroLibraries.put("secState", "<span class='awsui-ux-title' style='vertical-align:inherit;'>\u4e09\u5458\u72b6\u6001</span>&nbsp;<select name='state' class='awsui-select'><option value='on' " + (HighSecurity.getSecModel().isON() ? "selected" : "") + ">\u542f\u7528</option><option value='off' " + (HighSecurity.getSecModel().isON() ? "" : "selected") + ">\u5173\u95ed</option></select>");
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.sec.tools.3p.home.htm", macroLibraries);
    }

    private String getUserSelect(String s) {
        return "&nbsp;<input type=button class='button blue' value='\u9009\u62e9' onClick=\"openmailtree('" + s + "');\" border='0'><input type=button value='\u6e05\u7a7a' onClick=\"frmMain." + s + ".value='';\" class='button green' border='0'>";
    }

    private String getBPMMenu(String list, String prefix) {
        StringBuilder sb = new StringBuilder();
        List<NavigationDirectoryModel> directoryList = NavigationDirectoryCache.getListOfSystem("obj_ed721d4f4b5e468caa6fb5e0438c9918");
        boolean isSuperMaster = "admin".equals(this._me.getUID());
        sb.append("<table");
        sb.append(" class='table' align='center' id='NavSystem").append(20).append("'>\n");
        int ii = 0;
        while (ii < directoryList.size()) {
            NavigationDirectoryModel navigationDirectoryModel = directoryList.get(ii);
            boolean isManager = list != null && HighSecurity.hasAc(list, String.valueOf(navigationDirectoryModel.getId()));
            String setSecurity = "";
            setSecurity = !isSuperMaster ? "<img src=../apps/_bpm.platform/img/model/ok.gif alt='\u60a8\u4e0d\u662f\u8d85\u7ea7\u7528\u6237\uff0c\u5e76\u4e14\u60a8\u6ca1\u6709\u6388\u6743\u6b64\u9879\u529f\u80fd\u7684\u6743\u5229'>" : "<input onclick='clickMeDir(this);' class='awsui-checkbox' type=checkbox " + (isManager ? "checked" : "") + " value =" + prefix + "1_" + navigationDirectoryModel.getId() + " id= " + prefix + "1_" + navigationDirectoryModel.getId() + "><label class='awsui-checkbox-label' for='" + prefix + "1_" + navigationDirectoryModel.getId() + "'></label>";
            sb.append("<tr><td bgColor='#E7E7E7' valign='middle'>");
            sb.append(setSecurity).append("&nbsp;<img src='../apps/_bpm.platform/img/portal/nav-directory.gif' border=0 align='absmiddle'>&nbsp;");
            sb.append(NavigationUtil.getLangName(this._me.getLanguage(), navigationDirectoryModel.getDirectoryName()));
            sb.append("</td></tr>\n");
            List<NavigationFunctionModel> functionList = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
            if (functionList != null) {
                sb.append("<tr><td bgColor='#FFFFFF'>\n");
                sb.append("<table class='table' align='center'>\n");
                sb.append("<tr>\n");
                int iii = 0;
                while (iii < functionList.size()) {
                    NavigationFunctionModel navigationFunctionModel = functionList.get(iii);
                    if (!isSuperMaster) {
                        setSecurity = "<img src=../apps/_bpm.platform/img/model/offlock_.gif alt='\u60a8\u4e0d\u662f\u8d85\u7ea7\u7528\u6237\uff0c\u5e76\u4e14\u60a8\u6ca1\u6709\u6388\u6743\u6b64\u9879\u529f\u80fd\u7684\u6743\u5229'>";
                    } else {
                        isManager = list != null && HighSecurity.hasAc(list, String.valueOf(navigationFunctionModel.getId()));
                        setSecurity = "<input onclick='clickMe(this);' class='awsui-checkbox' type=checkbox " + (isManager ? "checked" : "") + " value =" + prefix + "2_" + navigationFunctionModel.getId() + " name= " + prefix + "1_" + navigationDirectoryModel.getId() + " id= " + prefix + "2_" + navigationFunctionModel.getId() + "><label class='awsui-checkbox-label' for='" + prefix + "2_" + navigationDirectoryModel.getId() + "'></label>";
                    }
                    sb.append("<td>").append(setSecurity);
                    sb.append("&nbsp;<img src='../apps/_bpm.platform/img/portal/nav-function.gif' border=0 align='absmiddle'>&nbsp;");
                    sb.append(NavigationUtil.getLangName(this._me.getLanguage(), navigationFunctionModel.getFunctionName()));
                    sb.append("</td>\n");
                    if ((iii + 1) % 3 == 0) {
                        sb.append("</tr><tr>\n");
                    }
                    ++iii;
                }
                sb.append("</tr>\n");
                sb.append("</table>\n");
                sb.append("</td></tr>\n");
            }
            ++ii;
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

