/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.logging;

import com.actionsoft.bpms.commons.log.auditing.Auditor;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.model.ADMINType;
import com.actionsoft.bpms.commons.security.logging.model.Action;
import com.actionsoft.bpms.commons.security.logging.model.AuditModel;
import com.actionsoft.bpms.commons.security.logging.model.AuditObj;
import com.actionsoft.bpms.commons.security.logging.model.Catalog;
import com.actionsoft.bpms.commons.security.logging.model.Channel;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class AuditLogger {
    public static final String BPM_SOURCE = "BPM Platform";
    private String channel = "";
    private String catalog = "";
    private String auditObj = "";

    private AuditLogger(String channel) {
        if (channel != null) {
            this.channel = channel;
        }
    }

    private AuditLogger(String channel, String catalog) {
        this(channel);
        if (catalog != null) {
            this.catalog = catalog;
        }
    }

    private AuditLogger(String channel, String catalog, String obj) {
        this(channel, catalog);
        if (obj != null) {
            this.auditObj = obj;
        }
    }

    public static AuditLogger getLogger(Channel channel, Catalog catalog) {
        return AuditLogger.getLogger(channel, catalog, null);
    }

    public static AuditLogger getLogger(Channel channel, Catalog catalog, AuditObj obj) {
        return AuditLogger.getLogger(channel != null ? channel.getId() : "", catalog != null ? catalog.getId() : "", obj != null ? obj.getId() : "");
    }

    public static AuditLogger getLogger(String channel, String catalog, String obj) {
        return new AuditLogger(channel, catalog, obj);
    }

    private static boolean index(String s, String str) {
        return s.indexOf(String.valueOf('/') + str + '/') != -1 || s.indexOf(String.valueOf('\\') + str + '\\') != -1;
    }

    private static AuditObj getFileSign(String path) {
        if (AuditLogger.index(path, "cachet")) {
            return AuditObj.CACHET;
        }
        if (AuditLogger.index(path, "Document")) {
            return AuditObj.Document;
        }
        if (AuditLogger.index(path, "Email")) {
            return AuditObj.Email;
        }
        if (AuditLogger.index(path, "FormFile")) {
            return AuditObj.FormFile;
        }
        if (AuditLogger.index(path, "WebOffice")) {
            return AuditObj.WebOffice;
        }
        return null;
    }

    public static void logFile(DCContext DCContext2, String fn, String path, boolean success, boolean isUpFile) {
        AuditObj fobj;
        if (!success && (fobj = AuditLogger.getFileSign(path)) != null) {
            AuditModel auditModel = AuditModel.create(Action.DownFile);
            auditModel.setTitle("\u9644\u4ef6" + (isUpFile ? "\u4e0a\u4f20" : "\u4e0b\u8f7d") + (success ? "\u6210\u529f" : "\u5931\u8d25"));
            auditModel.addObjectTrace("\u7ed3\u679c", String.valueOf(isUpFile ? "\u4e0a\u4f20" : "\u4e0b\u8f7d") + (success ? "\u6210\u529f" : "\u5931\u8d25"));
            auditModel.addObjectTrace("FileName", fn);
            AuditLogger.getLogger(Channel.CLIENT.getId(), isUpFile ? Catalog.FILEUP.getId() : Catalog.FILEDOWN.getId(), fobj.getId()).log(auditModel, success ? Level.INFO : Level.ERROR);
        }
    }

    public void log(String title, Action action, String jsonObjTrace, Level level) {
        AuditModel auditModel = AuditModel.create(action);
        auditModel.setTitle(title);
        auditModel.addObjectTrace((Map)JSONObject.parseObject((String)jsonObjTrace));
        this.log(auditModel, level);
    }

    public void log(String title, Action action, Map trace, Level level) {
        AuditModel auditModel = AuditModel.create(action);
        auditModel.setTitle(title);
        auditModel.addObjectTrace(trace);
        this.log(auditModel, level);
    }

    public void info(AuditModel auditModel) {
        this.log(auditModel, Level.INFO);
    }

    public void warn(AuditModel auditModel) {
        this.log(auditModel, Level.WARN);
    }

    public void error(AuditModel auditModel) {
        this.log(auditModel, Level.ERROR);
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog.getId();
    }

    public void setAuditObj(AuditObj auditObj) {
        this.auditObj = auditObj.getId();
    }

    public void log(AuditModel auditModel, Level level) {
        if (Auditor.getLgConf().isService()) {
            JSONObject jsonObject = new JSONObject(auditModel.getObjectTrace());
            String desc = "";
            if (!jsonObject.isEmpty()) {
                desc = jsonObject.toString();
            }
            if (UtilString.isEmpty(auditModel.getSource()) && DispatcherRequest.getContext() != null) {
                Map objectTrace;
                Map<String, String> parameters = DispatcherRequest.getContext().getExchange().getParameters();
                String cmd = DispatcherRequest.getContext().getExchange().getCmd();
                if (UtilString.isNotEmpty(cmd) && cmd.toUpperCase().contains("LOGIN")) {
                    auditModel.setSource(parameters.get("userid"));
                }
                if ((objectTrace = auditModel.getObjectTrace()).containsKey("\u8d26\u6237\u5b89\u5168")) {
                    this.catalog = "\u8d26\u6237\u5b89\u5168";
                    desc = objectTrace.get(this.catalog).toString();
                }
                auditModel.setIp(DispatcherRequest.getContext().getIp());
            }
            SDK.getLogAPI().audit(this.channel, this.catalog, auditModel.getSource(), auditModel.getAction().getId(), this.auditObj, desc, auditModel.getIp(), level);
        }
    }

    private ADMINType getAdminType(AuditModel auditModel) {
        ADMINType adminType = ADMINType.NONE;
        if (HighSecurity.isON() && auditModel != null && auditModel.getSource() != null && !"".equals(auditModel.getSource()) && (Channel.SYSTEM.getId().equals(this.channel) || Channel.SECURITY.getId().equals(this.channel))) {
            if (HighSecurity.is3PSysAdmin(SDK.getORGAPI().getUserId(auditModel.getSource()))) {
                adminType = ADMINType.SYSADMIN;
            } else if (HighSecurity.is3PSecAdmin(SDK.getORGAPI().getUserId(auditModel.getSource()))) {
                adminType = ADMINType.SECADMIN;
            } else if (HighSecurity.is3PAuditor(SDK.getORGAPI().getUserId(auditModel.getSource()))) {
                adminType = ADMINType.AUDITOR;
            }
        }
        return adminType;
    }

    private int getSequenceValue() {
        return -1;
    }

    public boolean findLogger(String userId, int level, int deadline) {
        Timestamp date = this.findLoggerDate(userId, level);
        if (date == null) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(date.getTime()));
        calendar.add(5, deadline);
        return calendar.getTime().getTime() <= new Date().getTime();
    }

    public Timestamp findLoggerDate(String userId, int level) {
        StringBuilder sql = new StringBuilder();
        sql.append("select AUDIT_DATETIME dateTemp from SYS_AUDIT_LOG");
        sql.append(" where AUDIT_CHANNEL = '").append(this.channel).append("'");
        sql.append(" and AUDIT_CATALOG = '").append(this.catalog).append("'");
        sql.append(" and AUDIT_SOURCE = '").append(userId).append("'");
        sql.append(" and AUDIT_LEVEL = " + level);
        sql.append(" order by id desc ");
        return DBSql.getTimestamp(sql.toString(), "dateTemp");
    }

    class LoggerThread
    extends Thread {
        private AuditModel auditModel;
        private Level level;

        public LoggerThread(AuditModel model, Level lv) {
            super("AWS Audit Auditor Thread");
            this.auditModel = model;
            this.level = lv;
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO SYS_AUDIT_LOG(");
            sb.append("ID,AUDIT_CHANNEL,AUDIT_CATALOG,AUDIT_OBJECT,AUDIT_SOURCE,AUDIT_SOURCE_DEPTID,AUDIT_SOURCE_DEPTNAME,AUDIT_SOURCE_USERNAME,AUDIT_DATETIME,AUDIT_IP,");
            sb.append("AUDIT_LEVEL,ADMIN_TYPE,AUDIT_TITLE,AUDIT_DESC)values(");
            sb.append(AuditLogger.this.getSequenceValue());
            sb.append(",'" + (AuditLogger.this.channel == null ? "" : AuditLogger.this.channel) + "'");
            sb.append(",'" + (AuditLogger.this.catalog == null ? "" : AuditLogger.this.catalog) + "'");
            sb.append(",'" + (AuditLogger.this.auditObj == null ? "" : AuditLogger.this.auditObj) + "'");
            sb.append(",'" + (this.auditModel == null || this.auditModel.getSource() == null ? "" : this.auditModel.getSource()) + "'");
            sb.append(String.valueOf(',') + (this.auditModel == null ? "" : this.auditModel.get_source_deptid()));
            sb.append(",'" + (this.auditModel == null || this.auditModel.get_source_deptname() == null ? "" : this.auditModel.get_source_deptname()) + "'");
            sb.append(",'" + (this.auditModel == null || this.auditModel.get_source_username() == null ? "" : this.auditModel.get_source_username()) + "'");
            sb.append(String.valueOf(',') + DBSql.getDBFunctionOfDatetime(UtilDate.datetimeFormat24(new Date())));
            sb.append(",'" + (this.auditModel == null || this.auditModel.getIp() == null ? "" : this.auditModel.getIp()) + "'");
            sb.append(44 + (this.level == null ? Level.INFO.getLevel() : this.level.getLevel()));
            sb.append(44 + AuditLogger.this.getAdminType(this.auditModel).getType());
            sb.append(",?");
            sb.append(",?");
            sb.append(")");
        }
    }
}

