/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.logging.model;

import com.actionsoft.bpms.commons.security.logging.model.Action;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserModel;
import java.util.HashMap;
import java.util.Map;

public class AuditModel {
    private String _source = "";
    private String _source_deptid = "";
    private String _source_deptname = "";
    private String _source_username = "";
    private String _ip = "";
    private String _title = "";
    private Action _action = null;
    private Map _objectTrace = new HashMap();

    public static AuditModel create() {
        return new AuditModel(Action.NONE);
    }

    public static AuditModel create(Action action) {
        return new AuditModel(action);
    }

    private AuditModel() {
        String[] ss;
        String tn = Thread.currentThread().getName();
        if (tn != null && (ss = tn.split("--")) != null && ss.length > 2) {
            if ("DOWNFILE".equals(ss[0])) {
                this._source = ss[ss.length - 3];
                this._ip = ss[ss.length - 1];
            } else {
                this._source = ss[0];
                this._ip = ss[2];
            }
            UserModel um = UserCache.getModel((String)this._source);
            if (um != null) {
                this._source_username = um.getUserName();
                this._source_deptid = um.getDepartmentId();
                DepartmentModel dept = DepartmentCache.getModel((String)um.getDepartmentId());
                if (dept != null) {
                    this._source_deptname = dept.getName();
                }
            }
        }
    }

    public void set_source_deptid(String _source_deptid) {
        this._source_deptid = _source_deptid;
    }

    public void set_source_deptname(String _source_deptname) {
        this._source_deptname = _source_deptname;
    }

    public void set_source_username(String _source_username) {
        this._source_username = _source_username;
    }

    public String get_source_deptid() {
        return this._source_deptid;
    }

    public String get_source_deptname() {
        return this._source_deptname;
    }

    public String get_source_username() {
        return this._source_username;
    }

    public String getSource() {
        return this._source;
    }

    public void setSource(String _source) {
        this._source = _source;
    }

    public String getIp() {
        return this._ip;
    }

    public void setIp(String _ip) {
        this._ip = _ip;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String _title) {
        this._title = _title;
    }

    public Action getAction() {
        return this._action;
    }

    public void setAction(Action _action) {
        this._action = _action;
    }

    public Map getObjectTrace() {
        return this._objectTrace;
    }

    public void setObjectTrace(Map trace) {
        this._objectTrace = trace;
    }

    private AuditModel(Action action) {
        this();
        this._action = action;
    }

    public void addObjectTrace(String key, Object v) {
        this._objectTrace.put(key, v);
    }

    public void addObjectTrace(Map trace) {
        this._objectTrace.putAll(trace);
    }

    public Object getObjectTrace(String key) {
        return this._objectTrace.get(key);
    }
}

