/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.logging.model;

import java.util.HashMap;
import java.util.Map;

public enum Catalog {
    COMBING("F01"),
    PORTAL("F02"),
    MODEL("F03"),
    INTEGERATION("F04"),
    RUNTIME("F05"),
    ANALYSIS("F06"),
    SYSTEM("F07"),
    UPGRADE("U01"),
    MOBILE("M01"),
    TABLET("T01"),
    USERLOGIN("L01"),
    BPMLOGIN("L02"),
    COELOGIN("L03"),
    USERFREEZE("A111"),
    UNAUTHORIZEDACCESS("A112"),
    IN("CC01"),
    OUT("CC02"),
    INSERT("A01"),
    UPDATE("A02"),
    DELETE("A03"),
    FILEUP("A10"),
    FILEDOWN("A11"),
    WORKLIST("C01"),
    WORKFlOWRUNTIME("C02"),
    DIGGER_EXCUTE("C03"),
    THIRDPARTY("TP1"),
    PWChange("PCC09");

    private static Map<String, Catalog> _nameAndEnumMap;
    private static Map<String, String> _labels;
    private String id;

    static {
        _nameAndEnumMap = new HashMap<String, Catalog>();
        _labels = new HashMap<String, String>();
        Catalog[] catalogArray = Catalog.values();
        int n = catalogArray.length;
        int n2 = 0;
        while (n2 < n) {
            Catalog catalog = catalogArray[n2];
            _nameAndEnumMap.put(catalog.id, catalog);
            ++n2;
        }
        Catalog.addLabel(COMBING, "\u68b3\u7406");
        Catalog.addLabel(PORTAL, "\u95e8\u6237");
        Catalog.addLabel(MODEL, "\u5efa\u6a21");
        Catalog.addLabel(INTEGERATION, "\u96c6\u6210");
        Catalog.addLabel(RUNTIME, "\u8fd0\u884c");
        Catalog.addLabel(ANALYSIS, "\u5206\u6790");
        Catalog.addLabel(SYSTEM, "\u7cfb\u7edf");
        Catalog.addLabel(UPGRADE, "\u5347\u7ea7");
        Catalog.addLabel(MOBILE, "AWS\u624b\u673a\u5ba2\u6237\u7aef");
        Catalog.addLabel(TABLET, "\u5e73\u677f\u7535\u8111\u6d41\u7a0b\u95e8\u6237");
        Catalog.addLabel(USERLOGIN, "\u7528\u6237\u767b\u5f55");
        Catalog.addLabel(BPMLOGIN, "\u7ba1\u7406\u767b\u5f55");
        Catalog.addLabel(COELOGIN, "COE\u767b\u5f55");
        Catalog.addLabel(USERFREEZE, "\u8d26\u6237\u51bb\u7ed3");
        Catalog.addLabel(UNAUTHORIZEDACCESS, "\u8d8a\u6743\u8bbf\u95ee");
        Catalog.addLabel(IN, "\u5165\u7ad9");
        Catalog.addLabel(OUT, "\u51fa\u7ad9");
        Catalog.addLabel(INSERT, "\u63d2\u5165");
        Catalog.addLabel(UPDATE, "\u66f4\u65b0");
        Catalog.addLabel(DELETE, "\u5220\u9664");
        Catalog.addLabel(FILEUP, "\u9644\u4ef6\u4e0a\u4f20");
        Catalog.addLabel(FILEDOWN, "\u9644\u4ef6\u4e0b\u8f7d");
        Catalog.addLabel(WORKLIST, "\u5de5\u4f5c\u53f0");
        Catalog.addLabel(WORKFlOWRUNTIME, "\u5de5\u4f5c\u6d41\u8fd0\u884c\u65f6\u523b");
        Catalog.addLabel(DIGGER_EXCUTE, "\u62a5\u8868\u67e5\u8be2");
        Catalog.addLabel(THIRDPARTY, "\u4e09\u65b9\u63d2\u4ef6");
        Catalog.addLabel(PWChange, "\u4fee\u6539\u5bc6\u7801");
    }

    private Catalog(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel(String catalogId) {
        return _labels.get(catalogId);
    }

    private static void addLabel(Catalog catalog, String label) {
        _labels.put(catalog.id, label);
    }

    public static Catalog getCatalog(String id) {
        return _nameAndEnumMap.get(id);
    }
}

