/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.mgtgrade.util;

import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.mgtgrade.web.GradeSecurityWeb;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.VDeptCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.VDeptModel;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GradeSecurityUtil {
    public static final String[] SUPER_MASTER = new String[]{"admin"};

    public static boolean isAdmin(String uid) {
        int i = 0;
        while (i < SUPER_MASTER.length) {
            if (uid.equals(SUPER_MASTER[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSuperMaster(String uid) {
        if (HighSecurity.isON()) {
            return GradeSecurityUtil.isSystemMaster(uid);
        }
        int i = 0;
        while (i < SUPER_MASTER.length) {
            if (uid.equals(SUPER_MASTER[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSystemMaster(String uid) {
        return HighSecurity.isON() && HighSecurity.is3PSysAdmin(uid);
    }

    public static boolean isSecurityMaster(String uid) {
        return HighSecurity.isON() && HighSecurity.is3PSecAdmin(uid);
    }

    public static boolean isAuditorMaster(String uid) {
        return HighSecurity.isON() && HighSecurity.is3PAuditor(uid);
    }

    public static boolean checkMasterForDepartment(String uid, String departmentId) {
        if (GradeSecurityUtil.isSuperMaster(uid)) {
            return true;
        }
        String s = DepartmentCache.getFullID((String)departmentId);
        if (s != null && !"".equals(s)) {
            String[] departmentIds = s.split("\\/");
            int i = 0;
            while (i < departmentIds.length) {
                Map<String, String> administrators = GradeSecurityUtil.getMasterOfDepartment(departmentIds[i], true);
                if (administrators.containsKey(uid)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean checkSeeForDepartment(String uid, String departmentId) {
        String s = DepartmentCache.getFullID((String)departmentId);
        if (s != null && !"".equals(s)) {
            String[] departmentIds = s.split("\\/");
            int i = 0;
            while (i < departmentIds.length) {
                Map<String, String> administrators = GradeSecurityUtil.getMasterOfDepartment(departmentIds[i], true);
                if (administrators.containsKey(uid)) {
                    return true;
                }
                ++i;
            }
            return GradeSecurityUtil.canSeeNotMasterOfDepartment(uid, departmentId);
        }
        return false;
    }

    public static boolean checkSeeForVDepartment(String uid, String departmentId) {
        String s = VDeptCache.getFullID((String)departmentId);
        if (s != null && !"".equals(s)) {
            String[] departmentIds = s.split("\\/");
            int i = 0;
            while (i < departmentIds.length) {
                Map<String, String> administrators = GradeSecurityUtil.getMasterOfVDepartment(departmentIds[i], true);
                if (administrators.containsKey(uid)) {
                    return true;
                }
                ++i;
            }
            return GradeSecurityUtil.canSeeNotMasterOfVDepartment(uid, departmentId);
        }
        return false;
    }

    public static boolean isVirtual(String type) {
        return !UtilString.isEmpty(type) && type.equals(GradeSecurityWeb.DEPT_VIRTUAL);
    }

    private static boolean canSeeNotMasterOfVDepartment(String uid, String departmentId) {
        VDeptModel model = VDeptCache.getModel((String)departmentId);
        List modelList = VDeptCache.getParentDepartmentList((String)departmentId, (String)model.getUnitId());
        for (VDeptModel m : modelList) {
            if (m.getAdministrators().contains(uid)) {
                return true;
            }
            if (!GradeSecurityUtil.canSeeNotMasterOfVDepartment(uid, m.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean canSeeNotMasterOfDepartment(String uid, String departmentId) {
        DepartmentModel model = DepartmentCache.getModel((String)departmentId);
        List modelList = DepartmentCache.getListOfParentDepartment((String)model.getCompanyId(), (String)departmentId);
        for (DepartmentModel m : modelList) {
            if (m.getAdministrators().contains(uid)) {
                return true;
            }
            if (!GradeSecurityUtil.canSeeNotMasterOfDepartment(uid, m.getId())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> getMasterOfDepartment(String departmentId, boolean isExtendParent) {
        return GradeSecurityUtil.getMasterOfDepartment(departmentId, isExtendParent, false);
    }

    public static Map<String, String> getMasterOfVDepartment(String departmentId, boolean isExtendParent) {
        return GradeSecurityUtil.getMasterOfDepartment(departmentId, isExtendParent, true);
    }

    private static Map<String, String> getMasterOfDepartment(String departmentId, boolean isExtendParent, boolean v) {
        LinkedHashMap<String, String> h;
        block17: {
            block16: {
                String s;
                h = new LinkedHashMap<String, String>();
                int i = 0;
                while (i < SUPER_MASTER.length) {
                    h.put(SUPER_MASTER[i], SUPER_MASTER[i]);
                    ++i;
                }
                if (HighSecurity.isON()) {
                    String[] stringArray = HighSecurity.getSecModel().getSysAdmin().split(" ");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String user = stringArray[n2];
                        h.put(user, user);
                        ++n2;
                    }
                    stringArray = HighSecurity.getSecModel().getDerivativeSysAdmin().split(" ");
                    n = stringArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        String user = stringArray[n2];
                        h.put(user, user);
                        ++n2;
                    }
                    stringArray = HighSecurity.getSecModel().getSecAdmin().split(" ");
                    n = stringArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        String user = stringArray[n2];
                        h.put(user, user);
                        ++n2;
                    }
                    stringArray = HighSecurity.getSecModel().getDerivativeSecAdmin().split(" ");
                    n = stringArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        String user = stringArray[n2];
                        h.put(user, user);
                        ++n2;
                    }
                }
                if (!v) break block16;
                VDeptModel departmentModel = VDeptCache.getModel((String)departmentId);
                String admins = departmentModel.getAdministrators();
                if (admins != null && !"".equals(admins)) {
                    String[] administrators = admins.split("\\s");
                    int j = 0;
                    while (j < administrators.length) {
                        String s2 = administrators[j];
                        if (s2.contains("|")) {
                            s2 = s2.substring(0, s2.indexOf("|"));
                        }
                        h.put(SDK.getORGAPI().getUserId(s2), SDK.getORGAPI().getUserId(administrators[j]));
                        ++j;
                    }
                }
                if (departmentModel.isRoot() || !isExtendParent || (s = VDeptCache.getFullID((String)departmentId)) == null || "".equals(s)) break block17;
                String[] departmentIds = s.split("\\/");
                int i2 = 0;
                while (i2 < departmentIds.length) {
                    Map<String, String> administrators = GradeSecurityUtil.getMasterOfDepartment(departmentIds[i2], false, true);
                    h.putAll(administrators);
                    ++i2;
                }
                break block17;
            }
            DepartmentModel departmentModel = DepartmentCache.getModel((String)departmentId);
            if (!UtilString.isEmpty(departmentModel)) {
                String s;
                String admins = departmentModel.getAdministrators();
                if (admins != null && !"".equals(admins)) {
                    String[] administrators = admins.split("\\s");
                    int j = 0;
                    while (j < administrators.length) {
                        String s3 = administrators[j];
                        if (s3.contains("|")) {
                            s3 = s3.substring(0, s3.indexOf("|"));
                        }
                        h.put(SDK.getORGAPI().getUserId(s3), SDK.getORGAPI().getUserId(administrators[j]));
                        ++j;
                    }
                }
                if (!departmentModel.isRoot() && isExtendParent && (s = DepartmentCache.getFullID((String)departmentId)) != null && !"".equals(s)) {
                    String[] departmentIds = s.split("\\/");
                    int i = 0;
                    while (i < departmentIds.length) {
                        Map<String, String> administrators = GradeSecurityUtil.getMasterOfDepartment(departmentIds[i], false);
                        h.putAll(administrators);
                        ++i;
                    }
                }
            }
        }
        return h;
    }

    public static String removeGradeUser(String administrators, String master) {
        String s = "";
        if (administrators != null && !"".equals(administrators)) {
            return administrators.replace(master, "").replaceAll("  ", " ").trim();
        }
        return s.trim();
    }

    public static String addGradeUser(String administrators, String uid) {
        String s = "";
        if (administrators != null) {
            String[] admins = administrators.split("\\s");
            int i = 0;
            while (i < admins.length) {
                if (!uid.contains(SDK.getORGAPI().getUserId(admins[i]))) {
                    s = String.valueOf(s) + SDK.getORGAPI().getUserId(admins[i]) + " ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + uid;
        return s.trim();
    }

    public static String addGradeMaster(String administrators, String masters) {
        int i;
        String defaultPower = SDK.getAppAPI().getProperty("_bpm.platform", "deptAdminDefaultPower");
        if (UtilString.isEmpty(defaultPower)) {
            defaultPower = "W";
        }
        String s = "";
        if (administrators != null) {
            String[] admins = administrators.split("\\s");
            i = 0;
            while (i < admins.length) {
                String[] temp = admins[i].split("\\|");
                if (!masters.contains(SDK.getORGAPI().getUserId(temp[0]))) {
                    s = String.valueOf(s) + temp[0] + "|" + (temp.length == 2 ? temp[1] : defaultPower) + " ";
                }
                ++i;
            }
        }
        if (!UtilString.isEmpty(masters)) {
            String[] arr = masters.split("\\s");
            i = 0;
            while (i < arr.length) {
                String[] master = arr[i].split("\\|");
                if (!Arrays.asList(SUPER_MASTER).contains(SDK.getORGAPI().getUserId(master[0]))) {
                    s = String.valueOf(s) + SDK.getORGAPI().getUserId(master[0]) + "|" + (master.length == 2 ? master[1] : "W") + " ";
                }
                ++i;
            }
        }
        return s.trim();
    }

    public static boolean isVirtualDeptWriteMaster(String departmentId, String uid) {
        String s;
        if (GradeSecurityUtil.isSuperMaster(uid)) {
            return true;
        }
        String defaultPower = SDK.getAppAPI().getProperty("_bpm.platform", "deptAdminDefaultPower");
        if (UtilString.isEmpty(defaultPower)) {
            defaultPower = "W";
        }
        if ((s = VDeptCache.getFullID((String)departmentId)) != null && !"".equals(s)) {
            String[] departmentIds = s.split("\\/");
            int i = 0;
            while (i < departmentIds.length) {
                String id = departmentIds[i];
                VDeptModel model = VDeptCache.getModel((String)id);
                String masters = model.getAdministrators();
                if (!UtilString.isEmpty(masters) && masters.contains(uid)) {
                    String[] arr = masters.split(" ");
                    int j = 0;
                    while (j < arr.length) {
                        if (arr[j].contains("|")) {
                            String[] temp = arr[j].split("\\|");
                            if (uid.equals(temp[0])) {
                                return temp[1].equals("W");
                            }
                        } else {
                            return defaultPower.equals("W");
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isDeptWriteMaster(String departmentId, String uid) {
        String s;
        if (GradeSecurityUtil.isSuperMaster(uid) || HighSecurity.isOriginalSysAdmin(uid)) {
            return true;
        }
        if (GradeSecurityUtil.isSecurityMaster(uid)) {
            return false;
        }
        String defaultPower = SDK.getAppAPI().getProperty("_bpm.platform", "deptAdminDefaultPower");
        if (UtilString.isEmpty(defaultPower)) {
            defaultPower = "W";
        }
        if ((s = DepartmentCache.getFullID((String)departmentId)) != null && !"".equals(s)) {
            String[] departmentIds = s.split("\\/");
            int i = 0;
            while (i < departmentIds.length) {
                String id = departmentIds[i];
                DepartmentModel model = DepartmentCache.getModel((String)id);
                String masters = model.getAdministrators();
                if (!UtilString.isEmpty(masters) && masters.contains(uid)) {
                    String[] arr = masters.split(" ");
                    int j = 0;
                    while (j < arr.length) {
                        if (arr[j].contains("|")) {
                            String[] temp = arr[j].split("\\|");
                            if (uid.equals(temp[0])) {
                                return temp[1].equals("W");
                            }
                        } else {
                            return defaultPower.equals("W");
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isGlobalMaster(String uid) {
        if (UtilString.isEmpty(uid) || GradeSecurityUtil.isSuperMaster(uid)) {
            return false;
        }
        String secondMasterStr = SDK.getAppAPI().getProperty("_bpm.platform", "modelMaster");
        String uids = SDK.getORGAPI().getUserIds(secondMasterStr);
        String[] array = uids.trim().split(" ");
        int i = 0;
        while (i < array.length) {
            if (uid.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

