/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.mgtgrade.web;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.AuditLogger;
import com.actionsoft.bpms.commons.security.logging.model.AuditObj;
import com.actionsoft.bpms.commons.security.logging.model.Catalog;
import com.actionsoft.bpms.commons.security.logging.model.Channel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.cache.VDeptCache;
import com.actionsoft.bpms.org.dao.OrgDaoFactory;
import com.actionsoft.bpms.org.dao.VOrgDaoFactory;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.VDeptModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GradeSecurityWeb
extends ActionWeb {
    public static String DEPT_VIRTUAL = "virtual";

    public GradeSecurityWeb(UserContext uc) {
        super(uc);
    }

    public String get(String departmentId, String type) {
        if (UtilString.isEmpty(type)) {
            return this.getDepartmentGardeSecurity(departmentId);
        }
        return this.getVirtualDepartmentGardeSecurity(departmentId);
    }

    public String getVirtualDepartmentGardeSecurity(String departmentId) {
        StringBuilder superMaster = new StringBuilder();
        int i = 0;
        while (i < GradeSecurityUtil.SUPER_MASTER.length) {
            superMaster.append("<img src='../apps/_bpm.platform/img/model/online_admin.gif'>").append(GradeSecurityUtil.SUPER_MASTER[i]).append("&nbsp;");
            ++i;
        }
        String defaultPower = SDK.getAppAPI().getProperty("_bpm.platform", "deptAdminDefaultPower");
        if (UtilString.isEmpty(defaultPower)) {
            defaultPower = "W";
        }
        StringBuilder subDepartmentMaster = new StringBuilder();
        VDeptModel dept = VDeptCache.getModel((String)departmentId);
        String currentMasters = dept.getAdministrators();
        Map<String, String> masterList = GradeSecurityUtil.getMasterOfVDepartment(departmentId, true);
        Iterator<Map.Entry<String, String>> iterator = masterList.entrySet().iterator();
        boolean isReadonly = defaultPower.equals("R");
        List<Object> secAdminList = new ArrayList();
        if (HighSecurity.isON()) {
            secAdminList = Arrays.asList(HighSecurity.getSecModel().getDerivativeSecAdmin().split(" "));
        }
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String master = entry.getValue();
            boolean showFlag = true;
            if (HighSecurity.isON() && (master.equals("security1") || master.equals("security2") || secAdminList.contains(master))) {
                showFlag = false;
            }
            if (!showFlag) continue;
            String masterID = master;
            if (masterID.contains("|")) {
                masterID = masterID.substring(0, masterID.indexOf("|"));
                isReadonly = master.endsWith("|R");
            }
            boolean isCurrent = currentMasters.contains(master);
            int i2 = 0;
            while (i2 < GradeSecurityUtil.SUPER_MASTER.length) {
                String userAliName;
                if (!masterID.equals(GradeSecurityUtil.SUPER_MASTER[i2]) && !UtilString.isEmpty(userAliName = SDK.getORGAPI().getUserAliasNames(masterID))) {
                    subDepartmentMaster.append("<div class='user-item' sourceId='" + masterID + "'><span class='awsui-iconfont'>&#58939;</span>").append(Html.escape(userAliName)).append("</div>");
                    if (isCurrent) {
                        subDepartmentMaster.append("&nbsp;<input id='" + masterID + "' class='awsui-checkbox' " + (isReadonly ? "" : "checked='checked'") + " type='checkbox'/><label class='awsui-checkbox-label' for='" + masterID + "' title='" + I18nRes.findValue("_bpm.platform", " \u90e8\u95e8\u7528\u6237\u754c\u9762\u53ef\u4fee\u6539") + "'>" + I18nRes.findValue("_bpm.platform", "\u53ef\u4fee\u6539") + "</label>");
                        subDepartmentMaster.append("&nbsp;<a href='' onClick=\"removeMaster(frmMain,'").append(master).append("');return false;\" title='" + I18nRes.findValue("_bpm.platform", "\u53d6\u6d88\u8fd9\u4e2a\u7ba1\u7406\u5458") + "' border='0'>" + I18nRes.findValue("_bpm.platform", "\u79fb\u9664") + "</a>");
                    } else {
                        subDepartmentMaster.append("&nbsp;" + (isReadonly ? "\uff08" + I18nRes.findValue("_bpm.platform", "\u90e8\u95e8\u7528\u6237\u754c\u9762\u4e0d\u53ef\u4fee\u6539") + "\uff09" : "\uff08" + I18nRes.findValue("_bpm.platform", "\u90e8\u95e8\u7528\u6237\u754c\u9762\u53ef\u4fee\u6539") + "\uff09"));
                    }
                    subDepartmentMaster.append("<br>");
                }
                ++i2;
            }
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>(10);
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("superDepartmentMaster", superMaster.toString());
        macroLibraries.put("subDepartmentMaster", subDepartmentMaster.toString());
        macroLibraries.put("departmentId", departmentId);
        macroLibraries.put("page_title", "[" + VDeptCache.getFullName((String)departmentId) + "]" + I18nRes.findValue("_bpm.platform", "\u7684\u7ba1\u7406\u5458"));
        macroLibraries.put("defaultPower", defaultPower);
        macroLibraries.put("type", DEPT_VIRTUAL);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.org.dept.security.htm", macroLibraries);
    }

    public String getDepartmentGardeSecurity(String departmentId) {
        StringBuilder superMaster = new StringBuilder();
        int i = 0;
        while (i < GradeSecurityUtil.SUPER_MASTER.length) {
            superMaster.append("<div class='user-item'><span class='awsui-iconfont' style='color:#DA2912;'>&#58939;</span>").append(UserCache.getModel((String)GradeSecurityUtil.SUPER_MASTER[i]).getUserName()).append("</div>");
            ++i;
        }
        String defaultPower = SDK.getAppAPI().getProperty("_bpm.platform", "deptAdminDefaultPower");
        if (UtilString.isEmpty(defaultPower)) {
            defaultPower = "W";
        }
        StringBuilder subDepartmentMaster = new StringBuilder();
        DepartmentModel dept = DepartmentCache.getModel((String)departmentId);
        String currentMasters = dept.getAdministrators();
        Map<String, String> masterList = GradeSecurityUtil.getMasterOfDepartment(departmentId, true);
        Iterator<Map.Entry<String, String>> iterator = masterList.entrySet().iterator();
        boolean isReadonly = defaultPower.equals("R");
        List<Object> secAdminList = new ArrayList();
        if (HighSecurity.isON()) {
            secAdminList = Arrays.asList(HighSecurity.getSecModel().getDerivativeSecAdmin().split(" "));
        }
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String master = entry.getValue();
            boolean showFlag = true;
            if (HighSecurity.isON() && (master.equals("security1") || master.equals("security2") || secAdminList.contains(master))) {
                showFlag = false;
            }
            if (!showFlag) continue;
            String masterID = master;
            if (masterID.contains("|")) {
                masterID = masterID.substring(0, masterID.indexOf("|"));
                isReadonly = master.endsWith("|R");
            }
            boolean isCurrent = currentMasters.contains(master);
            int i2 = 0;
            while (i2 < GradeSecurityUtil.SUPER_MASTER.length) {
                String userAliName;
                if (!masterID.equals(GradeSecurityUtil.SUPER_MASTER[i2]) && !UtilString.isEmpty(userAliName = SDK.getORGAPI().getUserNames(masterID))) {
                    subDepartmentMaster.append("<div class='user-item' sourceId='" + masterID + "'><span class='awsui-iconfont'>&#58939;</span>").append(Html.escape(userAliName)).append("</div>");
                    if (isCurrent) {
                        subDepartmentMaster.append("&nbsp;<input id='" + masterID + "' class='awsui-checkbox' " + (isReadonly ? "" : "checked='checked'") + " type='checkbox'/><label class='awsui-checkbox-label' for='" + masterID + "' title='" + I18nRes.findValue("_bpm.platform", "\u90e8\u95e8\u7528\u6237\u754c\u9762\u53ef\u4fee\u6539") + "'>" + I18nRes.findValue("_bpm.platform", "\u53ef\u4fee\u6539") + "</label>");
                        subDepartmentMaster.append("&nbsp;<a href='' onClick=\"removeMaster(frmMain,'").append(master).append("');return false;\" title='" + I18nRes.findValue("_bpm.platform", "\u53d6\u6d88\u8fd9\u4e2a\u7ba1\u7406\u5458") + "' border='0'>" + I18nRes.findValue("_bpm.platform", "\u79fb\u9664") + "</a>");
                    } else {
                        subDepartmentMaster.append("&nbsp;" + (isReadonly ? "\uff08" + I18nRes.findValue("_bpm.platform", "\u90e8\u95e8\u7528\u6237\u754c\u9762\u4e0d\u53ef\u4fee\u6539") + "\uff09" : "\uff08" + I18nRes.findValue("_bpm.platform", "\u90e8\u95e8\u7528\u6237\u754c\u9762\u53ef\u4fee\u6539") + "\uff09"));
                    }
                    subDepartmentMaster.append("<br>");
                }
                ++i2;
            }
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>(10);
        macroLibraries.put("sid", super.getSIDFlag());
        macroLibraries.put("superDepartmentMaster", superMaster.toString());
        macroLibraries.put("subDepartmentMaster", subDepartmentMaster.toString());
        macroLibraries.put("closeButton", "");
        macroLibraries.put("departmentId", departmentId);
        macroLibraries.put("page_title", "[" + DepartmentCache.getFullName((String)departmentId) + "]" + I18nRes.findValue("_bpm.platform", "\u7684\u7ba1\u7406\u5458"));
        macroLibraries.put("defaultPower", defaultPower);
        macroLibraries.put("type", "");
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.org.dept.security.htm", macroLibraries);
    }

    public String createVirtualDepartmentGardeSecurity(String masters, String departmentId) {
        ResponseObject response = ResponseObject.newErrResponse(I18nRes.findValue("_bpm.platform", "\u6dfb\u52a0\u5931\u8d25"));
        VDeptModel departmentModel = VDeptCache.getModel((String)departmentId);
        if (!"".equals(masters.trim())) {
            String uid = masters.replaceAll("\\|W", "").replaceAll("\\|R", "");
            if (SDK.getORGAPI().validateUsers(uid).equals("")) {
                String admins = departmentModel.getAdministrators();
                String administators = GradeSecurityUtil.addGradeMaster(admins, masters);
                VOrgDaoFactory.createDepartment().setAdministrators(departmentId, administators);
                String[] arr = masters.trim().split("\\s+");
                int i = 0;
                while (i < arr.length) {
                    String[] temp = arr[i].split("\\|");
                    String uAName = temp[0];
                    String string = SDK.getORGAPI().getUserId(uAName);
                    ++i;
                }
                response.ok(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u6210\u529f"));
            } else {
                response.msg(String.valueOf(I18nRes.findValue("_bpm.platform", "\u90e8\u95e8\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5408\u6cd5")) + "(" + uid + ")");
            }
        }
        return response.toString();
    }

    public String createDepartmentGardeSecurity(String masters, String departmentId) {
        ResponseObject response = ResponseObject.newErrResponse(I18nRes.findValue("_bpm.platform", "\u6dfb\u52a0\u5931\u8d25"));
        AuditLogger logger = AuditLogger.getLogger(Channel.SYSTEM, Catalog.MODEL, AuditObj.MODEL_ORG_DEPARTMENT_AUTH);
        DepartmentModel departmentModel = DepartmentCache.getModel((String)departmentId);
        if (!"".equals(masters.trim())) {
            String uid = masters.replaceAll("\\|W", "").replaceAll("\\|R", "");
            if (SDK.getORGAPI().validateUsers(uid).equals("")) {
                String admins = departmentModel.getAdministrators();
                String administators = GradeSecurityUtil.addGradeMaster(admins, masters);
                OrgDaoFactory.createDepartment().setAdministrators(departmentId, administators);
                String[] arr = masters.trim().split("\\s+");
                String okids = "";
                int i = 0;
                while (i < arr.length) {
                    String[] temp = arr[i].split("\\|");
                    String uAName = temp[0];
                    String u = SDK.getORGAPI().getUserId(uAName);
                    okids = String.valueOf(okids) + u + "|" + (temp.length == 2 ? temp[1] : "W") + " ";
                    ++i;
                }
                response.ok(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u6210\u529f"));
            } else {
                response.msg(String.valueOf(I18nRes.findValue("_bpm.platform", "\u90e8\u95e8\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5408\u6cd5")) + "(" + uid + ")");
            }
        }
        return response.toString();
    }

    public String removeDepartmentGardeSecurity(String uid, String departmentId, String type) {
        if (GradeSecurityUtil.isVirtual(type)) {
            VDeptModel department = VDeptCache.getModel((String)departmentId);
            String admins = department.getAdministrators();
            String administators = GradeSecurityUtil.removeGradeUser(admins, uid);
            VOrgDaoFactory.createDepartment().setAdministrators(departmentId, administators);
            AuditLogger logger = AuditLogger.getLogger(Channel.SYSTEM, Catalog.MODEL, AuditObj.MODEL_ORG_DEPARTMENT_AUTH);
            HashMap trace = new HashMap();
            VDeptModel departmentModel = VDeptCache.getModel((String)departmentId);
            return this.getVirtualDepartmentGardeSecurity(departmentId);
        }
        DepartmentModel department = DepartmentCache.getModel((String)departmentId);
        String admins = department.getAdministrators();
        String administators = GradeSecurityUtil.removeGradeUser(admins, uid);
        OrgDaoFactory.createDepartment().setAdministrators(departmentId, administators);
        AuditLogger logger = AuditLogger.getLogger(Channel.SYSTEM, Catalog.MODEL, AuditObj.MODEL_ORG_DEPARTMENT_AUTH);
        DepartmentModel departmentModel = DepartmentCache.getModel((String)departmentId);
        return this.getDepartmentGardeSecurity(departmentId);
    }
}

