/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.security.sql;

import java.sql.SQLException;
import java.util.regex.Pattern;

public class SQLSecurityProxy {
    private static Pattern INJECT_KEY = Pattern.compile("\\s+and\\s+|\\s+or\\s+", 2);
    private static Pattern INJECT_EXEC = Pattern.compile("EXECUTE|SP_|EXEC", 2);

    public static void checkInjection(String supply, String type, String v) throws SQLException {
        if (v == null) {
            return;
        }
        if (INJECT_KEY.matcher(v).find()) {
            throw new SQLException("\u8f93\u5165\u6761\u4ef6\u4e0d\u5141\u8bb8\u5305\u542bAND,OR");
        }
        if (v.indexOf(59) != -1) {
            throw new SQLException("\u8f93\u5165\u6761\u4ef6\u4e0d\u5141\u8bb8\u5305\u542b;");
        }
        if (INJECT_EXEC.matcher(v).find()) {
            throw new SQLException("\u8f93\u5165\u6761\u4ef6\u4e0d\u5141\u8bb8\u5305\u542bEXEC,EXECUTE,SP_");
        }
    }
}

