/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.seq.impl;

import com.actionsoft.bpms.commons.seq.ClusterSEQ;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class FileSEQ
implements ClusterSEQ {
    private static String SEQ_LOCATION = "./seq/";

    static {
        if (!new File(SEQ_LOCATION).exists()) {
            new File(SEQ_LOCATION).mkdirs();
        }
        ConsolePrinter.info("\u96c6\u7fa4\u5e8f\u5217\u53f7\u4f4d\u7f6e\uff1a" + new File(SEQ_LOCATION).getAbsolutePath());
    }

    @Override
    public synchronized long getSEQ(String key) {
        long l;
        RandomAccessFile ff = new RandomAccessFile(new File(SEQ_LOCATION, key), "rw");
        ff.getChannel().lock();
        try {
            long v = 1L;
            if (ff.length() != 0L) {
                v = Long.parseLong(ff.readLine()) + 1L;
            }
            ff.seek(0L);
            ff.writeBytes(Long.toString(v));
            l = v;
        }
        catch (Throwable throwable) {
            try {
                ff.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ff.close();
        return l;
    }

    public synchronized void reset(String key, long v) {
        try {
            RandomAccessFile ff = new RandomAccessFile(new File(SEQ_LOCATION, key), "rw");
            ff.getChannel().lock();
            try {
                ff.seek(0L);
                ff.writeBytes(Long.toString(v));
            }
            finally {
                ff.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized long cur(String key) {
        long l;
        RandomAccessFile ff = new RandomAccessFile(new File(SEQ_LOCATION, key), "rw");
        ff.getChannel().lock();
        try {
            long v = 0L;
            if (ff.length() != 0L) {
                v = Long.parseLong(ff.readLine());
            }
            l = v;
        }
        catch (Throwable throwable) {
            try {
                ff.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ff.close();
        return l;
    }

    public List<String> list() {
        return Arrays.asList(new File(SEQ_LOCATION).list());
    }

    public static void main(String[] args) throws IOException {
        Calendar c = Calendar.getInstance();
        c.set(12, c.get(12) + 2);
        c.set(13, 0);
        new Timer(false).schedule(new TimerTask(){

            @Override
            public void run() {
                long l1 = System.currentTimeMillis();
                int TIMES = 10000;
                FileSEQ s = new FileSEQ();
                int i = 0;
                while (i < TIMES) {
                    System.out.println(s.getSEQ("testSEQ"));
                    ++i;
                }
                System.out.println("\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l1) + "\uff0cTPS\uff1a" + (long)(TIMES * 1000) / (System.currentTimeMillis() - l1));
            }
        }, c.getTime());
    }
}

