/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.seq.impl;

import com.actionsoft.bpms.commons.seq.ClusterSEQ;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.AWSDataAccessException;
import java.util.HashMap;
import java.util.Map;

public class OracelSEQ
implements ClusterSEQ {
    private static Map<String, Integer> SEQ_INFO_CACHE = new HashMap<String, Integer>();
    private static final String SEQ_T = "sys_seq_info";
    private static final String SEQ_S = "aws_user_seq_map";
    private static final String SEQ_PRE = "user_seq_";

    static {
        OracelSEQ.initOracleSeqInfo();
    }

    private static void initOracleSeqInfo() {
        OracelSEQ.createSeqInfo();
    }

    private static void createSeqInfo() {
        String sql = "CREATE SEQUENCE aws_user_seq_map START WITH 1 INCREMENT BY 1 NOCYCLE CACHE 10";
        try {
            DBSql.update(sql);
        }
        catch (AWSDataAccessException e) {
            OracelSEQ.handleEx(e);
        }
        try {
            sql = "create table sys_seq_info(id number(6) not null, SEQUENCENAME varchar2(320) not null primary key)";
            DBSql.update(sql);
        }
        catch (AWSDataAccessException e) {
            OracelSEQ.handleEx(e);
        }
    }

    @Override
    public long getSEQ(String seq) {
        return OracelSEQ.getNextVal(seq);
    }

    private static String getSN(String seq) {
        Integer no = SEQ_INFO_CACHE.get(seq);
        if (no == null) {
            return null;
        }
        return SEQ_PRE + no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSEQName(String seq) {
        String sn = OracelSEQ.getSN(seq);
        if (sn != null) {
            return sn;
        }
        String string = seq;
        synchronized (string) {
            sn = OracelSEQ.getSN(seq);
            if (sn != null) {
                return sn;
            }
            String sql = "select id from sys_seq_info where SEQUENCENAME=?";
            int id = DBSql.getInt(sql, new Object[]{seq});
            if (id == 0) {
                try {
                    DBSql.update("insert into sys_seq_info(id,SEQUENCENAME)values(aws_user_seq_map.nextval,?)", new Object[]{seq});
                }
                catch (AWSDataAccessException e) {
                    OracelSEQ.handleEx(e);
                }
                id = DBSql.getInt(sql, new Object[]{seq});
                OracelSEQ.createSeq(seq, id);
            }
            SEQ_INFO_CACHE.put(seq, id);
        }
        return OracelSEQ.getSN(seq);
    }

    private static void createSeq(String seq, int id) {
        int start = 0;
        try {
            start = DBSql.getInt("select SEQUENCEVALUE from SYS_SEQUENCE where SEQUENCENAME=?", new Object[]{seq});
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sql = "CREATE SEQUENCE user_seq_" + id + " START WITH " + Math.max(start, 1) + " INCREMENT BY 1 NOCYCLE CACHE 10";
        try {
            DBSql.update(sql);
        }
        catch (AWSDataAccessException e) {
            OracelSEQ.handleEx(e);
        }
    }

    private static int getNextVal(String seq) {
        String seqName = OracelSEQ.getSEQName(seq);
        String sql = "select " + seqName + ".nextval from dual";
        return DBSql.getInt(sql, new Object[0]);
    }

    public static int cur(String seq) {
        String seqName = OracelSEQ.getSEQName(seq);
        String sql = "select " + seqName + ".currval from dual";
        return DBSql.getInt(sql, new Object[0]);
    }

    public static synchronized void reset(String seq, long v) {
        String seqName = OracelSEQ.getSEQName(seq);
        String sql = "DROP SEQUENCE " + seqName;
        DBSql.update(sql);
        sql = "CREATE SEQUENCE " + seqName + " START WITH " + (v + 1L) + " INCREMENT BY 1 NOCYCLE CACHE 10";
        DBSql.update(sql);
    }

    private static void handleEx(AWSDataAccessException e) {
        if (e.getMessage().indexOf("ORA-00955") == -1) {
            throw e;
        }
    }
}

