/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.track;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.ProcessTrackPluginProfile;
import com.actionsoft.bpms.commons.track.ProcessTrackInterface;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSClassLoaderException;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.AWSForbiddenException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.sdk.local.SDK;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public final class ProcessTrackProfileManager {
    private static List<ProcessTrackPluginProfile> _list = new ArrayList<ProcessTrackPluginProfile>();

    private ProcessTrackProfileManager() {
    }

    public static boolean registerPlugin(AppContext app, ProcessTrackPluginProfile profile) {
        for (ProcessTrackPluginProfile p : _list) {
            if (!p.getId().equals(profile.getId())) continue;
            SDK.getAppAPI().err(app, "\u6d41\u7a0b\u8ddf\u8e2a[" + app.getName() + "]\u5df2\u88ab\u6ce8\u518c");
            return false;
        }
        profile.setAppContext(app);
        _list.add(profile);
        return true;
    }

    public static boolean destoryPlugin(AppContext app, ProcessTrackPluginProfile profile) {
        ProcessTrackPluginProfile p = ProcessTrackProfileManager.getProfile(profile.getId());
        if (p != null) {
            _list.remove(p);
        }
        return true;
    }

    public static ProcessTrackPluginProfile getProfile(String id) {
        for (ProcessTrackPluginProfile p : _list) {
            if (!p.getId().equals(id)) continue;
            return p;
        }
        return null;
    }

    public static ProcessTrackPluginProfile getProfileByAppId(String appId) {
        for (ProcessTrackPluginProfile p : _list) {
            if (!p.getAppContext().getId().equals(appId)) continue;
            return p;
        }
        return null;
    }

    public static List<ProcessTrackPluginProfile> getList() {
        ArrayList<ProcessTrackPluginProfile> list = new ArrayList<ProcessTrackPluginProfile>();
        for (ProcessTrackPluginProfile p : _list) {
            if (!SDK.getAppAPI().isActive(p.getAppContext().getId())) continue;
            list.add(p);
        }
        return list;
    }

    public static ProcessTrackInterface getMainPageObject(String clazzName) {
        if (UtilString.isEmpty(clazzName)) {
            throw new AWSIllegalArgumentException("\u6d41\u7a0b\u8ddf\u8e2a\u5b9e\u73b0\u7c7b", "EMPT");
        }
        ProcessTrackPluginProfile profile = ProcessTrackProfileManager.getProfile(clazzName);
        if (profile == null) {
            throw new AWSForbiddenException("\u6d41\u7a0b\u8ddf\u8e2a\u5b9e\u73b0\u7c7b[" + clazzName + "]\u6ca1\u6709\u6ce8\u518c\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
        }
        if (!SDK.getAppAPI().isActive(profile.getAppContext().getId())) {
            throw new AWSForbiddenException("\u5e94\u7528[" + profile.getAppContext().getName() + "]\u5df2\u505c\u6b62\uff0c\u6d41\u7a0b\u8ddf\u8e2a[" + profile.getAppContext().getName() + "]\u6682\u4e0d\u53ef\u7528");
        }
        Constructor cons = null;
        try {
            Class[] parameterTypes = new Class[]{};
            cons = ClassReflect.getConstructor(clazzName, parameterTypes, profile.getAppContext());
            Class<?> clazz = profile.getAppContext().getBindClassLoader().loadClass(clazzName);
            ProcessTrackInterface obj = (ProcessTrackInterface)cons.newInstance(new Object[0]);
            return obj;
        }
        catch (AWSException e) {
            SDK.getAppAPI().err(profile.getAppContext(), String.valueOf(clazzName) + "--" + e.toString());
            throw e;
        }
        catch (Exception e) {
            SDK.getAppAPI().err(profile.getAppContext(), String.valueOf(clazzName) + "--" + e.toString());
            throw new AWSClassLoaderException(e);
        }
    }
}

