/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.userprofile;

import com.actionsoft.bpms.commons.userprofile.cache.UserProfileCache;
import com.actionsoft.bpms.commons.userprofile.dao.UserProfile;
import com.actionsoft.bpms.commons.userprofile.model.UserProfileModel;
import com.actionsoft.bpms.util.UtilJson;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class UserProfileAPIManager {
    public static String PROFILE_KEY_COMMONS = "commns";
    private static int MAX_BLOCK_SIZE = 2000;
    private static UserProfileAPIManager inst = new UserProfileAPIManager();

    private UserProfileAPIManager() {
    }

    public static UserProfileAPIManager getInstance() {
        return inst;
    }

    public JSONObject getProfileSchema(String appId, String userId, String profileKey) {
        UserProfileModel model = UserProfileCache.getModel(userId, String.valueOf(appId) + "_" + profileKey);
        if (model != null) {
            return JSONObject.parseObject((String)model.getProfileValue());
        }
        return new JSONObject();
    }

    public JSONObject queryProfileSchema(String appId, String userId, String profileKey) {
        UserProfileModel model = UserProfileCache.getModel(userId, String.valueOf(appId) + "_" + profileKey);
        if (model != null) {
            return JSON.parseObject((String)model.getProfileValue());
        }
        return new JSONObject();
    }

    public String getProfileItem(String appId, String userId, String profileKey, String itemName) {
        UserProfileModel model = UserProfileCache.getModel(userId, String.valueOf(appId) + "_" + profileKey);
        if (model != null) {
            JSONObject json = JSON.parseObject((String)model.getProfileValue());
            String v = UtilJson.optString(json, itemName);
            return v;
        }
        return null;
    }

    public boolean setProfileSchema(String appId, String userId, String profileKey, JSONObject json) {
        if (json.toString().length() > MAX_BLOCK_SIZE) {
            return false;
        }
        UserProfileModel model = UserProfileCache.getModel(userId, String.valueOf(appId) + "_" + profileKey);
        if (model != null) {
            model.setProfileValue(json.toString());
            return new UserProfile().update(model) > 0;
        }
        model = new UserProfileModel();
        model.setUserId(userId);
        model.setProfileKey(String.valueOf(appId) + "_" + profileKey);
        model.setProfileValue(json.toString());
        return new UserProfile().insert(model) > 0;
    }

    public boolean setProfileItem(String appId, String userId, String profileKey, String itemName, String itemValue) {
        UserProfileModel model = UserProfileCache.getModel(userId, String.valueOf(appId) + "_" + profileKey);
        if (model != null) {
            JSONObject json = JSON.parseObject((String)model.getProfileValue());
            json.put(itemName, (Object)itemValue);
            if (json.toString().length() > MAX_BLOCK_SIZE) {
                return false;
            }
            model.setProfileValue(json.toString());
            return new UserProfile().update(model) > 0;
        }
        JSONObject json = new JSONObject();
        json.put(itemName, (Object)itemValue);
        if (json.toString().length() > MAX_BLOCK_SIZE) {
            return false;
        }
        model = new UserProfileModel();
        model.setUserId(userId);
        model.setProfileKey(String.valueOf(appId) + "_" + profileKey);
        model.setProfileValue(json.toString());
        return new UserProfile().insert(model) > 0;
    }
}

