/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.userprofile.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.userprofile.dao.UserProfile;
import com.actionsoft.bpms.commons.userprofile.model.UserProfileModel;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.Iterator;
import java.util.List;

public class UserProfileCache
extends Cache<String, UserProfileModel> {
    public UserProfileCache(CachePluginProfile configuration) {
        super(configuration);
    }

    public static void putModel(UserProfileModel model) {
        UserProfileCache.getCache().put(UserProfileCache.getKey(model), model);
    }

    public static void removeByUid(String userId) {
        Iterator it = UserProfileCache.getCache().iterator();
        while (it.hasNext()) {
            UserProfileModel model = (UserProfileModel)it.next();
            if (!model.getUserId().equals(userId)) continue;
            UserProfileCache.removeByUserKey(model.getUserId(), model.getProfileKey());
        }
    }

    public static void removeByKey(String profileKey) {
        Iterator it = UserProfileCache.getCache().iterator();
        while (it.hasNext()) {
            UserProfileModel model = (UserProfileModel)it.next();
            if (!model.getProfileKey().equals(profileKey)) continue;
            UserProfileCache.removeByUserKey(model.getUserId(), model.getProfileKey());
        }
    }

    public static void removeByAppId(String appId) {
        Iterator it = UserProfileCache.getCache().iterator();
        while (it.hasNext()) {
            UserProfileModel model = (UserProfileModel)it.next();
            if (!model.getProfileKey().startsWith(String.valueOf(appId) + "_")) continue;
            UserProfileCache.removeByUserKey(model.getUserId(), model.getProfileKey());
        }
    }

    public static void removeByUserKey(String userId, String profileKey) {
        UserProfileCache.getCache().remove(UserProfileCache.getKey(userId, profileKey));
    }

    public static UserProfileModel getModel(String userId, String profileKey) {
        return (UserProfileModel)UserProfileCache.getCache().get(UserProfileCache.getKey(userId, profileKey));
    }

    private static String getKey(UserProfileModel model) {
        return UserProfileCache.getKey(model.getUserId(), model.getProfileKey());
    }

    private static String getKey(String userId, String profileKey) {
        return String.valueOf(userId) + "|" + profileKey;
    }

    @Override
    public void load() {
        String pmpt = "Cache\u52a0\u8f7d\u7528\u6237\u914d\u7f6e\u6570\u636e\u5b9e\u4f8b";
        List<UserProfileModel> h = new UserProfile().getList();
        if (h != null) {
            for (UserProfileModel model : h) {
                UserProfileCache.getCache().put(UserProfileCache.getKey(model), model, false);
            }
        }
        pmpt = String.valueOf(pmpt) + " [" + (h == null ? 0 : h.size()) + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(pmpt);
    }

    public static UserProfileCache getCache() {
        return CacheManager.getCache(UserProfileCache.class);
    }
}

