/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.userprofile.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.userprofile.cache.UserProfileCache;
import com.actionsoft.bpms.commons.userprofile.model.UserProfileModel;
import com.actionsoft.bpms.util.DBSql;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class UserProfile
extends DaoObject<UserProfileModel> {
    @Override
    public int insert(UserProfileModel obj) {
        UserProfileModel model = obj;
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("USERID", model.getUserId());
        paramsMap.put("PROFILEKEY", model.getProfileKey());
        paramsMap.put("PROFILEVALUE", model.getProfileValue());
        int r = DBSql.update(DBSql.getInsertStatement("SYS_USERPROFILE", paramsMap), paramsMap);
        UserProfileCache.putModel(model);
        return r;
    }

    @Override
    public int update(UserProfileModel obj) {
        int r;
        UserProfileModel model = obj;
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("USERID", model.getUserId());
        paramsMap.put("PROFILEKEY", model.getProfileKey());
        paramsMap.put("PROFILEVALUE", model.getProfileValue());
        try {
            r = DBSql.update("UPDATE SYS_USERPROFILE SET PROFILEVALUE=:PROFILEVALUE WHERE USERID=:USERID AND PROFILEKEY=:PROFILEKEY", paramsMap);
        }
        catch (Throwable throwable) {
            UserProfileCache.putModel((UserProfileModel)this.queryBy("USERID=? and PROFILEKEY=?", model.getUserId(), model.getProfileKey()));
            throw throwable;
        }
        UserProfileCache.putModel((UserProfileModel)this.queryBy("USERID=? and PROFILEKEY=?", model.getUserId(), model.getProfileKey()));
        return r;
    }

    public int removeByUid(String userId) {
        int r = DBSql.update("DELETE FROM SYS_USERPROFILE WHERE USERID=?", new Object[]{userId});
        UserProfileCache.removeByUid(userId);
        return r;
    }

    public int removeByKey(String profileKey) {
        int r = DBSql.update("DELETE FROM SYS_USERPROFILE WHERE PROFILEKEY=?", new Object[]{profileKey});
        UserProfileCache.removeByKey(profileKey);
        return r;
    }

    public int removeByAppId(String appId) {
        int r = DBSql.update("DELETE FROM SYS_USERPROFILE WHERE PROFILEKEY like ?", new Object[]{String.valueOf(appId) + "_%"});
        UserProfileCache.removeByAppId(appId);
        return r;
    }

    public int removeByUserKey(String userId, String profileKey) {
        int r = DBSql.update("DELETE FROM SYS_USERPROFILE WHERE USERID=? AND PROFILEKEY=?", new Object[]{userId, profileKey});
        UserProfileCache.removeByUserKey(userId, profileKey);
        return r;
    }

    public List<UserProfileModel> getList() {
        return this.query().list();
    }

    @Override
    public String entityName() {
        return "SYS_USERPROFILE";
    }

    @Override
    public RowMapper<UserProfileModel> rowMapper() {
        return new UserProfileModelMapper();
    }

    public static class UserProfileModelMapper
    implements RowMapper<UserProfileModel> {
        public UserProfileModel mapRow(ResultSet rs, int rowNum) throws SQLException {
            UserProfileModel model = new UserProfileModel();
            model.setUserId(rs.getString("USERID"));
            model.setProfileKey(rs.getString("PROFILEKEY"));
            model.setProfileValue(rs.getString("PROFILEVALUE"));
            return model;
        }
    }
}

