/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.wechat;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.WechatPluginProfile;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLATimeCollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.push.MVCFrameworkPush;
import com.actionsoft.bpms.commons.wechat.WechatProcessor;
import com.actionsoft.bpms.commons.wechat.WechatProfileManager;
import com.actionsoft.bpms.commons.wechat.bean.WechatInMessage;
import com.actionsoft.bpms.commons.wechat.bean.WechatOutMessage;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.exception.AWSObjectNotFindException;
import java.lang.reflect.Constructor;

public class WechatExecuter {
    private WechatExecuter() {
    }

    public static WechatExecuter createService() {
        return new WechatExecuter();
    }

    public WechatOutMessage handleMessage(String appId, String message) {
        if (appId == null) {
            throw new AWSIllegalArgumentException("appId", "NULL");
        }
        if (message == null) {
            throw new AWSIllegalArgumentException("message", "NULL");
        }
        WechatPluginProfile profile = WechatProfileManager.getWechatProfile(appId);
        if (profile == null) {
            throw new AWSObjectNotFindException("\u672a\u6ce8\u518c\u5fae\u4fe1\u6d88\u606f\u5904\u7406\u5668\u3002" + appId);
        }
        AppContext targetApp = profile.getAppContext();
        String serviceClassName = profile.getClazzName();
        if (UtilString.isEmpty(serviceClassName)) {
            throw new AWSObjectNotFindException("\u5e94\u7528" + appId + "\u6ce8\u518c\u7684\u5fae\u4fe1\u6d88\u606f\u5904\u7406\u7c7b\u540d\u4e3a\u7a7a!");
        }
        try {
            WechatProcessor service = this.getObj(targetApp, serviceClassName);
            SLATimeCollectionContext ctx = MVCFrameworkPush.getInstance().begin();
            WechatOutMessage r = this.call(service, message);
            return r;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private WechatOutMessage call(WechatProcessor service, String message) {
        WechatInMessage msg = WechatInMessage.fromXml(message);
        try {
            WechatOutMessage outmsg = service.handleMessage(msg);
            return outmsg;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private WechatProcessor getObj(AppContext targetApp, String serviceClassName) throws Exception {
        Constructor cons = null;
        cons = ClassReflect.getConstructor(serviceClassName.trim(), null, targetApp);
        Object obj = cons.newInstance(new Object[0]);
        WechatProcessor service = (WechatProcessor)obj;
        return service;
    }
}

